import Vue from 'vue'
import Router from 'vue-router'

const Disease = () => import('@/views/disease')
const FishingPrice = () => import('@/views/fishing-price')
const QualitySafety = () => import('@/views/quality-safety.vue')
const RiceFish = () => import('@/views/rice-fish.vue')
const OceanFarm = () => import('@/views/ocean-farm.vue')

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/disease',
    },
    {
      name: 'disease',
      path: '/disease',
      component: Disease,
    },
    {
      name: 'fishing-price',
      path: '/fishing-price',
      component: FishingPrice,
    },
    {
      name: 'quality-safety',
      path: '/quality-safety',
      component: QualitySafety,
    },
    {
      name: 'rice-fish',
      path: '/rice-fish',
      component: RiceFish,
    },
    {
      name: 'ocean-farm',
      path: '/ocean-farm',
      component: OceanFarm,
    }
  ]
})
