import Bounds from './Bounds';
import IBounds from './interface/IBounds';
import IMapOptions from './interface/IMapOptions';
import IOverlayers from './interface/IOverlayers';
import MapControlBase from './interface/MapControlBase';
import EventEmitter from './mod';
import Overlayerbase from './Overlays/Overlayerbase';
import OverlayGroup from './Overlays/OverlayGroup';
export default class Map extends EventEmitter implements IOverlayers {
    private viewMode;
    private zooms;
    private showBuildingBlock;
    private map;
    private mapControl;
    private mapoverlayers;
    private mapoverlayersflayer;
    constructor(container: string, options?: IMapOptions);
    getZoom(): number;
    setZoom(zoomlevel: number): void;
    panTo(targetpoint: number[]): void;
    panBy(offsetx: number, offsety: number): void;
    getBounds(): IBounds;
    setBounds(bds: Bounds): void;
    setCenter(centerx: number, centery: number, centerz?: number): Promise<void>;
    setZoomAndCenter(zoomlevel: number, center: number[]): Promise<void>;
    getCenter(): number[];
    getScale(): number;
    setRotation(rotation: number): void;
    setPitch(pitch: number): void;
    getPitch(): number;
    zoomIn(): void;
    zoomOut(): void;
    setMapStyle(style: string): void;
    getMapStyle(): string;
    addControl(control: MapControlBase): void;
    removeControl(control: MapControlBase): void;
    enableThroughGround(isunderground: boolean): void;
    add(overlayers: Overlayerbase | Overlayerbase[] | OverlayGroup): void;
    remove(overlayers: Overlayerbase | Overlayerbase[] | OverlayGroup): void;
    update(overlayers: Overlayerbase | Overlayerbase[] | OverlayGroup): void;
    addfeature(overlayers: Overlayerbase | Overlayerbase[] | OverlayGroup): void;
    updatefeature(overlayers: Overlayerbase | Overlayerbase[] | OverlayGroup): void;
    removefeature(overlayers: Overlayerbase | Overlayerbase[] | OverlayGroup): void;
    clearMap(): void;
    showXQ_Poly(): void;
    hideXQ_Poly(): void;
    showXQ_Point(): void;
    hideXQ_Point(): void;
    showMPZ(): void;
    hideMPZ(): void;
    setAPPKey(appkey: string): void;
    setDistrict(districts: string[]): void;
    setFilter(layerName: string, filter: string): void;
    private init;
}
