import Vue from 'vue'
import Router from 'vue-router'

const Disease = () => import('@/views/disease')
const FishingPrice = () => import('@/views/fishing-price')
const QualitySafety = () => import('@/views/quality-safety.vue')
const RiceFish = () => import('@/views/rice-fish.vue')
const OceanFarm = () => import('@/views/ocean-farm.vue')
const Seedling = () => import('@/views/seedling.vue')

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/disease',
    },
    {
      name: 'disease',
      path: '/disease',
      meta: {
        title: '病害防控大数据',
      },
      component: Disease,
    },
    {
      name: 'fishing-price',
      path: '/fishing-price',
      meta: {
        title: '水产品价格分析',
      },
      component: FishingPrice,
    },
    {
      name: 'quality-safety',
      path: '/quality-safety',
      meta: {
        title: '水产品质量安全大数据',
      },
      component: QualitySafety,
    },
    {
      name: 'rice-fish',
      path: '/rice-fish',
      meta: {
        title: '稻鱼综合种养分析',
      },
      component: RiceFish,
    },
    {
      name: 'ocean-farm',
      path: '/ocean-farm',
      meta: {
        title: '海洋牧场分析',
      },
      component: OceanFarm,
    },
    {
      name: 'seedling',
      path: '/seedling',
      meta: {
        title: '苗种数据分析',
      },
      component: Seedling,
    },
  ]
})
