import ajax from '@/server/ajax'
import api from '@/server/api'
import com from '@/util/common'
import moment from 'moment'
let curStreet = '新江湾城街道'
let hoId_eq = null
let streetId = null

export default {
  initData({dispatch, state}) {
    streetId = state.currentStreetInfo.id
    hoId_eq = state.currentStreetInfo.houseId
    curStreet = state.currentStreetInfo.name
    dispatch('getGreenInfo')
    dispatch('getDiscoverTrend')
    dispatch('getRepairRate')
    dispatch('getResourceSum')
    dispatch('getCheckSum')
    dispatch('getGridSum')
    dispatch('getPopulationInfo')
    // dispatch('getPatrolList')
    dispatch('getCameraList')
    dispatch('getDiscoverInfo')
    dispatch('getRepairInfo')
    dispatch('getHandleList')
    dispatch('getDoneList')
    dispatch('getHealthInfo')
    dispatch('getInspection')
    // dispatch('getStreetBasic')
  },
  async getGreenInfo({commit}) {
    const result = [
      {name: '环卫公厕', value: await ajax.get({url: api.DATA_URL + api.GET_TOILET_COUNT, params: {street: curStreet}}) || 0},
      {name: '生活垃圾收集', value: await ajax.get({url: api.DATA_URL + api.GET_GARBAGE_COUNT, params: {street: curStreet}}) || 0},
      {name: '小型压缩站', value: await ajax.get({url: api.DATA_URL + api.GET_COMPRESS_COUNT, params: {street: curStreet}}) || 0},
    ]
    commit('SET_GREEN_INFO', result)
  },
  getDiscoverTrend({commit}) {
    ajax.get({
      url: api.GET_DISCOVER_TREND,
      params: {days: 10, streetId}
    }).then(res => {
      const {content} = res.data
      const keys = (content && Object.keys(content)) ||[]
      const result = keys.map(key => ({
        date: moment(key).format('MM.DD'),
        ...content[key],
      }))
      commit('SET_DISCOVER_TREND', result)
    })
  },
  getRepairRate({commit}) {
    const list = ['水', '堵', '险', '电', '漏', '其他']
    ajax.get({url: api.GET_REPAIR_RATE, params: {streetId}}).then(res => {
      const data = com.confirm(res, 'data.content', [])
      const result = list.map(name => {
        const cur = data.find(item => item.troubleType === name)
        return {
          name,
          value: (cur && +cur.count) || 0
        }
      })
      commit('SET_REPAIR_RATE', result)
    })
  },
  getResourceSum({commit}) {
    ajax.get({url: api.GET_RESOURCE_SUM, params: {streetId}}).then(res => {
      commit('SET_RESOURCE_SUM', com.confirm(res, 'data.content', {}))
    })
  },
  getCheckSum({commit}) {
    ajax.get({url: api.GET_CHECK_SUM, params: {
      hoId_eq,
      nearlyMonth: 12,
      orderType_in: '0,1,2,3',
    }}).then(res => {
      commit('SET_CHECK_SUM', com.confirm(res, 'data.content', {}))
    })
  },
  async getGridSum({commit}) {
    const start = moment().format('YYYY-MM-DD')
    const end = moment().add(1, 'days').format('YYYY-MM-DD')
    const grid1 = await ajax.get({url: api.DATA_URL + api.GET_GRID1, params: {street: curStreet, start, end}})
    const grid2 = await ajax.get({url: api.DATA_URL + api.GET_GRID2, params: {street: curStreet, start, end}})
    const grid3 = await ajax.get({url: api.DATA_URL + api.GET_GRID3, params: {street: curStreet, start, end}})
    const grid4 = await ajax.get({url: api.DATA_URL + api.GET_GRID4, params: {street: curStreet, start, end}})
    const grid5 = await ajax.get({url: api.DATA_URL + api.GET_GRID5, params: {street: curStreet, start, end}})
    const grid6 = await ajax.get({url: api.DATA_URL + api.GET_GRID6, params: {street: curStreet, start, end}})
    commit('SET_GRID_SUM', [+grid1 || 0, +grid2 || 0, +grid3 || 0, +grid4 || 0, +grid5 || 0, +grid6 || 0])
    const alert1 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT1, params: {street: curStreet, start, end}})
    const alert2 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT2, params: {street: curStreet, start, end}})
    const alert3 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT3, params: {street: curStreet, start, end}})
    const alert4 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT4, params: {street: curStreet, start, end}})
    const alert5 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT5, params: {street: curStreet, start, end}})
    const alert6 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT6, params: {street: curStreet, start, end}})
    commit('SET_NOT_ALERT_SUM', [+alert1 || 0, +alert2 || 0, +alert3 || 0, +alert4 || 0, +alert5 || 0, +alert6 || 0])
  },
  async getPopulationInfo({commit}) {
    const year1 = await ajax.get({url: api.DATA_URL + api.GET_POPULATION_INFO, params: {year: moment().add(-2, 'y').format('YYYY')}})
    const year2 = await ajax.get({url: api.DATA_URL + api.GET_POPULATION_INFO, params: {year: moment().add(-1, 'y').format('YYYY')}})
    if (year1 && year2) {
      const result = [year1, year2].map(year => year.find(item => item.street == '总计'))
      commit('SET_LAND_POPULATION_INFO', result)
    }
  },
  // getPatrolList({commit}) {
  //   ajax.get({
  //     url: api.GET_CHECK_LIST,
  //     params: {
  //       hoId_eq,
  //       pageSize: 10000,
  //       nearlyMonth: 12,
  //       orderType_in: '0,1,2,3',
  //     }
  //   }).then(res => {
  //     commit('SET_PATROL_LIST', com.confirm(res, 'data.content', []))
  //   })
  // },
  getCameraList({commit}) {
    ajax.get({
      url: api.GET_CAMERA_LIST,
      params: {
        streetname_l: curStreet,
      }
    }).then(res => {
      commit('SET_CAMERA_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getDiscoverInfo({commit}) {
    ajax.get({
      url: api.GET_DISCOVER_INFO,
      params: {streetId},
    }).then(res => {
      const sum = {done: 0, today: 0}
      const data = com.confirm(res, 'data.content', [])
      const keys = ['accCtl', 'heap', 'nonVehicleCharg', 'streetMonitor']
      // const keys = ['heap', 'parkFireExit', 'nonVehicleCharg', 'buildingVibration', 'trash', 'manholeCover', 'waterTank', 'roofWater', 'hermeticSpace', 'accCtl', 'streetMonitor']
      const result = data.filter(item => keys.indexOf(item.types) >= 0)
      result.forEach(e => {
        sum.done += +e.done
        sum.today += +e.numbers
      })
      commit('SET_DISCOVER_SUM', sum)
      commit('SET_DISCOVER_INFO', result)
    })
  },
  getRepairInfo({commit}) {
    ajax.get({
      url: api.GET_TS_BX,
      params: {streetId},
    }).then(res => {
      const data = com.confirm(res, 'data.content', {})
      const result = [
        [+data.alarmIn5MinBX || 0, +data.undoneBX || 0],
        [+data.alarmIn5MinTS || 0, +data.undoneTS || 0],
      ]
      commit('SET_REPAIR_INFO', result)
    })
  },
  getHandleList({commit}) { // 获取并全局设置联勤联动处置列表
    ajax.get({url: api.GET_HANDLE_LIST, params: {state_ne: 5, streetId}}).then(res => {
      commit('SET_HANDLE_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getDoneList({commit}) { // 获取并全局设置已完成列表
    ajax.get({url: api.GET_HANDLE_LIST, params: {state: 5, days: 7, streetId}}).then(res => {
      commit('SET_DONE_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getHealthInfo({commit}) { // 健康度
    ajax.get({url: api.GET_HEALTH_INFO}).then(res => {
      commit('SET_HEALTH_INFO', com.confirm(res, 'data.content', {}))
    })
  },
  getInspection({commit}) { // 专项检查
    ajax.post({
      url: api.GET_INSPECTION_LIST,
      params: {
        pageNo: 1,
        pageSize: 10000,
        flag: 0,
        someday: moment().format('YYYYMMDD'),
        hpb_id: 310110000000,
      }
    }).then(res => {
      console.log('res --', res)
    })
  }
  // getStreetBasic({commit}) { // 街道基数
  //   ajax.get({url: api.DATA_URL + api.GET_STREET_BASIC, params: {street: '五角场街道', gridId: 10027}}).then(res => {
  //     console.log('basic', com.confirm(res, 'data.content', {}))
  //     // commit('SET_STREET_BASIC', com.confirm(res, 'data.content', {}))
  //   })
  // },
}
