import ajax from '@/server/ajax'
import api from '@/server/api'
import com from '@/util/common'
import moment from 'moment'
let curStreet = '新江湾城街道'
let hoId_eq = null
let streetId = null

export default {
  initData({dispatch, state}) {
    streetId = state.currentStreetInfo.id
    hoId_eq = state.currentStreetInfo.houseId
    curStreet = state.currentStreetInfo.name
    dispatch('getGreenInfo')
    dispatch('getDiscoverTrend')
    dispatch('getRepairRate')
    dispatch('getResourceSum')
    dispatch('getCheckSum')
    dispatch('getGridSum')
    dispatch('getPopulationInfo')
    dispatch('getPatrolList')
    dispatch('getDiscoverInfo')
    dispatch('getRepairInfo')
    dispatch('getHandleList')
    dispatch('getDoneList')
    dispatch('getHealthInfo')
  },
  async getGreenInfo({state, commit}) {
    if (state.currentStreetInfo.name === '新江湾城街道') {
      const result = [
        {name: '环卫公厕', value: 10},
        {name: '生活垃圾收集', value: 98},
        {name: '小型压缩站', value: 34},
      ]
      commit('SET_GREEN_INFO', result)
      return
    }
    const result = [
      {name: '环卫公厕', value: await ajax.get({url: api.DATA_URL + api.GET_TOILET_COUNT, params: {street: curStreet}}) || 0},
      {name: '生活垃圾收集', value: await ajax.get({url: api.DATA_URL + api.GET_GARBAGE_COUNT, params: {street: curStreet}}) || 0},
      {name: '小型压缩站', value: await ajax.get({url: api.DATA_URL + api.GET_COMPRESS_COUNT, params: {street: curStreet}}) || 0},
    ]
    commit('SET_GREEN_INFO', result)
  },
  getDiscoverTrend({commit}) {
    ajax.get({
      url: api.GET_DISCOVER_TREND,
      params: {days: 10, streetId}
    }).then(res => {
      const {content} = res.data
      const keys = (content && Object.keys(content)) ||[]
      const result = keys.map(key => ({
        date: moment(key).format('MM.DD'),
        ...content[key],
      }))
      commit('SET_DISCOVER_TREND', result)
    })
  },
  getRepairRate({commit}) {
    const list = ['水', '堵', '险', '电', '漏', '其他']
    ajax.get({url: api.GET_REPAIR_RATE, params: {streetId}}).then(res => {
      const data = com.confirm(res, 'data.content', [])
      const result = list.map(name => {
        const cur = data.find(item => item.troubleType === name)
        return {
          name,
          value: (cur && +cur.count) || 0
        }
      })
      commit('SET_REPAIR_RATE', result)
    })
  },
  getResourceSum({commit}) {
    ajax.get({url: api.GET_RESOURCE_SUM, params: {streetId}}).then(res => {
      commit('SET_RESOURCE_SUM', com.confirm(res, 'data.content', {}))
    })
  },
  getCheckSum({commit}) {
    ajax.get({url: api.GET_CHECK_SUM, params: {
      hoId_eq,
      nearlyMonth: 12,
      orderType_in: '0,1,2,3',
    }}).then(res => {
      commit('SET_CHECK_SUM', com.confirm(res, 'data.content', {}))
    })
  },
  async getGridSum({state, commit}) {
    if (state.currentStreetInfo.name === '新江湾城街道') {
      commit('SET_GRID_SUM', [34, 43, 0])
      commit('SET_NOT_ALERT_SUM', [18, 27, 0])
      return
    }
    const start = moment().add(-10, 'days').format('YYYY-MM-DD')
    const end = moment().format('YYYY-MM-DD')
    const total = await ajax.get({url: api.DATA_URL + api.GET_GRID_TOTAL, params: {street: curStreet, start, end}})
    const solving = await ajax.get({url: api.DATA_URL + api.GET_GRID_SOLVING, params: {street: curStreet, start, end}})
    const overdue = await ajax.get({url: api.DATA_URL + api.GET_GRID_OVERDUE, params: {street: curStreet, start, end}})
    commit('SET_GRID_SUM', [+overdue || 0, +solving || 0, +total || 0])
    const total2 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT_TOTAL, params: {street: curStreet, start, end}})
    const solving2 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT_SOLVING, params: {street: curStreet, start, end}})
    const overdue2 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT_OVERDUE, params: {street: curStreet, start, end}})
    commit('SET_NOT_ALERT_SUM', [+overdue2 || 0, +solving2 || 0, +total2 || 0])
  },
  async getPopulationInfo({state, commit}) {
    if (state.currentStreetInfo.name === '新江湾城街道') {
      const result = [
        {
          year: '2018',
          area: 60.61,
          registered_population: 1074138,
          population_density: 17722,
        },
        {
          year: '2019',
          area: 60.61,
          registered_population: 1067017,
          population_density: 17605,
        },
      ]
      commit('SET_LAND_POPULATION_INFO', result)
      return
    }
    const year1 = await ajax.get({url: api.DATA_URL + api.GET_POPULATION_INFO, params: {year: moment().add(-2, 'y').format('YYYY')}})
    const year2 = await ajax.get({url: api.DATA_URL + api.GET_POPULATION_INFO, params: {year: moment().add(-1, 'y').format('YYYY')}})
    if (year1 && year2) {
      const result = [year1, year2].map(year => year.find(item => item.street == '总计'))
      commit('SET_LAND_POPULATION_INFO', result)
    }
  },
  getPatrolList({commit}) {
    ajax.get({
      url: api.GET_CHECK_LIST,
      params: {
        hoId_eq,
        pageSize: 10000,
        nearlyMonth: 12,
        orderType_in: '0,1,2,3',
      }
    }).then(res => {
      commit('SET_PATROL_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getDiscoverInfo({commit}) {
    ajax.get({
      url: api.GET_DISCOVER_INFO,
      params: {streetId},
    }).then(res => {
      const sum = {total: 0, today: 0}
      const data = com.confirm(res, 'data.content', [])
      const keys = ['heap', 'parkFireExit', 'nonVehicleCharg', 'buildingVibration', 'trash', 'manholeCover', 'waterTank', 'roofWater', 'hermeticSpace', 'accCtl', 'streetMonitor']
      const result = data.filter(item => keys.indexOf(item.types) >= 0)
      result.forEach(e => {
        sum.total += +e.total
        sum.today += +e.numbers
      })
      commit('SET_DISCOVER_SUM', sum)
      commit('SET_DISCOVER_INFO', result)
    })
  },
  getRepairInfo({commit}) {
    ajax.get({
      url: api.GET_TS_BX,
      params: {streetId},
    }).then(res => {
      const data = com.confirm(res, 'data.content', {})
      const result = [
        [+data.alarmIn5MinBX || 0, +data.undoneBX || 0],
        [+data.alarmIn5MinTS || 0, +data.undoneTS || 0],
      ]
      commit('SET_REPAIR_INFO', result)
    })
  },
  getHandleList({commit}) { // 获取并全局设置联勤联动处置列表
    ajax.get({url: api.GET_HANDLE_LIST, params: {state_ne: 5, streetId}}).then(res => {
      commit('SET_HANDLE_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getDoneList({commit}) { // 获取并全局设置已完成列表
    ajax.get({url: api.GET_HANDLE_LIST, params: {state: 5, days: 7, streetId}}).then(res => {
      commit('SET_DONE_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getHealthInfo({commit}) { // 健康度
    ajax.get({url: api.GET_HEALTH_INFO}).then(res => {
      commit('SET_HEALTH_INFO', com.confirm(res, 'data.content', {}))
    })
  },
}
