import ajax from '@/server/ajax'
import api from '@/server/api'
import com from '@/util/common'
import moment from 'moment'
const curStreet = '新江湾城街道'

export default {
  initData({dispatch}) {
    dispatch('getGreenInfo')
    dispatch('getDiscoverTrend')
    dispatch('getRepairRate')
    dispatch('getResourceSum')
    // dispatch('getCheckSum')
    dispatch('getGridSum')
    dispatch('getPopulationInfo')
    dispatch('getPatrolList')
    dispatch('getDiscoverInfo')
    dispatch('getRepairInfo')
    dispatch('getHandleList')
  },
  async getGreenInfo({commit}) {
    const result = [
      {name: '环卫公厕', value: await ajax.get({url: api.DATA_URL + api.GET_TOILET_COUNT, params: {street: curStreet}}) || 0},
      {name: '生活垃圾收集', value: await ajax.get({url: api.DATA_URL + api.GET_GARBAGE_COUNT, params: {street: curStreet}}) || 0},
      {name: '小型压缩站', value: await ajax.get({url: api.DATA_URL + api.GET_COMPRESS_COUNT, params: {street: curStreet}}) || 0},
    ]
    commit('SET_GREEN_INFO', result)
  },
  getDiscoverTrend({commit}) {
    ajax.get({
      url: api.GET_DISCOVER_TREND,
      params: {days: 10}
    }).then(res => {
      const {content} = res.data
      const keys = (content && Object.keys(content)) ||[]
      const result = keys.map(key => ({
        date: moment(key).format('MM.DD'),
        ...content[key],
      }))
      commit('SET_DISCOVER_TREND', result)
    })
  },
  getRepairRate({commit}) {
    ajax.get({url: api.GET_REPAIR_RATE}).then(res => {
      const data = com.confirm(res, 'data.content', [])
      const result = data.map(item => ({
        name: item.troubleType,
        value: +item.count || 0,
      }))
      commit('SET_REPAIR_RATE', result)
    })
  },
  getResourceSum({commit}) {
    ajax.get({url: api.GET_RESOURCE_SUM}).then(res => {
      commit('SET_RESOURCE_SUM', com.confirm(res, 'data.content', {}))
    })
  },
  getCheckSum({commit}) {
    ajax.get({url: api.GET_CHECK_SUM}).then(res => {
      commit('SET_CHECK_SUM', com.confirm(res, 'data.content', {}))
    })
  },
  async getGridSum({commit}) {
    const start = moment().add(-10, 'days').format('YYYY-MM-DD')
    const end = moment().format('YYYY-MM-DD')
    const total = await ajax.get({url: api.DATA_URL + api.GET_GRID_TOTAL, params: {street: curStreet, start, end}})
    const solving = await ajax.get({url: api.DATA_URL + api.GET_GRID_SOLVING, params: {street: curStreet, start, end}})
    const overdue = await ajax.get({url: api.DATA_URL + api.GET_GRID_OVERDUE, params: {street: curStreet, start, end}})
    commit('SET_GRID_SUM', [+overdue || 0, +solving || 0, +total || 0])
    const total2 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT_TOTAL, params: {street: curStreet, start, end}})
    const solving2 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT_SOLVING, params: {street: curStreet, start, end}})
    const overdue2 = await ajax.get({url: api.DATA_URL + api.GET_NOT_ALERT_OVERDUE, params: {street: curStreet, start, end}})
    commit('SET_NOT_ALERT_SUM', [+overdue2 || 0, +solving2 || 0, +total2 || 0])
  },
  async getPopulationInfo({commit}) {
    const year1 = await ajax.get({url: api.DATA_URL + api.GET_POPULATION_INFO, params: {year: moment().add(-2, 'y').format('YYYY')}})
    const year2 = await ajax.get({url: api.DATA_URL + api.GET_POPULATION_INFO, params: {year: moment().add(-1, 'y').format('YYYY')}})
    if (year1 && year2) {
      const result = [year1, year2].map(year => year.find(item => item.street == '总计'))
      commit('SET_LAND_POPULATION_INFO', result)
    }
  },
  getPatrolList({commit}) {
    setTimeout(() => {
      const result = [
        {
          name: '建发新江湾华苑二期',
          event: '未落实每日自查',
          time: '2020-10-21',
          status: '逾期',
          submit: '朱煜东',
          department: '新江湾城街道房屋管理办事处',
          theme: '市物业中心-住宅小区日常巡查2020.10',
          x: 3249.901,
          y: 9338.801
        }, {
          name: '建发新江湾华苑一期',
          event: '未落实每日自查',
          time: '2020-10-01',
          status: '逾期',
          submit: '朱煜东',
          department: '新江湾城街道房屋管理办事处',
          theme: '市物业中心-住宅小区日常巡查2020.10',
          x: 3161.201,
          y: 9327.401
        },
        {
          name: '嘉誉园',
          event: '车库挡水板未配置',
          time: '2020-06-12',
          status: '逾期',
          submit: '俞泓',
          department: '新江湾城街道房屋管理办事处',
          theme: '2020年住宅小区防汛防台检查',
          x: 3580.401,
          y: 10968.201
        },
        {
          name: '东方锦园',
          event: '未落实每日自查',
          time: '2020-02-07',
          status: '逾期',
          submit: '黄麒玮',
          department: '新江湾城街道房屋管理办事处',
          theme: '2020年上海市住宅小区疫情防控专项检查',
          x: 2719.201,
          y: 8474.801
        }
      ]
      commit('SET_PATROL_LIST', result)
    }, 3000)
  },
  getDiscoverInfo({commit}) {
    ajax.get({
      url: api.GET_DISCOVER_INFO,
    }).then(res => {
      const sum = {total: 0, today: 0}
      const data = com.confirm(res, 'data.content', [])
      const keys = ['staffLeaveAlarmTcfteodr', 'parkFireExit', 'nonVehicleCharg', 'elevatorLock', 'buildingVibration', 'trash', 'manholeCover', 'waterTank', 'roofWater', 'hermeticSpace', 'accCtl']
      const result = data.filter(item => keys.indexOf(item.types) >= 0)
      result.forEach(e => {
        sum.total += +e.total
        sum.today += +e.numbers
      })
      commit('SET_DISCOVER_SUM', sum)
      commit('SET_DISCOVER_INFO', result)
    })
  },
  getRepairInfo({commit}) {
    ajax.get({
      url: api.GET_TS_BX,
    }).then(res => {
      const data = com.confirm(res, 'data.content', {})
      const result = [
        [+data.alarmIn5MinBX || 0, +data.undoneBX || 0],
        [+data.alarmIn5MinTS || 0, +data.undoneTS || 0],
      ]
      commit('SET_REPAIR_INFO', result)
    })
  },
  getHandleList({commit}) { // 获取并全局设置联勤联动处置列表
    ajax.get({url: api.GET_HANDLE_LIST}).then(res => {
      commit('SET_HANDLE_LIST', com.confirm(res, 'data.content', []))
    })
  },
}
