/** 公共方法 */
export default {
  /**
     * 在深层数据结构中取值（为了替代类似 res && res.data && res.data.content这种写法）
     * @param {Object} obj [必填-需要取值的目标对象（例：res）]
     * @param {String} path [必填-数据结构路径（例：'data.content'）]
     * @param {Any} defaultValue [可选-如果取不到值则默认返回该值]
     */
  confirm(obj, path, defaultValue = null) {
    if (!obj || typeof(obj) != 'object' || !path || typeof(path) != 'string') return defaultValue
    const reducer = (accumulator, currentValue) =>
      (accumulator && accumulator[currentValue]) ?
        accumulator[currentValue] :
        defaultValue

    return path.split('.').reduce(reducer, obj)
  },
  /**
     *  -----  柯里化版本 （为了不再重复输入obj这个参数） -----
     * 在深层数据结构中取值（为了替代类似 res && res.data && res.data.content这种写法）
     * @param {Object} obj [必填-需要取值的目标对象（例：res）]
     */
  confirm_currying(obj) {
    if (!obj || typeof(obj) != 'object') return
    return (path, defaultValue = null) => {
      if (!path || typeof(path) != 'string') return
      const reducer = (accumulator, currentValue) =>
        (accumulator && accumulator[currentValue]) ?
          accumulator[currentValue] :
          defaultValue
      return path.split('.').reduce(reducer, obj)
    }
  },
  transStatus(type) {
    if (type == 1) {
      return '转物业'
    } else if (type == 2) {
      return '转物业'
    } else if (type == 5) {
      return '已完成'
    }
  },
  transType(type) {
    const data = {
      'accCtl': '门禁异常',
      'parkFireExit': '占用消防通道',
      'nonVehicleCharg': '集中充电异常',
      'heap': '楼道堆物', // 延吉
      'buildingVibration': '损坏承重结构',
      'trash': '非定时倒垃圾',
      'manholeCover': '窨井盖异常',
      'waterTank': '水箱异常开启',
      'roofWater': '屋顶积水',
      'hermeticSpace': '屋顶违章建筑',
      'weixiuzijin': '维修资金异常',
      'streetMonitor': '街面占用', // 控江
      'staffLeaveAlarmTcfteodr': '门岗脱岗',
      'elevatorLock': '楼道充电',
    }
    return data[type]
  },
}
