import ajax from '@/server/ajax'
import api from '@/server/api'
import com from '@/util/common'
// import moment from 'moment'
// const curStreet = '新江湾城街道'

export default {
  initData({dispatch}) {
    dispatch('getTaskList')
    dispatch('getHandleList')
    dispatch('getResourceCount')
    dispatch('getCommunityRate')
    dispatch('getMarketShare')
    dispatch('getIndustryInfo')
    dispatch('getRepairInfo')
    dispatch('getComplaintInfo')
    dispatch('getHealthInfo')
  },
  getTaskList({commit}) {
    ajax.get({url: api.GET_TASK_LIST}).then(res => {
      commit('SET_TASK_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getHandleList({commit}) { // 获取并全局设置联勤联动处置列表
    ajax.get({url: api.GET_HANDLE_LIST}).then(res => {
      commit('SET_HANDLE_LIST', com.confirm(res, 'data.content', []))
    })
  },
  getResourceCount({commit}) { // 获取运行体征
    ajax.get({url: api.GET_RESOURCE_COUNT}).then(res => {
      commit('SET_RESOURCE_COUNT', com.confirm(res, 'data.content', {}))
    })
  },
  getCommunityRate({commit}) { // 小区占比
    ajax.get({url: api.GET_COMMUNITY_RATE}).then(res => {
      commit('SET_COMMUNITY_RATE', com.confirm(res, 'data.content', {}))
    })
  },
  getMarketShare({commit}) { // 市场份额
    ajax.get({url: api.GET_MARKET_SHARE}).then(res => {
      commit('SET_MARKET_SHARE', com.confirm(res, 'data.content', {}))
    })
  },
  getIndustryInfo({commit}) { // 行业督查
    ajax.get({url: api.GET_INDUSTRY_INFO}).then(res => {
      commit('SET_INDUSTRY_INFO', com.confirm(res, 'data.content', {}))
    })
  },
  getReportInfo({commit, state}) { // 信息上报、重大事件
    ajax.get({url: api.GET_REPORT_INFO, params: {taskid: state.reportId}}).then(res => {
      commit('SET_REPORT_INFO', com.confirm(res, 'data.content.typeRatio', []))
      commit('SET_REPORT_SUM', {
        finish: com.confirm(res, 'data.content.finish', 0),
        total: com.confirm(res, 'data.content.total', 0),
      })
      commit('SET_IMPORTANT_LIST', com.confirm(res, 'data.content.importantEvent', []))
    })
  },
  getRepairInfo({commit}) { // 物业维修
    ajax.get({url: api.GET_REPAIR_INFO}).then(res => {
      commit('SET_REPAIR_INFO', com.confirm(res, 'data.content', {}))
    })
  },
  getComplaintInfo({commit}) { // 信访投诉
    ajax.get({url: api.GET_COMPLAINT_INFO}).then(res => {
      commit('SET_COMPLAINT_INFO', com.confirm(res, 'data.content', {}))
    })
  },
  getHealthInfo({commit}) { // 健康度
    ajax.get({url: api.GET_HEALTH_INFO}).then(res => {
      commit('SET_HEALTH_INFO', com.confirm(res, 'data.content', {}))
    })
  },
}
