import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common'
export default {
  GET_THEME_LIST({commit}, data = {}) {
    ajax.post({
      url: api.POST_THEME_LIST,
      params: data,
    }).then(res => {
      commit('SET_THEME_LIST', common.confirm(res, 'data.content', []))
    })
  },
  GET_COMMUNITY_LIST({commit}, data = {}) {
    ajax.post({
      url: api.POST_COMMUNITY_LIST,
      params: {isPublish: 0, ...data},
    }).then(res => {
      commit('SET_CHECKED_LIST', common.confirm(res, 'data.content', []))
    })
    ajax.post({
      url: api.POST_COMMUNITY_LIST,
      params: {isPublish: 1, ...data},
    }).then(res => {
      commit('SET_RECTIFY_LIST', common.confirm(res, 'data.content', []))
    })
  },
  GET_PERSON_LIST({commit}, data = {}) {
    ajax.post({
      url: api.POST_PERSON_LIST,
      params: {pageNo: 1, pageSize: 10000, ...data},
    }).then(res => {
      commit('SET_PERSON_LIST', common.confirm(res, 'data.content', []))
    })
  },
}
