/** 公共方法 */
const _defaultConfig = {
  name: 'test-point',
  mode: 'add',
  dataArray: [
    {
      codX: -1000,
      codY: -1000,
      codZ: 100,
      attrs: {
        att1: '测试属性',
        attm: '第1类',
      },
    }
  ],
  popupEnabled: false, // 是否打开弹出框
  legendVisible: false, // 图例是否可见
  type: 'point',
  fieldJsonArray: [
    {
      name: 'att1',
      alias: '属性1',
      type: 'string',
    },
    {
      name: 'attm',
      alias: '属性m',
      type: 'string',
    },
  ],
  renderer: {
    type: 'unique-value',
    field: 'attm',
    defaultLabel: '无数据',
    uniqueValueInfos: [
      {
        value: '第1类',
        label: '第I类',
        symbol: {
          type: 'point-3d',
          symbolLayers: [
            {
              type: 'icon',
              size: 24,
              resource: {
                href: 'http://168.168.112.76:8181/propertybusinessmanage/tjcmv/images/marker/1.png'
              // href: 'http://localhost:8080/static/person-bg.png'
              },
            },
          ]
        }
      },
    ]
  },
  labelSymbol: {
    symbol: {
      type: 'text',
      color: 'red',
      haloSize: 2,
      haloColor: '#fff',
    },
    labelPlacement: 'center-right',
  }
}
export default {
  /**
     * 在深层数据结构中取值（为了替代类似 res && res.data && res.data.content这种写法）
     * @param {Object} obj [必填-需要取值的目标对象（例：res）]
     * @param {String} path [必填-数据结构路径（例：'data.content'）]
     * @param {Any} defaultValue [可选-如果取不到值则默认返回该值]
     */
  confirm(obj, path, defaultValue = null) {
    if (!obj || typeof(obj) != 'object' || !path || typeof(path) != 'string') return
    const reducer = (accumulator, currentValue) =>
      (accumulator && accumulator[currentValue]) ?
        accumulator[currentValue] :
        defaultValue

    path = path.split('.')
    return path.reduce(reducer, obj)
  },
  /**
     *  -----  柯里化版本 （为了不再重复输入obj这个参数） -----
     * 在深层数据结构中取值（为了替代类似 res && res.data && res.data.content这种写法）
     * @param {Object} obj [必填-需要取值的目标对象（例：res）]
     */
  confirm_currying(obj) {
    if (!obj || typeof(obj) != 'object') return
    return (path, defaultValue = null) => {
      if (!path || typeof(path) != 'string') return
      const reducer = (accumulator, currentValue) =>
        (accumulator && accumulator[currentValue]) ?
          accumulator[currentValue] :
          defaultValue
      path = path.split('.')
      return path.reduce(reducer, obj)
    }
  },
  /**
   * ------  从数据中整理出地图撒点所需的参数 -------
   * @param {Array} data [必填 - 获取的数据]
   * @param {String} key [必填 - 根据哪个关键字区别撒点（一般是id）]
   */
  getMapParams(data = [], key) {
    const dataArray = []
    const uniqueValueInfos = []
    const fieldJsonArray = []
    for (let e in data[0]) {
      fieldJsonArray.push({
        name: e,
        alias: e,
        type: 'string',
      })
    }
    data.forEach(item => {
      dataArray.push({
        codX: item.X,
        codY: item.Y,
        codZ: 100,
        attrs: {
          ...item,
        },
      })
      uniqueValueInfos.push({
        value: item[key],
        label: '?', // TODO
        symbol: {
          type: 'point-3d',
          symbolLayers: [
            {
              type: 'icon',
              size: 24,
              resource: {
                href: 'http://localhost:8080/static/person-bg.png'
              },
            },
          ]
        }
      })
    })
    return {
      dataArray,
      popupEnabled: false, // 是否打开弹出框
      legendVisible: false, // 图例是否可见
      type: 'point',
      fieldJsonArray,
      renderer: {
        type: 'unique-value',
        field: key,
        uniqueValueInfos,
      },
      labelSymbol: {
        symbol: {
          type: 'text',
          color: 'red',
          haloSize: 2,
          haloColor: '#fff',
        },
        labelPlacement: 'center-right',
      }
    }
  }
}
