import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common.js'

const DISCOVERYLIST = [     //智能发现列表上排
  {
    title:'当日新增',
    img:'data1.png',
    num:'0',
    unit:'个',
    key: 'today',
  },
  {
    title:'历史累计',
    img:'data2.png',
    num:'0',
    unit:'个',
    key: 'total'
  },
]
const FOUNDLIST = [     //智能发现列表下排
  {
    title:'门岗脱岗',
    img:'mw2.png',
    num:'0',
    key: 'staffLeaveAlarmTcfteodr'
  },
  {
    title:'占用消防通道',
    img:'xf2.png',
    num:'0',
    key: 'parkFireExit'
  },
  {
    title:'集中充电异常',
    img:'cd2.png',
    num:'0',
    key: 'nonVehicleCharg'
  },
  {
    title:'楼道充电',
    img:'cd2.png',
    num:'0',
    key: 'elevatorLock'
  },
  {
    title:'损坏承重结构',
    img:'jg2.png',
    num:'0',
    key: 'buildingVibration'
  },
  {
    title:'非定时倒垃圾',
    img:'lj2.png',
    num:'0',
    key: 'trash'
  },
  {
    title:'窨井盖异常',
    img:'ld2.png',
    num:'0',
    key: 'manholeCover'
  },
  {
    title:'水箱异常开启',
    img:'sx2.png',
    num:'0',
    key: 'waterTank'
  },
  {
    title:'屋顶积水',
    img:'js2.png',
    num:'0',
    key: 'roofWater'
  },
  {
    title:'屋顶违章建筑',
    img:'dt2.png',
    num:'0',
    key: 'hermeticSpace'
  },
  // {
  //   title:'密闭空间监控',
  //   img:'lj.png',
  //   num:'0',
  //   key: 'hermeticSpace'
  // },
  // {
  //   title:'电梯运行异常',
  //   img:'dt.png',
  //   num:'0',
  // },
]

export default {
  initNanmatouData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'指挥长',
        name:'李爱武',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'顾伟',
        img:'person.png',
      },
      {
        title:'应急模式',
        name:'',
        img:'',
      },
    ]
    const OPERATELIST = [     // 运行体征
      {
        title:'小区',
        num:'89',
      },
      {
        title:'总户数',
        num:'17882',
      },
      {
        title:'物业企业',
        num:'31',
      },
      {
        title:'项目经理',
        num:'48',
      },
      {
        title:'业主大会',
        num:'72',
      },
      {
        title:'物业管理处',
        num:'66',
      },
      {
        title:'车位',
        num:'5468',
      },
      {
        title:'消防水泵',
        num:'191',
      },
      {
        title:'监控探头',
        num:'859',
      },
      {
        title:'电梯',
        num:'59',
      },
      {
        title:'消防栓',
        num:'3864',
      },
      {
        title:'消防通道',
        num:'310',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
  },
  initLinyiData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'值班长',
        name:'倪萍',
        img:'person.png',
      },
      {
        title:'副值班长',
        name:'李铭',
        img:'person.png',
      },
      {
        title: '更多',
        name:'',
        img:'',
      }
    ]
    const OPERATELIST = [     // 基础数据
      {
        title: '小区',
        num: '5',
        unit: '个',
        img: 'basic1.png',
      },
      {
        title: '总户数',
        num: '1719',
        unit: '户',
        img: 'basic2.png',
      },
      {
        title:'物业企业',
        num:'4',
        unit: '家',
        img: 'basic3.png',
      },
      {
        title:'监控探头',
        num:'16',
        unit: '个',
        img: 'basic4.png',
      },
      {
        title:'电梯',
        num:'3',
        unit: '部',
        img: 'basic5.png'
      },
      {
        title:'车位',
        num:'62',
        unit: '个',
        img: 'basic6.png'
      },

    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
  },
  initShenjiangData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'值班长',
        name:'倪萍',
        img:'person.png',
      },
      {
        title:'副值班长',
        name:'李铭',
        img:'person.png',
      },
    ]
    const OPERATELIST = [     // 基础数据
      {
        title: '幢数',
        num: '28',
        unit: '幢',
        img: 'map.png',
      },
      {
        title: '总户数',
        num: '1755',
        unit: '户',
        img: 'group.png',
      },
      {
        title:'物业企业',
        num:'1',
        unit: '家',
        img: 'data1.png',
      },
      {
        title:'监控探头',
        num:'210',
        unit: '个',
        img: 'data2.png',
      },
      {
        title:'电梯',
        num:'43',
        unit: '部',
        img: 'property.png'
      },
      {
        title:'车位',
        num:'438',
        unit: '个',
        img: 'community.png'
      },

    ]
    const REPAIRLIST = [     // 报修投诉
      {
        title:'报修数量',
        img:'repair.png',
        num:'1',
        allNum: '3',
      },
      {
        title:'投诉数量',
        img:'complaint.png',
        num:'1',
        allNum: '5',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
    commit('SET_REPAIRLIST', REPAIRLIST)
  },
  setDiscoverInfo({commit}) { // 获取并全局设置智能发现数据
    ajax.get({
      url: api.GET_DISCOVER_INFO,
    }).then(res => {
      const sum = {total: 0, today: 0}
      const data = common.confirm(res, 'data.content', [])
      const originSum = JSON.parse(JSON.stringify(DISCOVERYLIST))
      const originData = JSON.parse(JSON.stringify(FOUNDLIST))
      data.forEach(e => {
        const cur = originData.find(item => item.key == e.types)
        if (cur) {
          cur.num = +e.numbers
          sum.total += +e.total
          sum.today += +e.numbers
        }
      })
      originSum.forEach(e => e.num = sum[e.key])
      commit('SET_DISCOVERYLIST', originSum)
      commit('SET_FOUNDLIST', originData)
    })
  },
  setTsBx({commit}) { // 获取投诉报修数据
    ajax.get({
      url: api.GET_TS_BX,
    }).then(res => {
      const data = common.confirm(res, 'data.content', {})
      const result = [
        {
          title:'报修数量',
          img:'repair.png',
          num: data.alarmIn5MinBX || 0,
          allNum: data.undoneBX || 0,
          key: 'bx',
        },
        {
          title:'投诉数量',
          img:'complaint.png',
          num: data.alarmIn5MinTS || 0,
          allNum: data.undoneTS || 0,
          key: 'ts',
        },
      ]
      commit('SET_REPAIRLIST', result)
    })
  },
  setHandleList({commit}) { // 获取并全局设置联勤联动处置列表
    ajax.get({
      url: api.GET_HANDLE_LIST,
    }).then(res => {
      const data = common.confirm(res, 'data.content', [])
      commit('SET_HANDLELIST', data)
    })
  },
  setSensorList({commit}) {
    ajax.get({
      url: api.GET_SENSOR,
    }).then(res => {
      const sensorList = common.confirm(res, 'data.content', [])
      sensorList.forEach(sensor => {
        sensor._scene = common.getSensorScene(sensor.type)
        sensor._status = sensor.state == '1' ? '报警' : '正常'
        sensor.state == '1' ? sensor.icon = 'warn.png' : null
      })
      commit('SET_SENSORLIST', sensorList)
    })
  },
}
