import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common.js'

export default {
  initData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'指挥长',
        name:'周韶华',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'夏毅',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'瞿跃方',
        img:'person.png',
      },
    ]
    const OPERATELIST = [     // 运行体征
      {
        title:'小区',
        img:'community.png',
        unit: '个',
        num:'2790',
      },
      {
        title:'从业人员',
        img:'group.png',
        unit: '人',
        num:'41000',
      },
      // {
      //   title:'业委会',
      //   img:'group.png',
      //   unit: '个',
      //   num:'1749',
      // },
      {
        title:'物业企业',
        img:'property.png',
        unit: '家',
        num:'497',
      },
      {
        title:'管理面积',
        img:'map.png',
        unit: '万㎡',
        num:'17800',
      },
    ]
    const REPAIRLIST = [     // 报修投诉
      {
        title:'报修',
        img:'repair.png',
        num:'15',
        allNum: '348',
      },
      {
        title:'投诉',
        img:'complaint.png',
        num:'26',
        allNum: '248',
      },
    ]
    const HANDLELIST = [    //协同处置
      {
        title:'兰高小区',
        address:'蓝村路60弄',
        matter:'占用消防通道' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:'2020-04-14 12:30:30',  // 可能是moment格式
        sendTime:'2020-04-14 13:30:30',
        fixTime:'2020-04-14 14:30:30',
        successTime:'2020-04-14 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'楼道充电' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:'2020-04-14 12:30:30',  // 可能是moment格式
        sendTime:'2020-04-14 13:30:30',
        fixTime:'2020-04-14 14:30:30',
        successTime:'2020-04-14 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:2
      },
      {
        title:'新高苑',
        address:'高建路11弄',
        matter:'楼道充电' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:'2020-04-13 10:16:30',  // 可能是moment格式
        sendTime:'2020-04-13 13:30:30',
        fixTime:'2020-04-13 14:30:30',
        successTime:'2020-04-13 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:3
      },
    ]
    const DISCOVERYLIST = [     //智能发现列表上排
      {
        title:'本月新增',
        img:'data1.png',
        num:'34',
        unit:'个',
      },
      {
        title:'历史累计',
        img:'data2.png',
        num:'57',
        unit:'个',
      },
    ]
    const FOUNDLIST = [     //智能发现列表下排
      {
        title:'门岗脱岗',
        img:'mw.png',
        num:'1',
      },
      {
        title:'占用消防通道',
        img:'xf.png',
        num:'2',
      },
      {
        title:'维修资金使用异常',
        img:'zj.png',
        num:'3',
      },
      {
        title:'楼道充电',
        img:'dt.png',
        num:'1',
      },
      {
        title:'集中充电异常',
        img:'dz.png',
        num:'0',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
    commit('SET_REPAIRLIST', REPAIRLIST)
    commit('SET_HANDLELIST', HANDLELIST)
    commit('SET_DISCOVERYLIST', DISCOVERYLIST)
    commit('SET_FOUNDLIST', FOUNDLIST)
  },
  getCheckCommunityList({commit}, params = {}){// 获取检查小区的列表
    ajax.post({
      url: api.POST_CHECKCOMMUNITY_LIST,
      params: {
        pageSize: 10000,
        someday: '20200317',
        ...params
      },
    }).then(res => {
      // let list = common.confirm(res, 'data.content', [])
      let list = [
        {COMMUNITYNAME: '兰高小区', X: 5606.064392, Y: -2538.0578, TASKID:'兰高小区', COMMUNITYID: '兰高小区'},
        {COMMUNITYNAME: '(补)临沂二村', X: 3706.690186, Y: -4234.159912, TASKID:'（补）临沂二村', COMMUNITYID: '（补）临沂二村'},
        {COMMUNITYNAME: '新高苑 ', X: 3606.064392, Y: -6538.0578, TASKID:'新高苑', COMMUNITYID: '新高苑'},
        {COMMUNITYNAME: '(补)杨园四村', X: 4706.690186, Y: -2234.159912, TASKID:'（补）杨园四村', COMMUNITYID: '（补）杨园四村'},
        {COMMUNITYNAME: '浦发博园', X: 6606.064392, Y: -4538.0578, TASKID:'浦发博园', COMMUNITYID: '浦发博园'},
        {COMMUNITYNAME: '三林新村c4', X: 7606.064392, Y: -1238.0578, TASKID:'三林新村c4', COMMUNITYID: '三林新村c4'},
        {COMMUNITYNAME: '(补)海阳新村 ', X: 8606.064392, Y: -3538.0578, TASKID:'（补）海阳新村', COMMUNITYID: '（补）海阳新村'},
        {COMMUNITYNAME: '听潮六村 ', X: null, Y: null, TASKID:'听潮六村', COMMUNITYID: '听潮六村'},
        {COMMUNITYNAME: '民乐城惠桐苑', X: null, Y: null, TASKID:'民乐城惠桐苑', COMMUNITYID: '民乐城惠桐苑'},
      ]
      if (params.isPublish && params.isPublish == 1) {
        // commit('SET_SENDCHECKED',list.length)            // 传了1   已开单小区
        commit('SET_SENDCHECKED', 3)            // 传了1   已开单小区

      } else {
        list.forEach((item, i) => { // 营造不同颜色的点，以后要删掉
          if (i <= 2) {
            item.icon = 'red.png'
          }
        })
        commit('SET_CHECKCOMMUNITYLIST',list)    // 没传ispublish   已检查小区总数
        commit('SET_ALLCHECKED', 7)
        // commit('SET_ALLCHECKED',list.length)
      }
    })
  },
  getCheckedPeopleList({commit}, params = {}){            // 获取检查人员的列表
    ajax.post({
      url: api.POST_CHECKPEOPLE_LIST,
      params: {
        pageSize:10000,
        startDate:'2020-03-17 00:00:00',
        endDate:'2020-03-18 23:19:54',
        ...params,
      },
    }).then(res => {
      // let list = common.confirm(res, 'data.content', [])

      const list = [
        {TE_NAME: '孙杨保', ROLE_NAME: '市局', TASK_ID: '孙杨保', OPER_ID: '孙杨保'},
        {TE_NAME: '杨晓东', ROLE_NAME: '市局', TASK_ID: '杨晓东', OPER_ID: '杨晓东'},
        {TE_NAME: '奚海峰', ROLE_NAME: '市局', TASK_ID: '奚海峰', OPER_ID: '奚海峰'},
        // {TE_NAME: '胡永亮', ROLE_NAME: '市局', TASK_ID: '胡永亮', OPER_ID: '胡永亮'},
      ]
      commit('SET_CHECKPEOPLELIST',list)
    })
  }
}
