import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common.js'
import moment from 'moment'

const beforeDay = moment().subtract(1, 'days').format('YYYY-MM-DD')
export default {
  initData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'指挥长',
        name:'周韶华',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'夏毅',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'瞿跃方',
        img:'person.png',
      },
    ]
    const OPERATELIST = [     // 运行体征
      {
        title:'小区',
        img:'community.png',
        unit: '个',
        num:'2790',
      },
      {
        title:'业委会',
        img:'group.png',
        unit: '个',
        num:'1749',
      },
      {
        title:'物业企业',
        img:'property.png',
        unit: '家',
        num:'497',
      },
      // {
      //   title:'建筑面积',
      //   img:'map.png',
      //   unit: '万㎡',
      //   num:'17800',
      // },
      {
        title:'从业人员',
        img:'group.png',
        unit: '人',
        num:'41000',
      },
    ]
    const REPAIRLIST = [     // 报修投诉
      {
        title:'报修',
        img:'repair.png',
        num:'15',
        allNum: '348',
      },
      {
        title:'投诉',
        img:'complaint.png',
        num:'26',
        allNum: '248',
      },
    ]
    const HANDLELIST = [    //协同处置
      {
        title:'兰高小区',
        address:'蓝村路60弄',
        matter:'占用消防通道' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:beforeDay + ' 12:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'楼道充电' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:beforeDay + ' 12:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:2
      },
      {
        title:'新高苑',
        address:'高建路11弄',
        matter:'楼道充电' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:3
      },
    ]
    const DISCOVERYLIST = [     //智能发现列表上排
      {
        title:'当日新增',
        img:'data1.png',
        num:'34',
        unit:'个',
      },
      {
        title:'历史累计',
        img:'data2.png',
        num:'57',
        unit:'个',
      },
    ]
    const FOUNDLIST = [     //智能发现列表下排
      {
        title:'门岗脱岗',
        img:'mw.png',
        num:'1',
      },
      {
        title:'占用消防通道',
        img:'xf.png',
        num:'2',
      },
      {
        title:'集中充电异常',
        img:'cd.png',
        num:'0',
      },
      {
        title:'楼道充电',
        img:'ld.png',
        num:'1',
      },
      {
        title:'维修资金使用异常',
        img:'zj.png',
        num:'3',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
    commit('SET_REPAIRLIST', REPAIRLIST)
    commit('SET_HANDLELIST', HANDLELIST)
    commit('SET_DISCOVERYLIST', DISCOVERYLIST)
    commit('SET_FOUNDLIST', FOUNDLIST)
  },
  initNanmatouData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'指挥长',
        name:'李爱武',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'顾伟',
        img:'person.png',
      },
      {
        title:'应急模式',
        name:'',
        img:'',
      },
    ]
    const OPERATELIST = [     // 运行体征
      {
        title:'小区',
        num:'89',
      },
      {
        title:'总户数',
        num:'17882',
      },
      {
        title:'物业企业',
        num:'31',
      },
      {
        title:'项目经理',
        num:'48',
      },
      {
        title:'业主大会',
        num:'72',
      },
      {
        title:'物业管理处',
        num:'66',
      },
      {
        title:'车位',
        num:'5468',
      },
      {
        title:'消防水泵',
        num:'191',
      },
      {
        title:'监控探头',
        num:'859',
      },
      {
        title:'电梯',
        num:'59',
      },
      {
        title:'消防栓',
        num:'3864',
      },
      {
        title:'消防通道',
        num:'310',
      },
    ]
    const REPAIRLIST = [     // 报修投诉
      {
        title:'报修',
        img:'repair.png',
        num:'2',
        allNum: '38',
      },
      {
        title:'投诉',
        img:'complaint.png',
        num:'6',
        allNum: '48',
      },
    ]
    const HANDLELIST = [    //协同处置
      {
        title:'（补）教师大楼',
        address:'东方路3391弄',
        matter:'占用消防通道' ,    // 事项
        style:'智能发现',
        department:'上海霞悦物业',
        foundTime:beforeDay + ' 18:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 19:30:30',
        fixTime:beforeDay + ' 20:30:30',
        successTime:beforeDay + ' 20:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1,
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'违规充电' ,    // 事项
        style:'智能发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 12:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1,
      },
      {
        title:'（补）金田公寓',
        address:'南码头路160弄',
        matter:'毁绿占绿' ,    // 事项
        style:'投诉发现',
        department:'城管部门',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）临沂五村',
        address:'临沂路381弄',
        matter:'垃圾分类违规' ,    // 事项
        style:'巡查发现',
        department:'居委会',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:3
      },
      {
        title:'（补）东盛公寓',
        address:'浦三路821弄',
        matter:'停车矛盾' ,    // 事项
        style:'投诉发现',
        department:'上海创特物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:2
      },
      {
        title:'（补）华南名苑',
        address:'浦东南路3666弄',
        matter:'违规充电' ,    // 事项
        style:'智能发现',
        department:'上海证大物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）明丰佳园',
        address:'东方路2851弄',
        matter:'噪音扰民' ,    // 事项
        style:'投诉发现',
        department:'上海名东物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
    ]
    const DISCOVERYLIST = [     //智能发现列表上排
      {
        title:'当日新增',
        img:'data1.png',
        num:'2',
        unit:'个',
      },
      {
        title:'历史累计',
        img:'data2.png',
        num:'57',
        unit:'个',
      },
    ]
    const FOUNDLIST = [     //智能发现列表下排
      {
        title:'门岗脱岗',
        img:'mw.png',
        num:'0',
      },
      {
        title:'占用消防通道',
        img:'xf.png',
        num:'1',
      },
      {
        title:'集中充电异常',
        img:'cd.png',
        num:'1',
      },
      {
        title:'楼道充电',
        img:'ld.png',
        num:'0',
      },
      {
        title:'损坏房屋承重结构',
        img:'jg.png',
        num:'0',
      },
      {
        title:'屋顶违建',
        img:'dt.png',
        num:'0',
      },
      {
        title:'非定时倾倒垃圾',
        img:'lj.png',
        num:'0',
      },
      {
        title:'维修资金使用异常',
        img:'zj.png',
        num:'0',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
    commit('SET_REPAIRLIST', REPAIRLIST)
    commit('SET_HANDLELIST', HANDLELIST)
    commit('SET_DISCOVERYLIST', DISCOVERYLIST)
    commit('SET_FOUNDLIST', FOUNDLIST)
    commit('SET_SENDCHECKED', 3)
    commit('SET_ALLCHECKED', 7)
  },
  initLinyiData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'值班长',
        name:'倪萍',
        img:'person.png',
      },
      {
        title:'副值班长',
        name:'李铭',
        img:'person.png',
      },
    ]
    const OPERATELIST = [     // 基础数据
      {
        title: '小区',
        num: '5',
        unit: '个',
        img: 'map.png',
      },
      {
        title: '总户数',
        num: '1719',
        unit: '户',
        img: 'group.png',
      },
      {
        title:'物业企业',
        num:'4',
        unit: '家',
        img: 'data1.png',
      },
      {
        title:'监控探头',
        num:'16',
        unit: '个',
        img: 'data2.png',
      },
      {
        title:'电梯',
        num:'3',
        unit: '部',
        img: 'property.png'
      },
      {
        title:'车位',
        num:'62',
        unit: '个',
        img: 'community.png'
      },

    ]
    const REPAIRLIST = [     // 报修投诉
      {
        title:'报修',
        img:'repair.png',
        num:'1',
        allNum: '3',
      },
      {
        title:'投诉',
        img:'complaint.png',
        num:'1',
        allNum: '5',
      },
    ]
    const HANDLELIST = [    //协同处置
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'占用消防通道' ,    // 事项
        style:'智能发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 18:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 19:30:30',
        fixTime:beforeDay + ' 20:30:30',
        successTime:beforeDay + ' 20:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1,
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'违规充电' ,    // 事项
        style:'智能发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 12:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1,
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'毁绿占绿' ,    // 事项
        style:'投诉发现',
        department:'城管部门',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'垃圾分类违规' ,    // 事项
        style:'巡查发现',
        department:'居委会',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:3
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'停车矛盾' ,    // 事项
        style:'投诉发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:2
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'违规充电' ,    // 事项
        style:'智能发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'噪音扰民' ,    // 事项
        style:'投诉发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
    ]
    const DISCOVERYLIST = [     //智能发现列表上排
      {
        title:'当日新增',
        img:'data1.png',
        num:'6',
        unit:'个',
      },
      {
        title:'历史累计',
        img:'data2.png',
        num:'6',
        unit:'个',
      },
    ]
    const FOUNDLIST = [     //智能发现列表下排
      {
        title:'门岗脱岗',
        img:'mw.png',
        num:'0',
      },
      {
        title:'占用消防通道',
        img:'xf.png',
        num:'1',
      },
      {
        title:'集中充电异常',
        img:'cd.png',
        num:'1',
      },
      {
        title:'楼道充电',
        img:'ld.png',
        num:'1',
      },
      {
        title:'损坏房屋承重结构',
        img:'jg.png',
        num:'1',
      },
      {
        title:'屋顶违建',
        img:'dt.png',
        num:'1',
      },
      {
        title:'非定时倾倒垃圾',
        img:'lj.png',
        num:'1',
      },
      {
        title:'维修资金使用异常',
        img:'zj.png',
        num:'0',
      },
      {
        title:'窨井异常',
        img:'xf.png',
        num:'0',
      },
      {
        title:'水箱异常开启',
        img:'ld.png',
        num:'0',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
    commit('SET_REPAIRLIST', REPAIRLIST)
    commit('SET_HANDLELIST', HANDLELIST)
    commit('SET_DISCOVERYLIST', DISCOVERYLIST)
    commit('SET_FOUNDLIST', FOUNDLIST)
    commit('SET_SENDCHECKED', 0)
    commit('SET_ALLCHECKED', 1)
  },
  initShenjiangData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'值班长',
        name:'倪萍',
        img:'person.png',
      },
      {
        title:'副值班长',
        name:'李铭',
        img:'person.png',
      },
    ]
    const OPERATELIST = [     // 基础数据
      {
        title: '幢数',
        num: '28',
        unit: '幢',
        img: 'map.png',
      },
      {
        title: '总户数',
        num: '1755',
        unit: '户',
        img: 'group.png',
      },
      {
        title:'物业企业',
        num:'1',
        unit: '家',
        img: 'data1.png',
      },
      {
        title:'监控探头',
        num:'210',
        unit: '个',
        img: 'data2.png',
      },
      {
        title:'电梯',
        num:'43',
        unit: '部',
        img: 'property.png'
      },
      {
        title:'车位',
        num:'438',
        unit: '个',
        img: 'community.png'
      },

    ]
    const REPAIRLIST = [     // 报修投诉
      {
        title:'报修',
        img:'repair.png',
        num:'1',
        allNum: '3',
      },
      {
        title:'投诉',
        img:'complaint.png',
        num:'1',
        allNum: '5',
      },
    ]
    const HANDLELIST = [    //协同处置
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'占用消防通道' ,    // 事项
        style:'智能发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 18:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 19:30:30',
        fixTime:beforeDay + ' 20:30:30',
        successTime:beforeDay + ' 20:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1,
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'违规充电' ,    // 事项
        style:'智能发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 12:30:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1,
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'毁绿占绿' ,    // 事项
        style:'投诉发现',
        department:'城管部门',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'垃圾分类违规' ,    // 事项
        style:'巡查发现',
        department:'居委会',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:3
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'停车矛盾' ,    // 事项
        style:'投诉发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:2
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'违规充电' ,    // 事项
        style:'智能发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'（补）临沂二村',
        address:'浦三路12弄',
        matter:'噪音扰民' ,    // 事项
        style:'投诉发现',
        department:'上海振南物业',
        foundTime:beforeDay + ' 10:16:30',  // 可能是moment格式
        sendTime:beforeDay + ' 13:30:30',
        fixTime:beforeDay + ' 14:30:30',
        successTime:beforeDay + ' 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
    ]
    const DISCOVERYLIST = [     //智能发现列表上排
      {
        title:'当日新增',
        img:'data1.png',
        num:'6',
        unit:'个',
      },
      {
        title:'历史累计',
        img:'data2.png',
        num:'6',
        unit:'个',
      },
    ]
    const FOUNDLIST = [     //智能发现列表下排
      {
        title:'门岗脱岗',
        img:'mw.png',
        num:'0',
      },
      {
        title:'占用消防通道',
        img:'xf.png',
        num:'1',
      },
      {
        title:'集中充电异常',
        img:'cd.png',
        num:'1',
      },
      {
        title:'楼道充电',
        img:'ld.png',
        num:'1',
      },
      {
        title:'损坏房屋承重结构',
        img:'jg.png',
        num:'1',
      },
      {
        title:'屋顶违建',
        img:'dt.png',
        num:'1',
      },
      {
        title:'非定时倾倒垃圾',
        img:'lj.png',
        num:'1',
      },
      {
        title:'维修资金使用异常',
        img:'zj.png',
        num:'0',
      },
      {
        title:'窨井异常',
        img:'xf.png',
        num:'0',
      },
      {
        title:'水箱异常开启',
        img:'ld.png',
        num:'0',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
    commit('SET_REPAIRLIST', REPAIRLIST)
    commit('SET_HANDLELIST', HANDLELIST)
    commit('SET_DISCOVERYLIST', DISCOVERYLIST)
    commit('SET_FOUNDLIST', FOUNDLIST)
    commit('SET_SENDCHECKED', 0)
    commit('SET_ALLCHECKED', 1)
  },
  getCheckCommunityList({commit}, params = {}){// 获取检查小区的列表
    ajax.post({
      url: api.POST_CHECKCOMMUNITY_LIST,
      params: {
        pageSize: 10000,
        someday: '20200317',
        ...params
      },
    }).then(res => {
      // let list = common.confirm(res, 'data.content', [])
      let list = [
        // {COMMUNITYNAME: '兰高小区', X: 5606.064392, Y: -2538.0578, },
        // {COMMUNITYNAME: '(补)临沂二村', X: 3706.690186, Y: -4234.159912, TASKID:'（补）临沂二村', COMMUNITYID: '（补）临沂二村'},
        // {COMMUNITYNAME: '新高苑 ', X: 3606.064392, Y: -6538.0578, TASKID:'新高苑', COMMUNITYID: '新高苑'},
        // {COMMUNITYNAME: '(补)杨园四村', X: 4706.690186, Y: -2234.159912, TASKID:'（补）杨园四村', COMMUNITYID: '（补）杨园四村'},
        // {COMMUNITYNAME: '浦发博园', X: 6606.064392, Y: -4538.0578, TASKID:'浦发博园', COMMUNITYID: '浦发博园'},
        // {COMMUNITYNAME: '三林新村c4', X: 7606.064392, Y: -1238.0578, TASKID:'三林新村c4', COMMUNITYID: '三林新村c4'},
        // {COMMUNITYNAME: '(补)海阳新村 ', X: 8606.064392, Y: -3538.0578, TASKID:'（补）海阳新村', COMMUNITYID: '（补）海阳新村'},
        // {COMMUNITYNAME: '听潮六村 ', X: null, Y: null, TASKID:'听潮六村', COMMUNITYID: '听潮六村'},
        // {COMMUNITYNAME: '民乐城惠桐苑', X: null, Y: null, TASKID:'民乐城惠桐苑', COMMUNITYID: '民乐城惠桐苑'},
        {COMMUNITYNAME: '（补）教师大楼', TASKID:'（补）教师大楼', COMMUNITYID: '（补）教师大楼', icon: 'yellow.png', X: 4039.44281, Y: -4712.403381},
        {COMMUNITYNAME: '（补）临沂二村', TASKID:'（补）临沂二村', COMMUNITYID: '（补）临沂二村', icon: 'yellow.png', X: 3706.690186, Y: -4234.159912},
        {COMMUNITYNAME: '（补）金田公寓', TASKID:'（补）金田公寓', COMMUNITYID: '（补）金田公寓', icon: 'red.png', X: 3391.523438, Y: -3836.112488},
        {COMMUNITYNAME: '（补）临沂五村', TASKID:'（补）临沂五村', COMMUNITYID: '（补）临沂五村', icon: 'green.png', X: 3779.35022, Y: -4665.97998},
        {COMMUNITYNAME: '（补）东盛公寓', TASKID:'（补）东盛公寓', COMMUNITYID: '（补）东盛公寓', icon: 'green.png', X: 4678.271423, Y: -5648.677185},
        {COMMUNITYNAME: '（补）华南名苑', TASKID:'（补）华南名苑', COMMUNITYID: '（补）华南名苑', icon: 'yellow.png', X: 3094.474182, Y: -4879.984985},
        {COMMUNITYNAME: '（补）明丰佳园', TASKID:'（补）明丰佳园', COMMUNITYID: '（补）明丰佳园', icon: 'yellow.png', X: 4574.670227, Y: -4217.309998},
      ]
      if (params.isPublish == 1) {
        // commit('SET_SENDCHECKED',list.length)            // 传了1   已开单小区
      } else {
        commit('SET_CHECKCOMMUNITYLIST',list)    // 没传ispublish   已检查小区总数
        // commit('SET_ALLCHECKED',list.length)
      }
    })
  },
  getCheckedPeopleList({commit}, params = {}){            // 获取检查人员的列表
    ajax.post({
      url: api.POST_CHECKPEOPLE_LIST,
      params: {
        pageSize:10000,
        startDate:'2020-03-17 00:00:00',
        endDate:'2020-03-18 23:19:54',
        ...params,
      },
    }).then(res => {
      // let list = common.confirm(res, 'data.content', [])

      const list = [
        {TE_NAME: '孙杨保', ROLE_NAME: '市局', TASK_ID: '孙杨保', OPER_ID: '孙杨保'},
        {TE_NAME: '杨晓东', ROLE_NAME: '市局', TASK_ID: '杨晓东', OPER_ID: '杨晓东'},
        {TE_NAME: '奚海峰', ROLE_NAME: '市局', TASK_ID: '奚海峰', OPER_ID: '奚海峰'},
        // {TE_NAME: '胡永亮', ROLE_NAME: '市局', TASK_ID: '胡永亮', OPER_ID: '胡永亮'},
      ]
      commit('SET_CHECKPEOPLELIST',list)
    })
  }
}
