import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common.js'

export default {
  getCheckCommunityList({commit}, params = {}){// 获取检查小区的列表
    ajax.post({
      url: api.POST_CHECKCOMMUNITY_LIST,
      params: {
        pageSize: 10000,
        someday: '20200317',
        ...params
      },
    }).then(res => {
      let list = common.confirm(res, 'data.content', [])
      if (params.isPublish && params.isPublish == 1) {
        commit('SET_SENDCHECKED',list.length)            // 传了1   已开单小区
      } else {
        commit('SET_CHECKCOMMUNITYLIST',list)    // 没传ispublish   已检查小区总数
        commit('SET_ALLCHECKED',list.length)
      }
    })
  },
  getCheckedPeopleList({commit}, params = {}){            // 获取检查人员的列表
    ajax.post({
      url: api.POST_CHECKPEOPLE_LIST,
      params: {
        pageSize:10000,
        startDate:'2020-03-17 00:00:00',
        endDate:'2020-03-18 23:19:54',
        ...params,
      },
    }).then(res => {
      let list = common.confirm(res, 'data.content', [])
      commit('SET_CHECKPEOPLELIST',list)
    })
  }
}
