import ajax from '@/server/ajax'
import api from '@/server/api'
import common from '@/util/common.js'

export default {
  initData({commit}) {
    const COMMANDLIST = [    // 物业应急指挥体系
      {
        title:'指挥长',
        name:'周韶华',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'夏毅',
        img:'person.png',
      },
      {
        title:'值班长',
        name:'瞿越方',
        img:'person.png',
      },
    ]
    const OPERATELIST = [     // 运行体征
      {
        title:'小区',
        img:'community.png',
        unit: '个',
        num:'2790',
      },
      {
        title:'从业人员',
        img:'group.png',
        unit: '人',
        num:'41000',
      },
      // {
      //   title:'业委会',
      //   img:'group.png',
      //   unit: '个',
      //   num:'1749',
      // },
      {
        title:'物业企业',
        img:'property.png',
        unit: '家',
        num:'497',
      },
      {
        title:'管理面积',
        img:'map.png',
        unit: '万㎡',
        num:'17800',
      },
    ]
    const REPAIRLIST = [     // 报修投诉
      {
        title:'报修',
        img:'repair.png',
        num:'15',
        allNum: '348',
      },
      {
        title:'投诉',
        img:'complaint.png',
        num:'26',
        allNum: '248',
      },
    ]
    const HANDLELIST = [    //协同处置
      {
        title:'金港花园',
        address:'古楼公路345弄12号',
        matter:'占用消防通道' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:'2020-01-01 12:30:30',  // 可能是moment格式
        sendTime:'2020-01-02 13:30:30',
        fixTime:'2020-01-02 14:30:30',
        successTime:'2020-01-02 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:1
      },
      {
        title:'金港花园',
        address:'古楼公路345弄12号',
        matter:'占用消防通道' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:'2020-01-01 12:30:30',  // 可能是moment格式
        sendTime:'2020-01-02 13:30:30',
        fixTime:'2020-01-02 14:30:30',
        successTime:'2020-01-02 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:2
      },
      {
        title:'金港花园',
        address:'古楼公路345弄12号',
        matter:'占用消防通道' ,    // 事项
        style:'物业督查',
        department:'消防部门',
        foundTime:'2020-01-01 12:30:30',  // 可能是moment格式
        sendTime:'2020-01-02 13:30:30',
        fixTime:'2020-01-02 14:30:30',
        successTime:'2020-01-02 16:30:30',
        overTime:null,
        step:[
          {
            name:'推送',
          },
          {
            name:'处理中',
          },
          {
            name:'完成',
          },
          {
            name:'入库'
          }
        ],
        current:3
      },
    ]
    const DISCOVERYLIST = [     //智能发现列表上排
      {
        title:'本月新增',
        img:'data1.png',
        num:'34',
        unit:'个',
      },
      {
        title:'历史累计',
        img:'data2.png',
        num:'57',
        unit:'个',
      },
    ]
    const FOUNDLIST = [     //智能发现列表下排
      {
        title:'门卫脱岗',
        img:'mw.png',
        num:'1',
      },
      {
        title:'消防通道',
        img:'xf.png',
        num:'2',
      },
      {
        title:'维修资金',
        img:'zj.png',
        num:'3',
      },
      {
        title:'电梯困人',
        img:'dt.png',
        num:'1',
      },
      {
        title:'非机动车集中充电',
        img:'dz.png',
        num:'0',
      },
    ]
    commit('SET_COMMANDLIST', COMMANDLIST)
    commit('SET_OPERATELIST', OPERATELIST)
    commit('SET_REPAIRLIST', REPAIRLIST)
    commit('SET_HANDLELIST', HANDLELIST)
    commit('SET_DISCOVERYLIST', DISCOVERYLIST)
    commit('SET_FOUNDLIST', FOUNDLIST)
  },
  getCheckCommunityList({commit}, params = {}){// 获取检查小区的列表
    ajax.post({
      url: api.POST_CHECKCOMMUNITY_LIST,
      params: {
        pageSize: 10000,
        someday: '20200317',
        ...params
      },
    }).then(res => {
      let list = common.confirm(res, 'data.content', [])
      if (params.isPublish && params.isPublish == 1) {
        commit('SET_SENDCHECKED',list.length)            // 传了1   已开单小区
      } else {
        list.forEach((item, i) => { // 营造不同颜色的点，以后要删掉
          if (i >= 10) {
            item.icon = 'red.png'
          }
        })
        commit('SET_CHECKCOMMUNITYLIST',list)    // 没传ispublish   已检查小区总数
        commit('SET_ALLCHECKED',list.length)
      }
    })
  },
  getCheckedPeopleList({commit}, params = {}){            // 获取检查人员的列表
    ajax.post({
      url: api.POST_CHECKPEOPLE_LIST,
      params: {
        pageSize:10000,
        startDate:'2020-03-17 00:00:00',
        endDate:'2020-03-18 23:19:54',
        ...params,
      },
    }).then(res => {
      let list = common.confirm(res, 'data.content', [])
      commit('SET_CHECKPEOPLELIST',list)
    })
  }
}
