/** 公共方法 */
export default {
  gaodeLocation: [
    {name: '烟雾感应器', id: '4F00BA0F', lon: 121.511187, lat: 31.19628},
    {name: '烟雾感应器', id: '4F00B9E2', lon: 121.510922, lat: 31.196155},
    {name: '烟雾感应器', id: '4F00B9F2', lon: 121.511107, lat: 31.196236},
    {name: '烟雾感应器', id: '4F00B9EC', lon: 121.511001, lat: 31.196189},
    {name: '温湿度传感器', id: '4F00E284', lon: 121.511173, lat: 31.196303},
    {name: '温湿度传感器', id: '4F00E286', lon: 121.510993, lat: 31.19622},
    {name: '温湿度传感器', id: '4F00E287', lon: 121.511115, lat: 31.196274},
    {name: '温湿度传感器', id: '4F00E28A', lon: 121.510899, lat: 31.196179},
    {name: '震动传感器', id: '4F00E290', lon: 121.510306, lat: 31.195458},
    {name: '震动传感器', id: '4F00E291', lon: 121.509932, lat: 31.195557},
    {name: '震动传感器', id: '4F00E292', lon: 121.511298, lat: 31.195026},
    {name: '震动传感器', id: '4F00E293', lon: 121.510007, lat: 31.195328},
    {name: '震动传感器', id: '4F00E294', lon: 121.510186, lat: 31.195674},
    {name: '震动传感器', id: '4F00E295', lon: 121.51156, lat: 31.194614},
    {name: '震动传感器', id: '4F00E296', lon: 121.511426, lat: 31.194818},
    {name: '温湿度传感器', id: '4F00E285', lon: 121.509901, lat: 31.196354},
    {name: '温湿度传感器', id: '4F00E288', lon: 121.510042, lat: 31.196404},
    {name: '温湿度传感器', id: '4F00E289', lon: 121.509712, lat: 31.196273},
    {name: '温湿度传感器', id: '4F00E28B', lon: 121.510672, lat: 31.196546},
    {name: '人体感应传感器', id: '4F00E28C', lon: 121.509901, lat: 31.196354},
    {name: '人体感应传感器', id: '4F00E28D', lon: 121.510672, lat: 31.196546},
    {name: '人体感应传感器', id: '4F00E28E', lon: 121.509712, lat: 31.196273},
    {name: '人体感应传感器', id: '4F00E28F', lon: 121.510042, lat: 31.196404},
    {name: '水浸传感器', id: '4F00E297', lon: 121.509901, lat: 31.196354},
    {name: '水浸传感器', id: '4F00E298', lon: 121.510042, lat: 31.196404},
    {name: '水浸传感器', id: '4F00E299', lon: 121.510672, lat: 31.196546},
    {name: '水浸传感器', id: '4F00E29A', lon: 121.509712, lat: 31.196273},
    {name: '智能门磁感应器', id: '4F00AABD', lon: 121.509712, lat: 31.196273},
    {name: '智能门磁感应器', id: '4F00AABF', lon: 121.510672, lat: 31.196546},
    {name: '智能门磁感应器', id: '222238D5', lon: 121.509901, lat: 31.196354},
    {name: '智能门磁感应器', id: '4F00AAC4', lon: 121.510042, lat: 31.196404},
    {name: '超声波车检器', id: '4F00A512', lon: 121.511343, lat: 31.197095},
    {name: '井盖异动检测器', id: '4F008717', lon: 121.511191, lat: 31.195338},
    {name: '井盖异动检测器', id: '4F0087A4', lon: 121.511322, lat: 31.195105},
    {name: '井盖异动检测器', id: '4F0088CD', lon: 121.510899, lat: 31.195242},
    {name: '井盖异动检测器', id: '4F008977', lon: 121.510946, lat: 31.19668},
    {name: '超声波车检器', id: '864162040644943', lon: 121.510097, lat: 31.196471},
    {name: '超声波车检器', id: '864162040743323', lon: 121.510662, lat: 31.195084},
    {name: '超声波车检器', id: '864162040676879', lon: 121.510825, lat: 31.196117},
    {name: '超声波车检器', id: '864162040761416', lon: 121.510734, lat: 31.196155},
    {name: '超声波车检器', id: '864162040630405  ', lon: 121.510949, lat: 31.195285},
    {name: '超声波车检器', id: '868681046282354', lon: 121.510282, lat: 31.196054},
    {name: '智能门磁感应器', id: '222253AC', lon: 121.510337, lat: 31.196592},
    {name: '智能门磁感应器', id: '22225E97', lon: 121.510337, lat: 31.196592},
    {name: '智能门磁感应器', id: '22225EB2', lon: 121.510337, lat: 31.196592},
    {name: '智能门磁感应器', id: '2222558C', lon: 121.510337, lat: 31.196592},
    {name: '震动传感器', id: '4F00E2A3', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2A4', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2A5', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2A6', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2A7', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2A8', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2A9', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2AA', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2AB', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2AC', lon: 121.51057, lat: 31.197248},
    {name: '震动传感器', id: '4F00E2AD', lon: 121.51057, lat: 31.197248},
    {name: '电梯监控套装', id: '31103101152017110109', lon: 121.51023, lat: 31.196849},
    {name: '电梯监控套装', id: '31103101152017110236', lon: 121.510249, lat: 31.196837},
    {name: '电梯监控套装', id: '31103101152017110225', lon: 121.510572, lat: 31.197225},
    {name: '电梯监控套装', id: '31103101152017110104', lon: 121.510545, lat: 31.197238},
  ],
  /**
     * 在深层数据结构中取值（为了替代类似 res && res.data && res.data.content这种写法）
     * @param {Object} obj [必填-需要取值的目标对象（例：res）]
     * @param {String} path [必填-数据结构路径（例：'data.content'）]
     * @param {Any} defaultValue [可选-如果取不到值则默认返回该值]
     */
  confirm(obj, path, defaultValue = null) {
    if (!obj || typeof(obj) != 'object' || !path || typeof(path) != 'string') return defaultValue
    const reducer = (accumulator, currentValue) =>
      (accumulator && accumulator[currentValue]) ?
        accumulator[currentValue] :
        defaultValue

    path = path.split('.')
    return path.reduce(reducer, obj)
  },
  /**
     *  -----  柯里化版本 （为了不再重复输入obj这个参数） -----
     * 在深层数据结构中取值（为了替代类似 res && res.data && res.data.content这种写法）
     * @param {Object} obj [必填-需要取值的目标对象（例：res）]
     */
  confirm_currying(obj) {
    if (!obj || typeof(obj) != 'object') return
    return (path, defaultValue = null) => {
      if (!path || typeof(path) != 'string') return
      const reducer = (accumulator, currentValue) =>
        (accumulator && accumulator[currentValue]) ?
          accumulator[currentValue] :
          defaultValue
      path = path.split('.')
      return path.reduce(reducer, obj)
    }
  },
  /**
     * 转换为金钱格式(千分位且保留两位小数)
     * @param {Number | String} num [需转换的数字或字符串]
     */
  toMoney(num) {
    if (!num) {
      return 0.00
    }
    num = this.toFloat(num).toFixed(2)
    const arr = num.toString().split('.')
    let int = (arr[0] || 0).toString(),
      result = ''
    while (int.length > 3) {
      result = ',' + int.slice(-3) + result
      int = int.slice(0, int.length - 3)
    }
    if (int) {
      result = int + result
    }
    return `${result}.${arr[1]}`
  },
  //
  //
  //   转换为千位分隔符
  //
  format (num) {
    var reg=/\d{1,3}(?=(\d{3})+$)/g
    return (num + '').replace(reg, '$&,')
  },

  getSensorScene(type) {
    const data = {
      'fire': '火警报警',
      'staffLeaveAlarmTcfteodr': '门岗脱岗',
      'parkFireExit': '占用消防通道',
      'nonVehicleCharg': '集中充电异常',
      'elevatorLock': '楼道充电',
      'buildingVibration': '损坏承重结构',
      'trash': '非定时倒垃圾',
      'manholeCover': '窨井盖异常',
      'waterTank': '水箱异常开启',
      'roofWater': '屋顶积水',
      'hermeticSpace': '屋顶违章建筑',
    }
    return data[type]
  },

}
