// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import 'babel-polyfill'
import Vue from 'vue'
import App from './App'
import router from './router'
import store from './store'
import ajax from './server/ajax'
import api from './server/api'
import cookie from './util/local-cookie'
import common from './util/common'
import {
  Button,
  message,
  Spin,
  Layout,
  Menu,
  Icon,
  Breadcrumb,
  Form,
  Input,
  InputNumber,
  Card,
  Dropdown,
  Row,
  Col,
  Checkbox,
  Select,
  Alert,
  Table,
  Divider,
  Upload,
  Modal,
  badge,
  Tree,
  Tabs,
  DatePicker,
  skeleton,
  pagination,
  Tag,
  Badge,
  TreeSelect,
  Radio,
  Cascader,
  LocaleProvider,
  Steps,
  Anchor,
  Collapse,
  Popconfirm,
  Progress,
  Switch,
  Calendar,
  BackTop,
  Carousel,
  Tooltip,
} from 'ant-design-vue'
import ActiveForm from '@/components/ActiveForm'
import ActiveTable from '@/components/ActiveTable'
// 由于日期组件默认是英文的，需要本地化
import moment from 'moment'
import 'moment/locale/zh-cn'
moment.locale('zh-cn')

Vue.use(ActiveForm)
Vue.use(ActiveTable)
Vue.use(Button)
Vue.use(Spin)
Vue.use(Layout)
Vue.use(Menu)
Vue.use(Icon)
Vue.use(Breadcrumb)
Vue.use(Form)
Vue.use(Input)
Vue.use(InputNumber)
Vue.use(Card)
Vue.use(Dropdown)
Vue.use(Row)
Vue.use(Col)
Vue.use(Checkbox)
Vue.use(Select)
Vue.use(Alert)
Vue.use(Table)
Vue.use(Divider)
Vue.use(Upload)
Vue.use(Modal)
Vue.use(badge)
Vue.use(skeleton)
Vue.use(Tree)
Vue.use(Tabs)
Vue.use(DatePicker)
Vue.use(pagination)
Vue.use(Tag)
Vue.use(Badge)
Vue.use(TreeSelect)
Vue.use(Radio)
Vue.use(Cascader)
Vue.use(LocaleProvider)
Vue.use(Steps)
Vue.use(Anchor)
Vue.use(Collapse)
Vue.use(Popconfirm)
Vue.use(Progress)
Vue.use(Switch)
Vue.use(Calendar)
Vue.use(BackTop)
Vue.use(Carousel)
Vue.use(Tooltip)
Vue.config.productionTip = false
Vue.prototype.$ajax = ajax
Vue.prototype.$api = api
Vue.prototype.$cookie = cookie
Vue.prototype.$com = common
Vue.prototype.$message = message

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  components: { App },
  template: '<App/>'
})
