const xlsx = require('node-xlsx')
const fs = require('fs')

const extractFromFile = (file) => {
  console.info('开始从文件提取数据')
  const workSheetFromFile = xlsx.parse(`${__dirname}/${file}`)
  const sheets = JSON.parse(JSON.stringify(workSheetFromFile))
  return sheets[0].data
}

const processData = (file) => {
  const data = extractFromFile(file)
  if (!data || data.length === 0) {
    console.error('没有从文件中取得数据')
    return
  }
  return data
    .map((item, index) => {
      return {
        street: item[1],
        community: item[2],
        address: `${item[3]}${item[4]}弄${item[5]}号`,
        condition: item[6],
        color: item[7],
        location: [+item[8], +item[9]],
      }
    })
    .slice(1)
}
const start = (file, output) => {
  const data = processData(file)
  fs.writeFile(`${__dirname}/${output}`, JSON.stringify(data), (err) => {
    if (err) {
      console.error('写入文件错误：', err)
      return
    }
    console.info('--------  任务已完成  ---------')
  })
}

start('summary.xlsx', 'summary.json')
