export default{
  switchBuildingColor(level) {
    switch (level) {
    case 1:
      return ['ff99ff00', 'ff999900']
    case 2:
      return ['ffffff00', 'ffffcc00']
    case 3:
      return ['ffcc0000', 'ffaa0000']
    default:
      return []
    }
  },
  switchRate(ratio) {
    if (!ratio) return 0
    const result = ratio * 100
    if (result >= 100) return 100
    return result
  },
  switchIcon(ratio) {
    if (!ratio) ratio = 0
    ratio = ratio * 100
    if (ratio <= 50) return 'star1'
    if (ratio <= 75) return 'star2'
    return 'star3'
  },
  switchColor(color) {
    if (!color) return null
    if (color.indexOf('绿') >= 0) return {'background-color': '#8fd618'}
    if (color.indexOf('黄') >= 0) return {'background-color': 'gold'}
    if (color.indexOf('红') >= 0) return {'background-color': 'red'}
  },
  switchStarNum(val) {
    if (!+val) return 0
    if (+val > 3) return 3
    return +val
  },
  switchStatus(status) {
    status = Number(status)
    switch (status) {
    case 0:
      return '未签约'
    case 1:
      return '已公告'
    case 2:
      return '已施工'
    case 3:
      return '已竣工'
    default:
      return '暂无状态'
    }
  },
}
