// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import 'babel-polyfill'
import Vue from 'vue'
import App from './App'
import router from './router'
import common from './util/common'
import api from './util/api'
import {Button, Collapse, Panel, Modal, Table, Drawer, Tabs, TabPane, Spin} from 'view-design'
import 'view-design/dist/styles/iview.css'

Vue.config.productionTip = false
Vue.prototype.$com = common
Vue.prototype.$api = api
Vue.component('Button', Button)
Vue.component('Collapse', Collapse)
Vue.component('Panel', Panel)
Vue.component('Modal', Modal)
Vue.component('Table', Table)
Vue.component('Drawer', Drawer)
Vue.component('Tabs', Tabs)
Vue.component('TabPane', TabPane)
Vue.component('Spin', Spin)
/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  components: { App },
  template: '<App/>'
})
