export default{
  switchBuildingColor(level) {
    switch (level) {
    case 1:
      return ['ff99ff00', 'ff999900']
    case 2:
      return ['ffffff00', 'ffffcc00']
    case 3:
      return ['ffcc0000', 'ffaa0000']
    default:
      return []
    }
  },
  switchImg(ratio) {
    if (!ratio) ratio = 0
    if (ratio < 1) {
      ratio = ratio * 100
    }
    if (ratio <= 10) return 1
    if (ratio <= 20) return 2
    if (ratio <= 30) return 3
    if (ratio <= 40) return 4
    if (ratio <= 50) return 5
    if (ratio <= 60) return 6
    if (ratio <= 70) return 7
    if (ratio <= 80) return 8
    if (ratio <= 90) return 9
    if (ratio <= 100) return 10
  },
  switchColor(color) {
    if (!color) return null
    if (color.indexOf('绿') >= 0) return {'background-color': '#8fd618'}
    if (color.indexOf('黄') >= 0) return {'background-color': 'gold'}
    if (color.indexOf('红') >= 0) return {'background-color': 'red'}
  },
  switchStarNum(intention) {
    if (!intention) return 0
    if (intention.indexOf('一') >= 0) return 1
    if (intention.indexOf('二') >= 0 || intention.indexOf('两') >= 0) return 2
    if (intention.indexOf('三') >= 0) return 3
  },
  switchStatus(status) {
    status = Number(status)
    switch (status) {
    case 0:
      return '未签约'
    case 1:
      return '已公告'
    case 2:
      return '已开工'
    case 3:
      return '已完工'
    default:
      return '暂无状态'
    }
  },
}
