export default{
  switchBuildingColor(level) {
    switch (level) {
    case 1:
      return ['ff99ff00', 'ff999900']
    case 2:
      return ['ffffff00', 'ffffcc00']
    case 3:
      return ['ffcc0000', 'ffaa0000']
    default:
      return []
    }
  },
  similar(str1, str2) {
    if (!str1 || !str2 || typeof(str1) != 'string' || typeof(str2) != 'string') {
      console.error('参数需要是string类型！')
      return 0
    }

    const len1 = str1.length
    const len2 = str2.length
    const arr = []

    for (let i = 0; i <= len1; i++) {
      arr[i] = []
      arr[i][0] = i
    }
    for (let i = 0; i <= len2; i++) {
      arr[0][i] = i
    }

    let temp
    for (let i = 1; i <= len1; i++) {
      for (let j = 1; j <= len2; j++) {
        if (str1.charAt(i - 1) == str2.charAt(j - 1)) {
          temp = 0
        } else {
          temp = 1
        }
        arr[i][j] = Math.min(arr[i - 1][j - 1] + temp, arr[i][j - 1] + 1, arr[i - 1][j] + 1)
      }
    }
    return (1 - arr[len1][len2] / Math.max(len1, len2)).toFixed(3)
  }
}
