import MyMap from './my-map'
import { CallBack, Listener, MapConfig } from './types'

declare const aimap: {
  Map: any
  accessToken?: string
  baseApiUrl?: string
}
export default class AI_Map extends MyMap {
  constructor(config: MapConfig) {
    aimap.accessToken = config.appKey
    aimap.accessToken = config.appKey

    const instance = new aimap.Map({
      container: config.el,
      center: config.center,
      zoom: config.zoom,
      minZoom: config.zooms?.[0],
      maxZoom: config.zooms?.[1],
      pitch: config.pitch,
      minPitch: config.pitchs?.[0],
      maxPitch: config.pitchs?.[1],
      bearing: config.bearing,
      style: config.style,
    })
    super(instance)
  }

  on<K extends keyof Listener>(name: K, cb: CallBack) {
    const eventName = `on${name.slice(0, 1).toUpperCase()}${name
      .slice(1)
      .toLowerCase()}` as Listener[K]
    ;(this[eventName] as Function)(cb)
    return this
  }

  private onClick(cb: CallBack) {
    this.map.on('click', cb)
  }
  private onLoad(cb: CallBack) {
    this.map.on('load', cb)
  }
  private onZoom(cb: CallBack) {
    this.map.on('zoom', cb)
  }
  private onMove(cb: CallBack) {
    this.map.on('move', cb)
  }
  private onBlur(cb: CallBack) {
    this.map.on('blur', cb)
  }
  private onFocus(cb: CallBack) {
    this.map.on('focus', cb)
  }
  private onDrag(cb: CallBack) {
    this.map.on('drag', cb)
  }
  private onResize(cb: CallBack) {
    this.map.on('resize', cb)
  }
  private onDblClick(cb: CallBack) {
    this.map.on('dblclick', cb)
  }
  private onMouseWheel(cb: CallBack) {
    this.map.on('mousewheel', cb)
  }
}
