export type MapConfig = Partial<MapOptions>

export interface MapOptions {
  el: string
  /**
   * SMap 地图专用
   * @param internet 表示互联网2D
   * @param affairs 表示政务网2D
   * @param local3D 表示局域网3D
   * @param affairs3D 表示政务网3D
   * @param njdl 表示南京东路政务网3D
   */
  netType: 'internet' | 'affairs' | 'local3D' | 'affairs3D' | 'njdl'
  mode: '2D' | '3D'
  center: [number, number]
  zooms: [number, number]
  zoom: number
  pitch: number
  style: string
  appKey: string
  showBuildingBlock: boolean
  rotateEnable: boolean
}

export type CallBack = (arg: unknown, oth?: unknown) => void

export interface Listener {
  load: 'onLoad'
  zoom: 'onZoom'
  move: 'onMove'
  blur: 'onBlur'
  focus: 'onFocus'
  drag: 'onDrag'
  resize: 'onResize'
  click: 'onClick'
  dblclick: 'onDblClick'
  mousewheel: 'onMouseWheel'
}
