import MyMap from './my-map'
import { CallBack, MapConfig, Listener, EventName } from './types'

declare const SMap: {
  Map: any
  MapEvent: any
  Size: any
  Icon: any
  Label: any
  Marker: any
  Network: any
}
declare const Plugins: {
  MaskBoundary: any
}

export default class S_Map extends MyMap {
  constructor(config: MapConfig) {
    if (!config.netType) {
      throw new Error('SMap需要设置netType参数！')
    }
    new SMap.Network().setNet(config.netType)
    const instance = new SMap.Map(config.el, {
      appKey: config.appKey,
      viewMode: config.mode,
      center: config.center,
      zoom: config.zoom,
      zooms: config.zooms,
      pitch: config.pitch,
      mapStyle: config.style,
      showBuildingBlock: config.showBuildingBlock,
      rotateEnable: config.rotateEnable,
    })
    super(instance)
    this.on('load', this.clearFooter)
  }

  private clearFooter() {
    const footer = document.querySelector(
      '.esri-ui-manual-container>.esri-component',
    )
    footer && ((footer as HTMLElement).style.display = 'none')
  }

  on<K extends keyof Listener>(name: K, cb: CallBack) {
    const eventName = `on${name.slice(0, 1).toUpperCase()}${name
      .slice(1)
      .toLowerCase()}` as Listener[K]
    this[eventName](cb)
    return this
  }

  private onLoad(cb: CallBack) {
    this.map.on(SMap.MapEvent.maploaded, cb)
  }
  private onZoom(cb: CallBack) {
    this.map.on(SMap.MapEvent.zoomchanged, cb)
  }
  private onMove(cb: CallBack) {
    this.map.on(SMap.MapEvent.centerchanged, cb)
  }
  private onBlur(cb: CallBack) {
    this.map.on(SMap.MapEvent.blur, cb)
  }
  private onFocus(cb: CallBack) {
    this.map.on(SMap.MapEvent.focus, cb)
  }
  private onDrag(cb: CallBack) {
    this.map.on(SMap.MapEvent.drag, cb)
  }
  private onResize(cb: CallBack) {
    this.map.on(SMap.MapEvent.resize, cb)
  }

  private event(event: unknown, cb: CallBack) {
    this.map.on(event, (view: any, eventParamter: any) => {
      view.hitTest(eventParamter).then((res: any) => {
        cb(res.results, eventParamter.mapPoint)
      })
    })
  }

  private onClick(cb: CallBack): void {
    this.event(SMap.MapEvent.click, cb)
  }
  private onDblClick(cb: CallBack): void {
    this.event(SMap.MapEvent.doubleclick, cb)
  }
  private onMouseWheel(cb: CallBack): void {
    this.event(SMap.MapEvent.mousewheel, cb)
  }
}
