import { MapConfig } from './types'
import S_Map from './s-map'
import AI_Map from './ai-map'

const whichMap = {
  SMap: {
    with: (config: MapConfig) => new S_Map(config),
  },
  AIMap: {
    with: (config: MapConfig) => new AI_Map(config),
  },
}

export default function useMap<K extends keyof typeof whichMap>(key: K) {
  return whichMap[key]
}
