/**
 * 地图配置
 */
export type MapConfig = Partial<{
  /** 地图容器（需要有宽高） */
  el: string
  /**
   * SMap 地图专用
   * @param internet 表示互联网2D
   * @param affairs 表示政务网2D
   * @param local3D 表示局域网3D
   * @param affairs3D 表示政务网3D
   * @param njdl 表示南京东路政务网3D
   */
  netType: 'internet' | 'affairs' | 'local3D' | 'affairs3D' | 'njdl'
  /** 地图模式 */
  mode: '2D' | '3D'
  /** 地图初始中心点位 */
  center: Location
  /** 地图初始zoom等级 */
  zoom: number
  /** 地图zoom允许范围 */
  zooms: [number, number]
  /** 地图初始旋转角度 */
  bearing: number
  /** 地图初始仰角（3D用） */
  pitch: number
  /** 地图仰角允许范围 */
  pitchs: [number, number]
  /** 地图样式 */
  style: string
  /**
   * 在SMap中作为appKey使用
   * 在AIMap中作为accessToken使用
   */
  appKey: string
  showBuildingBlock: boolean
  rotateEnable: boolean
  baseApiUrl: string
  family: string
}>

export type Location = [number, number] | [number, number, number]

/**
 * 监听回调函数
 */
export type CallBack = (arg: any, oth?: any) => unknown

/**
 * 监听事件
 */
export interface Listeners {
  /** 加载完成触发 */
  load: (cb: CallBack) => unknown
  /** zoom变化触发 */
  zoom: (cb: CallBack) => unknown
  /** 地图移动 */
  move: (cb: CallBack) => unknown
  /** 失焦触发 */
  blur: (cb: CallBack) => unknown
  /** 聚焦触发 */
  focus: (cb: CallBack) => unknown
  /** 拖动触发 */
  drag: (cb: CallBack) => unknown
  /** 视图大小变化触发 */
  resize: (cb: CallBack) => unknown
  /** 点击触发 */
  click: (cb: CallBack) => unknown
  /** 双击触发 */
  dblclick: (cb: CallBack) => unknown
  /** 滚轮触发 */
  mousewheel: (cb: CallBack) => unknown
}

type Position = 'top-left' | 'top-right' | 'bottom-left' | 'bottom-right'
export interface ControlOptions {
  show?: boolean
  /** 控件位置 */
  position?: Position
  /** ScaleControl控件的最大长度，以像素为单位 */
  maxWidth?: number
  /** ScaleControl控件的距离单位 */
  unit?: 'imperial' | 'metric' | 'nautical'
}
export interface Controls {
  home: (options?: ControlOptions) => unknown
  compass: (options?: ControlOptions) => unknown
  zoom: (options?: ControlOptions) => unknown
  scale: (options?: ControlOptions) => unknown
  fullScreen: (options?: ControlOptions) => unknown
  layerList: (options?: ControlOptions) => unknown
  measureLine: (options?: ControlOptions) => unknown
  measureArea: (options?: ControlOptions) => unknown
  basemapToggle: (options?: ControlOptions) => unknown
  underguroundSwitch: (options?: ControlOptions) => unknown
  bMapGallery: (options?: ControlOptions) => unknown
  bMapGalleryexpand: (options?: ControlOptions) => unknown
}
export interface ZoomOptions {
  /** 如果 false ，则没有动画效果（默认true） */
  animate?: boolean
  /** 动态转换的持续时间，按毫秒计算（默认3000） */
  duration?: number
  /** 该函数持续的时间在 0~1 之间， 返回一个表示状态的数字，初始状态为 0，最终状态为 1 */
  easing?: (t?: number) => number | void
  /** 动态转换结束后，目标中心与实际地图容器中心间的偏差，单位为像素 */
  offset?: [number, number]
}

export interface FocusOptions {
  /**地图缩放等级（默认当前等级） */
  zoom?: number
  /** 地图倾斜角度（默认当前角度） */
  pitch?: number
  /** 地图旋转角度（默认当前角度） */
  bearing?: number
  /** 图层距离容器四周距离(单位像素) */
  padding?: { top?: number; bottom?: number; left?: number; right?: number }
  /** 动画速度（默认1.2） */
  speed?: number
  /** 默认1.42 */
  curve?: number
  /** 整个fly动画持续毫秒时间（默认3000） */
  maxDuration?: number
}
