/**
 * 地图配置
 */
export type MapConfig = Partial<{
  /** 地图容器（需要有宽高） */
  el: string
  /**
   * SMap 地图专用
   * @param internet 表示互联网2D
   * @param affairs 表示政务网2D
   * @param local3D 表示局域网3D
   * @param affairs3D 表示政务网3D
   * @param njdl 表示南京东路政务网3D
   */
  netType: 'internet' | 'affairs' | 'local3D' | 'affairs3D' | 'njdl'
  /** 地图模式 */
  mode: '2D' | '3D'
  /** 地图初始中心点位 */
  center: [number, number]
  /** 地图初始zoom等级 */
  zoom: number
  /** 地图zoom允许范围 */
  zooms: [number, number]
  /** 地图初始旋转角度 */
  bearing: number
  /** 地图初始仰角（3D用） */
  pitch: number
  /** 地图仰角允许范围 */
  pitchs: [number, number]
  /** 地图样式 */
  style: string
  /**
   * 在SMap中作为appKey使用
   * 在AIMap中作为accessToken使用
   */
  appKey: string
  showBuildingBlock: boolean
  rotateEnable: boolean
  baseApiUrl: string
}>

/**
 * 监听回调函数
 */
export type CallBack = (arg: any, oth?: any) => void

/**
 * 监听事件
 */
export interface Listeners {
  /** 加载完成触发 */
  load: (cb: CallBack) => unknown
  /** zoom变化触发 */
  zoom: (cb: CallBack) => unknown
  /** 地图移动 */
  move: (cb: CallBack) => unknown
  /** 失焦触发 */
  blur: (cb: CallBack) => unknown
  /** 聚焦触发 */
  focus: (cb: CallBack) => unknown
  /** 拖动触发 */
  drag: (cb: CallBack) => unknown
  /** 视图大小变化触发 */
  resize: (cb: CallBack) => unknown
  /** 点击触发 */
  click: (cb: CallBack) => unknown
  /** 双击触发 */
  dblclick: (cb: CallBack) => unknown
  /** 滚轮触发 */
  mousewheel: (cb: CallBack) => unknown
}
