import MyMap from './my-map'
import { CallBack, MapConfig, Listeners } from './types'

declare const SMap: {
  Map: any
  MapEvent: any
  Size: any
  Icon: any
  Label: any
  Marker: any
  Network: any
}
declare const Plugins: {
  MaskBoundary: any
}

export default class S_Map extends MyMap {
  constructor(config: MapConfig) {
    if (!config.netType) {
      throw new Error('SMap需要设置netType参数！')
    }
    new SMap.Network().setNet(config.netType)
    const instance = new SMap.Map(config.el, {
      appKey: config.appKey,
      viewMode: config.mode,
      center: config.center,
      zoom: config.zoom,
      zooms: config.zooms,
      pitch: config.pitch,
      mapStyle: config.style,
      showBuildingBlock: config.showBuildingBlock,
      rotateEnable: config.rotateEnable,
    })
    super(instance)
    this.setListeners()
    this.on('load', this.clearFooter)
  }

  private clearFooter() {
    const footer = document.querySelector(
      '.esri-ui-manual-container>.esri-component',
    )
    footer && ((footer as HTMLElement).style.display = 'none')
  }
  private setListeners() {
    const listeners: Partial<Listeners> = {
      load: (cb: CallBack) => {
        this.map.on(SMap.MapEvent.maploaded, cb)
      },
      zoom: (cb: CallBack) => {
        this.map.on(SMap.MapEvent.zoomchanged, cb)
      },
      move: (cb: CallBack) => {
        this.map.on(SMap.MapEvent.centerchanged, cb)
      },
      blur: (cb: CallBack) => {
        this.map.on(SMap.MapEvent.blur, cb)
      },
      focus: (cb: CallBack) => {
        this.map.on(SMap.MapEvent.focus, cb)
      },
      drag: (cb: CallBack) => {
        this.map.on(SMap.MapEvent.drag, cb)
      },
      resize: (cb: CallBack) => {
        this.map.on(SMap.MapEvent.resize, cb)
      },
      click: (cb: CallBack) => {
        this.event(SMap.MapEvent.click, cb)
      },
      dblclick: (cb: CallBack) => {
        this.event(SMap.MapEvent.doubleclick, cb)
      },
      mousewheel: (cb: CallBack) => {
        this.event(SMap.MapEvent.mousewheel, cb)
      },
    }
    this.listeners = Object.assign(this.listeners, listeners)
  }

  private event(event: unknown, cb: CallBack) {
    this.map.on(event, (view: any, eventParamter: any) => {
      view.hitTest(eventParamter).then((res: any) => {
        cb(res.results, eventParamter.mapPoint)
      })
    })
  }
}
