import { CallBack, Listeners } from './types'

export default class MyMap {
  protected map
  protected listeners: Listeners
  constructor(instance: any) {
    this.map = instance
    this.listeners = {
      load: (cb: CallBack) => {
        console.error('on：此地图不存在 load 监听事件！')
      },
      zoom: (cb: CallBack) => {
        console.error('on：此地图不存在 zoom 监听事件！')
      },
      move: (cb: CallBack) => {
        console.error('on：此地图不存在 move 监听事件！')
      },
      blur: (cb: CallBack) => {
        console.error('on：此地图不存在 blur 监听事件！')
      },
      focus: (cb: CallBack) => {
        console.error('on：此地图不存在 focus 监听事件！')
      },
      drag: (cb: CallBack) => {
        console.error('on：此地图不存在 drag 监听事件！')
      },
      resize: (cb: CallBack) => {
        console.error('on：此地图不存在 resize 监听事件！')
      },
      click: (cb: CallBack) => {
        console.error('on：此地图不存在 click 监听事件！')
      },
      dblclick: (cb: CallBack) => {
        console.error('on：此地图不存在 dblclick 监听事件！')
      },
      mousewheel: (cb: CallBack) => {
        console.error('on：此地图不存在 mousewheel 监听事件！')
      },
    }
  }

  /**
   *  原始地图实例
   * （主要适用于调用原始地图的方法、功能）
   */
  get instance(): any {
    return this.map
  }

  /**
   * 监听事件
   * @param name 事件名称
   * @param cb 回调函数
   */
  on<K extends keyof Listeners>(name: K, cb: CallBack) {
    this.listeners[name](cb)
    return this
  }
}
