import MyMap from './my-map'
import { CallBack, MapConfig, Listeners } from './types'

declare const aimap: {
  Map: any
  accessToken?: string
  baseApiUrl?: string
}
export default class AI_Map extends MyMap {
  constructor(config: MapConfig) {
    aimap.accessToken = config.appKey
    aimap.baseApiUrl = config.baseApiUrl

    const instance = new aimap.Map({
      container: config.el,
      center: config.center,
      zoom: config.zoom,
      minZoom: config.zooms?.[0],
      maxZoom: config.zooms?.[1],
      pitch: config.pitch,
      minPitch: config.pitchs?.[0],
      maxPitch: config.pitchs?.[1],
      bearing: config.bearing,
      style: config.style,
    })
    super(instance)
    this.setListeners()
  }

  private setListeners() {
    const listeners: Partial<Listeners> = {
      load: (cb: CallBack) => {
        this.map.on('load', cb)
      },
      zoom: (cb: CallBack) => {
        this.map.on('zoom', cb)
      },
      move: (cb: CallBack) => {
        this.map.on('move', cb)
      },
      blur: (cb: CallBack) => {
        this.map.on('blur', cb)
      },
      focus: (cb: CallBack) => {
        this.map.on('focus', cb)
      },
      drag: (cb: CallBack) => {
        this.map.on('drag', cb)
      },
      resize: (cb: CallBack) => {
        this.map.on('resize', cb)
      },
      click: (cb: CallBack) => {
        this.map.on('click', cb)
      },
    }
    this.listeners = Object.assign(this.listeners, listeners)
  }
}
