// The module 'vscode' contains the VS Code extensibility API
// Import the module and reference it with the alias vscode in your code below
import * as vscode from 'vscode';
import { getWebViewContent, fetchProject, updatePackageJson } from './util';

// this method is called when your extension is activated
// your extension is activated the very first time the command is executed
export function activate(context: vscode.ExtensionContext) {

	// Use the console to output diagnostic information (console.log) and errors (console.error)
	// This line of code will only be executed once when your extension is activated
	// console.log('Congratulations, your extension "my-cli" is now active!');

	// The command has been defined in the package.json file
	// Now provide the implementation of the command with registerCommand
	// The commandId parameter must match the command field in package.json
	const disposable = vscode.commands.registerCommand('my-cli.my-cli', () => {
		const panel = vscode.window.createWebviewPanel(
			'my-cli',
			'创建前端项目',
			vscode.ViewColumn.One,
			{
				enableScripts: true,
				retainContextWhenHidden: true,
			}
		);
		panel.webview.html = getWebViewContent('../front-view/public/index.html');
		panel.webview.onDidReceiveMessage(async msg => {
			const {command, data} = msg;
			switch (command) {
				case 'FETCH_PROJECT':
					const {url, filePath, filename} = data;
					try {
						await fetchProject({url, filePath, filename});
					} catch (error) {
						panel.webview.postMessage({
							command: 'CLOSE_LOADER',
						});
					}
					await updatePackageJson(data);
					panel.webview.postMessage({
						command: 'CLOSE_LOADER',
					});
					break;
				case 'SELECT_FOLDER':
					const folders = await vscode.window.showOpenDialog({
						canSelectFolders: true,
						canSelectFiles: false
					});
					panel.webview.postMessage({
						command: 'DIRECTORY',
						data: {
							text: folders?.[0]?.path
						}
					});
					break;
				default:
					break;
			}
		}, undefined, context.subscriptions);
	});

	context.subscriptions.push(disposable);
}

// this method is called when your extension is deactivated
export function deactivate() {}
