export default function useLayout(key: string) {
  switch (key) {
    case '2-6-1':
      return {
        template: ['box1 . box4', 'box2 . box5', 'box3 . box6'],
        rows: '1fr 1fr 1fr',
        boxNum: 6,
      }
    case '2-5-1':
      return {
        template: ['box1 . box3', 'box2 . box4', 'box2 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-5-2':
      return {
        template: ['box1 . box3', 'box1 . box4', 'box2 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-5-3':
      return {
        template: ['box1 . box4', 'box2 . box4', 'box3 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-5-4':
      return {
        template: ['box1 . box4', 'box2 . box5', 'box3 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-4-1':
      return {
        template: ['box1 . box3', 'box2 . box4', 'box2 . box4'],
        rows: '1fr 1fr 1fr',
        boxNum: 4,
      }
    case '2-4-2':
      return {
        template: ['box1 . box3', 'box1 . box3', 'box2 . box4'],
        rows: '1fr 1fr 1fr',
        boxNum: 4,
      }
    default:
      return {
        template: [],
        rows: '',
        boxNum: 0,
      }
  }
}
