import { onBeforeUnmount } from '@vue/runtime-core'

export type Settings = { path: string; value: string; pastValue: string }[]

export default function useSettings(settings: Settings) {
  let timer: any = null
  function setNewValue() {
    settings.forEach((item) => {
      const ele = document.querySelector<HTMLElement>(item.path)
      ele && (ele.innerText = item.value)
    })
  }

  let count = 0
  timer = setInterval(() => {
    setNewValue()
    count += 1
    if (count >= 10) {
      clearTimer()
    }
  }, 500)

  function clearTimer() {
    timer && clearInterval(timer)
    timer = null
  }
  onBeforeUnmount(clearTimer)
}
