let BASE_URL: string = ''
switch (process.env.NODE_ENV) {
  case 'production':
    BASE_URL = 'http://ja-hm.omniview.pro/api/v2'
    break
  default:
    BASE_URL = 'http://ja-hm.omniview.pro/api/v2'
}

export default {
  BASE_URL,
  CONFIGS: '/service-bigscreen/public/bigscreenConfigs', // 配置
  GET_COMMUNITY: '/service-basicdatasync-ddd/public/community/{id}', // 根据id获取小区详情
  POST_COMMUNITY: '/service-customkey-ddd/public/communities/v2', // 小区
  BUILDINGS: '/service-basicdatasync-ddd/public/community/buildings', // 门牌幢
  BUILDING: '/service-basicdatasync-ddd/public/building/{id}', // 根据id查楼栋信息
  RISK_BUILDINGS: '/service-special-ja-ddd/public/getRiskByBuilding', // 安全排查结果
  ORDERS: '/service-documents-ddd/public/dr/check/orders', // 月查
  ORDER: '/service-documents-ddd/public/dr/check/order/{id}', // 根据id查检查单
  CHECK_ORDERS: '/service-documents-ddd/public/checkOrder/pages', // 检查单列表
  BX: '/service-documents-ddd/public/reportBX', // 物业报修
  TS: '/service-documents-ddd/public/reportTS', // 物业投诉
  EQUIPMENT: '/service-basicdatasync-ddd/public/community/facEqus', // 设施设备
  EXPAND_INFO:
    '/service-basicdatasync-ddd/public/tbl_community/entity/{id}/ext', // 小区拓展信息
  ELEVATOR: '/service-special-ja-ddd/public/elevatorInstallationInfos', // 电梯
  GIS: '/service-special-ja-ddd/public/giss', // gis点位
}
