import { ref } from 'vue'
import useConfig, { Config } from './useConfig'

export default function useLayout() {
  const showLayoutModal = ref(false) // 展示布局选择弹窗
  const layout = ref<Config['layout']>({
    // 布局内容设置
    template: [],
    rows: '',
    boxNum: 0,
  })

  const config = useConfig() // 获取布局配置
  if (config?.layout) {
    layout.value = config.layout
  }

  const onChangeLayout = (key: string) => {
    // 选择某一布局后获取布局内容
    layout.value = getLayout(key)
  }
  return { showLayoutModal, layout, onChangeLayout }
}

function getLayout(key: string) {
  switch (key) {
    case '2-6-1':
      return {
        template: ['box1 . box4', 'box2 . box5', 'box3 . box6'],
        rows: '1fr 1fr 1fr',
        boxNum: 6,
      }
    case '2-5-1':
      return {
        template: ['box1 . box3', 'box2 . box4', 'box2 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-5-2':
      return {
        template: ['box1 . box3', 'box1 . box4', 'box2 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-5-3':
      return {
        template: ['box1 . box4', 'box2 . box4', 'box3 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-5-4':
      return {
        template: ['box1 . box4', 'box2 . box5', 'box3 . box5'],
        rows: '1fr 1fr 1fr',
        boxNum: 5,
      }
    case '2-4-1':
      return {
        template: ['box1 . box3', 'box2 . box4', 'box2 . box4'],
        rows: '1fr 1fr 1fr',
        boxNum: 4,
      }
    case '2-4-2':
      return {
        template: ['box1 . box3', 'box1 . box3', 'box2 . box4'],
        rows: '1fr 1fr 1fr',
        boxNum: 4,
      }
    default:
      return {
        template: [],
        rows: '',
        boxNum: 0,
      }
  }
}
