export interface Config {
  layout: { template: string[]; rows: string; boxNum: number }
  components: { [key: number]: string }
}

export default function useConfig(config?: string) {
  if (config) {
    // 保存配置
    window.sessionStorage.setItem('__layout_components__', config)
    return
  }

  // 获取配置
  const data = window.sessionStorage.getItem('__layout_components__')
  if (data) {
    return JSON.parse(data) as Config
  } else {
    return {
      layout: {
        template: [],
        rows: '',
        boxNum: 0,
      },
      components: {},
    }
  }
}
