import { defineComponent, resolveComponent, openBlock, createElementBlock, normalizeClass, Fragment, renderList, normalizeStyle, createCommentVNode, createElementVNode, createVNode, toDisplayString, createTextVNode, createBlock, withCtx, pushScopeId, popScopeId, unref, inject, computed, ref, watch, markRaw, provide, h, renderSlot, onBeforeMount, toRef } from 'vue';

var img$9 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA21BMVEUAAABcZnBGU2FHVGJGU2JHVGJIVGJLWmVKVmdGVGJGVGJGU2FGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFGVGJHVGFHVGJHVGJIVWJIU2NIVGNIVmRIVWJIU2SAgIBIU2JGU2H////V2NtjbnqSmqJNWWdQXGlpdH/x8vOyuL3S1dnP0taBipOssrjb3eBUYG2hp6/P09apr7VIVmPf4eRhbHilq7Kgp651f4n7+/zJzdHBxcq3vMGXnqZbZ3Pn6etYZHD19vfY296Lk5yEjZZweoWcoqp5g41daHWQoSEBAAAAIHRSTlMABvh9+6NEIx/68+/s49/a0srEv6edj4h1X1VKPC4ChxxGkpcAAANeSURBVGjezdppV+IwFAbg0IVF9l1Wb0TEZVgUBlkVx23+/y8aWoamkEtKQnv0/aIn1sec2JumCeSYhBpV3cxlUglNS6QyOVOvNkLEj4Tqel4DLlper5/4B5ph8wwO5swMN5XpaDkJHkmWo0p0pBiDIxIrRuTpggFHxijI8SFdA4lousT/NpwGyaTDx3a7BAopHdX5aBaUko1627U4KCZe87IrBijHqIjtczgp5yL7Ak7MhUq/T+97BXxIBbdrhh+4UcPsaBx8STyK1GUWfEqWr9US+JYSN1eBjwnvDUraTzy9OzA6+BrdbUc0f3Et4sILIMryZdGW1AuujgvL54lS+iCpG6zrRQ9bQS86tRkT2yp6bFunZbGtppc3dlOwrhrY7uONvJ5sHirOzmTSYvYVdGz9vi1fpibXvlpL0yGzATryfTftyufXsb8tacjsp76CfmbNAXU4gDv2LR31FUam7kwrPD5mNqU9pktNMPkDuMtW0/OEhDQcd9u2fi2rayHSABxntrLeIFUMd+wuZfkjq1fRx8SYs5V0nZh4zTNbXTdJzttmuZTScySDz4PMVtczJHWo34+Ijev3AxxPkQTXb8dGc8fpHXozRPEE2a2hT87m9fZWByv2pV94Fe3hL7iN6y3nd+Y4vjcs71PO5vOw0RdgZ7JueW3jw5KCXX30ZheRp97rwiYLq+UNw1P8rehl790q7VerYYbfijnMltDfqZXpCi0iE5u1vHMF/zOjdpZY+fMTV0sK70+pnR46cVXF+N1k1bfzMUfxq21DC5tyG0K856q9OYZfbhvG2MMipInwJaxmIyt3HfhC8L9Owwv2mCN5Ef7LqacZtBB8wFo+kAc00cX47XbwUXzEWm6xpUX9BLzDGvipse4s59Tw7s61yHKOmMr48MbdNEcWoiSsjE+oO9MhsoRuJlXx/ri7zoLSmfV1iS3+SVkJd/JsXcaljL1wqeP4CxcpyuPLayfr9rfNd0OmFNGXXDEuzusH8pJLCv7g9BF5PScRzR98wDYW8C2R50tXJvDZ22Rh/0Cc+bMzrQS5mRPkNlSQG2iBbv0FuWkZ5HZrkBvFQW9xB785H/yxQvAHIsEf5QR/CKV+fPb9B39KR5Y/5bBV7pj4px1wH3c0/1M/VHDixyH+ASV8UgWLo8tSAAAAAElFTkSuQmCC";
  var icon1 = img$9;

var img$8 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA/1BMVEUAAABGU2KwsLBGU2FHVGJGU2FLV2RIVWRubnRHU2FGU2FHVGJHU2FGVGFGVGJGU2FGVGJGU2JIVGNHVGJHVGJIVWNGU2JGU2JHU2JGVGJIVWNKWGVJV2dGU2JHVGJHU2JIVWRJWGZKV2hGVGJHU2FIVWJGVGJHU2FGU2JOYnZGVGJGU2FIU2RKVmRQW2pIU2JGU2H///9MWWb19vZ9hpBUYG2XnqZ7hI6nrrT9/f2HkJl2gIra3eBIVWPg4uSTm6OLk5y4vcOkqrH5+frx8vNga3dZZXHs7u/q6+3k5ujd4OK/w8issriboqllcHxPXGnV2NvQ09fP09bKzdGzuL4kE+K2AAAAMHRSTlMA+wH17uMUNAT463Hf1Mm3l4h7dlxF8sWNZkkkHdijbTofGLydQauRgQbOsS4sEVbl30lTAAADIUlEQVRo3rWa6XLaMBRGZWOHYGPWsoU1AZqkWfo5lDbshOxLk27v/ywNYVoHyzKyLZ0ZfjFzRnMlXUn3mvCgVnfMTDplJTVNt1LtTn6nuk1EoB6bR0VQxNL5uBpRHd83wETLtML7t3J1bCB5sBdKvVeOgYNEZjf4qDMJcKI0asFmsakhALH8doBp/ISA1Lu8w84pCE52myvaaYSixBH5lo6QaIVN7p0YQqN88Hd/UBAF08/dREQOfMaNyJjMeCuIDiPurRgEoBQ817cOIWgeiUxNQxApeq/mIYwylasUiMMVdjUFgdQP1+QV+PB0abPpzUGTW1spGtg82770JqCI7RKHffjwzfanD5rGu4HHRMuV6n95Fl68PI3v70PK0fnnPi3Cg8mD/UpYuVIjK0x4MbSjyJElK7zP+kU0ua6SJSfw5Jxb7rdNy3zyi/7ZOtdjSk6vRp1PPoKb777y4jI5VsEnfxh+WWd25ytHy0krImJOJ5iPsuTtV7khS544JHuQJccx6cqTfyYVefIcKfPKx9RSvN0gbziLJeomoimRNq/88ca9/X9tkFskJS/mSVKXJzeILk+ekCqXGha5E9qWJ7fYm2jRWwJg1FsxWLkuey58NlEZvExX8iF4aZAKeLl4cw+uwUuOlXIno9nX94yAm95S/gd4Ga79NRtNGCmXcVj0x7aLOfD8Y3B1/ir6bbsY9xmHBTG8Q+Dm9gzA8oeRTfHIOOa8l8sVLVhgxdnYprhiHNDeM2p7sHgL7c1P2wPW1aLKK7fvzuezC+/3EetSRJJMOT+s6xzJypF3nCu0eHnXufwLl+vqSm7KkGedB5dweaLmPBWFyzs+j9xBMPfA55FLJ/VpMPmUTuUOWwb1CA3E3K+wQCeY4XTAHZOp242c9GKO/DKU/AIaUY8giNK2xKJljXgQF1RulVkollnillmcl9hWaMptiPgT1xESoyC/CeWPmhfYPqOJB86RVpdwo1YEtixptvb5m62dWvA2cbYork1Mc5q3hDa46da8DiZGpkWioZ40jzRQFNNmXCUiUHcLzUy6ZCUNLWmV0hmT83OIv9yi4fsD/tVEAAAAAElFTkSuQmCC";
  var icon2 = img$8;

var img$7 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAAw1BMVEUAAABGVGFHVGJGU2JGU2FHVGJHVGFIVWNLWmVKVmdgYIBaaWlHVGJGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFHVGJHVGJIVWJIU2NIVGNIVGNIVWJIU2RIU2JGU2H///+nrrT8/P3l5+mAiJKSmqK6vsT6+vvp6+xYY3BOWmj09PXt7vCzuL5yfIfX2t2Hj5je4eOZoKhKVmS+wsejqbCNlZ6EjZZpc39eaXVUYG3h5ObJzdGutLplcHu0ub+dpKyCi5WR5B/VAAAAHnRSTlMA93368aafSCMfCAX+7OPf2tLKxL+PiHVfVUM8Lof1DLvbAAAC5ElEQVRo3s2aaW/iMBCGbeegSct9tBwdF7YhBJarNz129///qhWRJTY1Nk6c0fJ8ROJRZDsv4xmICeGoz7x2s16ltFpvtj3WH4WkDC6HrENBgnbY8NJSPfBdUOL6g+LmoFeDE9R6QSH1he+AAY5/kV/tXYEhV14+fcgo5ICyHIen0oCcNCqmh68LBegaHcygBYVoBQZL4kJB3JNLc+NAYZwbvfsarLjWuW/Bklus59Y/+w2UgGLdKw6UgFM5er5dKAU3OPJetqAkWvK72oXS6EoLDlp26+h9sYjewIhvyx42NHm9fFqNeUq8M8vIbAIzUDB7fpzzAxEYwTK/OxSO8LC82/AsEzCCXpADHsi8RnMuMQUzvH8e/AokXsb8CGPT39XDo/sg8TblNnLwiSBwQOKT28mdQMh7ILOylENPyGsgM7GV10Q9CBhyGIjtRJH7aRy6+eSzZQImuPtwHEIu+W7Opx/3MwP7MI2VXPIfPGW1fTMJmE5uuWDz9Ao6OoSEVCd/SkSGPWflgvhzqa60aUhGoJGPD1+NJbnw/wEVI9LXyfkXCGZTWS54AQV9wrTyefQzJYq5Ur5IlDvqQd4NlVgqQ71tL39WyNukaS+/V8ibpI4nr5MqnrxKKJ6cospRlwV3Q5v6N/QxSnlcfJNP9p9uTh1F/Uv0qsiWyUNa+qy08jbxCqXiB6T80sq9E8G1fRDl2Tq7LPM0T74WWjlTR66wTVPG0obuPz2xoX0ywjstIxJSLDkNCelgyTuEEIYlZ2lRhCQfpuUchlyUc8THkfuihEaRD0TxjyGvqa8t9vKe4sKlkydrLrFNkkRx4ZK29GUTx/GY5+N9Bhl8xSV3wYuwVV1ys6G+KiRfZ6Nc1ViY/b7Lz1rdWCAMSoUpmzn2NEJlG8qeCmYDDbX1h9m0xGy3YjaKMVvcmM15zLEC5kAEc5SDOYTCHJ/9/8FfoZHluQxb842Jz23AbTSaP98/Fdj9HeIvPkYT9tICXNQAAAAASUVORK5CYII=";
  var icon3 = img$7;

var script$b = defineComponent({
  name: 'Brief',
  props: {
    list: {
      type: Array,
      required: true
    },
    color: {
      type: String,
      default: null
    },
    size: {
      type: String,
      default: '0.22rem'
    },
    align: {
      type: String,
      default: 'horizontal'
    }
  }
});

const _hoisted_1$a = ["src"];
const _hoisted_2$8 = {
  key: 1
};
const _hoisted_3$8 = {
  class: "count-group"
};

const _hoisted_4$8 = /*#__PURE__*/createTextVNode(" / ");

function render$4(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_count = resolveComponent("m-count");

  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["brief-container", {
      vertical: _ctx.align === 'vertical'
    }])
  }, [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.list, item => {
    return openBlock(), createElementBlock("div", {
      key: item.name
    }, [item.icon ? (openBlock(), createElementBlock("img", {
      key: 0,
      src: item.icon,
      style: normalizeStyle(`width:${_ctx.size};height:${_ctx.size}`)
    }, null, 12, _hoisted_1$a)) : createCommentVNode("", true), Array.isArray(item.value) ? (openBlock(), createElementBlock("div", _hoisted_2$8, [createElementVNode("div", _hoisted_3$8, [createVNode(_component_m_count, {
      class: "count orange-count",
      value: item.value[0],
      style: normalizeStyle({
        color: _ctx.color
      })
    }, null, 8, ["value", "style"]), _hoisted_4$8, createVNode(_component_m_count, {
      class: "count",
      value: item.value[1]
    }, null, 8, ["value"])]), createElementVNode("p", null, toDisplayString(item.name), 1)])) : (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass({
        center: !item.icon
      })
    }, [createVNode(_component_m_count, {
      class: "count",
      style: normalizeStyle({
        color: _ctx.color
      }),
      value: item.value
    }, null, 8, ["style", "value"]), createElementVNode("p", null, toDisplayString(item.name), 1)], 2))]);
  }), 128))], 2);
}

function styleInject(css, ref) {
  if ( ref === void 0 ) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') { return; }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}

var css_248z$b = ".brief-container[data-v-27978040] {\n  display: flex;\n  align-items: center;\n  white-space: nowrap;\n  flex-wrap: wrap;\n}\n.brief-container .count[data-v-27978040] {\n  font-family: $font-barlow;\n  font-size: 0.14rem;\n}\n.brief-container.vertical[data-v-27978040] {\n  display: inline-block;\n}\n.brief-container >div[data-v-27978040] {\n  display: flex;\n  align-items: center;\n  width: 33%;\n}\n.brief-container >div >img[data-v-27978040] {\n  margin-right: 0.05rem;\n}\n.brief-container >div >div[data-v-27978040] {\n  font-weight: bold;\n}\n.brief-container >div >div p[data-v-27978040] {\n  color: #ccc;\n}\n.brief-container >div >div.center[data-v-27978040] {\n  text-align: center;\n}\n";
styleInject(css_248z$b);

script$b.render = render$4;
script$b.__scopeId = "data-v-27978040";

const _withScopeId$3 = n => (pushScopeId("data-v-707d5116"), n = n(), popScopeId(), n);

const _hoisted_1$9 = {
  class: "wrapper"
};
const _hoisted_2$7 = {
  class: "left"
};
const _hoisted_3$7 = {
  class: "right"
};

const _hoisted_4$7 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("p", null, "整改执行", -1));

const _hoisted_5$5 = {
  class: "count"
};

const _hoisted_6$5 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("p", null, "已开", -1));

const _hoisted_7$4 = /*#__PURE__*/createTextVNode(" | ");

const _hoisted_8$4 = {
  class: "count"
};

const _hoisted_9$4 = /*#__PURE__*/createTextVNode("%");

const _hoisted_10$4 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("p", null, "完成率", -1));
const __default__$6 = {
  name: 'A001',
  title: '物业'
};

function setup$6(__props) {
  const summary = [{
    icon: icon1,
    name: '小区',
    value: 904
  }, {
    icon: icon2,
    name: '业委会',
    value: 400
  }, {
    icon: icon3,
    name: '物业服务企业',
    value: 130
  }];
  const list = [{
    name: '房办月查',
    value: 79
  }, {
    name: '物企双周查',
    value: 83
  }, {
    name: '物业日查',
    value: 100
  }];
  return (_ctx, _cache) => {
    const _component_m_progress = resolveComponent("m-progress");

    const _component_m_count = resolveComponent("m-count");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "物业"
    }, {
      default: withCtx(() => [createVNode(script$b, {
        list: summary
      }), createElementVNode("div", _hoisted_1$9, [createElementVNode("div", _hoisted_2$7, [(openBlock(), createElementBlock(Fragment, null, renderList(list, item => {
        return createVNode(_component_m_progress, {
          key: item.name,
          value: item.value,
          msg: {
            name: item.name,
            value: item.value,
            unit: '%',
            color: '#fff'
          },
          color: ['rgb(36,59,86)', '#F4923E']
        }, null, 8, ["value", "msg", "color"]);
      }), 64))]), createElementVNode("div", _hoisted_3$7, [_hoisted_4$7, createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("p", _hoisted_5$5, [createVNode(_component_m_count, {
        value: 63
      })]), _hoisted_6$5]), _hoisted_7$4, createElementVNode("div", null, [createElementVNode("p", _hoisted_8$4, [createVNode(_component_m_count, {
        value: 76
      }), _hoisted_9$4]), _hoisted_10$4])])])])]),
      _: 1
    });
  };
}

var script$a = /*#__PURE__*/defineComponent({ ...__default__$6,
  setup: setup$6
});

var css_248z$a = ".wrapper[data-v-707d5116] {\n  display: flex;\n  padding-bottom: 0.05rem;\n}\n.wrapper .left[data-v-707d5116] {\n  flex: 1.8;\n}\n.wrapper .right[data-v-707d5116] {\n  flex: 1;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  margin: 0.06rem 0.06rem 0 0.1rem;\n  padding: 0.06rem 0.1rem;\n}\n.wrapper .right >div[data-v-707d5116] {\n  display: flex;\n  align-items: center;\n  margin-top: 0.1rem;\n}\n.wrapper .right >div >div[data-v-707d5116] {\n  flex: 1;\n  text-align: center;\n}\n.wrapper .right >div >div .count[data-v-707d5116] {\n  font-size: 0.12rem;\n  color: #edb872;\n  font-family: DIN, 'Avenir', Helvetica, Arial, sans-serif;\n  font-weight: bold;\n}\n.wrapper .right >div >div >p[data-v-707d5116] {\n  color: #ccc;\n}\n";
styleInject(css_248z$a);

script$a.__scopeId = "data-v-707d5116";

var img$6 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA1VBMVEUAAABcZnBGU2FHVGJGU2JHVGJIVGJJWWVGVGFGVGJGU2FGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFGVGJHVGFHVGJHVGJIVWJIU2NIVGNIVmRIVWJIU2RMWmdNVWaAgIBIU2JGU2H///+AiJLFyc54gYuQl6Db3uFfanb39/jq7O3k5ujKztLO0tWpr7b7+/vw8fK5vsPt7u/BxclSXmvV2Nulq7Kco6pzfYhWYm9MWWbX2t2zub6WnaWFjpdsd4JpdH/f4eSts7mLk5xmcXyIkZqBipNC5kTCAAAAIXRSTlMABvh9/KNEIfrz7+zj39rSysS/p52PiHVfVUo8LiUeAofuiMjAAAADIElEQVRo3s2ae1PiMBDAQ9ICgsgb5aG4RaiVN/hEEfS8+/4f6UqYOcrFJE3pjvz+WmecH5mSTba7kDAkWnVmF/O5LKXZXL5os3orQeIg0WQlCgK0xJoHfkA7aZ+AlBM72Y6svqqdgobT2lUk9WUlDSFIVy6N1amyBSGxyimzb5FRMIAyg+82eQaGnCXDLrsKEaiGWnyqAJEohHjyjQxEJNPQuS8siIx1oXafw0Gcq9zXcCDXmnUjrf0CYkDy3BtWHHKr8e3+zkAsZFKiO1GAmCiIuVqF2KgKZxUILEYzR8Qb3mrtyf8eyhkIvDnfM7nXnpH7D4aBwMvYkfAEOtjeTqEg0HVkTLVyGtwxZRDpSOU3oKUcuIutuOXW7tauQNxyqPyrT9Lxy9NXZEsN4pdDjXDap+byl2n/jvO6lNVibUlyauWL/u6vR2Wa2ir53Xu3233ku9sPOu5WvnR2jCUJa/PMP1HJf/H4wXFmPHjeyqdOgGdJDbw5A5pgLr8JyjsSQZMfK2aPRZQrDpiSQi5iIC8RkqBYcpogLcCSQ4vUI8v7nZ6nlNcJiyzvAoyUckbsyPJbgJ5SbpMinrxI8mr5eDoajR420YcfvHkm8jzJqeX8Mrb8c8rjR8i7iTxHsmr5Hx4P/L3Bg3VAvgJ4UsqzhKrlD5sFP4/96LcfLOYB+fBlPVPKKaF4SURJFk+eJTk8eY7kI8u9z7lanj8giXoAc3US4aY/w5Mz7ZF757quxw8CP+gbyeu6y2LKS/WJ715vokcTeUt3zXX20/8rIP8CWKqvOd0F/bYJ7zcr569CTwH5JyxelRe0trRw3OFwOOHb2g9e95LoY6YtLZpYGdrk5RyOnJdzxMaR29sSGkeeVBf/5nKx+Cc1DHlN98JlLhdfuEglfnlF/5JrLhdfckk5bnlZ3lhYzQeDgSuVTwZ7jRjX/+f5StZYEA6YvmNMH4IwRTNnYi6fSJo5Ypr2PFO31xOSE6uBhtr6w2xaYrZbMRvFmC1uzOY85lgBcyCCOcrBHEJhjs9+fvAXaWR5LMNWszHxsQ24w43mj/VHBQf+HOIv6+FkF94I7mUAAAAASUVORK5CYII=";
  var icon4 = img$6;

var img$5 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAAn1BMVEUAAABcZnBGU2JGU2FHVGJGU2FGU2FHVGJIVGJLWmVKVmdGVGJHU2JGVGFHU2FGU2JHVGFGVGJHVGFHVGJHVGJIVWJIU2NIVGNIVmRIVWJIU2SAgIBIU2JGU2H///+2u8FrdYC1ur/Z3N+Ql6Dc3uHh4+XDyMzS1tn5+vr09PXq7O2gpq5ueYRXY3CxtryTm6OQmKB+h5FjbXlhbHhPW2ml6aG0AAAAHXRSTlMABvv4fe7do0QjH/Pj0srEv6edj4h1X1VKPC4Ch85MXNQAAAKZSURBVGjetNNXVgJBEIXh22ECAhIletsIiDntf21yPCoI0z3FQH8L+E893IKEmgxt1mqmiTFJ2mxldjhROAY1tm3DHaZtxwoHmeZZnV71LJ+iqpN+gyUa/RNUUetqCuhubf90R1NId/bLK2u4B2MVxPKUe0pzyKgeK+gp0UZOWcmpYDejhBUlI5QYaFamBwg640HOEHDOA50L7o5w+4BHMPDsRPMI9Khw3wmPIinYuxL8ztN8/iT4JoVtgp9/XTq3fGWpHrbkLPO+cN8W7yyT4x+VMkw/3Lkfdw+aYanCJsuwx5nbMHtkmMWGmmHI57Pb8vzJEFPDWochb/dux/0bQzobh+vg/lyh4Cr1+vQu/W6WzmN5Q7/u329q+nwsXMDigz7690/7of35hVfZx7dpw7e/W1fq1rfKxjT4nC9O5CX4phmLXTiRCxbLsKLqceJ1BWDMOHGOAVhxfHa9MhPHLYC2OH7JlUtxvA0oEytuFCaMFecEw3jxIWy8uEUmj8+vVubyeIYWY+2cLTTjxZtI48VTJPHiCUy8uPlq1mxWGISBIDyh/uRi/QXRQ6ktKvT9H7C45NJCwlYz1Dnl9F3c4OxMVHAHeMjfQY6TDp7y4CkyHjxDwYMXKHnwUnf91+eml/g4Oa6665/wRjFBz4P3GHnwEebCgl8MULHgldJaLPdNs/gLOS5KazGw5nwQO8eBi51DzoHn2GQ5cOvMP+ODOvOPjjGKXWjh0sPDCxea+PAmvOTq4eElF3VseO0LFianWQefJ6ePYMEXidx2yheJwGTH4d4wBzYm3OJLbTx464n+YsCvhhlaMuNWZlDMjLiZ4TyzVmAWIswqh1lCMeuz/xd/uyrLs5Stv9XEZyu4ddX8WR8VHHwO8QZvsPW/TuK6fgAAAABJRU5ErkJggg==";
  var icon5 = img$5;

var img$4 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA21BMVEUAAABGVGFHVGJGU2JGU2FHVGJHVGFIVWNLWmVKVmdgYIBaaWlGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFHVGJHVGJIVWJIU2NIVGNIVGNIVWJIU2RIU2JGU2H///9SXmvQ09agp675+vr6+vtHVGKPl5/8/PxLWGWwtbvr7O7n6epOW2j19fbc3uG4vcLg4uXLztLDyMxkb3tcZ3Pv8PKco6qKkpuAiZLX2t20ub6SmaJ8hY93gYtyfIdoc35eanZVYW74+PnBxcqjqrCGj5jFys68wcaTm6Otsrh9oYmoAAAAHXRSTlMA93368aafSCMfCAXs49/a0srEv4+IdV9VQzwuh3BQCboAAANtSURBVGjezZrpUuJAEIAngUQI96Uc9nAYQEDuQ1EQr9V9/ydaEjYmq51kJsnU+v1yYtVXw6S7SbohLGiNqqwU89m0JKWz+aIiVxsaiYJUXS5J8A2pJNdTIdU1NQ6uxNVacHOykgEfMpVkIHVCjQEDMTXBr1Z0YERX+PSaLAEHkswRPGc54CR3xhp8ZQhAOcUUIwUIRCHJcCRxCEjc92guYhCY2IW3+xxCce7lvoSQXPrsW9DeLyACXM79LAYREDtD4zsOkRBPInlZgIgofM/VMkRG+duBQ4R8OXYtBxGS04gTGSJFdroTEkSKlCA2CiDcjju93tUXOl8YbEeAoDg2rmNuykYLEHR76yogTCkjt4CgfuYmlvc7SsNsPWblaQUQ5pSZR0CokBPYc9Wyxy6fAEKGmNQA4ZWy03kChJrr7ewPKAdt11uaiqNxyMOqj5VeozjWAaFFudgAQt2lrCwoH2O3AlNCrl9TTvaIpESIhtSs0Q2vfI5VL400kMv3lJfeAdE0SBW5Oqbc/EY0VfR+Ok/ln4Afui5+oXdU8dl5a+BUOBeTK2pzjRb1ok/uryfU5mNLbXbOZHhANEWSR642V/ZnHx069qL/ZJ/YDPa2+w4Q8iQLCG/OHbWdi6719/MSYPIZLGjVzZI0YKxPFffq3ihi79YJwZHNMzWYLox8aP11bwAjTSRAeXwfPA8ni6Pa+CDjo2C2Py50gMN2Orhb949qAP1jSmlnvgAUyZbj6PO2mbPLvrlwBMXT1Nxv0/iPmzwNXjRnlL7q1uKF0pem9dGGxqF5kiZZcOewXpmhcGvoR10za1bthQ793aRnRswOPMiSPLgwH9phdzOeTe2I7DkyeHU324ALeVIEF1p8X3JoEini5AqRxcllUvWVD7qLh1YQeZU0/OQ3S2vFK28QTfKQ28V0zy+XNEJKPvL7Uz7yy0vGo4WPvHvKTn65bDwUiZLXrce58HL8cY6oYuQqMaiJkdeISUaEPGO9toiQV5AXrhBy/IWLqNHLVeQlN5Qcf8klioe8dW2w5ZMrPo2FCWXkzbOxgBeY5ZhJ3XtBzlT2b+aMmgz00WaOyDaUyAaa0NafyKalyHaryEaxyBa3yOa8yLGCyIGIyFGOyCGUyPHZ/x/8BRpZ/pRhK9+Y+KcNuJlG8z/3RwXhfg7xB6gTAxHfAaEDAAAAAElFTkSuQmCC";
  var icon6 = img$4;

var img$3 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA0lBMVEUAAABHVGJGU2JGU2FIVGJLWmVKVmdmZmZHU2JGVGJHVGFGVGJGU2FGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFGVGJIVGJHVGJHVGFHVGJIVWJIU2NIVGNIVmRIVWJIU2RgYIBJbW1GU2H///+Pl5/S1diGj5j9/f25vsNxe4b7+/uWnqbs7e+KkptLWGWSmqJtd4Ohp654gYvk5ujf4eTIzNC0usCssriboqpibHhdaXVSXmv29/fy8/TMz9OCipTY297AxMmmrLN9h5Fncn3T1trwuhTPAAAAInRSTlMAffv4RCMfBYj6+fPv7OPf2tLKxL+npKGdj3VfVUo8LggH6G/WKQAAAwVJREFUaN7NmmlX6jAQhtMW2fcdZfOtgpSCiCjivt3//5fuFTkGbNNOQnouzyc+PeQkmUkyU0ah32sb9UqpkEunc4VSpW60e32mg0TXqFrwYFWNbmJPdayRgZBMI6ZujifzCCGfjCupj5opEEg1j+TVNRNEzJqc/tSwIIFlnEosYxGSFKlLm2hBgVaCtEfKUKJM2DedLBTJdsLcJyaUMU+C3cfYi+MgdxJ7kqSMW//YT6ABwbx3TGjA7Pju7yy0kI37xGUZmih7Y7UFbbQ8uQoaif3KsUVopLibgQ0QuLPXODMAt5vfc/hh7Jw7Fghc2N8MAJxvfp/BD+uIcWrQK0dta+AmdpiN1tyry00+9CZ2sTecf6jK0fyJzZRXvuF6/KAmT8VFidbe4nG5UpDz5Jv3k3OGN3MFeV4UnPZvFpdTKTkP04ZYznla3kvKG+t0mAmW89n5IyXPfCXHLghyDlmOLk8rOuU8wVSjklcZ61vS8sVkSpFbfdYDWc55el+Ey9FjbSk5hyBvMyM6ucHq0cnrrLKf/HkGIRVWUpNzXgdT+FNiBVU5x716gB8FllOXc5yLGbzkWJoqd4P98JImy92VIy0nT8sYt7LyHHVB3SnuHdF2vPoHvBSoW3EMCId+J9qKxCBypwAfOlFeIYX/8Po7yt/dof9y+FMPS1zXt+OPFQ/B6efL3YVLlBthKffJGx0Dhyhvhx4WjyPsMhlSp6UXfsw9zrHN2ZA651afcEA72/ax7eUSvlRJVwtnxufEpssN2qWIT/ulhLxLu87xdD2iyzMJ0kXUxQ8P9HO0QbtC3wDAy9t6clyyPEa6/NtLYP769SefwDNVng98tnAmo/NNjnlbLanyZOCDi7PYTmFEeSoufCrKMYGXpveRqy4XP3JZTbe8JigsKMrFhQVm6JUbnmKOsnwQUMzxhqnz+wz9Qix/EQRn5AU0/aW/6IuW0Zdb9ReKoy9xR1+c199WiL4hor+VE2UTKsr22f9v/Cm1LA+l2SrXJj60BjepNX+4HxXs9znEX1oDfV+ZAFJRAAAAAElFTkSuQmCC";
  var icon7 = img$3;

var img$2 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAAtFBMVEUAAABcZnBGU2FHVGJGU2JGU2FHU2FHVGJHVGFIVGJLWmVKVmdHU2JGVGJGVGJGU2FGVGFHU2FGU2JHVGFHVGJIVWJIU2NIVGNIVmRIVWJIU2SAgIBGU2H////d3+J1f4lmcXxoc366v8SQmKDKzdHf4eSYn6dibXnq7O1NWmf19vd8hY+DjJVyfIZeanZVYW7BxcqmrLN6g42Kkpvw8fLi5Oaxtrz+/v7T1tnQ09eaoalsdoFqpc6HAAAAHHRSTlMABvh9++7hpp9EIx+I+vPa0srEv491X1VKPC4CKilPXQAAAqdJREFUaN7Nmol22jAQRWXJK/sW1mcSUhqWmCWQpNv//1ftQ0lpkYVkNCfcD7jW0YzG8oyZDs6wJ4JWw/c49/xGKxC9ocNs4AxEm+MM3haDKx8wisIacqmF0aiwulzxcQG/Ui6kLoVVaFANS+bqwIUmbmCmdwSHAVwYxDaqw5B6pLvsDgrQcbRypIlCNDXypu+hIF7/krvrojBuV+2+w1XcqdwVXEmFat3qtXdhgW5OnriwgNuX5rcHK3iSfHeasETz/Kx2YI3OWa2CPrNlyhPyif7blLqJPE5Ryev/boyATTnEqbvE7cp56UQewK4cwcnCXdty9+/SQ9iWI/w4m1VISH6Mc3jL5Mv5H8YrSKiWlYV2HmsyVhXfkQ8Jq1ibB0jwR4rD+a4vf4GMSBHOV335PD+kTg0SdrEB0pDWshowgIxHE/kjZAzyyspiaSJfLvIKTBsSktiIBBLajDkcEqZm8ikkcIcNIWN1b8QKMoasBzJ6ytfE5uEiG+QjFKVcKx+/KIt6i07eYg06eYP5dHKfeXRyj3Ed+Xz7sn01lnMt+fsCwGZ7sO33P9MSniTJZbnOtmxx4HucsgDWcfwM4PK2aAT02wYHJoZyXyMV33BkaSZvaByiKY58PchnmvIWC+jkARN0csF6dPIeGxrKk8nkOc3z3W53UT5kDjeQG51Q7jDWppK3s6sFlVxklyIq+eBwnSOR1xyWEtLIQ5YR0cgjxeU/Yz3JWOPIbHLGBimKyz+rgICK6oNrP9bnl+KDSxrSp1ife1k4j5Rc23K3xD4IbMsDRWPBVK5sLDBhVy4UzRxj1M0cFsEiEWUDjbT1R9m0pGy3UjaKKVvclM15yrEC5UCEcpRDOYSiHJ99/uCv0MjyVoatZmPiWxtw643mb/Wngit/h/gNgxzgBJI/poMAAAAASUVORK5CYII=";
  var icon8 = img$2;

var img$1 = "data:image/png;base64,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";
  var avatar1 = img$1;

var script$9 = defineComponent({
  name: 'Summary',
  props: {
    title: {
      type: String,
      default: ''
    },
    list: {
      type: Array,
      required: true
    },
    avatar: {
      type: String,
      default: null
    },
    clickAble: {
      type: Boolean,
      default: false
    }
  },
  emits: ['select'],

  setup(props, ctx) {
    const handleClick = () => {
      if (props.clickAble) {
        ctx.emit('select');
      }
    };

    return {
      handleClick
    };
  }

});

const _hoisted_1$8 = {
  class: "summary"
};
const _hoisted_2$6 = {
  key: 0
};
const _hoisted_3$6 = ["src"];
const _hoisted_4$6 = {
  class: "unit"
};
function render$3(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_count = resolveComponent("m-count");

  return openBlock(), createElementBlock("div", _hoisted_1$8, [_ctx.title ? (openBlock(), createElementBlock("p", _hoisted_2$6, toDisplayString(_ctx.title), 1)) : createCommentVNode("", true), createElementVNode("div", {
    class: normalizeClass(["summary-container", {
      'over-two': _ctx.list.length > 3,
      'click-able': _ctx.clickAble
    }]),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.list, (item, i) => {
    return openBlock(), createElementBlock("div", {
      key: item.name
    }, [createElementVNode("p", null, [_ctx.avatar && i === 0 ? (openBlock(), createElementBlock("img", {
      key: 0,
      src: _ctx.avatar
    }, null, 8, _hoisted_3$6)) : createCommentVNode("", true), createVNode(_component_m_count, {
      class: "count orange-count",
      value: item.value
    }, null, 8, ["value"]), createElementVNode("span", _hoisted_4$6, toDisplayString(item.unit), 1)]), createElementVNode("p", null, toDisplayString(item.name), 1)]);
  }), 128))], 2)]);
}

var css_248z$9 = ".summary[data-v-00787f3a] {\n  width: 100%;\n  min-height: 0.4rem;\n  background: rgba(70,83,97,0.4);\n  box-shadow: inset 0 0.01rem 0.02rem 0 rgba(204,204,204,0.2);\n  border-radius: 0.03rem;\n  padding: 0.06rem 0;\n}\n.summary >p[data-v-00787f3a] {\n  margin-left: 0.1rem;\n  font-weight: bold;\n}\n.summary-container[data-v-00787f3a] {\n  display: flex;\n  align-items: center;\n  justify-content: space-around;\n  box-sizing: border-box;\n}\n.summary-container.click-able[data-v-00787f3a] {\n  cursor: pointer;\n}\n.summary-container.click-able[data-v-00787f3a]:hover {\n  background: rgba(70,83,97,0.5);\n  box-shadow: none;\n}\n.summary-container.over-two >div[data-v-00787f3a]:nth-last-child(2):before {\n  content: '';\n  display: block;\n  height: 40%;\n  width: 0.01rem;\n  background: #aaa;\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  margin: auto 0;\n  left: -100%;\n}\n.summary-container >div[data-v-00787f3a] {\n  text-align: center;\n  position: relative;\n}\n.summary-container >div[data-v-00787f3a]:first-child {\n  padding-left: 0.5rem;\n}\n.summary-container >div[data-v-00787f3a]:last-child:before {\n  content: '';\n  display: block;\n  height: 40%;\n  width: 0.01rem;\n  background: #aaa;\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  margin: auto 0;\n  left: -100%;\n}\n.summary-container >div p .count[data-v-00787f3a] {\n  font-family: $font-barlow;\n  font-size: 0.12rem;\n  margin-right: 0.01rem;\n  color: #f7933e;\n}\n.summary-container >div p .unit[data-v-00787f3a] {\n  color: #aaa;\n  font-size: 0.09rem;\n}\n.summary-container >div p[data-v-00787f3a]:last-child {\n  font-weight: bold;\n  color: #ccc;\n}\n.summary-container >div p >img[data-v-00787f3a] {\n  position: absolute;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  margin: auto 0;\n  width: 0.26rem;\n}\n";
styleInject(css_248z$9);

script$9.render = render$3;
script$9.__scopeId = "data-v-00787f3a";

const _hoisted_1$7 = /*#__PURE__*/createTextVNode(" 住宅房屋 ");

const _hoisted_2$5 = /*#__PURE__*/createTextVNode(" 物业企业 ");

const _hoisted_3$5 = /*#__PURE__*/createTextVNode(" 业委会 ");

const _hoisted_4$5 = /*#__PURE__*/createTextVNode(" 维修资金 ");
const __default__$5 = {
  name: 'A002',
  title: '物业体征'
};

function setup$5(__props) {
  const summary = [{
    icon: icon4,
    name: '商品房',
    value: 904
  }, {
    icon: icon5,
    name: '公房',
    value: 400
  }, {
    icon: icon1,
    name: '私房/农房',
    value: 130
  }, {
    icon: icon6,
    name: '商住混合',
    value: 82
  }, {
    icon: icon7,
    name: '军产',
    value: 12
  }, {
    icon: icon8,
    name: '保障房',
    value: 46
  }];
  const list = [{
    name: '分户',
    value: 47520
  }, {
    name: '门牌',
    value: 3960
  }, {
    name: '小区',
    value: 45
  }];
  return (_ctx, _cache) => {
    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "物业体征"
    }, {
      default: withCtx(() => [createVNode(_component_m_sub, {
        addition: {
          value: 1674,
          unit: '个小区'
        }
      }, {
        default: withCtx(() => [_hoisted_1$7]),
        _: 1
      }), createVNode(script$b, {
        list: summary
      }), createVNode(_component_m_sub, {
        addition: {
          value: 1264,
          unit: '个'
        }
      }, {
        default: withCtx(() => [_hoisted_2$5]),
        _: 1
      }), createVNode(_component_m_sub, {
        addition: {
          value: 1015,
          unit: '个'
        }
      }, {
        default: withCtx(() => [_hoisted_3$5]),
        _: 1
      }), createVNode(_component_m_sub, {
        addition: {
          value: 1684,
          unit: '万元'
        }
      }, {
        default: withCtx(() => [_hoisted_4$5]),
        _: 1
      }), createVNode(script$9, {
        title: "续筹分布",
        list: list,
        avatar: unref(avatar1)
      }, null, 8, ["avatar"])]),
      _: 1
    });
  };
}

var script$8 = /*#__PURE__*/defineComponent({ ...__default__$5,
  setup: setup$5
});

var css_248z$8 = "";
styleInject(css_248z$8);

script$8.__scopeId = "data-v-641b747d";

var colors = {
    black: '#000',
    silver: '#C0C0C0',
    gray: '#808080',
    white: '#FFF',
    maroon: '#800000',
    red: '#F00',
    purple: '#800080',
    fuchsia: '#F0F',
    green: '#008000',
    lime: '#0F0',
    olive: '#808000',
    yellow: '#FF0',
    navy: '#000080',
    blue: '#00F',
    teal: '#008080',
    aqua: '#0FF',
    transparent: '#0000'
};

const prefix$1 = '^\\s*';
const suffix = '\\s*$';
const float = '\\s*((\\.\\d+)|(\\d+(\\.\\d*)?))\\s*'; // 4 offset
const hex = '([0-9A-Fa-f])';
const dhex = '([0-9A-Fa-f]{2})';
const rgbRegex = new RegExp(`${prefix$1}rgb\\s*\\(${float},${float},${float}\\)${suffix}`);
const rgbaRegex = new RegExp(`${prefix$1}rgba\\s*\\(${float},${float},${float},${float}\\)${suffix}`);
const sHexRegex = new RegExp(`${prefix$1}#${hex}${hex}${hex}${suffix}`);
const hexRegex = new RegExp(`${prefix$1}#${dhex}${dhex}${dhex}${suffix}`);
const sHexaRegex = new RegExp(`${prefix$1}#${hex}${hex}${hex}${hex}${suffix}`);
const hexaRegex = new RegExp(`${prefix$1}#${dhex}${dhex}${dhex}${dhex}${suffix}`);
function parseHex(value) {
    return parseInt(value, 16);
}
/**
 * Convert color string to rgba array.
 * @param color format like #000[0], #000000[00], rgb(0, 0, 0), rgba(0, 0, 0, 0) and basic color keywords https://www.w3.org/TR/css-color-3/#html4 and transparent
 * @returns
 */
function rgba(color) {
    try {
        let i;
        if ((i = hexRegex.exec(color))) {
            return [parseHex(i[1]), parseHex(i[2]), parseHex(i[3]), 1];
        }
        else if ((i = rgbRegex.exec(color))) {
            return [roundChannel(i[1]), roundChannel(i[5]), roundChannel(i[9]), 1];
        }
        else if ((i = rgbaRegex.exec(color))) {
            return [
                roundChannel(i[1]),
                roundChannel(i[5]),
                roundChannel(i[9]),
                roundAlpha(i[13])
            ];
        }
        else if ((i = sHexRegex.exec(color))) {
            return [
                parseHex(i[1] + i[1]),
                parseHex(i[2] + i[2]),
                parseHex(i[3] + i[3]),
                1
            ];
        }
        else if ((i = hexaRegex.exec(color))) {
            return [
                parseHex(i[1]),
                parseHex(i[2]),
                parseHex(i[3]),
                roundAlpha(parseHex(i[4]) / 255)
            ];
        }
        else if ((i = sHexaRegex.exec(color))) {
            return [
                parseHex(i[1] + i[1]),
                parseHex(i[2] + i[2]),
                parseHex(i[3] + i[3]),
                roundAlpha(parseHex(i[4] + i[4]) / 255)
            ];
        }
        else if (color in colors) {
            return rgba(colors[color]);
        }
        throw new Error(`[seemly/rgba]: Invalid color value ${color}.`);
    }
    catch (e) {
        throw e;
    }
}
function normalizeAlpha(alphaValue) {
    return alphaValue > 1 ? 1 : alphaValue < 0 ? 0 : alphaValue;
}
function stringifyRgba(r, g, b, a) {
    return `rgba(${roundChannel(r)}, ${roundChannel(g)}, ${roundChannel(b)}, ${normalizeAlpha(a)})`;
}
function compositeChannel(v1, a1, v2, a2, a) {
    return roundChannel((v1 * a1 * (1 - a2) + v2 * a2) / a);
}
function composite(background, overlay) {
    if (!Array.isArray(background))
        background = rgba(background);
    if (!Array.isArray(overlay))
        overlay = rgba(overlay);
    const a1 = background[3];
    const a2 = overlay[3];
    const alpha = roundAlpha(a1 + a2 - a1 * a2);
    return stringifyRgba(compositeChannel(background[0], a1, overlay[0], a2, alpha), compositeChannel(background[1], a1, overlay[1], a2, alpha), compositeChannel(background[2], a1, overlay[2], a2, alpha), alpha);
}
function scaleColor(base, options) {
    const [r, g, b, a = 1] = Array.isArray(base) ? base : rgba(base);
    const { lightness = 1, alpha = 1 } = options;
    return toRgbaString([r * lightness, g * lightness, b * lightness, a * alpha]);
}
function roundAlpha(value) {
    const v = Math.round(Number(value) * 100) / 100;
    if (v > 1)
        return 1;
    if (v < 0)
        return 0;
    return v;
}
function roundChannel(value) {
    const v = Math.round(Number(value));
    if (v > 255)
        return 255;
    if (v < 0)
        return 0;
    return v;
}
function toRgbaString(base) {
    const [r, g, b] = base;
    if (3 in base) {
        return `rgba(${roundChannel(r)}, ${roundChannel(g)}, ${roundChannel(b)}, ${roundAlpha(base[3])})`;
    }
    return `rgba(${roundChannel(r)}, ${roundChannel(g)}, ${roundChannel(b)}, 1)`;
}

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

var freeGlobal$1 = freeGlobal;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal$1 || freeSelf || Function('return this')();

var root$1 = root;

/** Built-in value references. */
var Symbol$1 = root$1.Symbol;

var Symbol$2 = Symbol$1;

/** Used for built-in method references. */
var objectProto$a = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$8 = objectProto$a.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString$1 = objectProto$a.toString;

/** Built-in value references. */
var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty$8.call(value, symToStringTag$1),
      tag = value[symToStringTag$1];

  try {
    value[symToStringTag$1] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString$1.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$1] = tag;
    } else {
      delete value[symToStringTag$1];
    }
  }
  return result;
}

/** Used for built-in method references. */
var objectProto$9 = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto$9.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

var isArray$1 = isArray;

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol$2 ? Symbol$2.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray$1(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag$1 = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag$1 || tag == genTag || tag == asyncTag || tag == proxyTag;
}

/** Used to detect overreaching core-js shims. */
var coreJsData = root$1['__core-js_shared__'];

var coreJsData$1 = coreJsData;

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/** Used for built-in method references. */
var funcProto$2 = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString$2 = funcProto$2.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString$2.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto$1 = Function.prototype,
    objectProto$8 = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString$1 = funcProto$1.toString;

/** Used to check objects for own properties. */
var hasOwnProperty$7 = objectProto$8.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString$1.call(hasOwnProperty$7).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

var baseCreate$1 = baseCreate;

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

var defineProperty$1 = defineProperty;

/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !defineProperty$1 ? identity : function(func, string) {
  return defineProperty$1(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': constant(string),
    'writable': true
  });
};

var baseSetToString$1 = baseSetToString;

/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = shortOut(baseSetToString$1);

var setToString$1 = setToString;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER$1 = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER$1 : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty$1) {
    defineProperty$1(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/** Used for built-in method references. */
var objectProto$7 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$6 = objectProto$7.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty$6.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        array = Array(length);

    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return apply(func, this, otherArgs);
  };
}

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString$1(overRest(func, start, identity), func + '');
}

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (isArrayLike(object) && isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return eq(object[index], value);
  }
  return false;
}

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

/** Used for built-in method references. */
var objectProto$6 = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto$6;

  return value === proto;
}

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/** `Object#toString` result references. */
var argsTag$1 = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag$1;
}

/** Used for built-in method references. */
var objectProto$5 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$5 = objectProto$5.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto$5.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty$5.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

var isArguments$1 = isArguments;

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

/** Detect free variable `exports`. */
var freeExports$2 = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule$2 = freeExports$2 && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;

/** Built-in value references. */
var Buffer$1 = moduleExports$2 ? root$1.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer$1 ? Buffer$1.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

var isBuffer$1 = isBuffer;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag$1 = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag$1] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/** Detect free variable `exports`. */
var freeExports$1 = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule$1 = freeExports$1 && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports$1 && freeGlobal$1.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule$1 && freeModule$1.require && freeModule$1.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

var nodeUtil$1 = nodeUtil;

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

var isTypedArray$1 = isTypedArray;

/** Used for built-in method references. */
var objectProto$4 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$4 = objectProto$4.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray$1(value),
      isArg = !isArr && isArguments$1(value),
      isBuff = !isArr && !isArg && isBuffer$1(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray$1(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty$4.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}

/** Used for built-in method references. */
var objectProto$3 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$3 = objectProto$3.hasOwnProperty;

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!isObject(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object),
      result = [];

  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !hasOwnProperty$3.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

var nativeCreate$1 = nativeCreate;

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
  this.size = 0;
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED$1 = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto$2 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$2 = objectProto$2.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate$1) {
    var result = data[key];
    return result === HASH_UNDEFINED$1 ? undefined : result;
  }
  return hasOwnProperty$2.call(data, key) ? data[key] : undefined;
}

/** Used for built-in method references. */
var objectProto$1 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$1 = objectProto$1.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate$1 ? (data[key] !== undefined) : hasOwnProperty$1.call(data, key);
}

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate$1 && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/* Built-in method references that are verified to be native. */
var Map = getNative(root$1, 'Map');

var Map$1 = Map;

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map$1 || ListCache),
    'string': new Hash
  };
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

var getPrototype$1 = getPrototype;

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype$1(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : baseSlice(array, start, end);
}

/** Used to compose unicode character classes. */
var rsAstralRange$1 = '\\ud800-\\udfff',
    rsComboMarksRange$1 = '\\u0300-\\u036f',
    reComboHalfMarksRange$1 = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange$1 = '\\u20d0-\\u20ff',
    rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1,
    rsVarRange$1 = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ$1 = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ$1 + rsAstralRange$1  + rsComboRange$1 + rsVarRange$1 + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsAstral = '[' + rsAstralRange + ']',
    rsCombo = '[' + rsComboRange + ']',
    rsFitz = '\\ud83c[\\udffb-\\udfff]',
    rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
    rsNonAstral = '[^' + rsAstralRange + ']',
    rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
    rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
    rsZWJ = '\\u200d';

/** Used to compose unicode regexes. */
var reOptMod = rsModifier + '?',
    rsOptVar = '[' + rsVarRange + ']?',
    rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
    rsSeq = rsOptVar + reOptMod + rsOptJoin,
    rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function unicodeToArray(string) {
  return string.match(reUnicode) || [];
}

/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function stringToArray(string) {
  return hasUnicode(string)
    ? unicodeToArray(string)
    : asciiToArray(string);
}

/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */
function createCaseFirst(methodName) {
  return function(string) {
    string = toString(string);

    var strSymbols = hasUnicode(string)
      ? stringToArray(string)
      : undefined;

    var chr = strSymbols
      ? strSymbols[0]
      : string.charAt(0);

    var trailing = strSymbols
      ? castSlice(strSymbols, 1).join('')
      : string.slice(1);

    return chr[methodName]() + trailing;
  };
}

/**
 * Converts the first character of `string` to upper case.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */
var upperFirst = createCaseFirst('toUpperCase');

var upperFirst$1 = upperFirst;

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map$1 || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root$1.Buffer : undefined,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

/** Built-in value references. */
var Uint8Array = root$1.Uint8Array;

var Uint8Array$1 = Uint8Array;

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array$1(result).set(new Uint8Array$1(arrayBuffer));
  return result;
}

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate$1(getPrototype$1(object))
    : {};
}

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

var baseFor$1 = baseFor;

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

/**
 * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function safeGet(object, key) {
  if (key === 'constructor' && typeof object[key] === 'function') {
    return;
  }

  if (key == '__proto__') {
    return;
  }

  return object[key];
}

/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = safeGet(object, key),
      srcValue = safeGet(source, key),
      stacked = stack.get(srcValue);

  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer
    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
    : undefined;

  var isCommon = newValue === undefined;

  if (isCommon) {
    var isArr = isArray$1(srcValue),
        isBuff = !isArr && isBuffer$1(srcValue),
        isTyped = !isArr && !isBuff && isTypedArray$1(srcValue);

    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray$1(objValue)) {
        newValue = objValue;
      }
      else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      }
      else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      }
      else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      }
      else {
        newValue = [];
      }
    }
    else if (isPlainObject(srcValue) || isArguments$1(srcValue)) {
      newValue = objValue;
      if (isArguments$1(objValue)) {
        newValue = toPlainObject(objValue);
      }
      else if (!isObject(objValue) || isFunction(objValue)) {
        newValue = initCloneObject(srcValue);
      }
    }
    else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  assignMergeValue(object, key, newValue);
}

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor$1(source, function(srcValue, key) {
    stack || (stack = new Stack);
    if (isObject(srcValue)) {
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

/**
 * This method is like `_.assign` except that it recursively merges own and
 * inherited enumerable string keyed properties of source objects into the
 * destination object. Source properties that resolve to `undefined` are
 * skipped if a destination value exists. Array and plain object properties
 * are merged recursively. Other objects and value types are overridden by
 * assignment. Source objects are applied from left to right. Subsequent
 * sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 0.5.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var object = {
 *   'a': [{ 'b': 2 }, { 'd': 4 }]
 * };
 *
 * var other = {
 *   'a': [{ 'c': 3 }, { 'e': 5 }]
 * };
 *
 * _.merge(object, other);
 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
 */
var merge = createAssigner(function(object, source, srcIndex) {
  baseMerge(object, source, srcIndex);
});

var merge$1 = merge;

const ssrContextKey = Symbol('@css-render/vue3-ssr');
function createStyleString(id, style) {
    return `<style cssr-id="${id}">\n${style}\n</style>`;
}
function ssrAdapter(id, style) {
    const ssrContext = inject(ssrContextKey, null);
    if (ssrContext === null) {
        console.error('[css-render/vue3-ssr]: no ssr context found.');
        return;
    }
    const { styles, ids } = ssrContext;
    // we need to impl other options to make it behaves the same as the client side
    if (ids.has(id))
        return;
    if (styles !== null) {
        ids.add(id);
        styles.push(createStyleString(id, style));
    }
}
function useSsrAdapter() {
    const context = inject(ssrContextKey, null);
    if (context === null)
        return undefined;
    return {
        adapter: ssrAdapter,
        context
    };
}

function ampCount(selector) {
    let cnt = 0;
    for (let i = 0; i < selector.length; ++i) {
        if (selector[i] === '&')
            ++cnt;
    }
    return cnt;
}
/**
 * Don't just use ',' to separate css selector. For example:
 * x:(a, b) {} will be split into 'x:(a' and 'b)', which is not expected.
 * Make sure comma doesn't exist inside parentheses.
 */
const seperatorRegex = /\s*,(?![^(]*\))\s*/g;
const extraSpaceRegex = /\s+/g;
/**
 * selector must includes '&'
 * selector is trimmed
 * every part of amp is trimmed
 */
function resolveSelectorWithAmp(amp, selector) {
    const nextAmp = [];
    selector.split(seperatorRegex).forEach(partialSelector => {
        let round = ampCount(partialSelector);
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        if (!round) {
            amp.forEach(partialAmp => {
                nextAmp.push(
                // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
                (partialAmp && partialAmp + ' ') + partialSelector);
            });
            return;
        }
        else if (round === 1) {
            amp.forEach(partialAmp => {
                nextAmp.push(partialSelector.replace('&', partialAmp));
            });
            return;
        }
        let partialNextAmp = [
            partialSelector
        ];
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        while (round--) {
            const nextPartialNextAmp = [];
            partialNextAmp.forEach(selectorItr => {
                amp.forEach(partialAmp => {
                    nextPartialNextAmp.push(selectorItr.replace('&', partialAmp));
                });
            });
            partialNextAmp = nextPartialNextAmp;
        }
        partialNextAmp.forEach(part => nextAmp.push(part));
    });
    return nextAmp;
}
/**
 * selector mustn't includes '&'
 * selector is trimmed
 */
function resolveSelector(amp, selector) {
    const nextAmp = [];
    selector.split(seperatorRegex).forEach(partialSelector => {
        amp.forEach(partialAmp => {
            // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
            nextAmp.push(((partialAmp && partialAmp + ' ') + partialSelector));
        });
    });
    return nextAmp;
}
function parseSelectorPath(selectorPaths) {
    let amp = [''];
    selectorPaths.forEach(selector => {
        // eslint-disable-next-line
        selector = selector && selector.trim();
        if (
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        !selector) {
            /**
             * if it's a empty selector, do nothing
             */
            return;
        }
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        if (selector.includes('&')) {
            amp = resolveSelectorWithAmp(amp, selector);
        }
        else {
            amp = resolveSelector(amp, selector);
        }
    });
    return amp.join(', ').replace(extraSpaceRegex, ' ');
}

const kebabRegex = /[A-Z]/g;
function kebabCase(pattern) {
    return pattern.replace(kebabRegex, match => '-' + match.toLowerCase());
}
/** TODO: refine it to solve nested object */
function upwrapProperty(prop, indent = '  ') {
    if (typeof prop === 'object' && prop !== null) {
        return (' {\n' +
            Object.entries(prop).map(v => {
                return indent + `  ${kebabCase(v[0])}: ${v[1]};`;
            }).join('\n') +
            '\n' + indent + '}');
    }
    return `: ${prop};`;
}
/** unwrap properties */
function upwrapProperties(props, instance, params) {
    if (typeof props === 'function') {
        return props({
            context: instance.context,
            props: params
        });
    }
    return props;
}
function createStyle(selector, props, instance, params) {
    if (!props)
        return '';
    // eslint-disable-next-line
    const unwrappedProps = upwrapProperties(props, instance, params);
    if (!unwrappedProps)
        return '';
    if (typeof unwrappedProps === 'string') {
        return `${selector} {\n${unwrappedProps}\n}`;
    }
    const propertyNames = Object.keys(unwrappedProps);
    if (propertyNames.length === 0) {
        if (instance.config.keepEmptyBlock)
            return selector + ' {\n}';
        return '';
    }
    const statements = selector
        ? [
            selector + ' {'
        ]
        : [];
    propertyNames.forEach(propertyName => {
        const property = unwrappedProps[propertyName];
        if (propertyName === 'raw') {
            statements.push('\n' + property + '\n');
            return;
        }
        propertyName = kebabCase(propertyName);
        if (property !== null && property !== undefined) {
            statements.push(`  ${propertyName}${upwrapProperty(property)}`);
        }
    });
    if (selector) {
        statements.push('}');
    }
    return statements.join('\n');
}
function loopCNodeListWithCallback(children, options, callback) {
    /* istanbul ignore if */
    if (!children)
        return;
    children.forEach(child => {
        if (Array.isArray(child)) {
            loopCNodeListWithCallback(child, options, callback);
        }
        else if (typeof child === 'function') {
            const grandChildren = child(options);
            if (Array.isArray(grandChildren)) {
                loopCNodeListWithCallback(grandChildren, options, callback);
            }
            else if (grandChildren) {
                callback(grandChildren);
            }
        }
        else if (child) {
            callback(child);
        }
    });
}
function traverseCNode(node, selectorPaths, styles, instance, params, styleSheet) {
    const $ = node.$;
    if (!$ || typeof $ === 'string') {
        // as a string selector
        selectorPaths.push($);
    }
    else if (typeof $ === 'function') {
        // as a lazy selector
        selectorPaths.push($({
            context: instance.context,
            props: params
        }));
    }
    else { // as a option selector
        if ($.before)
            $.before(instance.context);
        if (!$.$ || typeof $.$ === 'string') {
            selectorPaths.push($.$);
        }
        else /* istanbul ignore else */ if ($.$) {
            selectorPaths.push($.$({
                context: instance.context,
                props: params
            }));
        }
    }
    const selector = parseSelectorPath(selectorPaths);
    const style = createStyle(selector, node.props, instance, params);
    if (styleSheet && style) {
        styleSheet.insertRule(style);
    }
    if (!styleSheet && style.length)
        styles.push(style);
    if (node.children) {
        loopCNodeListWithCallback(node.children, {
            context: instance.context,
            props: params
        }, childNode => {
            if (typeof childNode === 'string') {
                const style = createStyle(selector, { raw: childNode }, instance, params);
                if (styleSheet) {
                    styleSheet.insertRule(style);
                }
                else {
                    styles.push(style);
                }
            }
            else {
                traverseCNode(childNode, selectorPaths, styles, instance, params, styleSheet);
            }
        });
    }
    selectorPaths.pop();
    if ($ && $.after)
        $.after(instance.context);
}
function render$2(node, instance, props, insertRule = false) {
    const styles = [];
    traverseCNode(node, [], styles, instance, props, insertRule
        ? node.instance.__styleSheet
        : undefined);
    if (insertRule)
        return '';
    return styles.join('\n\n');
}

/* eslint-disable */
// Inspired by https://github.com/garycourt/murmurhash-js
// Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
function murmur2(str) {
  // 'm' and 'r' are mixing constants generated offline.
  // They're not really 'magic', they just happen to work well.
  // const m = 0x5bd1e995;
  // const r = 24;
  // Initialize the hash
  var h = 0; // Mix 4 bytes at a time into the hash

  var k,
      i = 0,
      len = str.length;

  for (; len >= 4; ++i, len -= 4) {
    k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
    k =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
    k ^=
    /* k >>> r: */
    k >>> 24;
    h =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Handle the last few bytes of the input array


  switch (len) {
    case 3:
      h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

    case 2:
      h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

    case 1:
      h ^= str.charCodeAt(i) & 0xff;
      h =
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Do a few final mixes of the hash to ensure the last few
  // bytes are well-incorporated.


  h ^= h >>> 13;
  h =
  /* Math.imul(h, m): */
  (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  return ((h ^ h >>> 15) >>> 0).toString(36);
}

function removeElement(el) {
    /* istanbul ignore if */
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    if (!el)
        return;
    const parentElement = el.parentElement;
    /* istanbul ignore else */
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    if (parentElement)
        parentElement.removeChild(el);
}
function queryElement(id) {
    return document.querySelector(`style[cssr-id="${id}"]`);
}
function createElement(id) {
    const el = document.createElement('style');
    el.setAttribute('cssr-id', id);
    return el;
}

/* eslint-disable @typescript-eslint/strict-boolean-expressions */
if (typeof window !== 'undefined') {
    window.__cssrContext = {};
}
function unmount(intance, node, id) {
    const { els } = node;
    // If id is undefined, unmount all styles
    if (id === undefined) {
        els.forEach(removeElement);
        node.els = [];
    }
    else {
        const target = queryElement(id);
        // eslint-disable-next-line
        if (target && els.includes(target)) {
            removeElement(target);
            node.els = els.filter((el) => el !== target);
        }
    }
}
function addElementToList(els, target) {
    els.push(target);
}
function mount(instance, node, id, props, head, slient, force, ssrAdapter
// eslint-disable-next-line @typescript-eslint/no-invalid-void-type
) {
    var _a;
    if (slient && !ssrAdapter) {
        if (id === undefined) {
            // it is possible to use hash to get rid of the requirements of id
            // if you are interested in it, please create a pr
            // i have no time to impl it
            console.error('[css-render/mount]: `id` is required in `slient` mode.');
            // @ts-expect-error
            return;
        }
        const cssrContext = window.__cssrContext;
        if (!cssrContext[id]) {
            cssrContext[id] = true;
            render$2(node, instance, props, slient);
        }
        // @ts-expect-error
        return;
    }
    let style;
    if (id === undefined) {
        style = node.render(props);
        id = murmur2(style);
    }
    if (ssrAdapter) {
        ssrAdapter.adapter(id, style !== null && style !== void 0 ? style : node.render(props));
        // @ts-expect-error
        return;
    }
    const queriedTarget = queryElement(id);
    if (queriedTarget !== null && !force) {
        // @ts-expect-error
        return queriedTarget;
    }
    const target = queriedTarget !== null && queriedTarget !== void 0 ? queriedTarget : createElement(id);
    if (style === undefined)
        style = node.render(props);
    target.textContent = style;
    // @ts-expect-error
    if (queriedTarget !== null)
        return queriedTarget;
    if (head) {
        const firstStyleEl = (_a = document.head.querySelector('style, link')) !== null && _a !== void 0 ? _a : null;
        document.head.insertBefore(target, firstStyleEl);
    }
    else {
        document.head.appendChild(target);
    }
    addElementToList(node.els, target);
    // @ts-expect-error
    return queriedTarget !== null && queriedTarget !== void 0 ? queriedTarget : target;
}

function wrappedRender(props) {
    return render$2(this, this.instance, props);
}
// do not guard node calling, it should throw an error.
function wrappedMount(options = {}
// eslint-disable-next-line @typescript-eslint/no-invalid-void-type
) {
    const { id, ssr, props, head = false, slient = false, force = false } = options;
    const targetElement = mount(this.instance, this, id, props, head, slient, force, ssr);
    return targetElement;
}
function wrappedUnmount(options = {}) {
    /* istanbul ignore next */
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    const { id } = options;
    unmount(this.instance, this, id);
}
const createCNode = function (instance, $, props, children) {
    return {
        instance,
        $,
        props,
        children,
        els: [],
        render: wrappedRender,
        mount: wrappedMount,
        unmount: wrappedUnmount
    };
};
const c$1 = function (instance, $, props, children) {
    if (Array.isArray($)) {
        return createCNode(instance, { $: null }, null, $);
    }
    if (Array.isArray(props)) {
        return createCNode(instance, $, null, props);
    }
    else if (Array.isArray(children)) {
        return createCNode(instance, $, props, children);
    }
    else {
        return createCNode(instance, $, props, null);
    }
};

function CssRender(config = {}) {
    let styleSheet = null;
    const cssr = {
        c: ((...args) => c$1(cssr, ...args)),
        use: (plugin, ...args) => plugin.install(cssr, ...args),
        find: queryElement,
        context: {},
        config,
        get __styleSheet() {
            // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
            if (!styleSheet) {
                const style = document.createElement('style');
                document.head.appendChild(style);
                styleSheet = document.styleSheets[document.styleSheets.length - 1];
                return styleSheet;
            }
            return styleSheet;
        }
    };
    return cssr;
}

/* eslint-disable @typescript-eslint/restrict-template-expressions */
/* eslint-disable @typescript-eslint/strict-boolean-expressions */
function plugin$1(options) {
    let _bPrefix = '.';
    let _ePrefix = '__';
    let _mPrefix = '--';
    let c;
    if (options) {
        let t = options.blockPrefix;
        if (t) {
            _bPrefix = t;
        }
        t = options.elementPrefix;
        if (t) {
            _ePrefix = t;
        }
        t = options.modifierPrefix;
        if (t) {
            _mPrefix = t;
        }
    }
    const _plugin = {
        install(instance) {
            c = instance.c;
            const ctx = instance.context;
            ctx.bem = {};
            ctx.bem.b = null;
            ctx.bem.els = null;
        }
    };
    function b(arg) {
        let memorizedB;
        let memorizedE;
        return {
            before(ctx) {
                memorizedB = ctx.bem.b;
                memorizedE = ctx.bem.els;
                ctx.bem.els = null;
            },
            after(ctx) {
                ctx.bem.b = memorizedB;
                ctx.bem.els = memorizedE;
            },
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                context.bem.b = arg;
                return `${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}`;
            }
        };
    }
    function e(arg) {
        let memorizedE;
        return {
            before(ctx) {
                memorizedE = ctx.bem.els;
            },
            after(ctx) {
                ctx.bem.els = memorizedE;
            },
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                context.bem.els = arg.split(',').map(v => v.trim());
                return context.bem.els
                    .map(el => `${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}__${el}`).join(', ');
            }
        };
    }
    function m(arg) {
        return {
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                const modifiers = arg.split(',').map(v => v.trim());
                function elementToSelector(el) {
                    return modifiers.map(modifier => `&${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}${el !== undefined ? `${_ePrefix}${el}` : ''}${_mPrefix}${modifier}`).join(', ');
                }
                const els = context.bem.els;
                if (els !== null) {
                    return elementToSelector(els[0]);
                }
                else {
                    return elementToSelector();
                }
            }
        };
    }
    function notM(arg) {
        return {
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                const els = context.bem.els;
                return `&:not(${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}${(els !== null && els.length > 0) ? `${_ePrefix}${els[0]}` : ''}${_mPrefix}${arg})`;
            }
        };
    }
    const cB = ((...args) => c(b(args[0]), args[1], args[2]));
    const cE = ((...args) => c(e(args[0]), args[1], args[2]));
    const cM = ((...args) => c(m(args[0]), args[1], args[2]));
    const cNotM = ((...args) => c(notM(args[0]), args[1], args[2]));
    Object.assign(_plugin, {
        cB, cE, cM, cNotM
    });
    return _plugin;
}

function createKey(prefix, suffix) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return (prefix +
        (suffix === 'default'
            ? ''
            : suffix.replace(/^[a-z]/, (startChar) => startChar.toUpperCase())));
}
createKey('abc', 'def');

/* eslint-disable @typescript-eslint/restrict-template-expressions */
const namespace = 'n';
const prefix = `.${namespace}-`;
const elementPrefix = '__';
const modifierPrefix = '--';
const cssr = CssRender();
const plugin = plugin$1({
    blockPrefix: prefix,
    elementPrefix,
    modifierPrefix
});
cssr.use(plugin);
const { c, find } = cssr;
const { cB, cE, cM, cNotM } = plugin;

var commonVariables = {
    fontFamily: 'v-sans, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"',
    fontFamilyMono: 'v-mono, SFMono-Regular, Menlo, Consolas, Courier, monospace',
    fontWeight: '400',
    fontWeightStrong: '500',
    cubicBezierEaseInOut: 'cubic-bezier(.4, 0, .2, 1)',
    cubicBezierEaseOut: 'cubic-bezier(0, 0, .2, 1)',
    cubicBezierEaseIn: 'cubic-bezier(.4, 0, 1, 1)',
    borderRadius: '3px',
    borderRadiusSmall: '2px',
    fontSize: '14px',
    fontSizeTiny: '12px',
    fontSizeSmall: '14px',
    fontSizeMedium: '14px',
    fontSizeLarge: '15px',
    fontSizeHuge: '16px',
    lineHeight: '1.6',
    heightTiny: '22px',
    heightSmall: '28px',
    heightMedium: '34px',
    heightLarge: '40px',
    heightHuge: '46px',
    transformDebounceScale: 'scale(1)'
};

// It is static and won't be changed in the app's lifetime
// If user want to overrides it they need to use `n-global-style` is provided
//
// Technically we can remove font-size & font-family & line-height to make
// it pure. However the coding cost doesn't worth it.
//
// -webkit-tap-hilight-color:
// https://developer.mozilla.org/en-US/docs/Web/CSS/-webkit-tap-highlight-color
// In some android devices, there will be the style.

var globalStyle = c('body', `
 margin: 0;
 font-size: ${commonVariables.fontSize};
 font-family: ${commonVariables.fontFamily};
 line-height: ${commonVariables.lineHeight};
 -webkit-text-size-adjust: 100%;
 -webkit-tap-highlight-color: transparent;
`, [c('input', `
 font-family: inherit;
 font-size: inherit;
 `)]);

function useMemo(getterOrOptions) {
    const computedValueRef = computed(getterOrOptions);
    // Maybe it's not possible to lazy evaluate the value, since we can't make
    // render phase capture the deps behind useMemo
    const valueRef = ref(computedValueRef.value);
    watch(computedValueRef, (value) => {
        valueRef.value = value;
    });
    if (typeof getterOrOptions === 'function') {
        return valueRef;
    }
    else {
        return {
            __v_isRef: true,
            get value() {
                return valueRef.value;
            },
            set value(v) {
                getterOrOptions.set(v);
            }
        };
    }
}

function warn(location, message) {
    console.error(`[naive/${location}]: ${message}`);
}

const pureNumberRegex = /^(\d|\.)+$/;
const numberRegex = /(\d|\.)+/;
function formatLength(length, { c = 1, offset = 0, attachPx = true } = {}) {
    if (typeof length === 'number') {
        const result = (length + offset) * c;
        if (result === 0)
            return '0';
        return `${result}px`;
    }
    else if (typeof length === 'string') {
        if (pureNumberRegex.test(length)) {
            const result = (Number(length) + offset) * c;
            if (attachPx) {
                if (result === 0)
                    return '0';
                return `${result}px`;
            }
            else {
                return `${result}`;
            }
        }
        else {
            const result = numberRegex.exec(length);
            if (!result)
                return length;
            return length.replace(numberRegex, String((Number(result[0]) + offset) * c));
        }
    }
    return length;
}

const configProviderInjectionKey = Symbol('configProviderInjection');
const configProviderProps = {
    abstract: Boolean,
    bordered: {
        type: Boolean,
        default: undefined
    },
    clsPrefix: String,
    locale: Object,
    dateLocale: Object,
    namespace: String,
    rtl: Array,
    tag: {
        type: String,
        default: 'div'
    },
    hljs: Object,
    theme: Object,
    themeOverrides: Object,
    componentOptions: Object,
    icons: Object,
    // deprecated
    as: {
        type: String,
        validator: () => {
            warn('config-provider', '`as` is deprecated, please use `tag` instead.');
            return true;
        },
        default: undefined
    }
};
defineComponent({
    name: 'ConfigProvider',
    alias: ['App'],
    props: configProviderProps,
    setup(props) {
        const NConfigProvider = inject(configProviderInjectionKey, null);
        const mergedThemeRef = computed(() => {
            const { theme } = props;
            if (theme === null)
                return undefined;
            const inheritedTheme = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeRef.value;
            return theme === undefined
                ? inheritedTheme
                : inheritedTheme === undefined
                    ? theme
                    : Object.assign({}, inheritedTheme, theme);
        });
        const mergedThemeOverridesRef = computed(() => {
            const { themeOverrides } = props;
            // stop inheriting themeOverrides
            if (themeOverrides === null)
                return undefined;
            // use inherited themeOverrides
            if (themeOverrides === undefined) {
                return NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeOverridesRef.value;
            }
            else {
                const inheritedThemeOverrides = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeOverridesRef.value;
                if (inheritedThemeOverrides === undefined) {
                    // no inherited, use self overrides
                    return themeOverrides;
                }
                else {
                    // merge overrides
                    return merge$1({}, inheritedThemeOverrides, themeOverrides);
                }
            }
        });
        const mergedNamespaceRef = useMemo(() => {
            const { namespace } = props;
            return namespace === undefined
                ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedNamespaceRef.value
                : namespace;
        });
        const mergedBorderedRef = useMemo(() => {
            const { bordered } = props;
            return bordered === undefined
                ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedBorderedRef.value
                : bordered;
        });
        const mergedIconsRef = computed(() => {
            const { icons } = props;
            return icons === undefined ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedIconsRef.value : icons;
        });
        const mergedComponentPropsRef = computed(() => {
            const { componentOptions } = props;
            if (componentOptions !== undefined)
                return componentOptions;
            return NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedComponentPropsRef.value;
        });
        const mergedClsPrefixRef = computed(() => {
            var _a;
            const { clsPrefix } = props;
            return (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedClsPrefixRef.value) !== null && _a !== void 0 ? _a : clsPrefix;
        });
        const mergedRtlRef = computed(() => {
            const { rtl } = props;
            if (rtl === undefined) {
                return NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedRtlRef.value;
            }
            const rtlEnabledState = {};
            for (const rtlInfo of rtl) {
                rtlEnabledState[rtlInfo.name] = markRaw(rtlInfo);
            }
            return rtlEnabledState;
        });
        provide(configProviderInjectionKey, {
            mergedRtlRef,
            mergedIconsRef,
            mergedComponentPropsRef,
            mergedBorderedRef,
            mergedNamespaceRef,
            mergedClsPrefixRef,
            mergedLocaleRef: computed(() => {
                const { locale } = props;
                if (locale === null)
                    return undefined;
                return locale === undefined
                    ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedLocaleRef.value
                    : locale;
            }),
            mergedDateLocaleRef: computed(() => {
                const { dateLocale } = props;
                if (dateLocale === null)
                    return undefined;
                return dateLocale === undefined
                    ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedDateLocaleRef.value
                    : dateLocale;
            }),
            mergedHljsRef: computed(() => {
                const { hljs } = props;
                return hljs === undefined ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedHljsRef.value : hljs;
            }),
            mergedThemeRef,
            mergedThemeOverridesRef
        });
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            mergedBordered: mergedBorderedRef,
            mergedNamespace: mergedNamespaceRef,
            mergedTheme: mergedThemeRef,
            mergedThemeOverrides: mergedThemeOverridesRef
        };
    },
    render() {
        return !this.abstract
            ? h(this.as || this.tag, {
                class: `${this.mergedClsPrefix || defaultClsPrefix}-config-provider`
            }, renderSlot(this.$slots, 'default'))
            : renderSlot(this.$slots, 'default');
    }
});

/* eslint-disable @typescript-eslint/consistent-type-assertions */
function useTheme(resolveId, mountId, style, defaultTheme, props, clsPrefixRef) {
    const ssrAdapter = useSsrAdapter();
    if (style) {
        const mountStyle = () => {
            const clsPrefix = clsPrefixRef === null || clsPrefixRef === void 0 ? void 0 : clsPrefixRef.value;
            style.mount({
                id: clsPrefix === undefined ? mountId : clsPrefix + mountId,
                head: true,
                props: {
                    bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
                },
                ssr: ssrAdapter
            });
            globalStyle.mount({
                id: 'naive-ui/global',
                head: true,
                ssr: ssrAdapter
            });
        };
        if (ssrAdapter) {
            mountStyle();
        }
        else {
            onBeforeMount(mountStyle);
        }
    }
    const NConfigProvider = inject(configProviderInjectionKey, null);
    const mergedThemeRef = computed(() => {
        var _a;
        // keep props to make theme overrideable
        const { theme: { common: selfCommon, self, peers = {} } = {}, themeOverrides: selfOverrides = {}, builtinThemeOverrides: builtinOverrides = {} } = props;
        const { common: selfCommonOverrides, peers: peersOverrides } = selfOverrides;
        const { common: globalCommon = undefined, [resolveId]: { common: globalSelfCommon = undefined, self: globalSelf = undefined, peers: globalPeers = {} } = {} } = (NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeRef.value) || {};
        const { common: globalCommonOverrides = undefined, [resolveId]: globalSelfOverrides = {} } = (NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeOverridesRef.value) || {};
        const { common: globalSelfCommonOverrides, peers: globalPeersOverrides = {} } = globalSelfOverrides;
        const mergedCommon = merge$1({}, selfCommon || globalSelfCommon || globalCommon || defaultTheme.common, globalCommonOverrides, globalSelfCommonOverrides, selfCommonOverrides);
        const mergedSelf = merge$1(
        // {}, executed every time, no need for empty obj
        (_a = (self || globalSelf || defaultTheme.self)) === null || _a === void 0 ? void 0 : _a(mergedCommon), builtinOverrides, globalSelfOverrides, selfOverrides);
        return {
            common: mergedCommon,
            self: mergedSelf,
            peers: merge$1({}, defaultTheme.peers, globalPeers, peers),
            peerOverrides: merge$1({}, globalPeersOverrides, peersOverrides)
        };
    });
    return mergedThemeRef;
}
useTheme.props = {
    theme: Object,
    themeOverrides: Object,
    builtinThemeOverrides: Object
};

const defaultClsPrefix = 'n';
function useConfig(props = {}, options = {
    defaultBordered: true
}) {
    const NConfigProvider = inject(configProviderInjectionKey, null);
    return {
        NConfigProvider,
        mergedBorderedRef: computed(() => {
            var _a, _b;
            const { bordered } = props;
            if (bordered !== undefined)
                return bordered;
            return ((_b = (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedBorderedRef.value) !== null && _a !== void 0 ? _a : options.defaultBordered) !== null && _b !== void 0 ? _b : true);
        }),
        mergedClsPrefixRef: computed(() => {
            const clsPrefix = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedClsPrefixRef.value;
            return clsPrefix || defaultClsPrefix;
        }),
        namespaceRef: computed(() => NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedNamespaceRef.value)
    };
}

function useStyle(mountId, style, clsPrefixRef) {
    if (!style) {
        return;
    }
    const ssrAdapter = useSsrAdapter();
    const mountStyle = () => {
        const clsPrefix = clsPrefixRef === null || clsPrefixRef === void 0 ? void 0 : clsPrefixRef.value;
        style.mount({
            id: clsPrefix === undefined ? mountId : clsPrefix + mountId,
            head: true,
            props: {
                bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
            },
            ssr: ssrAdapter
        });
        globalStyle.mount({
            id: 'naive-ui/global',
            head: true,
            ssr: ssrAdapter
        });
    };
    if (ssrAdapter) {
        mountStyle();
    }
    else {
        onBeforeMount(mountStyle);
    }
}

// eslint-disable-next-line @typescript-eslint/explicit-function-return-type
function replaceable(name, icon) {
    return defineComponent({
        name: upperFirst$1(name),
        setup() {
            const { NConfigProvider } = useConfig();
            return () => {
                var _a;
                const iconOverride = (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedIconsRef.value) === null || _a === void 0 ? void 0 : _a[name];
                return iconOverride ? iconOverride() : icon;
            };
        }
    });
}

var ErrorIcon = replaceable('error', h("svg", { viewBox: "0 0 48 48", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M17.8838835,16.1161165 L17.7823881,16.0249942 C17.3266086,15.6583353 16.6733914,15.6583353 16.2176119,16.0249942 L16.1161165,16.1161165 L16.0249942,16.2176119 C15.6583353,16.6733914 15.6583353,17.3266086 16.0249942,17.7823881 L16.1161165,17.8838835 L22.233,24 L16.1161165,30.1161165 L16.0249942,30.2176119 C15.6583353,30.6733914 15.6583353,31.3266086 16.0249942,31.7823881 L16.1161165,31.8838835 L16.2176119,31.9750058 C16.6733914,32.3416647 17.3266086,32.3416647 17.7823881,31.9750058 L17.8838835,31.8838835 L24,25.767 L30.1161165,31.8838835 L30.2176119,31.9750058 C30.6733914,32.3416647 31.3266086,32.3416647 31.7823881,31.9750058 L31.8838835,31.8838835 L31.9750058,31.7823881 C32.3416647,31.3266086 32.3416647,30.6733914 31.9750058,30.2176119 L31.8838835,30.1161165 L25.767,24 L31.8838835,17.8838835 L31.9750058,17.7823881 C32.3416647,17.3266086 32.3416647,16.6733914 31.9750058,16.2176119 L31.8838835,16.1161165 L31.7823881,16.0249942 C31.3266086,15.6583353 30.6733914,15.6583353 30.2176119,16.0249942 L30.1161165,16.1161165 L24,22.233 L17.8838835,16.1161165 L17.7823881,16.0249942 L17.8838835,16.1161165 Z" })))));

var InfoIcon = replaceable('info', h("svg", { viewBox: "0 0 28 28", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M14,2 C20.6274,2 26,7.37258 26,14 C26,20.6274 20.6274,26 14,26 C7.37258,26 2,20.6274 2,14 C2,7.37258 7.37258,2 14,2 Z M14,11 C13.4477,11 13,11.4477 13,12 L13,12 L13,20 C13,20.5523 13.4477,21 14,21 C14.5523,21 15,20.5523 15,20 L15,20 L15,12 C15,11.4477 14.5523,11 14,11 Z M14,6.75 C13.3096,6.75 12.75,7.30964 12.75,8 C12.75,8.69036 13.3096,9.25 14,9.25 C14.6904,9.25 15.25,8.69036 15.25,8 C15.25,7.30964 14.6904,6.75 14,6.75 Z" })))));

var SuccessIcon = replaceable('success', h("svg", { viewBox: "0 0 48 48", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M32.6338835,17.6161165 C32.1782718,17.1605048 31.4584514,17.1301307 30.9676119,17.5249942 L30.8661165,17.6161165 L20.75,27.732233 L17.1338835,24.1161165 C16.6457281,23.6279612 15.8542719,23.6279612 15.3661165,24.1161165 C14.9105048,24.5717282 14.8801307,25.2915486 15.2749942,25.7823881 L15.3661165,25.8838835 L19.8661165,30.3838835 C20.3217282,30.8394952 21.0415486,30.8698693 21.5323881,30.4750058 L21.6338835,30.3838835 L32.6338835,19.3838835 C33.1220388,18.8957281 33.1220388,18.1042719 32.6338835,17.6161165 Z" })))));

var WarningIcon = replaceable('warning', h("svg", { viewBox: "0 0 24 24", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M12,2 C17.523,2 22,6.478 22,12 C22,17.522 17.523,22 12,22 C6.477,22 2,17.522 2,12 C2,6.478 6.477,2 12,2 Z M12.0018002,15.0037242 C11.450254,15.0037242 11.0031376,15.4508407 11.0031376,16.0023869 C11.0031376,16.553933 11.450254,17.0010495 12.0018002,17.0010495 C12.5533463,17.0010495 13.0004628,16.553933 13.0004628,16.0023869 C13.0004628,15.4508407 12.5533463,15.0037242 12.0018002,15.0037242 Z M11.99964,7 C11.4868042,7.00018474 11.0642719,7.38637706 11.0066858,7.8837365 L11,8.00036004 L11.0018003,13.0012393 L11.00857,13.117858 C11.0665141,13.6151758 11.4893244,14.0010638 12.0021602,14.0008793 C12.514996,14.0006946 12.9375283,13.6145023 12.9951144,13.1171428 L13.0018002,13.0005193 L13,7.99964009 L12.9932303,7.8830214 C12.9352861,7.38570354 12.5124758,6.99981552 11.99964,7 Z" })))));

var style$1 = cB('base-icon', `
 height: 1em;
 width: 1em;
 line-height: 1em;
 text-align: center;
 display: inline-block;
 position: relative;
 fill: currentColor;
 transform: translateZ(0);
`, [c('svg', {
  height: '1em',
  width: '1em'
})]);

var NBaseIcon = defineComponent({
    name: 'BaseIcon',
    props: {
        role: String,
        ariaLabel: String,
        ariaDisabled: {
            type: Boolean,
            default: undefined
        },
        ariaHidden: {
            type: Boolean,
            default: undefined
        },
        clsPrefix: {
            type: String,
            required: true
        },
        onClick: Function,
        onMousedown: Function,
        onMouseup: Function
    },
    setup(props) {
        useStyle('BaseIcon', style$1, toRef(props, 'clsPrefix'));
    },
    render() {
        return (h("i", { class: `${this.clsPrefix}-base-icon`, onClick: this.onClick, onMousedown: this.onMousedown, onMouseup: this.onMouseup, role: this.role, "aria-label": this.ariaLabel, "aria-hidden": this.ariaHidden, "aria-disabled": this.ariaDisabled }, this.$slots));
    }
});

const base = {
    neutralBase: '#FFF',
    neutralInvertBase: '#000',
    neutralTextBase: '#000',
    neutralPopover: '#fff',
    neutralCard: '#fff',
    neutralModal: '#fff',
    neutralBody: '#fff',
    alpha1: '0.82',
    alpha2: '0.72',
    alpha3: '0.38',
    alpha4: '0.24',
    alpha5: '0.18',
    alphaClose: '0.52',
    alphaDisabled: '0.5',
    alphaDisabledInput: '0.02',
    alphaPending: '0.05',
    alphaTablePending: '0.02',
    alphaPressed: '0.07',
    alphaAvatar: '0.2',
    alphaRail: '0.14',
    alphaProgressRail: '.08',
    alphaBorder: '0.12',
    alphaDivider: '0.06',
    alphaInput: '0',
    alphaAction: '0.02',
    alphaTab: '0.04',
    alphaScrollbar: '0.25',
    alphaScrollbarHover: '0.4',
    alphaCode: '0.05',
    alphaTag: '0.02',
    // primary
    primaryHover: '#36ad6a',
    primaryDefault: '#18a058',
    primaryActive: '#0c7a43',
    primarySuppl: '#36ad6a',
    // info
    infoHover: '#4098fc',
    infoDefault: '#2080f0',
    infoActive: '#1060c9',
    infoSuppl: '#4098fc',
    // error
    errorHover: '#de576d',
    errorDefault: '#d03050',
    errorActive: '#ab1f3f',
    errorSuppl: '#de576d',
    // warning
    warningHover: '#fcb040',
    warningDefault: '#f0a020',
    warningActive: '#c97c10',
    warningSuppl: '#fcb040',
    // success
    successHover: '#36ad6a',
    successDefault: '#18a058',
    successActive: '#0c7a43',
    successSuppl: '#36ad6a'
};
const baseBackgroundRgb = rgba(base.neutralBase);
const baseInvertBackgroundRgb = rgba(base.neutralInvertBase);
const overlayPrefix = 'rgba(' + baseInvertBackgroundRgb.slice(0, 3).join(', ') + ', ';
function overlay(alpha) {
    return overlayPrefix + String(alpha) + ')';
}
function neutral(alpha) {
    const overlayRgba = Array.from(baseInvertBackgroundRgb);
    overlayRgba[3] = Number(alpha);
    return composite(baseBackgroundRgb, overlayRgba);
}
const derived = Object.assign(Object.assign({ name: 'common' }, commonVariables), { baseColor: base.neutralBase, 
    // primary color
    primaryColor: base.primaryDefault, primaryColorHover: base.primaryHover, primaryColorPressed: base.primaryActive, primaryColorSuppl: base.primarySuppl, 
    // info color
    infoColor: base.infoDefault, infoColorHover: base.infoHover, infoColorPressed: base.infoActive, infoColorSuppl: base.infoSuppl, 
    // success color
    successColor: base.successDefault, successColorHover: base.successHover, successColorPressed: base.successActive, successColorSuppl: base.successSuppl, 
    // warning color
    warningColor: base.warningDefault, warningColorHover: base.warningHover, warningColorPressed: base.warningActive, warningColorSuppl: base.warningSuppl, 
    // error color
    errorColor: base.errorDefault, errorColorHover: base.errorHover, errorColorPressed: base.errorActive, errorColorSuppl: base.errorSuppl, 
    // text color
    textColorBase: base.neutralTextBase, textColor1: 'rgb(31, 34, 37)', textColor2: 'rgb(51, 54, 57)', textColor3: 'rgb(158, 164, 170)', 
    // textColor4: neutral(base.alpha4), // disabled, placeholder, icon
    // textColor5: neutral(base.alpha5),
    textColorDisabled: neutral(base.alpha4), placeholderColor: neutral(base.alpha4), placeholderColorDisabled: neutral(base.alpha5), iconColor: neutral(base.alpha4), iconColorHover: scaleColor(neutral(base.alpha4), { lightness: 0.75 }), iconColorPressed: scaleColor(neutral(base.alpha4), { lightness: 0.9 }), iconColorDisabled: neutral(base.alpha5), opacity1: base.alpha1, opacity2: base.alpha2, opacity3: base.alpha3, opacity4: base.alpha4, opacity5: base.alpha5, dividerColor: 'rgb(239, 239, 245)', borderColor: 'rgb(224, 224, 230)', 
    // close
    closeColor: neutral(Number(base.alphaClose)), closeColorHover: neutral(Number(base.alphaClose) * 1.25), closeColorPressed: neutral(Number(base.alphaClose) * 0.8), closeColorDisabled: neutral(base.alpha4), 
    // clear
    clearColor: neutral(base.alpha4), clearColorHover: scaleColor(neutral(base.alpha4), { lightness: 0.75 }), clearColorPressed: scaleColor(neutral(base.alpha4), { lightness: 0.9 }), scrollbarColor: overlay(base.alphaScrollbar), scrollbarColorHover: overlay(base.alphaScrollbarHover), scrollbarWidth: '5px', scrollbarHeight: '5px', scrollbarBorderRadius: '5px', progressRailColor: neutral(base.alphaProgressRail), railColor: 'rgb(219, 219, 223)', popoverColor: base.neutralPopover, tableColor: base.neutralCard, cardColor: base.neutralCard, modalColor: base.neutralModal, bodyColor: base.neutralBody, tagColor: 'rgb(250, 250, 252)', avatarColor: neutral(base.alphaAvatar), invertedColor: 'rgb(0, 20, 40)', inputColor: neutral(base.alphaInput), codeColor: 'rgb(244, 244, 248)', tabColor: 'rgb(247, 247, 250)', actionColor: 'rgb(250, 250, 252)', tableHeaderColor: 'rgb(250, 250, 252)', hoverColor: 'rgb(243, 243, 245)', 
    // use color with alpha since it can be nested with header filter & sorter effect
    tableColorHover: 'rgba(0, 0, 100, 0.02)', pressedColor: 'rgb(237, 237, 239)', opacityDisabled: base.alphaDisabled, inputColorDisabled: 'rgb(250, 250, 252)', boxShadow1: '0 1px 2px -2px rgba(0, 0, 0, .08), 0 3px 6px 0 rgba(0, 0, 0, .06), 0 5px 12px 4px rgba(0, 0, 0, .04)', boxShadow2: '0 3px 6px -4px rgba(0, 0, 0, .12), 0 6px 16px 0 rgba(0, 0, 0, .08), 0 9px 28px 8px rgba(0, 0, 0, .05)', boxShadow3: '0 6px 16px -9px rgba(0, 0, 0, .08), 0 9px 28px 0 rgba(0, 0, 0, .05), 0 12px 48px 16px rgba(0, 0, 0, .03)' });
var commonLight = derived;

const self$1 = (vars) => {
    const { infoColor, successColor, warningColor, errorColor, textColor2, progressRailColor, fontSize, fontWeight } = vars;
    return {
        fontSize,
        fontSizeCircle: '28px',
        fontWeightCircle: fontWeight,
        railColor: progressRailColor,
        railHeight: '8px',
        iconSizeCircle: '36px',
        iconSizeLine: '18px',
        iconColor: infoColor,
        iconColorInfo: infoColor,
        iconColorSuccess: successColor,
        iconColorWarning: warningColor,
        iconColorError: errorColor,
        textColorCircle: textColor2,
        textColorLineInner: 'rgb(255, 255, 255)',
        textColorLineOuter: textColor2,
        fillColor: infoColor,
        fillColorInfo: infoColor,
        fillColorSuccess: successColor,
        fillColorWarning: warningColor,
        fillColorError: errorColor,
        lineBgProcessing: 'linear-gradient(90deg, rgba(255, 255, 255, .3) 0%, rgba(255, 255, 255, .5) 100%)'
    };
};
const progressLight = {
    name: 'Progress',
    common: commonLight,
    self: self$1
};
var progressLight$1 = progressLight;

// --bezier
// --fill-color
// --font-size
// --font-size-circle
// --font-weight-circle
// --icon-color
// --icon-size-circle
// --icon-size-line
// --line-bg-processing
// --rail-color
// --rail-height
// --text-color-circle
// --text-color-line-inner
// --text-color-line-outer

var style = c([cB('progress', {
  display: 'inline-block'
}, [cB('progress-icon', `
 color: var(--icon-color);
 transition: color .3s var(--bezier);
 `), cM('line', `
 width: 100%;
 display: block;
 `, [cB('progress-content', `
 display: flex;
 align-items: center;
 `, [cB('progress-graph', {
  flex: 1
})]), cB('progress-custom-content', {
  marginLeft: '14px'
}), cB('progress-icon', `
 width: 30px;
 padding-left: 14px;
 height: var(--icon-size-line);
 line-height: var(--icon-size-line);
 font-size: var(--icon-size-line);
 `, [cM('as-text', `
 color: var(--text-color-line-outer);
 text-align: center;
 width: 40px;
 font-size: var(--font-size);
 padding-left: 4px;
 transition: color .3s var(--bezier);
 `)])]), cM('circle', {
  width: '120px'
}, [cB('progress-custom-content', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 justify-content: center;
 `), cB('progress-text', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 color: inherit;
 font-size: var(--font-size-circle);
 color: var(--text-color-circle);
 font-weight: var(--font-weight-circle);
 transition: color .3s var(--bezier);
 white-space: nowrap;
 `), cB('progress-icon', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 color: var(--icon-color);
 font-size: var(--icon-size-circle);
 `)]), cM('multiple-circle', {
  width: '200px',
  color: 'inherit'
}, [cB('progress-text', `
 font-weight: var(--font-weight-circle);
 color: var(--text-color-circle);
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 justify-content: center;
 transition: color .3s var(--bezier);
 `)]), cB('progress-content', {
  position: 'relative'
}), cB('progress-graph', {
  position: 'relative'
}, [cB('progress-graph-circle', [c('svg', {
  verticalAlign: 'bottom'
}), cB('progress-graph-circle-fill', `
 stroke: var(--fill-color);
 transition:
 opacity .3s var(--bezier),
 stroke .3s var(--bezier),
 stroke-dasharray .3s var(--bezier);
 `, [cM('empty', {
  opacity: 0
})]), cB('progress-graph-circle-rail', `
 transition: stroke .3s var(--bezier);
 overflow: hidden;
 stroke: var(--rail-color);
 `)]), cB('progress-graph-line', [cM('indicator-inside', [cB('progress-graph-line-rail', {
  height: '16px',
  borderRadius: '10px'
}, [cB('progress-graph-line-fill', {
  height: 'inherit',
  borderRadius: '10px'
}), cB('progress-graph-line-indicator', `
 background: #0000;
 white-space: nowrap;
 text-align: right;
 margin-left: 14px;
 margin-right: 14px;
 height: inherit;
 line-height: 16px;
 font-size: 12px;
 color: var(--text-color-line-inner);
 transition: color .3s var(--bezier);
 `)])]), cM('indicator-inside-label', `
 height: 16px;
 display: flex;
 align-items: center;
 `, [cB('progress-graph-line-rail', {
  flex: 1,
  transition: 'background-color .3s var(--bezier)'
}), cB('progress-graph-line-indicator', `
 background: var(--fill-color);
 font-size: 12px;
 transform: translateZ(0);
 display: flex;
 vertical-align: middle;
 height: 16px;
 line-height: 16px;
 padding: 0 10px;
 border-radius: 10px;
 position: absolute;
 white-space: nowrap;
 color: var(--text-color-line-inner);
 transition:
 right .2s var(--bezier),
 color .3s var(--bezier),
 background-color .3s var(--bezier);
 `)]), cB('progress-graph-line-rail', `
 position: relative;
 overflow: hidden;
 height: var(--rail-height);
 border-radius: 5px;
 background-color: var(--rail-color);
 transition: background-color .3s var(--bezier);
 `, [cB('progress-graph-line-fill', `
 background: var(--fill-color);
 position: relative;
 border-radius: 5px;
 height: inherit;
 width: 100%;
 max-width: 0%;
 transition:
 background-color .3s var(--bezier),
 max-width .2s var(--bezier);
 `, [cM('processing', [c('&::after', `
 content: "";
 background-image: var(--line-bg-processing);
 animation: progress-processing-animation 2s var(--bezier) infinite;
 `)])])])])])]), c('@keyframes progress-processing-animation', `
 0% {
 position: absolute;
 left: 0;
 top: 0;
 bottom: 0;
 right: 100%;
 opacity: 1;
 }
 66% {
 position: absolute;
 left: 0;
 top: 0;
 bottom: 0;
 right: 0;
 opacity: 0;
 }
 100% {
 position: absolute;
 left: 0;
 top: 0;
 bottom: 0;
 right: 0;
 opacity: 0;
 }
 `)]);

const iconMap$1 = {
    success: h(SuccessIcon, null),
    error: h(ErrorIcon, null),
    warning: h(WarningIcon, null),
    info: h(InfoIcon, null)
};
var Line = defineComponent({
    name: 'ProgressLine',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        percentage: {
            type: Number,
            default: 0
        },
        railColor: String,
        railStyle: [String, Object],
        fillColor: String,
        status: {
            type: String,
            required: true
        },
        indicatorPlacement: {
            type: String,
            required: true
        },
        indicatorTextColor: String,
        unit: {
            type: String,
            default: '%'
        },
        processing: {
            type: Boolean,
            required: true
        },
        showIndicator: {
            type: Boolean,
            required: true
        },
        height: [String, Number],
        railBorderRadius: [String, Number],
        fillBorderRadius: [String, Number]
    },
    setup(props, { slots }) {
        const styleHeightRef = computed(() => {
            return formatLength(props.height);
        });
        const styleRailBorderRadiusRef = computed(() => {
            if (props.railBorderRadius !== undefined) {
                return formatLength(props.railBorderRadius);
            }
            if (props.height !== undefined) {
                return formatLength(props.height, { c: 0.5 });
            }
            return '';
        });
        const styleFillBorderRadiusRef = computed(() => {
            if (props.fillBorderRadius !== undefined) {
                return formatLength(props.fillBorderRadius);
            }
            if (props.railBorderRadius !== undefined) {
                return formatLength(props.railBorderRadius);
            }
            if (props.height !== undefined) {
                return formatLength(props.height, { c: 0.5 });
            }
            return '';
        });
        return () => {
            const { indicatorPlacement, railColor, railStyle, percentage, unit, indicatorTextColor, status, showIndicator, fillColor, processing, clsPrefix } = props;
            return (h("div", { class: `${clsPrefix}-progress-content`, role: "none" },
                h("div", { class: `${clsPrefix}-progress-graph`, "aria-hidden": true },
                    h("div", { class: [
                            `${clsPrefix}-progress-graph-line`,
                            {
                                [`${clsPrefix}-progress-graph-line--indicator-${indicatorPlacement}`]: true
                            }
                        ] },
                        h("div", { class: `${clsPrefix}-progress-graph-line-rail`, style: [
                                {
                                    backgroundColor: railColor,
                                    height: styleHeightRef.value,
                                    borderRadius: styleRailBorderRadiusRef.value
                                },
                                railStyle
                            ] },
                            h("div", { class: [
                                    `${clsPrefix}-progress-graph-line-fill`,
                                    processing &&
                                        `${clsPrefix}-progress-graph-line-fill--processing`
                                ], style: {
                                    maxWidth: `${props.percentage}%`,
                                    backgroundColor: fillColor,
                                    height: styleHeightRef.value,
                                    borderRadius: styleFillBorderRadiusRef.value
                                } }, indicatorPlacement === 'inside' ? (h("div", { class: `${clsPrefix}-progress-graph-line-indicator` }, `${percentage}${unit}`)) : null)))),
                showIndicator && indicatorPlacement === 'outside' ? (h("div", null, slots.default ? (h("div", { class: `${clsPrefix}-progress-custom-content`, style: {
                        color: indicatorTextColor
                    }, role: "none" }, slots.default())) : status === 'default' ? (h("div", { role: "none", class: `${clsPrefix}-progress-icon ${clsPrefix}-progress-icon--as-text`, style: {
                        color: indicatorTextColor
                    } },
                    percentage,
                    unit)) : (h("div", { class: `${clsPrefix}-progress-icon`, "aria-hidden": true },
                    h(NBaseIcon, { clsPrefix: clsPrefix }, { default: () => iconMap$1[status] }))))) : null));
        };
    }
});

const iconMap = {
    success: h(SuccessIcon, null),
    error: h(ErrorIcon, null),
    warning: h(WarningIcon, null),
    info: h(InfoIcon, null)
};
var Circle = defineComponent({
    name: 'ProgressCircle',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        status: {
            type: String,
            required: true
        },
        strokeWidth: {
            type: Number,
            required: true
        },
        fillColor: String,
        railColor: String,
        railStyle: [String, Object],
        percentage: {
            type: Number,
            default: 0
        },
        showIndicator: {
            type: Boolean,
            reqiuired: true
        },
        indicatorTextColor: String,
        unit: String,
        viewBoxWidth: {
            type: Number,
            required: true
        }
    },
    setup(props, { slots }) {
        const strokeDasharrayRef = computed(() => {
            return `${Math.PI * props.percentage}, ${props.viewBoxWidth * 8}`;
        });
        return () => {
            const { fillColor, railColor, railStyle, strokeWidth, status, percentage, showIndicator, indicatorTextColor, unit, clsPrefix } = props;
            return (h("div", { class: `${clsPrefix}-progress-content`, role: "none" },
                h("div", { class: `${clsPrefix}-progress-graph`, "aria-hidden": true },
                    h("div", { class: `${clsPrefix}-progress-graph-circle` },
                        h("svg", { viewBox: "0 0 110 110" },
                            h("g", null,
                                h("path", { class: `${clsPrefix}-progress-graph-circle-rail`, d: "m 55 5 a 50 50 0 1 1 0 100 a 50 50 0 1 1 0 -100", "stroke-width": strokeWidth * 1.1, "stroke-linecap": "round", fill: "none", style: [
                                        {
                                            strokeDashoffset: 0,
                                            stroke: railColor
                                        },
                                        railStyle
                                    ] })),
                            h("g", null,
                                h("path", { class: [
                                        `${clsPrefix}-progress-graph-circle-fill`,
                                        percentage === 0 &&
                                            `${clsPrefix}-progress-graph-circle-fill--empty`
                                    ], d: "m 55 5 a 50 50 0 1 1 0 100 a 50 50 0 1 1 0 -100", "stroke-width": strokeWidth * 1.1, "stroke-linecap": "round", fill: "none", style: {
                                        strokeDasharray: strokeDasharrayRef.value,
                                        strokeDashoffset: 0,
                                        stroke: fillColor
                                    } }))))),
                showIndicator ? (h("div", null, slots.default ? (h("div", { class: `${clsPrefix}-progress-custom-content`, role: "none" }, slots.default())) : status !== 'default' ? (h("div", { class: `${clsPrefix}-progress-icon`, "aria-hidden": true },
                    h(NBaseIcon, { clsPrefix: clsPrefix }, {
                        default: () => iconMap[status]
                    }))) : (h("div", { class: `${clsPrefix}-progress-text`, style: {
                        color: indicatorTextColor
                    }, role: "none" },
                    h("span", { class: `${clsPrefix}-progress-text__percentage` }, percentage),
                    h("span", { class: `${clsPrefix}-progress-text__unit` }, unit))))) : null));
        };
    }
});

function circlePath(r, sw, vw = 100) {
    return `m ${vw / 2} ${vw / 2 - r} a ${r} ${r} 0 1 1 0 ${2 * r} a ${r} ${r} 0 1 1 0 -${2 * r}`;
}
var MultipleCircle = defineComponent({
    name: 'ProgressMultipleCircle',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        viewBoxWidth: {
            type: Number,
            required: true
        },
        percentage: {
            type: Array,
            default: [0]
        },
        strokeWidth: {
            type: Number,
            required: true
        },
        circleGap: {
            type: Number,
            required: true
        },
        showIndicator: {
            type: Boolean,
            required: true
        },
        fillColor: {
            type: Array,
            default: () => []
        },
        railColor: {
            type: Array,
            default: () => []
        },
        railStyle: {
            type: Array,
            default: () => []
        }
    },
    setup(props, { slots }) {
        const strokeDasharrayRef = computed(() => {
            const strokeDasharrays = props.percentage.map((v, i) => `${((Math.PI * v) / 100) *
                (props.viewBoxWidth / 2 -
                    (props.strokeWidth / 2) * (1 + 2 * i) -
                    props.circleGap * i) *
                2}, ${props.viewBoxWidth * 8}`);
            return strokeDasharrays;
        });
        return () => {
            const { viewBoxWidth, strokeWidth, circleGap, showIndicator, fillColor, railColor, railStyle, percentage, clsPrefix } = props;
            return (h("div", { class: `${clsPrefix}-progress-content`, role: "none" },
                h("div", { class: `${clsPrefix}-progress-graph`, "aria-hidden": true },
                    h("div", { class: `${clsPrefix}-progress-graph-circle` },
                        h("svg", { viewBox: `0 0 ${viewBoxWidth} ${viewBoxWidth}` }, percentage.map((p, index) => {
                            return (h("g", { key: index },
                                h("path", { class: `${clsPrefix}-progress-graph-circle-rail`, d: circlePath(viewBoxWidth / 2 -
                                        (strokeWidth / 2) * (1 + 2 * index) -
                                        circleGap * index, strokeWidth, viewBoxWidth), "stroke-width": strokeWidth, "stroke-linecap": "round", fill: "none", style: [
                                        {
                                            strokeDashoffset: 0,
                                            stroke: railColor[index]
                                        },
                                        railStyle[index]
                                    ] }),
                                h("path", { class: [
                                        `${clsPrefix}-progress-graph-circle-fill`,
                                        p === 0 &&
                                            `${clsPrefix}-progress-graph-circle-fill--empty`
                                    ], d: circlePath(viewBoxWidth / 2 -
                                        (strokeWidth / 2) * (1 + 2 * index) -
                                        circleGap * index, strokeWidth, viewBoxWidth), "stroke-width": strokeWidth, "stroke-linecap": "round", fill: "none", style: {
                                        strokeDasharray: strokeDasharrayRef.value[index],
                                        strokeDashoffset: 0,
                                        stroke: fillColor[index]
                                    } })));
                        })))),
                showIndicator && slots.default ? (h("div", null,
                    h("div", { class: `${clsPrefix}-progress-text` }, slots.default()))) : null));
        };
    }
});

const progressProps = Object.assign(Object.assign({}, useTheme.props), { processing: Boolean, type: {
        type: String,
        default: 'line'
    }, status: {
        type: String,
        default: 'default'
    }, railColor: [String, Array], railStyle: [String, Array], color: [String, Array], viewBoxWidth: {
        type: Number,
        default: 100
    }, strokeWidth: {
        type: Number,
        default: 7
    }, percentage: [Number, Array], unit: {
        type: String,
        default: '%'
    }, showIndicator: {
        type: Boolean,
        default: true
    }, indicatorPosition: {
        type: String,
        default: 'outside'
    }, indicatorPlacement: {
        type: String,
        default: 'outside'
    }, indicatorTextColor: String, circleGap: {
        type: Number,
        default: 1
    }, height: Number, borderRadius: [String, Number], fillBorderRadius: [String, Number] });
var NProgress = defineComponent({
    name: 'Progress',
    props: progressProps,
    setup(props) {
        const mergedIndicatorPlacementRef = computed(() => {
            return props.indicatorPlacement || props.indicatorPosition;
        });
        const { mergedClsPrefixRef } = useConfig(props);
        const themeRef = useTheme('Progress', 'Progress', style, progressLight$1, props, mergedClsPrefixRef);
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            mergedIndicatorPlacement: mergedIndicatorPlacementRef,
            cssVars: computed(() => {
                const { status } = props;
                const { common: { cubicBezierEaseInOut }, self: { fontSize, fontSizeCircle, railColor, railHeight, iconSizeCircle, iconSizeLine, textColorCircle, textColorLineInner, textColorLineOuter, lineBgProcessing, fontWeightCircle, [createKey('iconColor', status)]: iconColor, [createKey('fillColor', status)]: fillColor } } = themeRef.value;
                return {
                    '--bezier': cubicBezierEaseInOut,
                    '--fill-color': fillColor,
                    '--font-size': fontSize,
                    '--font-size-circle': fontSizeCircle,
                    '--font-weight-circle': fontWeightCircle,
                    '--icon-color': iconColor,
                    '--icon-size-circle': iconSizeCircle,
                    '--icon-size-line': iconSizeLine,
                    '--line-bg-processing': lineBgProcessing,
                    '--rail-color': railColor,
                    '--rail-height': railHeight,
                    '--text-color-circle': textColorCircle,
                    '--text-color-line-inner': textColorLineInner,
                    '--text-color-line-outer': textColorLineOuter
                };
            })
        };
    },
    render() {
        // it's ok to expand all prop here since no slots' deps
        const { type, cssVars, indicatorTextColor, showIndicator, status, railColor, railStyle, color, percentage, viewBoxWidth, strokeWidth, mergedIndicatorPlacement, unit, borderRadius, fillBorderRadius, height, processing, circleGap, mergedClsPrefix, $slots } = this;
        return (h("div", { class: [
                `${mergedClsPrefix}-progress`,
                `${mergedClsPrefix}-progress--${type}`,
                `${mergedClsPrefix}-progress--${status}`
            ], style: cssVars, "aria-valuemax": 100, "aria-valuemin": 0, "aria-valuenow": percentage, role: type === 'circle' || type === 'line' ? 'progressbar' : 'none' }, type === 'circle' ? (h(Circle, { clsPrefix: mergedClsPrefix, status: status, showIndicator: showIndicator, indicatorTextColor: indicatorTextColor, railColor: railColor, fillColor: color, railStyle: railStyle, percentage: percentage, viewBoxWidth: viewBoxWidth, strokeWidth: strokeWidth, unit: unit }, $slots)) : type === 'line' ? (h(Line, { clsPrefix: mergedClsPrefix, status: status, showIndicator: showIndicator, indicatorTextColor: indicatorTextColor, railColor: railColor, fillColor: color, railStyle: railStyle, percentage: percentage, processing: processing, indicatorPlacement: mergedIndicatorPlacement, unit: unit, fillBorderRadius: fillBorderRadius, railBorderRadius: borderRadius, height: height }, $slots)) : type === 'multiple-circle' ? (h(MultipleCircle, { clsPrefix: mergedClsPrefix, strokeWidth: strokeWidth, railColor: railColor, fillColor: color, railStyle: railStyle, viewBoxWidth: viewBoxWidth, percentage: percentage, showIndicator: showIndicator, circleGap: circleGap }, $slots)) : null));
    }
});

var img = "data:image/png;base64,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";
  var CircleBg = img;

var script$7 = /*#__PURE__*/defineComponent({
  props: {
    color: {
      type: [String, Array],
      default: '#F7933E'
    },
    railColor: {
      type: [String, Array],
      default: 'rgba(255,255,255,0.1)'
    },
    value: {
      type: Number,
      default: 0
    },
    radius: {
      type: Number,
      default: 0
    },
    strokeWidth: {
      type: Number,
      default: 8
    },
    showInfo: {
      type: Boolean,
      default: true
    }
  },

  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: "circle",
        style: normalizeStyle(`background-image:url(${unref(CircleBg)})`)
      }, [createVNode(unref(NProgress), {
        class: "circle-item",
        type: "circle",
        percentage: +__props.value,
        color: __props.color,
        "border-radius": __props.radius,
        "fill-border-radius": __props.radius,
        "stroke-width": +__props.strokeWidth,
        "indicator-text-color": "#fff",
        "show-indicator": __props.showInfo,
        "rail-color": __props.railColor
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["percentage", "color", "border-radius", "fill-border-radius", "stroke-width", "show-indicator", "rail-color"])], 4);
    };
  }

});

var css_248z$7 = ".circle[data-v-76fe074a] {\n  width: 100%;\n  height: 100%;\n  background-repeat: no-repeat;\n  background-size: 100% 100%;\n  background-position: center;\n  padding: 0.05rem;\n  box-sizing: border-box;\n}\n.circle .circle-item[data-v-76fe074a] {\n  width: 100%;\n  height: 100%;\n}\n";
styleInject(css_248z$7);

script$7.__scopeId = "data-v-76fe074a";

const _withScopeId$2 = n => (pushScopeId("data-v-27b8f944"), n = n(), popScopeId(), n);

const _hoisted_1$6 = {
  class: "sum"
};
const _hoisted_2$4 = {
  class: "content"
};
const _hoisted_3$4 = {
  class: "cross"
};

const _hoisted_4$4 = /*#__PURE__*/createTextVNode(" 个");

const _hoisted_5$4 = /*#__PURE__*/_withScopeId$2(() => /*#__PURE__*/createElementVNode("span", null, "交叉任职数", -1));

const _hoisted_6$4 = {
  class: "chart"
};
const __default__$4 = {
  name: 'A003',
  title: '党建引领'
};

function setup$4(__props) {
  const fontSize = computed(() => Math.floor(screen.height * 1.6 / 100));
  const summary = [{
    name: '居委会',
    value: 10
  }, {
    name: '业委会',
    value: 10
  }, {
    name: '物业企业',
    value: 20
  }];
  const barData = {
    dimensions: [{
      name: 'street',
      displayName: '街道'
    }, {
      name: 'partyNum',
      displayName: '党小组数量'
    }, {
      name: 'data1',
      displayName: '居委会'
    }, {
      name: 'data2',
      displayName: '业委会'
    }, {
      name: 'data3',
      displayName: '物业企业'
    }],
    source: [{
      street: '街道1',
      partyNum: 60,
      data1: 20,
      data2: 20,
      data3: 20
    }, {
      street: '街道2',
      partyNum: 90,
      data1: 20,
      data2: 30,
      data3: 40
    }, {
      street: '街道3',
      partyNum: 130,
      data1: 30,
      data2: 40,
      data3: 60
    }, {
      street: '街道4',
      partyNum: 120,
      data1: 40,
      data2: 50,
      data3: 30
    }, {
      street: '街道5',
      partyNum: 120,
      data1: 50,
      data2: 60,
      data3: 10
    }, {
      street: '街道6',
      partyNum: 140,
      data1: 50,
      data2: 60,
      data3: 30
    }, {
      street: '街道7',
      partyNum: 130,
      data1: 50,
      data2: 60,
      data3: 20
    }, {
      street: '街道8',
      partyNum: 110,
      data1: 20,
      data2: 60,
      data3: 30
    }]
  };
  const barOption = {
    color: ['#785CDD', '#77BFF9', '#EDB872', '#64C29D'],
    legend: {
      right: '2%',
      itemWidth: fontSize.value * 0.6,
      itemHeight: fontSize.value * 0.8
    },
    yAxis: {
      minInterval: 1
    },
    xAxis: [{
      type: 'category',
      axisLabel: {
        interval: 0
      }
    }],
    series: [{
      type: 'bar',
      barWidth: '18%',
      itemStyle: {
        borderRadius: 8
      },
      barGap: 0
    }, ...[1, 2, 3].map(() => ({
      type: 'bar',
      barWidth: '18%',
      itemStyle: {
        borderRadius: 8
      },
      barGap: 0,
      stack: '总量'
    }))]
  };
  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_bar = resolveComponent("m-bar");

    const _component_m_empty = resolveComponent("m-empty");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "党建引领"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$6, [(openBlock(), createElementBlock(Fragment, null, renderList(summary, item => {
        return createElementVNode("div", {
          key: item.name,
          class: "rate"
        }, [createVNode(script$7, {
          value: item.value
        }, {
          default: withCtx(() => [createElementVNode("div", _hoisted_2$4, [createVNode(_component_m_count, {
            value: item.value
          }, null, 8, ["value"]), createElementVNode("p", null, toDisplayString(item.name), 1)])]),
          _: 2
        }, 1032, ["value"])]);
      }), 64)), createElementVNode("div", _hoisted_3$4, [createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 5
      }), _hoisted_4$4]), _hoisted_5$4])]), createElementVNode("div", _hoisted_6$4, [barData.source.length > 0 ? (openBlock(), createBlock(_component_m_bar, {
        key: 0,
        dataset: barData,
        option: barOption
      })) : (openBlock(), createBlock(_component_m_empty, {
        key: 1
      }))])]),
      _: 1
    });
  };
}

var script$6 = /*#__PURE__*/defineComponent({ ...__default__$4,
  setup: setup$4
});

var css_248z$6 = ".content[data-v-27b8f944] {\n  text-align: center;\n  white-space: nowrap;\n}\n.sum[data-v-27b8f944] {\n  display: flex;\n}\n.sum >div[data-v-27b8f944] {\n  flex: 1;\n}\n.sum >div.rate[data-v-27b8f944] {\n  box-sizing: border-box;\n  padding: 0.06rem;\n}\n.sum >div.cross[data-v-27b8f944] {\n  flex: 1.4;\n  margin: 0.08rem 0.05rem;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex-direction: column;\n}\n.sum >div.cross .count[data-v-27b8f944] {\n  color: #f7933e;\n  font-size: 0.12rem;\n}\n.chart[data-v-27b8f944] {\n  width: 100%;\n  height: 1.1rem;\n}\n";
styleInject(css_248z$6);

script$6.__scopeId = "data-v-27b8f944";

var script$5 = {
  name: 'A004',
  title: '公共收益'
};

const _withScopeId$1 = n => (pushScopeId("data-v-f72a3c44"), n = n(), popScopeId(), n);

const _hoisted_1$5 = /*#__PURE__*/createTextVNode(" 存量总额 ");

const _hoisted_2$3 = {
  class: "wrapper"
};

const _hoisted_3$3 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("p", null, "收入（季度）", -1));

const _hoisted_4$3 = {
  class: "count"
};

const _hoisted_5$3 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("span", null, "元", -1));

const _hoisted_6$3 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("p", null, "总额", -1));

const _hoisted_7$3 = /*#__PURE__*/createTextVNode(" | ");

const _hoisted_8$3 = {
  class: "count"
};

const _hoisted_9$3 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("span", null, "个", -1));

const _hoisted_10$3 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("p", null, "小区", -1));

const _hoisted_11$3 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("p", null, "支出（季度）", -1));

const _hoisted_12$1 = {
  class: "count"
};

const _hoisted_13$1 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("span", null, "元", -1));

const _hoisted_14$1 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("p", null, "总额", -1));

const _hoisted_15$1 = /*#__PURE__*/createTextVNode(" | ");

const _hoisted_16$1 = {
  class: "count"
};

const _hoisted_17 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("span", null, "个", -1));

const _hoisted_18 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("p", null, "小区", -1));

const _hoisted_19 = /*#__PURE__*/createTextVNode("维修资金总额");

function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_sub = resolveComponent("m-sub");

  const _component_m_count = resolveComponent("m-count");

  const _component_m_card = resolveComponent("m-card");

  return openBlock(), createBlock(_component_m_card, {
    title: "公共收益"
  }, {
    default: withCtx(() => [createVNode(_component_m_sub, {
      addition: {
        value: 6000,
        unit: '元'
      }
    }, {
      default: withCtx(() => [_hoisted_1$5]),
      _: 1
    }), createElementVNode("div", _hoisted_2$3, [createElementVNode("div", null, [_hoisted_3$3, createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("p", _hoisted_4$3, [createVNode(_component_m_count, {
      value: 100
    }), _hoisted_5$3]), _hoisted_6$3]), _hoisted_7$3, createElementVNode("div", null, [createElementVNode("p", _hoisted_8$3, [createVNode(_component_m_count, {
      value: 180
    }), _hoisted_9$3]), _hoisted_10$3])])]), createElementVNode("div", null, [_hoisted_11$3, createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("p", _hoisted_12$1, [createVNode(_component_m_count, {
      value: 169
    }), _hoisted_13$1]), _hoisted_14$1]), _hoisted_15$1, createElementVNode("div", null, [createElementVNode("p", _hoisted_16$1, [createVNode(_component_m_count, {
      value: 156
    }), _hoisted_17]), _hoisted_18])])])]), createVNode(_component_m_sub, {
      addition: {
        value: 1684,
        unit: '万元'
      }
    }, {
      default: withCtx(() => [_hoisted_19]),
      _: 1
    })]),
    _: 1
  });
}

var css_248z$5 = ".wrapper[data-v-f72a3c44] {\n  display: flex;\n  justify-content: space-between;\n  margin: 0.05rem 0;\n}\n.wrapper >div[data-v-f72a3c44] {\n  width: 48%;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.06rem 0.1rem;\n}\n.wrapper >div >div[data-v-f72a3c44] {\n  display: flex;\n  align-items: center;\n  margin-top: 0.05rem;\n}\n.wrapper >div >div >div[data-v-f72a3c44] {\n  flex: 1;\n  text-align: center;\n}\n.wrapper >div >div >div .count[data-v-f72a3c44] {\n  font-size: 0.14rem;\n  color: #edb872;\n  font-family: DIN, 'Avenir', Helvetica, Arial, sans-serif;\n  font-weight: bold;\n}\n.wrapper >div >div >div .count >span[data-v-f72a3c44] {\n  color: #ccc;\n  font-size: 0.09rem;\n  font-weight: normal;\n}\n.wrapper >div >div >div >p[data-v-f72a3c44] {\n  color: #ccc;\n}\n";
styleInject(css_248z$5);

script$5.render = render$1;
script$5.__scopeId = "data-v-f72a3c44";

const _hoisted_1$4 = {
  class: "sum"
};

const _hoisted_2$2 = /*#__PURE__*/createTextVNode("公开招投标数");

const _hoisted_3$2 = /*#__PURE__*/createTextVNode("招标中 ");

const _hoisted_4$2 = /*#__PURE__*/createTextVNode("已完成 ");

const _hoisted_5$2 = /*#__PURE__*/createTextVNode("邀请招标");

const _hoisted_6$2 = /*#__PURE__*/createTextVNode("招标中 ");

const _hoisted_7$2 = /*#__PURE__*/createTextVNode("已完成 ");

const _hoisted_8$2 = {
  class: "rate"
};
const _hoisted_9$2 = {
  class: "des"
};

const _hoisted_10$2 = /*#__PURE__*/createTextVNode(" 前期物业招标 ");

const _hoisted_11$2 = /*#__PURE__*/createTextVNode(" 业主大会公开招标 ");
const __default__$3 = {
  name: 'A005',
  title: '招投标'
};

function setup$3(__props) {
  return (_ctx, _cache) => {
    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_count = resolveComponent("m-count");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "招投标"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$4, [createElementVNode("div", null, [createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_2$2]),
        _: 1
      }), createElementVNode("span", null, [_hoisted_3$2, createVNode(_component_m_count, {
        class: "count",
        value: 31
      })]), createElementVNode("span", null, [_hoisted_4$2, createVNode(_component_m_count, {
        class: "count",
        value: 24
      })])]), createElementVNode("div", null, [createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_5$2]),
        _: 1
      }), createElementVNode("span", null, [_hoisted_6$2, createVNode(_component_m_count, {
        class: "count",
        value: 31
      })]), createElementVNode("span", null, [_hoisted_7$2, createVNode(_component_m_count, {
        class: "count",
        value: 24
      })])])]), createElementVNode("div", _hoisted_8$2, [createVNode(script$7, {
        class: "circle",
        color: "#F7B500",
        "rail-color": "#0091FF",
        value: 30,
        "show-info": false
      }), createElementVNode("div", _hoisted_9$2, [createElementVNode("p", null, [_hoisted_10$2, createVNode(_component_m_count, {
        class: "count",
        style: {
          "color": "#f7b500"
        },
        value: 120
      })]), createElementVNode("p", null, [_hoisted_11$2, createVNode(_component_m_count, {
        class: "count",
        style: {
          "color": "#0091ff"
        },
        value: 350
      })])])])]),
      _: 1
    });
  };
}

var script$4 = /*#__PURE__*/defineComponent({ ...__default__$3,
  setup: setup$3
});

var css_248z$4 = ".sum[data-v-4f9cdbec] {\n  display: flex;\n}\n.sum >div[data-v-4f9cdbec] {\n  flex: 1;\n  margin: 0 0.05rem;\n}\n.sum >div .count[data-v-4f9cdbec] {\n  font-size: 0.14rem;\n  margin-left: 0.04rem;\n  color: #fff;\n  font-weight: bold;\n}\n.sum >div span[data-v-4f9cdbec] {\n  margin: 0 0.04rem;\n  color: #ccc;\n}\n.sum >div span[data-v-4f9cdbec]:last-child {\n  float: right;\n}\n.rate[data-v-4f9cdbec] {\n  display: flex;\n  margin-top: 0.05rem;\n  padding-left: 0.1rem;\n}\n.rate .circle[data-v-4f9cdbec] {\n  width: 24%;\n}\n.rate .des[data-v-4f9cdbec] {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  margin-left: 0.3rem;\n}\n.rate .des .count[data-v-4f9cdbec] {\n  font-size: 0.14rem;\n  margin-left: 0.1rem;\n}\n";
styleInject(css_248z$4);

script$4.__scopeId = "data-v-4f9cdbec";

var script$3 = {
  name: 'A006',
  title: '行业监管'
};

const _withScopeId = n => (pushScopeId("data-v-40efc3fc"), n = n(), popScopeId(), n);

const _hoisted_1$3 = {
  class: "summary"
};
const _hoisted_2$1 = {
  class: "rate"
};

const _hoisted_3$1 = /*#__PURE__*/createTextVNode("/");

const _hoisted_4$1 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "督查", -1));

const _hoisted_5$1 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_6$1 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "整改率", -1));

const _hoisted_7$1 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_8$1 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "日查", -1));

const _hoisted_9$1 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_10$1 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "双周查", -1));

const _hoisted_11$1 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_12 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "月查", -1));

const _hoisted_13 = {
  class: "month"
};

const _hoisted_14 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "房办月查完成情况", -1));

const _hoisted_15 = /*#__PURE__*/createTextVNode("重大事件清单");

const _hoisted_16 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("div", {
  class: "content"
}, [/*#__PURE__*/createElementVNode("div", {
  class: "title"
}, [/*#__PURE__*/createElementVNode("p", null, "小区名称"), /*#__PURE__*/createElementVNode("span", {
  class: "line"
}), /*#__PURE__*/createElementVNode("span", null, "上报主题")]), /*#__PURE__*/createElementVNode("div", {
  class: "info"
}, [/*#__PURE__*/createElementVNode("div", null, [/*#__PURE__*/createElementVNode("span", null, "事件类型"), /*#__PURE__*/createElementVNode("p", null, "事件类型")]), /*#__PURE__*/createElementVNode("div", null, [/*#__PURE__*/createElementVNode("span", null, "人员伤亡"), /*#__PURE__*/createElementVNode("p", null, "0人")]), /*#__PURE__*/createElementVNode("div", null, [/*#__PURE__*/createElementVNode("span", null, "财产损失"), /*#__PURE__*/createElementVNode("p", null, "0元")])])], -1));

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_count = resolveComponent("m-count");

  const _component_m_sub = resolveComponent("m-sub");

  const _component_m_card = resolveComponent("m-card");

  return openBlock(), createBlock(_component_m_card, {
    title: "行业监管"
  }, {
    default: withCtx(() => [createElementVNode("div", _hoisted_1$3, [createElementVNode("div", _hoisted_2$1, [createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count orange-count",
      value: 31
    }), _hoisted_3$1, createVNode(_component_m_count, {
      value: 50
    })]), _hoisted_4$1]), createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count orange-count",
      value: 31
    }), _hoisted_5$1]), _hoisted_6$1])]), createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count",
      value: 90
    }), _hoisted_7$1]), _hoisted_8$1]), createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count",
      value: 82
    }), _hoisted_9$1]), _hoisted_10$1]), createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count",
      value: 76
    }), _hoisted_11$1]), _hoisted_12])])]), createElementVNode("div", _hoisted_13, [_hoisted_14, createElementVNode("div", null, [(openBlock(true), createElementBlock(Fragment, null, renderList(new Array(12), (_, i) => {
      return openBlock(), createElementBlock("span", {
        key: i
      }, toDisplayString(i + 1), 1);
    }), 128))])])]), createVNode(_component_m_sub, null, {
      default: withCtx(() => [_hoisted_15]),
      _: 1
    }), _hoisted_16]),
    _: 1
  });
}

var css_248z$3 = ".summary[data-v-40efc3fc] {\n  display: flex;\n}\n.summary .rate[data-v-40efc3fc] {\n  width: 45%;\n}\n.summary .rate >div >div[data-v-40efc3fc] {\n  display: inline-block;\n  width: 33.3%;\n}\n.summary .rate >div .count[data-v-40efc3fc] {\n  font-size: 0.14rem;\n  color: #fff;\n}\n.summary .rate >div span[data-v-40efc3fc],\n.summary .rate >div p[data-v-40efc3fc] {\n  font-size: 0.09rem;\n  color: #ccc;\n}\n.summary .month[data-v-40efc3fc] {\n  flex: 1;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.05rem 0.1rem;\n  display: flex;\n  flex-direction: column;\n  margin: 0.04rem 0;\n}\n.summary .month >div[data-v-40efc3fc] {\n  margin-top: 0.04rem;\n  flex: 1;\n  display: grid;\n  grid-template-columns: 1fr 1fr 1fr 1fr 1fr 1fr;\n  grid-template-rows: 1fr 1fr;\n  grid-gap: 0.04rem;\n}\n.summary .month >div span[data-v-40efc3fc] {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 0.02rem;\n  background: #4f953b;\n}\n.content[data-v-40efc3fc] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.04rem 0.1rem;\n  margin-bottom: 0.04rem;\n}\n.content .title[data-v-40efc3fc] {\n  display: flex;\n  align-items: center;\n}\n.content .title .line[data-v-40efc3fc] {\n  flex: 1;\n  height: 0;\n  border-bottom: 0.01rem dashed #2f86ee;\n  margin: 0 0.05rem;\n}\n.content .info[data-v-40efc3fc] {\n  display: flex;\n}\n.content .info >div[data-v-40efc3fc] {\n  flex: 1;\n}\n.content .info >div span[data-v-40efc3fc] {\n  color: #ccc;\n  font-size: 0.08rem;\n}\n";
styleInject(css_248z$3);

script$3.render = render;
script$3.__scopeId = "data-v-40efc3fc";

const _hoisted_1$2 = {
  class: "sum"
};

const _hoisted_2 = /*#__PURE__*/createTextVNode(" 全区物业保修数 ");

const _hoisted_3 = /*#__PURE__*/createTextVNode(" 个 ");

const _hoisted_4 = /*#__PURE__*/createTextVNode(" 应急维修数 ");

const _hoisted_5 = {
  class: "orange-count"
};

const _hoisted_6 = /*#__PURE__*/createTextVNode("/");

const _hoisted_7 = /*#__PURE__*/createTextVNode("/");

const _hoisted_8 = /*#__PURE__*/createTextVNode(" 个 ");

const _hoisted_9 = {
  class: "bar"
};
const _hoisted_10 = {
  class: "content"
};
const _hoisted_11 = {
  class: "progress"
};
const __default__$2 = {
  name: 'A007',
  title: '物业报修'
};

function setup$2(__props) {
  const list = [{
    name: '商品房',
    value: 60,
    rate: 20,
    count: 0.1,
    color: '#72c011'
  }, {
    name: '老旧小区',
    value: 135,
    rate: 45,
    count: 0.5,
    color: '#ff9d26'
  }, {
    name: '保障房',
    value: 105,
    rate: 35,
    count: 0.3,
    color: '#01bffe'
  }];
  const total = 255;
  const companyData = [{
    name: '物业企业1',
    value: 21,
    rate: (21 / total * 100).toFixed(0),
    count: 0.5
  }, {
    name: '物业企业2',
    value: 12,
    rate: (12 / total * 100).toFixed(0),
    count: 0.4
  }, {
    name: '物业企业3',
    value: 12,
    rate: (12 / total * 100).toFixed(0),
    count: 0.4
  }, {
    name: '其他',
    value: 210,
    rate: (210 / total * 100).toFixed(0),
    count: 0.9
  }];
  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_progress = resolveComponent("m-progress");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "物业报修"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$2, [createElementVNode("div", null, [_hoisted_2, createElementVNode("span", null, [createVNode(_component_m_count, {
        class: "orange-count",
        value: 100
      })]), _hoisted_3]), createElementVNode("div", null, [_hoisted_4, createElementVNode("span", _hoisted_5, [createVNode(_component_m_count, {
        value: 2
      }), _hoisted_6, createVNode(_component_m_count, {
        value: 4
      }), _hoisted_7, createVNode(_component_m_count, {
        value: 18
      })]), _hoisted_8])]), createElementVNode("div", _hoisted_9, [(openBlock(), createElementBlock(Fragment, null, renderList(list, item => {
        return createElementVNode("div", {
          key: item.name,
          style: normalizeStyle({
            flex: item.rate,
            background: item.color
          })
        }, [createElementVNode("div", {
          style: normalizeStyle({
            borderColor: item.color
          })
        }, [createElementVNode("p", null, [createElementVNode("span", {
          style: normalizeStyle({
            color: item.color
          })
        }, toDisplayString(item.value) + " / " + toDisplayString(item.rate) + "% / " + toDisplayString(item.count), 5), createTextVNode(" " + toDisplayString(item.name), 1)])], 4)], 4);
      }), 64))]), createElementVNode("div", _hoisted_10, [(openBlock(), createElementBlock(Fragment, null, renderList(companyData, item => {
        return createElementVNode("div", {
          key: item.name
        }, [createElementVNode("span", null, toDisplayString(item.name), 1), createElementVNode("div", _hoisted_11, [createVNode(_component_m_progress, {
          color: ['#FF692D', '#F7973D'],
          value: +item.rate
        }, null, 8, ["value"])]), createElementVNode("p", null, toDisplayString(item.value) + " / " + toDisplayString(item.rate) + "% / " + toDisplayString(item.count), 1)]);
      }), 64))])]),
      _: 1
    });
  };
}

var script$2 = /*#__PURE__*/defineComponent({ ...__default__$2,
  setup: setup$2
});

var css_248z$2 = ".sum[data-v-17368e92] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 0.03rem 0.05rem;\n}\n.sum span[data-v-17368e92] {\n  margin-left: 0.1rem;\n}\n.bar[data-v-17368e92] {\n  display: flex;\n  width: 100%;\n  height: 0.06rem;\n  margin: 0.35rem 0 0.05rem;\n}\n.bar >div[data-v-17368e92] {\n  position: relative;\n}\n.bar >div .count[data-v-17368e92] {\n  font-size: 0.12rem;\n}\n.bar >div p[data-v-17368e92] {\n  position: absolute;\n  min-width: 1rem;\n}\n.bar >div p span[data-v-17368e92] {\n  display: block;\n}\n.bar >div >div[data-v-17368e92] {\n  height: 0.25rem;\n}\n.bar >div:nth-of-type(1) >div[data-v-17368e92] {\n  transform: translateY(-90%);\n  border-left: 0.01rem solid;\n}\n.bar >div:nth-of-type(1) p[data-v-17368e92] {\n  top: -0.09rem;\n  left: 0.05rem;\n}\n.bar >div:nth-of-type(2) >div[data-v-17368e92],\n.bar >div:nth-of-type(3) >div[data-v-17368e92] {\n  transform: translateY(-90%);\n  border-right: 0.01rem solid;\n}\n.bar >div:nth-of-type(2) p[data-v-17368e92],\n.bar >div:nth-of-type(3) p[data-v-17368e92] {\n  top: -0.09rem;\n  right: 0.05rem;\n  text-align: right;\n}\n.content >div[data-v-17368e92] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n.content >div .progress[data-v-17368e92] {\n  flex: 1;\n  margin: 0 0.05rem;\n}\n.content >div span[data-v-17368e92] {\n  min-width: 0.5rem;\n}\n.content >div p[data-v-17368e92] {\n  min-width: 0.5rem;\n  text-align: right;\n}\n";
styleInject(css_248z$2);

script$2.__scopeId = "data-v-17368e92";

const _hoisted_1$1 = {
  class: "chart"
};
const __default__$1 = {
  name: 'A008',
  title: '小区健康度'
};

function setup$1(__props) {
  const data = {
    dimensions: [{
      name: 'class1',
      displayName: '行政检查',
      max: 100
    }, {
      name: 'class2',
      displayName: '履行行业管理',
      max: 100
    }, {
      name: 'class3',
      displayName: '履行物业服务规范',
      max: 100
    }, {
      name: 'class4',
      displayName: '投诉及处置情况',
      max: 100
    }, {
      name: 'class5',
      displayName: '诚信积分',
      max: 100
    }],
    source: [{
      seriesName: '健康度',
      class1: 85.6,
      class2: 87.6,
      class3: 54.6,
      class4: 96,
      class5: 72.7
    }]
  };
  const option = {
    color: [['#0078D0', '#61FAFA']],
    legend: {
      show: false
    },
    radar: {
      radius: '60%',
      axisName: {
        formatter: function (value, {
          name
        }) {
          var _data$dimensions$find;

          const key = (_data$dimensions$find = data.dimensions.find(e => e.displayName === name)) === null || _data$dimensions$find === void 0 ? void 0 : _data$dimensions$find.name;
          if (!key) return value;
          const val = data.source[0][key] || 0;
          let displayNum = '';

          if (val <= 60) {
            displayNum = `{b|${val}}`;
          } else if (val > 60 && val <= 80) {
            displayNum = `{c|${val}}`;
          } else if (val > 80) {
            displayNum = `{d|${val}}`;
          }

          return [`{a|${value}}`, displayNum].join('\n');
        },
        rich: {
          a: {
            color: '#ccc',
            fontSize: '.09rem',
            lineHeight: 14
          },
          b: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#F7B500',
            align: 'center'
          },
          c: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#32C5FF',
            align: 'center'
          },
          d: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#42FC5A',
            align: 'center'
          }
        }
      }
    }
  };
  return (_ctx, _cache) => {
    const _component_m_radar = resolveComponent("m-radar");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "小区健康度"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$1, [createVNode(_component_m_radar, {
        dataset: data,
        option: option
      })])]),
      _: 1
    });
  };
}

var script$1 = /*#__PURE__*/defineComponent({ ...__default__$1,
  setup: setup$1
});

var css_248z$1 = ".chart[data-v-16ed8978] {\n  width: 100%;\n  height: 1.5rem;\n}\n";
styleInject(css_248z$1);

script$1.__scopeId = "data-v-16ed8978";

const _hoisted_1 = {
  class: "chart"
};
const __default__ = {
  name: 'A009',
  title: '企业履职评分'
};

function setup(__props) {
  const data = {
    dimensions: [{
      name: 'class1',
      displayName: '物业服务履约质量',
      max: 100
    }, {
      name: 'class2',
      displayName: '综合能力等级',
      max: 100
    }, {
      name: 'class3',
      displayName: '诉求处置及信息报送',
      max: 100
    }, {
      name: 'class4',
      displayName: '社会责任履行社区满意度',
      max: 100
    }, {
      name: 'class5',
      displayName: '社会公众满意度',
      max: 100
    }, {
      name: 'class6',
      displayName: '企业信用计分情况',
      max: 100
    }],
    source: [{
      seriesName: '健康度',
      class1: 85.6,
      class2: 72.7,
      class3: 69.2,
      class4: 96.0,
      class5: 54.6,
      class6: 87.6
    }]
  };
  const option = {
    color: [['#F76B1C', '#FAD961']],
    legend: {
      show: false
    },
    radar: {
      center: ['50%', '50%'],
      radius: '52%',
      axisName: {
        formatter: function (value, {
          name
        }) {
          var _data$dimensions$find;

          const key = (_data$dimensions$find = data.dimensions.find(e => e.displayName === name)) === null || _data$dimensions$find === void 0 ? void 0 : _data$dimensions$find.name;
          if (!key) return value;
          const val = data.source[0][key] || 0;
          let displayNum = '';

          if (val <= 60) {
            displayNum = `{b|${val}}`;
          } else if (val > 60 && val <= 80) {
            displayNum = `{c|${val}}`;
          } else if (val > 80) {
            displayNum = `{d|${val}}`;
          }

          return [`{a|${value}}`, displayNum].join('\n');
        },
        rich: {
          a: {
            color: '#ccc',
            fontSize: '.09rem',
            lineHeight: 14
          },
          b: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#F7B500',
            align: 'center'
          },
          c: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#32C5FF',
            align: 'center'
          },
          d: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#42FC5A',
            align: 'center'
          }
        }
      }
    }
  };
  return (_ctx, _cache) => {
    const _component_m_radar = resolveComponent("m-radar");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "企业履职评分"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1, [createVNode(_component_m_radar, {
        dataset: data,
        option: option
      })])]),
      _: 1
    });
  };
}

var script = /*#__PURE__*/defineComponent({ ...__default__,
  setup
});

var css_248z = ".chart[data-v-e4f96678] {\n  width: 100%;\n  height: 1.5rem;\n}\n";
styleInject(css_248z);

script.__scopeId = "data-v-e4f96678";

var components = /*#__PURE__*/Object.freeze({
  __proto__: null,
  A001: script$a,
  A002: script$8,
  A003: script$6,
  A004: script$5,
  A005: script$4,
  A006: script$3,
  A007: script$2,
  A008: script$1,
  A009: script
});

const install = function (app) {
  Object.entries(components).forEach(([componentName, component]) => {
    app.component(componentName, component);
  });
};

export { script$a as A001, script$8 as A002, script$6 as A003, script$5 as A004, script$4 as A005, script$3 as A006, script$2 as A007, script$1 as A008, script as A009, install as default };
