import { ref } from 'vue'
import componentList, { tabs } from '@/utils/component-list'
import useConfig, { Config } from './useConfig'

export default function useComponent() {
  const showComponentModal = ref(false) // 展示组件选择框
  const curBox = ref<number | null>(null) // 当前容器下标
  const components = ref<Config['components']>({}) // {容器下标: 组件key}

  const config = useConfig() // 获取组件选择配置
  if (config?.components) {
    components.value = config.components
  }

  const openComponentModal = (i: number) => {
    // 点击容器中的新增按钮
    curBox.value = i
    showComponentModal.value = true
  }
  const onSelectComponent = (key: string) => {
    // 选择组件后将key存入
    if (curBox.value === null) return
    components.value[curBox.value] = key
  }
  const onCancelComponent = (i: number) => {
    // 取消组件
    delete components.value?.[i]
  }

  return {
    components,
    componentList, // key-组件 对照表
    showComponentModal,
    openComponentModal,
    onSelectComponent,
    onCancelComponent,
    tabs,
  }
}
