import { defineComponent, resolveComponent, openBlock, createElementBlock, normalizeClass, Fragment, renderList, normalizeStyle, createCommentVNode, createElementVNode, createVNode, toDisplayString, createTextVNode, createBlock, withCtx, pushScopeId, popScopeId, ref, unref, inject, provide, computed, onBeforeUnmount, readonly, watch, onMounted, Comment, markRaw, h, renderSlot, onBeforeMount, Transition, toRef, getCurrentInstance, withDirectives, Teleport, nextTick, mergeProps, watchEffect, vShow, cloneVNode } from 'vue';
import axios from 'axios';
import qs from 'qs';

function mitt(n){return {all:n=n||new Map,on:function(t,e){var i=n.get(t);i?i.push(e):n.set(t,[e]);},off:function(t,e){var i=n.get(t);i&&(e?i.splice(i.indexOf(e)>>>0,1):n.set(t,[]));},emit:function(t,e){var i=n.get(t);i&&i.slice().map(function(n){n(e);}),(i=n.get("*"))&&i.slice().map(function(n){n(t,e);});}}}

const eventBus$1 = mitt();
const defaultOptions = {
  global: true,
  inject: true,
  globalPropertyName: '$eventBus',
  injectName: '$eventBus'
};

function install$1(app, options) {
  const opt = { ...defaultOptions,
    ...options
  };

  if (opt.global) {
    app.config.globalProperties[opt.globalPropertyName] = eventBus$1;
  }

  if (opt.inject) {
    app.provide(opt.injectName, eventBus$1);
  }

  return eventBus$1;
}

eventBus$1.install = install$1;
var EventBus = eventBus$1;

var img$m = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA21BMVEUAAABcZnBGU2FHVGJGU2JHVGJIVGJLWmVKVmdGVGJGVGJGU2FGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFGVGJHVGFHVGJHVGJIVWJIU2NIVGNIVmRIVWJIU2SAgIBIU2JGU2H////V2NtjbnqSmqJNWWdQXGlpdH/x8vOyuL3S1dnP0taBipOssrjb3eBUYG2hp6/P09apr7VIVmPf4eRhbHilq7Kgp651f4n7+/zJzdHBxcq3vMGXnqZbZ3Pn6etYZHD19vfY296Lk5yEjZZweoWcoqp5g41daHWQoSEBAAAAIHRSTlMABvh9+6NEIx/68+/s49/a0srEv6edj4h1X1VKPC4ChxxGkpcAAANeSURBVGjezdppV+IwFAbg0IVF9l1Wb0TEZVgUBlkVx23+/y8aWoamkEtKQnv0/aIn1sec2JumCeSYhBpV3cxlUglNS6QyOVOvNkLEj4Tqel4DLlper5/4B5ph8wwO5swMN5XpaDkJHkmWo0p0pBiDIxIrRuTpggFHxijI8SFdA4lousT/NpwGyaTDx3a7BAopHdX5aBaUko1627U4KCZe87IrBijHqIjtczgp5yL7Ak7MhUq/T+97BXxIBbdrhh+4UcPsaBx8STyK1GUWfEqWr9US+JYSN1eBjwnvDUraTzy9OzA6+BrdbUc0f3Et4sILIMryZdGW1AuujgvL54lS+iCpG6zrRQ9bQS86tRkT2yp6bFunZbGtppc3dlOwrhrY7uONvJ5sHirOzmTSYvYVdGz9vi1fpibXvlpL0yGzATryfTftyufXsb8tacjsp76CfmbNAXU4gDv2LR31FUam7kwrPD5mNqU9pktNMPkDuMtW0/OEhDQcd9u2fi2rayHSABxntrLeIFUMd+wuZfkjq1fRx8SYs5V0nZh4zTNbXTdJzttmuZTScySDz4PMVtczJHWo34+Ijev3AxxPkQTXb8dGc8fpHXozRPEE2a2hT87m9fZWByv2pV94Fe3hL7iN6y3nd+Y4vjcs71PO5vOw0RdgZ7JueW3jw5KCXX30ZheRp97rwiYLq+UNw1P8rehl790q7VerYYbfijnMltDfqZXpCi0iE5u1vHMF/zOjdpZY+fMTV0sK70+pnR46cVXF+N1k1bfzMUfxq21DC5tyG0K856q9OYZfbhvG2MMipInwJaxmIyt3HfhC8L9Owwv2mCN5Ef7LqacZtBB8wFo+kAc00cX47XbwUXzEWm6xpUX9BLzDGvipse4s59Tw7s61yHKOmMr48MbdNEcWoiSsjE+oO9MhsoRuJlXx/ri7zoLSmfV1iS3+SVkJd/JsXcaljL1wqeP4CxcpyuPLayfr9rfNd0OmFNGXXDEuzusH8pJLCv7g9BF5PScRzR98wDYW8C2R50tXJvDZ22Rh/0Cc+bMzrQS5mRPkNlSQG2iBbv0FuWkZ5HZrkBvFQW9xB785H/yxQvAHIsEf5QR/CKV+fPb9B39KR5Y/5bBV7pj4px1wH3c0/1M/VHDixyH+ASV8UgWLo8tSAAAAAElFTkSuQmCC";
  var icon1 = img$m;

var img$l = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA/1BMVEUAAABGU2KwsLBGU2FHVGJGU2FLV2RIVWRubnRHU2FGU2FHVGJHU2FGVGFGVGJGU2FGVGJGU2JIVGNHVGJHVGJIVWNGU2JGU2JHU2JGVGJIVWNKWGVJV2dGU2JHVGJHU2JIVWRJWGZKV2hGVGJHU2FIVWJGVGJHU2FGU2JOYnZGVGJGU2FIU2RKVmRQW2pIU2JGU2H///9MWWb19vZ9hpBUYG2XnqZ7hI6nrrT9/f2HkJl2gIra3eBIVWPg4uSTm6OLk5y4vcOkqrH5+frx8vNga3dZZXHs7u/q6+3k5ujd4OK/w8issriboqllcHxPXGnV2NvQ09fP09bKzdGzuL4kE+K2AAAAMHRSTlMA+wH17uMUNAT463Hf1Mm3l4h7dlxF8sWNZkkkHdijbTofGLydQauRgQbOsS4sEVbl30lTAAADIUlEQVRo3rWa6XLaMBRGZWOHYGPWsoU1AZqkWfo5lDbshOxLk27v/ywNYVoHyzKyLZ0ZfjFzRnMlXUn3mvCgVnfMTDplJTVNt1LtTn6nuk1EoB6bR0VQxNL5uBpRHd83wETLtML7t3J1bCB5sBdKvVeOgYNEZjf4qDMJcKI0asFmsakhALH8doBp/ISA1Lu8w84pCE52myvaaYSixBH5lo6QaIVN7p0YQqN88Hd/UBAF08/dREQOfMaNyJjMeCuIDiPurRgEoBQ817cOIWgeiUxNQxApeq/mIYwylasUiMMVdjUFgdQP1+QV+PB0abPpzUGTW1spGtg82770JqCI7RKHffjwzfanD5rGu4HHRMuV6n95Fl68PI3v70PK0fnnPi3Cg8mD/UpYuVIjK0x4MbSjyJElK7zP+kU0ua6SJSfw5Jxb7rdNy3zyi/7ZOtdjSk6vRp1PPoKb777y4jI5VsEnfxh+WWd25ytHy0krImJOJ5iPsuTtV7khS544JHuQJccx6cqTfyYVefIcKfPKx9RSvN0gbziLJeomoimRNq/88ca9/X9tkFskJS/mSVKXJzeILk+ekCqXGha5E9qWJ7fYm2jRWwJg1FsxWLkuey58NlEZvExX8iF4aZAKeLl4cw+uwUuOlXIno9nX94yAm95S/gd4Ga79NRtNGCmXcVj0x7aLOfD8Y3B1/ir6bbsY9xmHBTG8Q+Dm9gzA8oeRTfHIOOa8l8sVLVhgxdnYprhiHNDeM2p7sHgL7c1P2wPW1aLKK7fvzuezC+/3EetSRJJMOT+s6xzJypF3nCu0eHnXufwLl+vqSm7KkGedB5dweaLmPBWFyzs+j9xBMPfA55FLJ/VpMPmUTuUOWwb1CA3E3K+wQCeY4XTAHZOp242c9GKO/DKU/AIaUY8giNK2xKJljXgQF1RulVkollnillmcl9hWaMptiPgT1xESoyC/CeWPmhfYPqOJB86RVpdwo1YEtixptvb5m62dWvA2cbYork1Mc5q3hDa46da8DiZGpkWioZ40jzRQFNNmXCUiUHcLzUy6ZCUNLWmV0hmT83OIv9yi4fsD/tVEAAAAAElFTkSuQmCC";
  var icon2 = img$l;

var img$k = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAAw1BMVEUAAABGVGFHVGJGU2JGU2FHVGJHVGFIVWNLWmVKVmdgYIBaaWlHVGJGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFHVGJHVGJIVWJIU2NIVGNIVGNIVWJIU2RIU2JGU2H///+nrrT8/P3l5+mAiJKSmqK6vsT6+vvp6+xYY3BOWmj09PXt7vCzuL5yfIfX2t2Hj5je4eOZoKhKVmS+wsejqbCNlZ6EjZZpc39eaXVUYG3h5ObJzdGutLplcHu0ub+dpKyCi5WR5B/VAAAAHnRSTlMA93368aafSCMfCAX+7OPf2tLKxL+PiHVfVUM8Lof1DLvbAAAC5ElEQVRo3s2aaW/iMBCGbeegSct9tBwdF7YhBJarNz129///qhWRJTY1Nk6c0fJ8ROJRZDsv4xmICeGoz7x2s16ltFpvtj3WH4WkDC6HrENBgnbY8NJSPfBdUOL6g+LmoFeDE9R6QSH1he+AAY5/kV/tXYEhV14+fcgo5ICyHIen0oCcNCqmh68LBegaHcygBYVoBQZL4kJB3JNLc+NAYZwbvfsarLjWuW/Bklus59Y/+w2UgGLdKw6UgFM5er5dKAU3OPJetqAkWvK72oXS6EoLDlp26+h9sYjewIhvyx42NHm9fFqNeUq8M8vIbAIzUDB7fpzzAxEYwTK/OxSO8LC82/AsEzCCXpADHsi8RnMuMQUzvH8e/AokXsb8CGPT39XDo/sg8TblNnLwiSBwQOKT28mdQMh7ILOylENPyGsgM7GV10Q9CBhyGIjtRJH7aRy6+eSzZQImuPtwHEIu+W7Opx/3MwP7MI2VXPIfPGW1fTMJmE5uuWDz9Ao6OoSEVCd/SkSGPWflgvhzqa60aUhGoJGPD1+NJbnw/wEVI9LXyfkXCGZTWS54AQV9wrTyefQzJYq5Ur5IlDvqQd4NlVgqQ71tL39WyNukaS+/V8ibpI4nr5MqnrxKKJ6cospRlwV3Q5v6N/QxSnlcfJNP9p9uTh1F/Uv0qsiWyUNa+qy08jbxCqXiB6T80sq9E8G1fRDl2Tq7LPM0T74WWjlTR66wTVPG0obuPz2xoX0ywjstIxJSLDkNCelgyTuEEIYlZ2lRhCQfpuUchlyUc8THkfuihEaRD0TxjyGvqa8t9vKe4sKlkydrLrFNkkRx4ZK29GUTx/GY5+N9Bhl8xSV3wYuwVV1ys6G+KiRfZ6Nc1ViY/b7Lz1rdWCAMSoUpmzn2NEJlG8qeCmYDDbX1h9m0xGy3YjaKMVvcmM15zLEC5kAEc5SDOYTCHJ/9/8FfoZHluQxb842Jz23AbTSaP98/Fdj9HeIvPkYT9tICXNQAAAAASUVORK5CYII=";
  var icon3 = img$k;

var script$l = defineComponent({
  name: 'Brief',
  props: {
    list: {
      type: Array,
      required: true
    },
    color: {
      type: String,
      default: null
    },
    size: {
      type: String,
      default: '0.22rem'
    },
    align: {
      type: String,
      default: 'horizontal'
    },
    clickAble: {
      type: Boolean,
      default: false
    }
  },
  emits: ['touch'],

  setup(props, ctx) {
    function onClick(index) {
      if (props.clickAble) {
        ctx.emit('touch', index);
      }
    }

    return {
      onClick
    };
  }

});

const _hoisted_1$k = ["onClick"];
const _hoisted_2$h = ["src"];
const _hoisted_3$h = {
  key: 1
};
const _hoisted_4$g = {
  class: "count-group"
};

const _hoisted_5$c = /*#__PURE__*/createTextVNode(" / ");

function render$6(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_count = resolveComponent("m-count");

  return openBlock(), createElementBlock("div", {
    class: normalizeClass(["brief-container", {
      vertical: _ctx.align === 'vertical'
    }])
  }, [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.list, (item, i) => {
    return openBlock(), createElementBlock("div", {
      key: item.name,
      class: normalizeClass({
        'click-able': _ctx.clickAble
      }),
      onClick: $event => _ctx.onClick(i)
    }, [item.icon ? (openBlock(), createElementBlock("img", {
      key: 0,
      src: item.icon,
      style: normalizeStyle(`width:${_ctx.size};height:${_ctx.size}`)
    }, null, 12, _hoisted_2$h)) : createCommentVNode("", true), Array.isArray(item.value) ? (openBlock(), createElementBlock("div", _hoisted_3$h, [createElementVNode("div", _hoisted_4$g, [createVNode(_component_m_count, {
      class: "count orange-count",
      value: item.value[0],
      style: normalizeStyle({
        color: _ctx.color
      })
    }, null, 8, ["value", "style"]), _hoisted_5$c, createVNode(_component_m_count, {
      class: "count",
      value: item.value[1]
    }, null, 8, ["value"])]), createElementVNode("p", null, toDisplayString(item.name), 1)])) : (openBlock(), createElementBlock("div", {
      key: 2,
      class: normalizeClass({
        center: !item.icon
      })
    }, [createVNode(_component_m_count, {
      class: "count",
      style: normalizeStyle({
        color: _ctx.color
      }),
      value: item.value
    }, null, 8, ["style", "value"]), createElementVNode("p", null, toDisplayString(item.name), 1)], 2))], 10, _hoisted_1$k);
  }), 128))], 2);
}

function styleInject(css, ref) {
  if ( ref === void 0 ) ref = {};
  var insertAt = ref.insertAt;

  if (!css || typeof document === 'undefined') { return; }

  var head = document.head || document.getElementsByTagName('head')[0];
  var style = document.createElement('style');
  style.type = 'text/css';

  if (insertAt === 'top') {
    if (head.firstChild) {
      head.insertBefore(style, head.firstChild);
    } else {
      head.appendChild(style);
    }
  } else {
    head.appendChild(style);
  }

  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    style.appendChild(document.createTextNode(css));
  }
}

var css_248z$m = ".brief-container[data-v-259ee77c] {\n  display: flex;\n  align-items: center;\n  white-space: nowrap;\n  flex-wrap: wrap;\n}\n.brief-container .count[data-v-259ee77c] {\n  font-family: $font-barlow;\n  font-size: 0.12rem;\n}\n.brief-container.vertical[data-v-259ee77c] {\n  display: inline-block;\n}\n.brief-container >div[data-v-259ee77c] {\n  display: flex;\n  align-items: center;\n  width: 33%;\n}\n.brief-container >div.click-able[data-v-259ee77c] {\n  cursor: pointer;\n}\n.brief-container >div.click-able:hover .count[data-v-259ee77c] {\n  background-clip: text;\n  -webkit-background-clip: text;\n  -webkit-text-fill-color: transparent;\n  background-image: linear-gradient(to bottom, #ffd1b2, #ff8635);\n}\n.brief-container >div.click-able:hover p[data-v-259ee77c] {\n  color: #edb872;\n}\n.brief-container >div >img[data-v-259ee77c] {\n  margin-right: 0.05rem;\n}\n.brief-container >div >div[data-v-259ee77c] {\n  font-weight: bold;\n}\n.brief-container >div >div p[data-v-259ee77c] {\n  color: #ccc;\n}\n.brief-container >div >div.center[data-v-259ee77c] {\n  text-align: center;\n}\n";
styleInject(css_248z$m);

script$l.render = render$6;
script$l.__scopeId = "data-v-259ee77c";

const _withScopeId$8 = n => (pushScopeId("data-v-3bacd8fc"), n = n(), popScopeId(), n);

const _hoisted_1$j = {
  class: "wrapper"
};
const _hoisted_2$g = {
  class: "left"
};
const _hoisted_3$g = {
  class: "right"
};

const _hoisted_4$f = /*#__PURE__*/_withScopeId$8(() => /*#__PURE__*/createElementVNode("p", null, "整改执行", -1));

const _hoisted_5$b = {
  class: "count"
};

const _hoisted_6$b = /*#__PURE__*/_withScopeId$8(() => /*#__PURE__*/createElementVNode("p", null, "已开", -1));

const _hoisted_7$a = /*#__PURE__*/createTextVNode(" | ");

const _hoisted_8$a = {
  class: "count"
};

const _hoisted_9$9 = /*#__PURE__*/createTextVNode("%");

const _hoisted_10$8 = /*#__PURE__*/_withScopeId$8(() => /*#__PURE__*/createElementVNode("p", null, "完成率", -1));
const _config$5 = {
  name: 'A001',
  title: '物业',
  row: 1,
  baseUrl: window._base_url,
  apis: [{
    key: 'summary',
    value: '/api1'
  }, {
    key: 'list',
    value: '/api2'
  }]
};
const __default__$f = _config$5;

function setup$f(__props) {
  const summary = [{
    icon: icon1,
    name: '小区',
    value: 904
  }, {
    icon: icon2,
    name: '业委会',
    value: 400
  }, {
    icon: icon3,
    name: '物业服务企业',
    value: 130
  }];
  const list = [{
    name: '房办月查',
    value: 79
  }, {
    name: '物企双周查',
    value: 83
  }, {
    name: '物业日查',
    value: 100
  }];
  /**
   * 'addPoints'
   * 'removePoints'
   * 'focus'
   *
   */

  const test = () => {
    EventBus.emit('map', 'A001');
  };

  EventBus.on('config-A001', config => {});
  return (_ctx, _cache) => {
    const _component_m_progress = resolveComponent("m-progress");

    const _component_m_count = resolveComponent("m-count");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: __props.title
    }, {
      default: withCtx(() => [createVNode(script$l, {
        list: summary
      }), createElementVNode("div", _hoisted_1$j, [createElementVNode("div", _hoisted_2$g, [(openBlock(), createElementBlock(Fragment, null, renderList(list, item => {
        return createVNode(_component_m_progress, {
          key: item.name,
          value: item.value,
          msg: {
            name: item.name,
            value: item.value,
            unit: '%',
            color: '#fff'
          },
          color: ['rgb(36,59,86)', '#F4923E'],
          onClick: $event => test()
        }, null, 8, ["value", "msg", "color", "onClick"]);
      }), 64))]), createElementVNode("div", _hoisted_3$g, [_hoisted_4$f, createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("p", _hoisted_5$b, [createVNode(_component_m_count, {
        value: 63
      })]), _hoisted_6$b]), _hoisted_7$a, createElementVNode("div", null, [createElementVNode("p", _hoisted_8$a, [createVNode(_component_m_count, {
        value: 76
      }), _hoisted_9$9]), _hoisted_10$8])])])])]),
      _: 1
    }, 8, ["title"]);
  };
}

var script$k = /*#__PURE__*/defineComponent({ ...__default__$f,
  props: {
    title: {
      type: String,
      default: _config$5.title
    }
  },
  setup: setup$f
});

var css_248z$l = ".wrapper[data-v-3bacd8fc] {\n  display: flex;\n  padding-bottom: 0.05rem;\n}\n.wrapper .left[data-v-3bacd8fc] {\n  flex: 1.8;\n}\n.wrapper .right[data-v-3bacd8fc] {\n  flex: 1;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  margin: 0.06rem 0.06rem 0 0.1rem;\n  padding: 0.06rem 0.1rem;\n}\n.wrapper .right >div[data-v-3bacd8fc] {\n  display: flex;\n  align-items: center;\n  margin-top: 0.1rem;\n}\n.wrapper .right >div >div[data-v-3bacd8fc] {\n  flex: 1;\n  text-align: center;\n}\n.wrapper .right >div >div .count[data-v-3bacd8fc] {\n  font-size: 0.12rem;\n  color: #edb872;\n  font-family: DIN, 'Avenir', Helvetica, Arial, sans-serif;\n  font-weight: bold;\n}\n.wrapper .right >div >div >p[data-v-3bacd8fc] {\n  color: #ccc;\n}\n";
styleInject(css_248z$l);

script$k.__scopeId = "data-v-3bacd8fc";

var img$j = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA1VBMVEUAAABcZnBGU2FHVGJGU2JHVGJIVGJJWWVGVGFGVGJGU2FGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFGVGJHVGFHVGJHVGJIVWJIU2NIVGNIVmRIVWJIU2RMWmdNVWaAgIBIU2JGU2H///+AiJLFyc54gYuQl6Db3uFfanb39/jq7O3k5ujKztLO0tWpr7b7+/vw8fK5vsPt7u/BxclSXmvV2Nulq7Kco6pzfYhWYm9MWWbX2t2zub6WnaWFjpdsd4JpdH/f4eSts7mLk5xmcXyIkZqBipNC5kTCAAAAIXRSTlMABvh9/KNEIfrz7+zj39rSysS/p52PiHVfVUo8LiUeAofuiMjAAAADIElEQVRo3s2ae1PiMBDAQ9ICgsgb5aG4RaiVN/hEEfS8+/4f6UqYOcrFJE3pjvz+WmecH5mSTba7kDAkWnVmF/O5LKXZXL5os3orQeIg0WQlCgK0xJoHfkA7aZ+AlBM72Y6svqqdgobT2lUk9WUlDSFIVy6N1amyBSGxyimzb5FRMIAyg+82eQaGnCXDLrsKEaiGWnyqAJEohHjyjQxEJNPQuS8siIx1oXafw0Gcq9zXcCDXmnUjrf0CYkDy3BtWHHKr8e3+zkAsZFKiO1GAmCiIuVqF2KgKZxUILEYzR8Qb3mrtyf8eyhkIvDnfM7nXnpH7D4aBwMvYkfAEOtjeTqEg0HVkTLVyGtwxZRDpSOU3oKUcuIutuOXW7tauQNxyqPyrT9Lxy9NXZEsN4pdDjXDap+byl2n/jvO6lNVibUlyauWL/u6vR2Wa2ir53Xu3233ku9sPOu5WvnR2jCUJa/PMP1HJf/H4wXFmPHjeyqdOgGdJDbw5A5pgLr8JyjsSQZMfK2aPRZQrDpiSQi5iIC8RkqBYcpogLcCSQ4vUI8v7nZ6nlNcJiyzvAoyUckbsyPJbgJ5SbpMinrxI8mr5eDoajR420YcfvHkm8jzJqeX8Mrb8c8rjR8i7iTxHsmr5Hx4P/L3Bg3VAvgJ4UsqzhKrlD5sFP4/96LcfLOYB+fBlPVPKKaF4SURJFk+eJTk8eY7kI8u9z7lanj8giXoAc3US4aY/w5Mz7ZF757quxw8CP+gbyeu6y2LKS/WJ715vokcTeUt3zXX20/8rIP8CWKqvOd0F/bYJ7zcr569CTwH5JyxelRe0trRw3OFwOOHb2g9e95LoY6YtLZpYGdrk5RyOnJdzxMaR29sSGkeeVBf/5nKx+Cc1DHlN98JlLhdfuEglfnlF/5JrLhdfckk5bnlZ3lhYzQeDgSuVTwZ7jRjX/+f5StZYEA6YvmNMH4IwRTNnYi6fSJo5Ypr2PFO31xOSE6uBhtr6w2xaYrZbMRvFmC1uzOY85lgBcyCCOcrBHEJhjs9+fvAXaWR5LMNWszHxsQ24w43mj/VHBQf+HOIv6+FkF94I7mUAAAAASUVORK5CYII=";
  var icon4 = img$j;

var img$i = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAAn1BMVEUAAABcZnBGU2JGU2FHVGJGU2FGU2FHVGJIVGJLWmVKVmdGVGJHU2JGVGFHU2FGU2JHVGFGVGJHVGFHVGJHVGJIVWJIU2NIVGNIVmRIVWJIU2SAgIBIU2JGU2H///+2u8FrdYC1ur/Z3N+Ql6Dc3uHh4+XDyMzS1tn5+vr09PXq7O2gpq5ueYRXY3CxtryTm6OQmKB+h5FjbXlhbHhPW2ml6aG0AAAAHXRSTlMABvv4fe7do0QjH/Pj0srEv6edj4h1X1VKPC4Ch85MXNQAAAKZSURBVGjetNNXVgJBEIXh22ECAhIletsIiDntf21yPCoI0z3FQH8L+E893IKEmgxt1mqmiTFJ2mxldjhROAY1tm3DHaZtxwoHmeZZnV71LJ+iqpN+gyUa/RNUUetqCuhubf90R1NId/bLK2u4B2MVxPKUe0pzyKgeK+gp0UZOWcmpYDejhBUlI5QYaFamBwg640HOEHDOA50L7o5w+4BHMPDsRPMI9Khw3wmPIinYuxL8ztN8/iT4JoVtgp9/XTq3fGWpHrbkLPO+cN8W7yyT4x+VMkw/3Lkfdw+aYanCJsuwx5nbMHtkmMWGmmHI57Pb8vzJEFPDWochb/dux/0bQzobh+vg/lyh4Cr1+vQu/W6WzmN5Q7/u329q+nwsXMDigz7690/7of35hVfZx7dpw7e/W1fq1rfKxjT4nC9O5CX4phmLXTiRCxbLsKLqceJ1BWDMOHGOAVhxfHa9MhPHLYC2OH7JlUtxvA0oEytuFCaMFecEw3jxIWy8uEUmj8+vVubyeIYWY+2cLTTjxZtI48VTJPHiCUy8uPlq1mxWGISBIDyh/uRi/QXRQ6ktKvT9H7C45NJCwlYz1Dnl9F3c4OxMVHAHeMjfQY6TDp7y4CkyHjxDwYMXKHnwUnf91+eml/g4Oa6665/wRjFBz4P3GHnwEebCgl8MULHgldJaLPdNs/gLOS5KazGw5nwQO8eBi51DzoHn2GQ5cOvMP+ODOvOPjjGKXWjh0sPDCxea+PAmvOTq4eElF3VseO0LFianWQefJ6ePYMEXidx2yheJwGTH4d4wBzYm3OJLbTx464n+YsCvhhlaMuNWZlDMjLiZ4TyzVmAWIswqh1lCMeuz/xd/uyrLs5Stv9XEZyu4ddX8WR8VHHwO8QZvsPW/TuK6fgAAAABJRU5ErkJggg==";
  var icon5 = img$i;

var img$h = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA21BMVEUAAABGVGFHVGJGU2JGU2FHVGJHVGFIVWNLWmVKVmdgYIBaaWlGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFHVGJHVGJIVWJIU2NIVGNIVGNIVWJIU2RIU2JGU2H///9SXmvQ09agp675+vr6+vtHVGKPl5/8/PxLWGWwtbvr7O7n6epOW2j19fbc3uG4vcLg4uXLztLDyMxkb3tcZ3Pv8PKco6qKkpuAiZLX2t20ub6SmaJ8hY93gYtyfIdoc35eanZVYW74+PnBxcqjqrCGj5jFys68wcaTm6Otsrh9oYmoAAAAHXRSTlMA93368aafSCMfCAXs49/a0srEv4+IdV9VQzwuh3BQCboAAANtSURBVGjezZrpUuJAEIAngUQI96Uc9nAYQEDuQ1EQr9V9/ydaEjYmq51kJsnU+v1yYtVXw6S7SbohLGiNqqwU89m0JKWz+aIiVxsaiYJUXS5J8A2pJNdTIdU1NQ6uxNVacHOykgEfMpVkIHVCjQEDMTXBr1Z0YERX+PSaLAEHkswRPGc54CR3xhp8ZQhAOcUUIwUIRCHJcCRxCEjc92guYhCY2IW3+xxCce7lvoSQXPrsW9DeLyACXM79LAYREDtD4zsOkRBPInlZgIgofM/VMkRG+duBQ4R8OXYtBxGS04gTGSJFdroTEkSKlCA2CiDcjju93tUXOl8YbEeAoDg2rmNuykYLEHR76yogTCkjt4CgfuYmlvc7SsNsPWblaQUQ5pSZR0CokBPYc9Wyxy6fAEKGmNQA4ZWy03kChJrr7ewPKAdt11uaiqNxyMOqj5VeozjWAaFFudgAQt2lrCwoH2O3AlNCrl9TTvaIpESIhtSs0Q2vfI5VL400kMv3lJfeAdE0SBW5Oqbc/EY0VfR+Ok/ln4Afui5+oXdU8dl5a+BUOBeTK2pzjRb1ok/uryfU5mNLbXbOZHhANEWSR642V/ZnHx069qL/ZJ/YDPa2+w4Q8iQLCG/OHbWdi6719/MSYPIZLGjVzZI0YKxPFffq3ihi79YJwZHNMzWYLox8aP11bwAjTSRAeXwfPA8ni6Pa+CDjo2C2Py50gMN2Orhb949qAP1jSmlnvgAUyZbj6PO2mbPLvrlwBMXT1Nxv0/iPmzwNXjRnlL7q1uKF0pem9dGGxqF5kiZZcOewXpmhcGvoR10za1bthQ793aRnRswOPMiSPLgwH9phdzOeTe2I7DkyeHU324ALeVIEF1p8X3JoEini5AqRxcllUvWVD7qLh1YQeZU0/OQ3S2vFK28QTfKQ28V0zy+XNEJKPvL7Uz7yy0vGo4WPvHvKTn65bDwUiZLXrce58HL8cY6oYuQqMaiJkdeISUaEPGO9toiQV5AXrhBy/IWLqNHLVeQlN5Qcf8klioe8dW2w5ZMrPo2FCWXkzbOxgBeY5ZhJ3XtBzlT2b+aMmgz00WaOyDaUyAaa0NafyKalyHaryEaxyBa3yOa8yLGCyIGIyFGOyCGUyPHZ/x/8BRpZ/pRhK9+Y+KcNuJlG8z/3RwXhfg7xB6gTAxHfAaEDAAAAAElFTkSuQmCC";
  var icon6 = img$h;

var img$g = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAA0lBMVEUAAABHVGJGU2JGU2FIVGJLWmVKVmdmZmZHU2JGVGJHVGFGVGJGU2FGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFGVGJIVGJHVGJHVGFHVGJIVWJIU2NIVGNIVmRIVWJIU2RgYIBJbW1GU2H///+Pl5/S1diGj5j9/f25vsNxe4b7+/uWnqbs7e+KkptLWGWSmqJtd4Ohp654gYvk5ujf4eTIzNC0usCssriboqpibHhdaXVSXmv29/fy8/TMz9OCipTY297AxMmmrLN9h5Fncn3T1trwuhTPAAAAInRSTlMAffv4RCMfBYj6+fPv7OPf2tLKxL+npKGdj3VfVUo8LggH6G/WKQAAAwVJREFUaN7NmmlX6jAQhtMW2fcdZfOtgpSCiCjivt3//5fuFTkGbNNOQnouzyc+PeQkmUkyU0ah32sb9UqpkEunc4VSpW60e32mg0TXqFrwYFWNbmJPdayRgZBMI6ZujifzCCGfjCupj5opEEg1j+TVNRNEzJqc/tSwIIFlnEosYxGSFKlLm2hBgVaCtEfKUKJM2DedLBTJdsLcJyaUMU+C3cfYi+MgdxJ7kqSMW//YT6ABwbx3TGjA7Pju7yy0kI37xGUZmih7Y7UFbbQ8uQoaif3KsUVopLibgQ0QuLPXODMAt5vfc/hh7Jw7Fghc2N8MAJxvfp/BD+uIcWrQK0dta+AmdpiN1tyry00+9CZ2sTecf6jK0fyJzZRXvuF6/KAmT8VFidbe4nG5UpDz5Jv3k3OGN3MFeV4UnPZvFpdTKTkP04ZYznla3kvKG+t0mAmW89n5IyXPfCXHLghyDlmOLk8rOuU8wVSjklcZ61vS8sVkSpFbfdYDWc55el+Ey9FjbSk5hyBvMyM6ucHq0cnrrLKf/HkGIRVWUpNzXgdT+FNiBVU5x716gB8FllOXc5yLGbzkWJoqd4P98JImy92VIy0nT8sYt7LyHHVB3SnuHdF2vPoHvBSoW3EMCId+J9qKxCBypwAfOlFeIYX/8Po7yt/dof9y+FMPS1zXt+OPFQ/B6efL3YVLlBthKffJGx0Dhyhvhx4WjyPsMhlSp6UXfsw9zrHN2ZA651afcEA72/ax7eUSvlRJVwtnxufEpssN2qWIT/ulhLxLu87xdD2iyzMJ0kXUxQ8P9HO0QbtC3wDAy9t6clyyPEa6/NtLYP769SefwDNVng98tnAmo/NNjnlbLanyZOCDi7PYTmFEeSoufCrKMYGXpveRqy4XP3JZTbe8JigsKMrFhQVm6JUbnmKOsnwQUMzxhqnz+wz9Qix/EQRn5AU0/aW/6IuW0Zdb9ReKoy9xR1+c199WiL4hor+VE2UTKsr22f9v/Cm1LA+l2SrXJj60BjepNX+4HxXs9znEX1oDfV+ZAFJRAAAAAElFTkSuQmCC";
  var icon7 = img$g;

var img$f = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAAtFBMVEUAAABcZnBGU2FHVGJGU2JGU2FHU2FHVGJHVGFIVGJLWmVKVmdHU2JGVGJGVGJGU2FGVGFHU2FGU2JHVGFHVGJIVWJIU2NIVGNIVmRIVWJIU2SAgIBGU2H////d3+J1f4lmcXxoc366v8SQmKDKzdHf4eSYn6dibXnq7O1NWmf19vd8hY+DjJVyfIZeanZVYW7BxcqmrLN6g42Kkpvw8fLi5Oaxtrz+/v7T1tnQ09eaoalsdoFqpc6HAAAAHHRSTlMABvh9++7hpp9EIx+I+vPa0srEv491X1VKPC4CKilPXQAAAqdJREFUaN7Nmol22jAQRWXJK/sW1mcSUhqWmCWQpNv//1ftQ0lpkYVkNCfcD7jW0YzG8oyZDs6wJ4JWw/c49/xGKxC9ocNs4AxEm+MM3haDKx8wisIacqmF0aiwulzxcQG/Ui6kLoVVaFANS+bqwIUmbmCmdwSHAVwYxDaqw5B6pLvsDgrQcbRypIlCNDXypu+hIF7/krvrojBuV+2+w1XcqdwVXEmFat3qtXdhgW5OnriwgNuX5rcHK3iSfHeasETz/Kx2YI3OWa2CPrNlyhPyif7blLqJPE5Ryev/boyATTnEqbvE7cp56UQewK4cwcnCXdty9+/SQ9iWI/w4m1VISH6Mc3jL5Mv5H8YrSKiWlYV2HmsyVhXfkQ8Jq1ibB0jwR4rD+a4vf4GMSBHOV335PD+kTg0SdrEB0pDWshowgIxHE/kjZAzyyspiaSJfLvIKTBsSktiIBBLajDkcEqZm8ikkcIcNIWN1b8QKMoasBzJ6ytfE5uEiG+QjFKVcKx+/KIt6i07eYg06eYP5dHKfeXRyj3Ed+Xz7sn01lnMt+fsCwGZ7sO33P9MSniTJZbnOtmxx4HucsgDWcfwM4PK2aAT02wYHJoZyXyMV33BkaSZvaByiKY58PchnmvIWC+jkARN0csF6dPIeGxrKk8nkOc3z3W53UT5kDjeQG51Q7jDWppK3s6sFlVxklyIq+eBwnSOR1xyWEtLIQ5YR0cgjxeU/Yz3JWOPIbHLGBimKyz+rgICK6oNrP9bnl+KDSxrSp1ife1k4j5Rc23K3xD4IbMsDRWPBVK5sLDBhVy4UzRxj1M0cFsEiEWUDjbT1R9m0pGy3UjaKKVvclM15yrEC5UCEcpRDOYSiHJ99/uCv0MjyVoatZmPiWxtw643mb/Wngit/h/gNgxzgBJI/poMAAAAASUVORK5CYII=";
  var icon8 = img$f;

var img$e = "data:image/png;base64,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";
  var avatar1 = img$e;

var script$j = defineComponent({
  name: 'Summary',
  props: {
    title: {
      type: String,
      default: ''
    },
    list: {
      type: Array,
      required: true
    },
    avatar: {
      type: String,
      default: null
    },
    clickAble: {
      type: Boolean,
      default: false
    }
  },
  emits: ['select'],

  setup(props, ctx) {
    const handleClick = () => {
      if (props.clickAble) {
        ctx.emit('select');
      }
    };

    return {
      handleClick
    };
  }

});

const _hoisted_1$i = {
  class: "summary"
};
const _hoisted_2$f = {
  key: 0
};
const _hoisted_3$f = ["src"];
const _hoisted_4$e = {
  class: "unit"
};
function render$5(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_count = resolveComponent("m-count");

  return openBlock(), createElementBlock("div", _hoisted_1$i, [_ctx.title ? (openBlock(), createElementBlock("p", _hoisted_2$f, toDisplayString(_ctx.title), 1)) : createCommentVNode("", true), createElementVNode("div", {
    class: normalizeClass(["summary-container", {
      'over-two': _ctx.list.length > 3,
      'click-able': _ctx.clickAble
    }]),
    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
  }, [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.list, (item, i) => {
    return openBlock(), createElementBlock("div", {
      key: item.name
    }, [createElementVNode("p", null, [_ctx.avatar && i === 0 ? (openBlock(), createElementBlock("img", {
      key: 0,
      src: _ctx.avatar
    }, null, 8, _hoisted_3$f)) : createCommentVNode("", true), createVNode(_component_m_count, {
      class: "count orange-count",
      value: item.value
    }, null, 8, ["value"]), createElementVNode("span", _hoisted_4$e, toDisplayString(item.unit), 1)]), createElementVNode("p", null, toDisplayString(item.name), 1)]);
  }), 128))], 2)]);
}

var css_248z$k = ".summary[data-v-00787f3a] {\n  width: 100%;\n  min-height: 0.4rem;\n  background: rgba(70,83,97,0.4);\n  box-shadow: inset 0 0.01rem 0.02rem 0 rgba(204,204,204,0.2);\n  border-radius: 0.03rem;\n  padding: 0.06rem 0;\n}\n.summary >p[data-v-00787f3a] {\n  margin-left: 0.1rem;\n  font-weight: bold;\n}\n.summary-container[data-v-00787f3a] {\n  display: flex;\n  align-items: center;\n  justify-content: space-around;\n  box-sizing: border-box;\n}\n.summary-container.click-able[data-v-00787f3a] {\n  cursor: pointer;\n}\n.summary-container.click-able[data-v-00787f3a]:hover {\n  background: rgba(70,83,97,0.5);\n  box-shadow: none;\n}\n.summary-container.over-two >div[data-v-00787f3a]:nth-last-child(2):before {\n  content: '';\n  display: block;\n  height: 40%;\n  width: 0.01rem;\n  background: #aaa;\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  margin: auto 0;\n  left: -100%;\n}\n.summary-container >div[data-v-00787f3a] {\n  text-align: center;\n  position: relative;\n}\n.summary-container >div[data-v-00787f3a]:first-child {\n  padding-left: 0.5rem;\n}\n.summary-container >div[data-v-00787f3a]:last-child:before {\n  content: '';\n  display: block;\n  height: 40%;\n  width: 0.01rem;\n  background: #aaa;\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  margin: auto 0;\n  left: -100%;\n}\n.summary-container >div p .count[data-v-00787f3a] {\n  font-family: $font-barlow;\n  font-size: 0.12rem;\n  margin-right: 0.01rem;\n  color: #f7933e;\n}\n.summary-container >div p .unit[data-v-00787f3a] {\n  color: #aaa;\n  font-size: 0.09rem;\n}\n.summary-container >div p[data-v-00787f3a]:last-child {\n  font-weight: bold;\n  color: #ccc;\n}\n.summary-container >div p >img[data-v-00787f3a] {\n  position: absolute;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  margin: auto 0;\n  width: 0.26rem;\n}\n";
styleInject(css_248z$k);

script$j.render = render$5;
script$j.__scopeId = "data-v-00787f3a";

const _hoisted_1$h = /*#__PURE__*/createTextVNode(" 住宅房屋 ");

const _hoisted_2$e = /*#__PURE__*/createTextVNode(" 物业企业 ");

const _hoisted_3$e = /*#__PURE__*/createTextVNode(" 业委会 ");

const _hoisted_4$d = /*#__PURE__*/createTextVNode(" 维修资金 ");
const __default__$e = {
  name: 'A002',
  title: '物业体征',
  row: 2
};

function setup$e(__props) {
  const summary = [{
    icon: icon4,
    name: '商品房',
    value: 904
  }, {
    icon: icon5,
    name: '公房',
    value: 400
  }, {
    icon: icon1,
    name: '私房/农房',
    value: 130
  }, {
    icon: icon6,
    name: '商住混合',
    value: 82
  }, {
    icon: icon7,
    name: '军产',
    value: 12
  }, {
    icon: icon8,
    name: '保障房',
    value: 46
  }];
  const list = ref([{
    name: '分户',
    value: 47520
  }, {
    name: '门牌',
    value: 3960
  }, {
    name: '小区',
    value: 45
  }]);
  EventBus.on('update:A002', data => {
    list.value = data;
  });
  return (_ctx, _cache) => {
    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "物业体征"
    }, {
      default: withCtx(() => [createVNode(_component_m_sub, {
        addition: {
          value: 1674,
          unit: '个小区'
        }
      }, {
        default: withCtx(() => [_hoisted_1$h]),
        _: 1
      }), createVNode(script$l, {
        list: summary
      }), createVNode(_component_m_sub, {
        addition: {
          value: 1264,
          unit: '个'
        }
      }, {
        default: withCtx(() => [_hoisted_2$e]),
        _: 1
      }), createVNode(_component_m_sub, {
        addition: {
          value: 1015,
          unit: '个'
        }
      }, {
        default: withCtx(() => [_hoisted_3$e]),
        _: 1
      }), createVNode(_component_m_sub, {
        addition: {
          value: 1684,
          unit: '万元'
        }
      }, {
        default: withCtx(() => [_hoisted_4$d]),
        _: 1
      }), createVNode(script$j, {
        title: "续筹分布",
        list: list.value,
        avatar: unref(avatar1)
      }, null, 8, ["list", "avatar"])]),
      _: 1
    });
  };
}

var script$i = /*#__PURE__*/defineComponent({ ...__default__$e,
  setup: setup$e
});

var css_248z$j = "";
styleInject(css_248z$j);

script$i.__scopeId = "data-v-99f832c6";

let onceCbs = [];
const paramsMap = new WeakMap();
function flushOnceCallbacks() {
    onceCbs.forEach((cb) => cb(...paramsMap.get(cb)));
    onceCbs = [];
}
function beforeNextFrameOnce(cb, ...params) {
    paramsMap.set(cb, params);
    if (onceCbs.includes(cb))
        return;
    onceCbs.push(cb) === 1 && requestAnimationFrame(flushOnceCallbacks);
}

function happensIn(e, dataSetPropName) {
    let { target } = e;
    while (target) {
        if (target.dataset) {
            if (target.dataset[dataSetPropName] !== undefined)
                return true;
        }
        target = target.parentElement;
    }
    return false;
}

function depx(value) {
    if (typeof value === 'string') {
        if (value.endsWith('px')) {
            return Number(value.slice(0, value.length - 2));
        }
        return Number(value);
    }
    return value;
}
function pxfy(value) {
    if (value === undefined || value === null)
        return undefined;
    if (typeof value === 'number')
        return `${value}px`;
    if (value.endsWith('px'))
        return value;
    return `${value}px`;
}
function getMargin(value, position) {
    const parts = value.trim().split(/\s+/g);
    const margin = {
        top: parts[0]
    };
    switch (parts.length) {
        case 1:
            margin.right = parts[0];
            margin.bottom = parts[0];
            margin.left = parts[0];
            break;
        case 2:
            margin.right = parts[1];
            margin.left = parts[1];
            margin.bottom = parts[0];
            break;
        case 3:
            margin.right = parts[1];
            margin.bottom = parts[2];
            margin.left = parts[1];
            break;
        case 4:
            margin.right = parts[1];
            margin.bottom = parts[2];
            margin.left = parts[3];
            break;
        default:
            throw new Error('[seemly/getMargin]:' + value + ' is not a valid value.');
    }
    if (position === undefined)
        return margin;
    return margin[position];
}
function getGap(value, orient) {
    const [rowGap, colGap] = value.split(' ');
    if (!orient)
        return {
            row: rowGap,
            col: colGap || rowGap
        };
    return orient === 'row' ? rowGap : colGap;
}

var colors = {
    black: '#000',
    silver: '#C0C0C0',
    gray: '#808080',
    white: '#FFF',
    maroon: '#800000',
    red: '#F00',
    purple: '#800080',
    fuchsia: '#F0F',
    green: '#008000',
    lime: '#0F0',
    olive: '#808000',
    yellow: '#FF0',
    navy: '#000080',
    blue: '#00F',
    teal: '#008080',
    aqua: '#0FF',
    transparent: '#0000'
};

const prefix$1 = '^\\s*';
const suffix = '\\s*$';
const float = '\\s*((\\.\\d+)|(\\d+(\\.\\d*)?))\\s*'; // 4 offset
const hex = '([0-9A-Fa-f])';
const dhex = '([0-9A-Fa-f]{2})';
const rgbRegex = new RegExp(`${prefix$1}rgb\\s*\\(${float},${float},${float}\\)${suffix}`);
const rgbaRegex = new RegExp(`${prefix$1}rgba\\s*\\(${float},${float},${float},${float}\\)${suffix}`);
const sHexRegex = new RegExp(`${prefix$1}#${hex}${hex}${hex}${suffix}`);
const hexRegex = new RegExp(`${prefix$1}#${dhex}${dhex}${dhex}${suffix}`);
const sHexaRegex = new RegExp(`${prefix$1}#${hex}${hex}${hex}${hex}${suffix}`);
const hexaRegex = new RegExp(`${prefix$1}#${dhex}${dhex}${dhex}${dhex}${suffix}`);
function parseHex(value) {
    return parseInt(value, 16);
}
/**
 * Convert color string to rgba array.
 * @param color format like #000[0], #000000[00], rgb(0, 0, 0), rgba(0, 0, 0, 0) and basic color keywords https://www.w3.org/TR/css-color-3/#html4 and transparent
 * @returns
 */
function rgba(color) {
    try {
        let i;
        if ((i = hexRegex.exec(color))) {
            return [parseHex(i[1]), parseHex(i[2]), parseHex(i[3]), 1];
        }
        else if ((i = rgbRegex.exec(color))) {
            return [roundChannel(i[1]), roundChannel(i[5]), roundChannel(i[9]), 1];
        }
        else if ((i = rgbaRegex.exec(color))) {
            return [
                roundChannel(i[1]),
                roundChannel(i[5]),
                roundChannel(i[9]),
                roundAlpha(i[13])
            ];
        }
        else if ((i = sHexRegex.exec(color))) {
            return [
                parseHex(i[1] + i[1]),
                parseHex(i[2] + i[2]),
                parseHex(i[3] + i[3]),
                1
            ];
        }
        else if ((i = hexaRegex.exec(color))) {
            return [
                parseHex(i[1]),
                parseHex(i[2]),
                parseHex(i[3]),
                roundAlpha(parseHex(i[4]) / 255)
            ];
        }
        else if ((i = sHexaRegex.exec(color))) {
            return [
                parseHex(i[1] + i[1]),
                parseHex(i[2] + i[2]),
                parseHex(i[3] + i[3]),
                roundAlpha(parseHex(i[4] + i[4]) / 255)
            ];
        }
        else if (color in colors) {
            return rgba(colors[color]);
        }
        throw new Error(`[seemly/rgba]: Invalid color value ${color}.`);
    }
    catch (e) {
        throw e;
    }
}
function normalizeAlpha(alphaValue) {
    return alphaValue > 1 ? 1 : alphaValue < 0 ? 0 : alphaValue;
}
function stringifyRgba(r, g, b, a) {
    return `rgba(${roundChannel(r)}, ${roundChannel(g)}, ${roundChannel(b)}, ${normalizeAlpha(a)})`;
}
function compositeChannel(v1, a1, v2, a2, a) {
    return roundChannel((v1 * a1 * (1 - a2) + v2 * a2) / a);
}
function composite(background, overlay) {
    if (!Array.isArray(background))
        background = rgba(background);
    if (!Array.isArray(overlay))
        overlay = rgba(overlay);
    const a1 = background[3];
    const a2 = overlay[3];
    const alpha = roundAlpha(a1 + a2 - a1 * a2);
    return stringifyRgba(compositeChannel(background[0], a1, overlay[0], a2, alpha), compositeChannel(background[1], a1, overlay[1], a2, alpha), compositeChannel(background[2], a1, overlay[2], a2, alpha), alpha);
}
function changeColor(base, options) {
    const [r, g, b, a = 1] = Array.isArray(base) ? base : rgba(base);
    if (options.alpha) {
        return stringifyRgba(r, g, b, options.alpha);
    }
    return stringifyRgba(r, g, b, a);
}
function scaleColor(base, options) {
    const [r, g, b, a = 1] = Array.isArray(base) ? base : rgba(base);
    const { lightness = 1, alpha = 1 } = options;
    return toRgbaString([r * lightness, g * lightness, b * lightness, a * alpha]);
}
function roundAlpha(value) {
    const v = Math.round(Number(value) * 100) / 100;
    if (v > 1)
        return 1;
    if (v < 0)
        return 0;
    return v;
}
function roundChannel(value) {
    const v = Math.round(Number(value));
    if (v > 255)
        return 255;
    if (v < 0)
        return 0;
    return v;
}
function toRgbaString(base) {
    const [r, g, b] = base;
    if (3 in base) {
        return `rgba(${roundChannel(r)}, ${roundChannel(g)}, ${roundChannel(b)}, ${roundAlpha(base[3])})`;
    }
    return `rgba(${roundChannel(r)}, ${roundChannel(g)}, ${roundChannel(b)}, 1)`;
}

const formItemInjectionKey = Symbol('formItem');
function useFormItem(props, { defaultSize = 'medium', mergedSize, mergedDisabled } = {}) {
    const NFormItem = inject(formItemInjectionKey, null);
    provide(formItemInjectionKey, null);
    const mergedSizeRef = computed(mergedSize
        ? () => mergedSize(NFormItem)
        : () => {
            const { size } = props;
            if (size)
                return size;
            if (NFormItem) {
                const { mergedSize } = NFormItem;
                if (mergedSize.value !== undefined) {
                    return mergedSize.value;
                }
            }
            return defaultSize;
        });
    const mergedDisabledRef = computed(mergedDisabled
        ? () => mergedDisabled(NFormItem)
        : () => {
            const { disabled } = props;
            if (disabled !== undefined) {
                return disabled;
            }
            if (NFormItem) {
                return NFormItem.disabled.value;
            }
            return false;
        });
    onBeforeUnmount(() => {
        if (NFormItem) {
            NFormItem.restoreValidation();
        }
    });
    return {
        mergedSizeRef,
        mergedDisabledRef,
        nTriggerFormBlur() {
            if (NFormItem) {
                NFormItem.handleContentBlur();
            }
        },
        nTriggerFormChange() {
            if (NFormItem) {
                NFormItem.handleContentChange();
            }
        },
        nTriggerFormFocus() {
            if (NFormItem) {
                NFormItem.handleContentFocus();
            }
        },
        nTriggerFormInput() {
            if (NFormItem) {
                NFormItem.handleContentInput();
            }
        }
    };
}

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

var freeGlobal$1 = freeGlobal;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal$1 || freeSelf || Function('return this')();

var root$1 = root;

/** Built-in value references. */
var Symbol$1 = root$1.Symbol;

var Symbol$2 = Symbol$1;

/** Used for built-in method references. */
var objectProto$a = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$8 = objectProto$a.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString$1 = objectProto$a.toString;

/** Built-in value references. */
var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty$8.call(value, symToStringTag$1),
      tag = value[symToStringTag$1];

  try {
    value[symToStringTag$1] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString$1.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag$1] = tag;
    } else {
      delete value[symToStringTag$1];
    }
  }
  return result;
}

/** Used for built-in method references. */
var objectProto$9 = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto$9.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && baseGetTag(value) == symbolTag);
}

/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

var isArray$1 = isArray;

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol$2 ? Symbol$2.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isArray$1(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return arrayMap(value, baseToString) + '';
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

/**
 * This method returns the first argument it receives.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Util
 * @param {*} value Any value.
 * @returns {*} Returns `value`.
 * @example
 *
 * var object = { 'a': 1 };
 *
 * console.log(_.identity(object) === object);
 * // => true
 */
function identity(value) {
  return value;
}

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag$1 = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag$1 || tag == genTag || tag == asyncTag || tag == proxyTag;
}

/** Used to detect overreaching core-js shims. */
var coreJsData = root$1['__core-js_shared__'];

var coreJsData$1 = coreJsData;

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

/** Used for built-in method references. */
var funcProto$2 = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString$2 = funcProto$2.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString$2.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto$1 = Function.prototype,
    objectProto$8 = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString$1 = funcProto$1.toString;

/** Used to check objects for own properties. */
var hasOwnProperty$7 = objectProto$8.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString$1.call(hasOwnProperty$7).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

/** Built-in value references. */
var objectCreate = Object.create;

/**
 * The base implementation of `_.create` without support for assigning
 * properties to the created object.
 *
 * @private
 * @param {Object} proto The object to inherit from.
 * @returns {Object} Returns the new object.
 */
var baseCreate = (function() {
  function object() {}
  return function(proto) {
    if (!isObject(proto)) {
      return {};
    }
    if (objectCreate) {
      return objectCreate(proto);
    }
    object.prototype = proto;
    var result = new object;
    object.prototype = undefined;
    return result;
  };
}());

var baseCreate$1 = baseCreate;

/**
 * A faster alternative to `Function#apply`, this function invokes `func`
 * with the `this` binding of `thisArg` and the arguments of `args`.
 *
 * @private
 * @param {Function} func The function to invoke.
 * @param {*} thisArg The `this` binding of `func`.
 * @param {Array} args The arguments to invoke `func` with.
 * @returns {*} Returns the result of `func`.
 */
function apply(func, thisArg, args) {
  switch (args.length) {
    case 0: return func.call(thisArg);
    case 1: return func.call(thisArg, args[0]);
    case 2: return func.call(thisArg, args[0], args[1]);
    case 3: return func.call(thisArg, args[0], args[1], args[2]);
  }
  return func.apply(thisArg, args);
}

/**
 * Copies the values of `source` to `array`.
 *
 * @private
 * @param {Array} source The array to copy values from.
 * @param {Array} [array=[]] The array to copy values to.
 * @returns {Array} Returns `array`.
 */
function copyArray(source, array) {
  var index = -1,
      length = source.length;

  array || (array = Array(length));
  while (++index < length) {
    array[index] = source[index];
  }
  return array;
}

/** Used to detect hot functions by number of calls within a span of milliseconds. */
var HOT_COUNT = 800,
    HOT_SPAN = 16;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeNow = Date.now;

/**
 * Creates a function that'll short out and invoke `identity` instead
 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
 * milliseconds.
 *
 * @private
 * @param {Function} func The function to restrict.
 * @returns {Function} Returns the new shortable function.
 */
function shortOut(func) {
  var count = 0,
      lastCalled = 0;

  return function() {
    var stamp = nativeNow(),
        remaining = HOT_SPAN - (stamp - lastCalled);

    lastCalled = stamp;
    if (remaining > 0) {
      if (++count >= HOT_COUNT) {
        return arguments[0];
      }
    } else {
      count = 0;
    }
    return func.apply(undefined, arguments);
  };
}

/**
 * Creates a function that returns `value`.
 *
 * @static
 * @memberOf _
 * @since 2.4.0
 * @category Util
 * @param {*} value The value to return from the new function.
 * @returns {Function} Returns the new constant function.
 * @example
 *
 * var objects = _.times(2, _.constant({ 'a': 1 }));
 *
 * console.log(objects);
 * // => [{ 'a': 1 }, { 'a': 1 }]
 *
 * console.log(objects[0] === objects[1]);
 * // => true
 */
function constant(value) {
  return function() {
    return value;
  };
}

var defineProperty = (function() {
  try {
    var func = getNative(Object, 'defineProperty');
    func({}, '', {});
    return func;
  } catch (e) {}
}());

var defineProperty$1 = defineProperty;

/**
 * The base implementation of `setToString` without support for hot loop shorting.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var baseSetToString = !defineProperty$1 ? identity : function(func, string) {
  return defineProperty$1(func, 'toString', {
    'configurable': true,
    'enumerable': false,
    'value': constant(string),
    'writable': true
  });
};

var baseSetToString$1 = baseSetToString;

/**
 * Sets the `toString` method of `func` to return `string`.
 *
 * @private
 * @param {Function} func The function to modify.
 * @param {Function} string The `toString` result.
 * @returns {Function} Returns `func`.
 */
var setToString = shortOut(baseSetToString$1);

var setToString$1 = setToString;

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER$1 = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER$1 : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

/**
 * The base implementation of `assignValue` and `assignMergeValue` without
 * value checks.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function baseAssignValue(object, key, value) {
  if (key == '__proto__' && defineProperty$1) {
    defineProperty$1(object, key, {
      'configurable': true,
      'enumerable': true,
      'value': value,
      'writable': true
    });
  } else {
    object[key] = value;
  }
}

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

/** Used for built-in method references. */
var objectProto$7 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$6 = objectProto$7.hasOwnProperty;

/**
 * Assigns `value` to `key` of `object` if the existing value is not equivalent
 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * for equality comparisons.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignValue(object, key, value) {
  var objValue = object[key];
  if (!(hasOwnProperty$6.call(object, key) && eq(objValue, value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

/**
 * Copies properties of `source` to `object`.
 *
 * @private
 * @param {Object} source The object to copy properties from.
 * @param {Array} props The property identifiers to copy.
 * @param {Object} [object={}] The object to copy properties to.
 * @param {Function} [customizer] The function to customize copied values.
 * @returns {Object} Returns `object`.
 */
function copyObject(source, props, object, customizer) {
  var isNew = !object;
  object || (object = {});

  var index = -1,
      length = props.length;

  while (++index < length) {
    var key = props[index];

    var newValue = customizer
      ? customizer(object[key], source[key], key, object, source)
      : undefined;

    if (newValue === undefined) {
      newValue = source[key];
    }
    if (isNew) {
      baseAssignValue(object, key, newValue);
    } else {
      assignValue(object, key, newValue);
    }
  }
  return object;
}

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeMax = Math.max;

/**
 * A specialized version of `baseRest` which transforms the rest array.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @param {Function} transform The rest array transform.
 * @returns {Function} Returns the new function.
 */
function overRest(func, start, transform) {
  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
  return function() {
    var args = arguments,
        index = -1,
        length = nativeMax(args.length - start, 0),
        array = Array(length);

    while (++index < length) {
      array[index] = args[start + index];
    }
    index = -1;
    var otherArgs = Array(start + 1);
    while (++index < start) {
      otherArgs[index] = args[index];
    }
    otherArgs[start] = transform(array);
    return apply(func, this, otherArgs);
  };
}

/**
 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
 *
 * @private
 * @param {Function} func The function to apply a rest parameter to.
 * @param {number} [start=func.length-1] The start position of the rest parameter.
 * @returns {Function} Returns the new function.
 */
function baseRest(func, start) {
  return setToString$1(overRest(func, start, identity), func + '');
}

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

/**
 * Checks if the given arguments are from an iteratee call.
 *
 * @private
 * @param {*} value The potential iteratee value argument.
 * @param {*} index The potential iteratee index or key argument.
 * @param {*} object The potential iteratee object argument.
 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
 *  else `false`.
 */
function isIterateeCall(value, index, object) {
  if (!isObject(object)) {
    return false;
  }
  var type = typeof index;
  if (type == 'number'
        ? (isArrayLike(object) && isIndex(index, object.length))
        : (type == 'string' && index in object)
      ) {
    return eq(object[index], value);
  }
  return false;
}

/**
 * Creates a function like `_.assign`.
 *
 * @private
 * @param {Function} assigner The function to assign values.
 * @returns {Function} Returns the new assigner function.
 */
function createAssigner(assigner) {
  return baseRest(function(object, sources) {
    var index = -1,
        length = sources.length,
        customizer = length > 1 ? sources[length - 1] : undefined,
        guard = length > 2 ? sources[2] : undefined;

    customizer = (assigner.length > 3 && typeof customizer == 'function')
      ? (length--, customizer)
      : undefined;

    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      customizer = length < 3 ? undefined : customizer;
      length = 1;
    }
    object = Object(object);
    while (++index < length) {
      var source = sources[index];
      if (source) {
        assigner(object, source, index, customizer);
      }
    }
    return object;
  });
}

/** Used for built-in method references. */
var objectProto$6 = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto$6;

  return value === proto;
}

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

/** `Object#toString` result references. */
var argsTag$1 = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag$1;
}

/** Used for built-in method references. */
var objectProto$5 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$5 = objectProto$5.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto$5.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty$5.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

var isArguments$1 = isArguments;

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

/** Detect free variable `exports`. */
var freeExports$2 = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule$2 = freeExports$2 && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;

/** Built-in value references. */
var Buffer$1 = moduleExports$2 ? root$1.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer$1 ? Buffer$1.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

var isBuffer$1 = isBuffer;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag$1 = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag$1] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

/** Detect free variable `exports`. */
var freeExports$1 = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule$1 = freeExports$1 && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports$1 && freeGlobal$1.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule$1 && freeModule$1.require && freeModule$1.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

var nodeUtil$1 = nodeUtil;

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

var isTypedArray$1 = isTypedArray;

/** Used for built-in method references. */
var objectProto$4 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$4 = objectProto$4.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray$1(value),
      isArg = !isArr && isArguments$1(value),
      isBuff = !isArr && !isArg && isBuffer$1(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray$1(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty$4.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

/**
 * This function is like
 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * except that it includes inherited enumerable properties.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function nativeKeysIn(object) {
  var result = [];
  if (object != null) {
    for (var key in Object(object)) {
      result.push(key);
    }
  }
  return result;
}

/** Used for built-in method references. */
var objectProto$3 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$3 = objectProto$3.hasOwnProperty;

/**
 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeysIn(object) {
  if (!isObject(object)) {
    return nativeKeysIn(object);
  }
  var isProto = isPrototype(object),
      result = [];

  for (var key in object) {
    if (!(key == 'constructor' && (isProto || !hasOwnProperty$3.call(object, key)))) {
      result.push(key);
    }
  }
  return result;
}

/**
 * Creates an array of the own and inherited enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keysIn(new Foo);
 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
 */
function keysIn(object) {
  return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
}

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

var nativeCreate$1 = nativeCreate;

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
  this.size = 0;
}

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED$1 = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto$2 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$2 = objectProto$2.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate$1) {
    var result = data[key];
    return result === HASH_UNDEFINED$1 ? undefined : result;
  }
  return hasOwnProperty$2.call(data, key) ? data[key] : undefined;
}

/** Used for built-in method references. */
var objectProto$1 = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty$1 = objectProto$1.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate$1 ? (data[key] !== undefined) : hasOwnProperty$1.call(data, key);
}

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate$1 && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

/* Built-in method references that are verified to be native. */
var Map$1 = getNative(root$1, 'Map');

var Map$2 = Map$1;

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map$2 || ListCache),
    'string': new Hash
  };
}

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

/** Built-in value references. */
var getPrototype = overArg(Object.getPrototypeOf, Object);

var getPrototype$1 = getPrototype;

/** `Object#toString` result references. */
var objectTag = '[object Object]';

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to infer the `Object` constructor. */
var objectCtorString = funcToString.call(Object);

/**
 * Checks if `value` is a plain object, that is, an object created by the
 * `Object` constructor or one with a `[[Prototype]]` of `null`.
 *
 * @static
 * @memberOf _
 * @since 0.8.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 * }
 *
 * _.isPlainObject(new Foo);
 * // => false
 *
 * _.isPlainObject([1, 2, 3]);
 * // => false
 *
 * _.isPlainObject({ 'x': 0, 'y': 0 });
 * // => true
 *
 * _.isPlainObject(Object.create(null));
 * // => true
 */
function isPlainObject(value) {
  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
    return false;
  }
  var proto = getPrototype$1(value);
  if (proto === null) {
    return true;
  }
  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
    funcToString.call(Ctor) == objectCtorString;
}

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : baseSlice(array, start, end);
}

/** Used to compose unicode character classes. */
var rsAstralRange$1 = '\\ud800-\\udfff',
    rsComboMarksRange$1 = '\\u0300-\\u036f',
    reComboHalfMarksRange$1 = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange$1 = '\\u20d0-\\u20ff',
    rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1,
    rsVarRange$1 = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ$1 = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ$1 + rsAstralRange$1  + rsComboRange$1 + rsVarRange$1 + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsAstral = '[' + rsAstralRange + ']',
    rsCombo = '[' + rsComboRange + ']',
    rsFitz = '\\ud83c[\\udffb-\\udfff]',
    rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
    rsNonAstral = '[^' + rsAstralRange + ']',
    rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
    rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
    rsZWJ = '\\u200d';

/** Used to compose unicode regexes. */
var reOptMod = rsModifier + '?',
    rsOptVar = '[' + rsVarRange + ']?',
    rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
    rsSeq = rsOptVar + reOptMod + rsOptJoin,
    rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function unicodeToArray(string) {
  return string.match(reUnicode) || [];
}

/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function stringToArray(string) {
  return hasUnicode(string)
    ? unicodeToArray(string)
    : asciiToArray(string);
}

/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */
function createCaseFirst(methodName) {
  return function(string) {
    string = toString(string);

    var strSymbols = hasUnicode(string)
      ? stringToArray(string)
      : undefined;

    var chr = strSymbols
      ? strSymbols[0]
      : string.charAt(0);

    var trailing = strSymbols
      ? castSlice(strSymbols, 1).join('')
      : string.slice(1);

    return chr[methodName]() + trailing;
  };
}

/**
 * Converts the first character of `string` to upper case.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */
var upperFirst = createCaseFirst('toUpperCase');

var upperFirst$1 = upperFirst;

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map$2 || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

/** Detect free variable `exports`. */
var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root$1.Buffer : undefined,
    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of  `buffer`.
 *
 * @private
 * @param {Buffer} buffer The buffer to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Buffer} Returns the cloned buffer.
 */
function cloneBuffer(buffer, isDeep) {
  if (isDeep) {
    return buffer.slice();
  }
  var length = buffer.length,
      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  buffer.copy(result);
  return result;
}

/** Built-in value references. */
var Uint8Array = root$1.Uint8Array;

var Uint8Array$1 = Uint8Array;

/**
 * Creates a clone of `arrayBuffer`.
 *
 * @private
 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
 * @returns {ArrayBuffer} Returns the cloned array buffer.
 */
function cloneArrayBuffer(arrayBuffer) {
  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  new Uint8Array$1(result).set(new Uint8Array$1(arrayBuffer));
  return result;
}

/**
 * Creates a clone of `typedArray`.
 *
 * @private
 * @param {Object} typedArray The typed array to clone.
 * @param {boolean} [isDeep] Specify a deep clone.
 * @returns {Object} Returns the cloned typed array.
 */
function cloneTypedArray(typedArray, isDeep) {
  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}

/**
 * Initializes an object clone.
 *
 * @private
 * @param {Object} object The object to clone.
 * @returns {Object} Returns the initialized clone.
 */
function initCloneObject(object) {
  return (typeof object.constructor == 'function' && !isPrototype(object))
    ? baseCreate$1(getPrototype$1(object))
    : {};
}

/**
 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
 *
 * @private
 * @param {boolean} [fromRight] Specify iterating from right to left.
 * @returns {Function} Returns the new base function.
 */
function createBaseFor(fromRight) {
  return function(object, iteratee, keysFunc) {
    var index = -1,
        iterable = Object(object),
        props = keysFunc(object),
        length = props.length;

    while (length--) {
      var key = props[fromRight ? length : ++index];
      if (iteratee(iterable[key], key, iterable) === false) {
        break;
      }
    }
    return object;
  };
}

/**
 * The base implementation of `baseForOwn` which iterates over `object`
 * properties returned by `keysFunc` and invokes `iteratee` for each property.
 * Iteratee functions may exit iteration early by explicitly returning `false`.
 *
 * @private
 * @param {Object} object The object to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @returns {Object} Returns `object`.
 */
var baseFor = createBaseFor();

var baseFor$1 = baseFor;

/**
 * This function is like `assignValue` except that it doesn't assign
 * `undefined` values.
 *
 * @private
 * @param {Object} object The object to modify.
 * @param {string} key The key of the property to assign.
 * @param {*} value The value to assign.
 */
function assignMergeValue(object, key, value) {
  if ((value !== undefined && !eq(object[key], value)) ||
      (value === undefined && !(key in object))) {
    baseAssignValue(object, key, value);
  }
}

/**
 * This method is like `_.isArrayLike` except that it also checks if `value`
 * is an object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array-like object,
 *  else `false`.
 * @example
 *
 * _.isArrayLikeObject([1, 2, 3]);
 * // => true
 *
 * _.isArrayLikeObject(document.body.children);
 * // => true
 *
 * _.isArrayLikeObject('abc');
 * // => false
 *
 * _.isArrayLikeObject(_.noop);
 * // => false
 */
function isArrayLikeObject(value) {
  return isObjectLike(value) && isArrayLike(value);
}

/**
 * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function safeGet(object, key) {
  if (key === 'constructor' && typeof object[key] === 'function') {
    return;
  }

  if (key == '__proto__') {
    return;
  }

  return object[key];
}

/**
 * Converts `value` to a plain object flattening inherited enumerable string
 * keyed properties of `value` to own properties of the plain object.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {Object} Returns the converted plain object.
 * @example
 *
 * function Foo() {
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.assign({ 'a': 1 }, new Foo);
 * // => { 'a': 1, 'b': 2 }
 *
 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
 * // => { 'a': 1, 'b': 2, 'c': 3 }
 */
function toPlainObject(value) {
  return copyObject(value, keysIn(value));
}

/**
 * A specialized version of `baseMerge` for arrays and objects which performs
 * deep merges and tracks traversed objects enabling objects with circular
 * references to be merged.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {string} key The key of the value to merge.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} mergeFunc The function to merge values.
 * @param {Function} [customizer] The function to customize assigned values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  var objValue = safeGet(object, key),
      srcValue = safeGet(source, key),
      stacked = stack.get(srcValue);

  if (stacked) {
    assignMergeValue(object, key, stacked);
    return;
  }
  var newValue = customizer
    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
    : undefined;

  var isCommon = newValue === undefined;

  if (isCommon) {
    var isArr = isArray$1(srcValue),
        isBuff = !isArr && isBuffer$1(srcValue),
        isTyped = !isArr && !isBuff && isTypedArray$1(srcValue);

    newValue = srcValue;
    if (isArr || isBuff || isTyped) {
      if (isArray$1(objValue)) {
        newValue = objValue;
      }
      else if (isArrayLikeObject(objValue)) {
        newValue = copyArray(objValue);
      }
      else if (isBuff) {
        isCommon = false;
        newValue = cloneBuffer(srcValue, true);
      }
      else if (isTyped) {
        isCommon = false;
        newValue = cloneTypedArray(srcValue, true);
      }
      else {
        newValue = [];
      }
    }
    else if (isPlainObject(srcValue) || isArguments$1(srcValue)) {
      newValue = objValue;
      if (isArguments$1(objValue)) {
        newValue = toPlainObject(objValue);
      }
      else if (!isObject(objValue) || isFunction(objValue)) {
        newValue = initCloneObject(srcValue);
      }
    }
    else {
      isCommon = false;
    }
  }
  if (isCommon) {
    // Recursively merge objects and arrays (susceptible to call stack limits).
    stack.set(srcValue, newValue);
    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
    stack['delete'](srcValue);
  }
  assignMergeValue(object, key, newValue);
}

/**
 * The base implementation of `_.merge` without support for multiple sources.
 *
 * @private
 * @param {Object} object The destination object.
 * @param {Object} source The source object.
 * @param {number} srcIndex The index of `source`.
 * @param {Function} [customizer] The function to customize merged values.
 * @param {Object} [stack] Tracks traversed source values and their merged
 *  counterparts.
 */
function baseMerge(object, source, srcIndex, customizer, stack) {
  if (object === source) {
    return;
  }
  baseFor$1(source, function(srcValue, key) {
    stack || (stack = new Stack);
    if (isObject(srcValue)) {
      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
    }
    else {
      var newValue = customizer
        ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
        : undefined;

      if (newValue === undefined) {
        newValue = srcValue;
      }
      assignMergeValue(object, key, newValue);
    }
  }, keysIn);
}

/**
 * This method is like `_.assign` except that it recursively merges own and
 * inherited enumerable string keyed properties of source objects into the
 * destination object. Source properties that resolve to `undefined` are
 * skipped if a destination value exists. Array and plain object properties
 * are merged recursively. Other objects and value types are overridden by
 * assignment. Source objects are applied from left to right. Subsequent
 * sources overwrite property assignments of previous sources.
 *
 * **Note:** This method mutates `object`.
 *
 * @static
 * @memberOf _
 * @since 0.5.0
 * @category Object
 * @param {Object} object The destination object.
 * @param {...Object} [sources] The source objects.
 * @returns {Object} Returns `object`.
 * @example
 *
 * var object = {
 *   'a': [{ 'b': 2 }, { 'd': 4 }]
 * };
 *
 * var other = {
 *   'a': [{ 'c': 3 }, { 'e': 5 }]
 * };
 *
 * _.merge(object, other);
 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
 */
var merge$1 = createAssigner(function(object, source, srcIndex) {
  baseMerge(object, source, srcIndex);
});

var merge$2 = merge$1;

const ssrContextKey = Symbol('@css-render/vue3-ssr');
function createStyleString(id, style) {
    return `<style cssr-id="${id}">\n${style}\n</style>`;
}
function ssrAdapter(id, style) {
    const ssrContext = inject(ssrContextKey, null);
    if (ssrContext === null) {
        console.error('[css-render/vue3-ssr]: no ssr context found.');
        return;
    }
    const { styles, ids } = ssrContext;
    // we need to impl other options to make it behaves the same as the client side
    if (ids.has(id))
        return;
    if (styles !== null) {
        ids.add(id);
        styles.push(createStyleString(id, style));
    }
}
function useSsrAdapter() {
    const context = inject(ssrContextKey, null);
    if (context === null)
        return undefined;
    return {
        adapter: ssrAdapter,
        context
    };
}

function ampCount(selector) {
    let cnt = 0;
    for (let i = 0; i < selector.length; ++i) {
        if (selector[i] === '&')
            ++cnt;
    }
    return cnt;
}
/**
 * Don't just use ',' to separate css selector. For example:
 * x:(a, b) {} will be split into 'x:(a' and 'b)', which is not expected.
 * Make sure comma doesn't exist inside parentheses.
 */
const seperatorRegex = /\s*,(?![^(]*\))\s*/g;
const extraSpaceRegex = /\s+/g;
/**
 * selector must includes '&'
 * selector is trimmed
 * every part of amp is trimmed
 */
function resolveSelectorWithAmp(amp, selector) {
    const nextAmp = [];
    selector.split(seperatorRegex).forEach(partialSelector => {
        let round = ampCount(partialSelector);
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        if (!round) {
            amp.forEach(partialAmp => {
                nextAmp.push(
                // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
                (partialAmp && partialAmp + ' ') + partialSelector);
            });
            return;
        }
        else if (round === 1) {
            amp.forEach(partialAmp => {
                nextAmp.push(partialSelector.replace('&', partialAmp));
            });
            return;
        }
        let partialNextAmp = [
            partialSelector
        ];
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        while (round--) {
            const nextPartialNextAmp = [];
            partialNextAmp.forEach(selectorItr => {
                amp.forEach(partialAmp => {
                    nextPartialNextAmp.push(selectorItr.replace('&', partialAmp));
                });
            });
            partialNextAmp = nextPartialNextAmp;
        }
        partialNextAmp.forEach(part => nextAmp.push(part));
    });
    return nextAmp;
}
/**
 * selector mustn't includes '&'
 * selector is trimmed
 */
function resolveSelector(amp, selector) {
    const nextAmp = [];
    selector.split(seperatorRegex).forEach(partialSelector => {
        amp.forEach(partialAmp => {
            // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
            nextAmp.push(((partialAmp && partialAmp + ' ') + partialSelector));
        });
    });
    return nextAmp;
}
function parseSelectorPath(selectorPaths) {
    let amp = [''];
    selectorPaths.forEach(selector => {
        // eslint-disable-next-line
        selector = selector && selector.trim();
        if (
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        !selector) {
            /**
             * if it's a empty selector, do nothing
             */
            return;
        }
        // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
        if (selector.includes('&')) {
            amp = resolveSelectorWithAmp(amp, selector);
        }
        else {
            amp = resolveSelector(amp, selector);
        }
    });
    return amp.join(', ').replace(extraSpaceRegex, ' ');
}

const kebabRegex = /[A-Z]/g;
function kebabCase(pattern) {
    return pattern.replace(kebabRegex, match => '-' + match.toLowerCase());
}
/** TODO: refine it to solve nested object */
function upwrapProperty(prop, indent = '  ') {
    if (typeof prop === 'object' && prop !== null) {
        return (' {\n' +
            Object.entries(prop).map(v => {
                return indent + `  ${kebabCase(v[0])}: ${v[1]};`;
            }).join('\n') +
            '\n' + indent + '}');
    }
    return `: ${prop};`;
}
/** unwrap properties */
function upwrapProperties(props, instance, params) {
    if (typeof props === 'function') {
        return props({
            context: instance.context,
            props: params
        });
    }
    return props;
}
function createStyle(selector, props, instance, params) {
    if (!props)
        return '';
    // eslint-disable-next-line
    const unwrappedProps = upwrapProperties(props, instance, params);
    if (!unwrappedProps)
        return '';
    if (typeof unwrappedProps === 'string') {
        return `${selector} {\n${unwrappedProps}\n}`;
    }
    const propertyNames = Object.keys(unwrappedProps);
    if (propertyNames.length === 0) {
        if (instance.config.keepEmptyBlock)
            return selector + ' {\n}';
        return '';
    }
    const statements = selector
        ? [
            selector + ' {'
        ]
        : [];
    propertyNames.forEach(propertyName => {
        const property = unwrappedProps[propertyName];
        if (propertyName === 'raw') {
            statements.push('\n' + property + '\n');
            return;
        }
        propertyName = kebabCase(propertyName);
        if (property !== null && property !== undefined) {
            statements.push(`  ${propertyName}${upwrapProperty(property)}`);
        }
    });
    if (selector) {
        statements.push('}');
    }
    return statements.join('\n');
}
function loopCNodeListWithCallback(children, options, callback) {
    /* istanbul ignore if */
    if (!children)
        return;
    children.forEach(child => {
        if (Array.isArray(child)) {
            loopCNodeListWithCallback(child, options, callback);
        }
        else if (typeof child === 'function') {
            const grandChildren = child(options);
            if (Array.isArray(grandChildren)) {
                loopCNodeListWithCallback(grandChildren, options, callback);
            }
            else if (grandChildren) {
                callback(grandChildren);
            }
        }
        else if (child) {
            callback(child);
        }
    });
}
function traverseCNode(node, selectorPaths, styles, instance, params, styleSheet) {
    const $ = node.$;
    if (!$ || typeof $ === 'string') {
        // as a string selector
        selectorPaths.push($);
    }
    else if (typeof $ === 'function') {
        // as a lazy selector
        selectorPaths.push($({
            context: instance.context,
            props: params
        }));
    }
    else { // as a option selector
        if ($.before)
            $.before(instance.context);
        if (!$.$ || typeof $.$ === 'string') {
            selectorPaths.push($.$);
        }
        else /* istanbul ignore else */ if ($.$) {
            selectorPaths.push($.$({
                context: instance.context,
                props: params
            }));
        }
    }
    const selector = parseSelectorPath(selectorPaths);
    const style = createStyle(selector, node.props, instance, params);
    if (styleSheet && style) {
        styleSheet.insertRule(style);
    }
    if (!styleSheet && style.length)
        styles.push(style);
    if (node.children) {
        loopCNodeListWithCallback(node.children, {
            context: instance.context,
            props: params
        }, childNode => {
            if (typeof childNode === 'string') {
                const style = createStyle(selector, { raw: childNode }, instance, params);
                if (styleSheet) {
                    styleSheet.insertRule(style);
                }
                else {
                    styles.push(style);
                }
            }
            else {
                traverseCNode(childNode, selectorPaths, styles, instance, params, styleSheet);
            }
        });
    }
    selectorPaths.pop();
    if ($ && $.after)
        $.after(instance.context);
}
function render$4(node, instance, props, insertRule = false) {
    const styles = [];
    traverseCNode(node, [], styles, instance, props, insertRule
        ? node.instance.__styleSheet
        : undefined);
    if (insertRule)
        return '';
    return styles.join('\n\n');
}

/* eslint-disable */
// Inspired by https://github.com/garycourt/murmurhash-js
// Ported from https://github.com/aappleby/smhasher/blob/61a0530f28277f2e850bfc39600ce61d02b518de/src/MurmurHash2.cpp#L37-L86
function murmur2(str) {
  // 'm' and 'r' are mixing constants generated offline.
  // They're not really 'magic', they just happen to work well.
  // const m = 0x5bd1e995;
  // const r = 24;
  // Initialize the hash
  var h = 0; // Mix 4 bytes at a time into the hash

  var k,
      i = 0,
      len = str.length;

  for (; len >= 4; ++i, len -= 4) {
    k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
    k =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16);
    k ^=
    /* k >>> r: */
    k >>> 24;
    h =
    /* Math.imul(k, m): */
    (k & 0xffff) * 0x5bd1e995 + ((k >>> 16) * 0xe995 << 16) ^
    /* Math.imul(h, m): */
    (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Handle the last few bytes of the input array


  switch (len) {
    case 3:
      h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

    case 2:
      h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

    case 1:
      h ^= str.charCodeAt(i) & 0xff;
      h =
      /* Math.imul(h, m): */
      (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  } // Do a few final mixes of the hash to ensure the last few
  // bytes are well-incorporated.


  h ^= h >>> 13;
  h =
  /* Math.imul(h, m): */
  (h & 0xffff) * 0x5bd1e995 + ((h >>> 16) * 0xe995 << 16);
  return ((h ^ h >>> 15) >>> 0).toString(36);
}

function removeElement(el) {
    /* istanbul ignore if */
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    if (!el)
        return;
    const parentElement = el.parentElement;
    /* istanbul ignore else */
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    if (parentElement)
        parentElement.removeChild(el);
}
function queryElement(id) {
    return document.querySelector(`style[cssr-id="${id}"]`);
}
function createElement(id) {
    const el = document.createElement('style');
    el.setAttribute('cssr-id', id);
    return el;
}

/* eslint-disable @typescript-eslint/strict-boolean-expressions */
if (typeof window !== 'undefined') {
    window.__cssrContext = {};
}
function unmount(intance, node, id) {
    const { els } = node;
    // If id is undefined, unmount all styles
    if (id === undefined) {
        els.forEach(removeElement);
        node.els = [];
    }
    else {
        const target = queryElement(id);
        // eslint-disable-next-line
        if (target && els.includes(target)) {
            removeElement(target);
            node.els = els.filter((el) => el !== target);
        }
    }
}
function addElementToList(els, target) {
    els.push(target);
}
function mount(instance, node, id, props, head, slient, force, ssrAdapter
// eslint-disable-next-line @typescript-eslint/no-invalid-void-type
) {
    var _a;
    if (slient && !ssrAdapter) {
        if (id === undefined) {
            // it is possible to use hash to get rid of the requirements of id
            // if you are interested in it, please create a pr
            // i have no time to impl it
            console.error('[css-render/mount]: `id` is required in `slient` mode.');
            // @ts-expect-error
            return;
        }
        const cssrContext = window.__cssrContext;
        if (!cssrContext[id]) {
            cssrContext[id] = true;
            render$4(node, instance, props, slient);
        }
        // @ts-expect-error
        return;
    }
    let style;
    if (id === undefined) {
        style = node.render(props);
        id = murmur2(style);
    }
    if (ssrAdapter) {
        ssrAdapter.adapter(id, style !== null && style !== void 0 ? style : node.render(props));
        // @ts-expect-error
        return;
    }
    const queriedTarget = queryElement(id);
    if (queriedTarget !== null && !force) {
        // @ts-expect-error
        return queriedTarget;
    }
    const target = queriedTarget !== null && queriedTarget !== void 0 ? queriedTarget : createElement(id);
    if (style === undefined)
        style = node.render(props);
    target.textContent = style;
    // @ts-expect-error
    if (queriedTarget !== null)
        return queriedTarget;
    if (head) {
        const firstStyleEl = (_a = document.head.querySelector('style, link')) !== null && _a !== void 0 ? _a : null;
        document.head.insertBefore(target, firstStyleEl);
    }
    else {
        document.head.appendChild(target);
    }
    addElementToList(node.els, target);
    // @ts-expect-error
    return queriedTarget !== null && queriedTarget !== void 0 ? queriedTarget : target;
}

function wrappedRender(props) {
    return render$4(this, this.instance, props);
}
// do not guard node calling, it should throw an error.
function wrappedMount(options = {}
// eslint-disable-next-line @typescript-eslint/no-invalid-void-type
) {
    const { id, ssr, props, head = false, slient = false, force = false } = options;
    const targetElement = mount(this.instance, this, id, props, head, slient, force, ssr);
    return targetElement;
}
function wrappedUnmount(options = {}) {
    /* istanbul ignore next */
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    const { id } = options;
    unmount(this.instance, this, id);
}
const createCNode = function (instance, $, props, children) {
    return {
        instance,
        $,
        props,
        children,
        els: [],
        render: wrappedRender,
        mount: wrappedMount,
        unmount: wrappedUnmount
    };
};
const c$2 = function (instance, $, props, children) {
    if (Array.isArray($)) {
        return createCNode(instance, { $: null }, null, $);
    }
    if (Array.isArray(props)) {
        return createCNode(instance, $, null, props);
    }
    else if (Array.isArray(children)) {
        return createCNode(instance, $, props, children);
    }
    else {
        return createCNode(instance, $, props, null);
    }
};

function CssRender(config = {}) {
    let styleSheet = null;
    const cssr = {
        c: ((...args) => c$2(cssr, ...args)),
        use: (plugin, ...args) => plugin.install(cssr, ...args),
        find: queryElement,
        context: {},
        config,
        get __styleSheet() {
            // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
            if (!styleSheet) {
                const style = document.createElement('style');
                document.head.appendChild(style);
                styleSheet = document.styleSheets[document.styleSheets.length - 1];
                return styleSheet;
            }
            return styleSheet;
        }
    };
    return cssr;
}

function exists(id, ssr) {
    if (id === undefined)
        return false;
    if (ssr) {
        const { context: { ids } } = ssr;
        return ids.has(id);
    }
    return queryElement(id) !== null;
}

/* eslint-disable @typescript-eslint/restrict-template-expressions */
/* eslint-disable @typescript-eslint/strict-boolean-expressions */
function plugin$1(options) {
    let _bPrefix = '.';
    let _ePrefix = '__';
    let _mPrefix = '--';
    let c;
    if (options) {
        let t = options.blockPrefix;
        if (t) {
            _bPrefix = t;
        }
        t = options.elementPrefix;
        if (t) {
            _ePrefix = t;
        }
        t = options.modifierPrefix;
        if (t) {
            _mPrefix = t;
        }
    }
    const _plugin = {
        install(instance) {
            c = instance.c;
            const ctx = instance.context;
            ctx.bem = {};
            ctx.bem.b = null;
            ctx.bem.els = null;
        }
    };
    function b(arg) {
        let memorizedB;
        let memorizedE;
        return {
            before(ctx) {
                memorizedB = ctx.bem.b;
                memorizedE = ctx.bem.els;
                ctx.bem.els = null;
            },
            after(ctx) {
                ctx.bem.b = memorizedB;
                ctx.bem.els = memorizedE;
            },
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                context.bem.b = arg;
                return `${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}`;
            }
        };
    }
    function e(arg) {
        let memorizedE;
        return {
            before(ctx) {
                memorizedE = ctx.bem.els;
            },
            after(ctx) {
                ctx.bem.els = memorizedE;
            },
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                context.bem.els = arg.split(',').map(v => v.trim());
                return context.bem.els
                    .map(el => `${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}__${el}`).join(', ');
            }
        };
    }
    function m(arg) {
        return {
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                const modifiers = arg.split(',').map(v => v.trim());
                function elementToSelector(el) {
                    return modifiers.map(modifier => `&${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}${el !== undefined ? `${_ePrefix}${el}` : ''}${_mPrefix}${modifier}`).join(', ');
                }
                const els = context.bem.els;
                if (els !== null) {
                    return elementToSelector(els[0]);
                }
                else {
                    return elementToSelector();
                }
            }
        };
    }
    function notM(arg) {
        return {
            $({ context, props }) {
                arg = typeof arg === 'string' ? arg : arg({ context, props });
                const els = context.bem.els;
                return `&:not(${(props === null || props === void 0 ? void 0 : props.bPrefix) || _bPrefix}${context.bem.b}${(els !== null && els.length > 0) ? `${_ePrefix}${els[0]}` : ''}${_mPrefix}${arg})`;
            }
        };
    }
    const cB = ((...args) => c(b(args[0]), args[1], args[2]));
    const cE = ((...args) => c(e(args[0]), args[1], args[2]));
    const cM = ((...args) => c(m(args[0]), args[1], args[2]));
    const cNotM = ((...args) => c(notM(args[0]), args[1], args[2]));
    Object.assign(_plugin, {
        cB, cE, cM, cNotM
    });
    return _plugin;
}

function createKey(prefix, suffix) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return (prefix +
        (suffix === 'default'
            ? ''
            : suffix.replace(/^[a-z]/, (startChar) => startChar.toUpperCase())));
}
createKey('abc', 'def');

/* eslint-disable @typescript-eslint/restrict-template-expressions */
const namespace = 'n';
const prefix = `.${namespace}-`;
const elementPrefix = '__';
const modifierPrefix = '--';
const cssr = CssRender();
const plugin = plugin$1({
    blockPrefix: prefix,
    elementPrefix,
    modifierPrefix
});
cssr.use(plugin);
const { c: c$1, find } = cssr;
const { cB, cE, cM, cNotM } = plugin;
function insideFormItem(status, style) {
    if (status === null)
        return style;
    return c$1([
        ({ props: { bPrefix } }) => c$1(`${bPrefix || prefix}form-item`, [
            c$1(`${bPrefix || prefix}form-item-blank`, [
                c$1(`&${bPrefix || prefix}form-item-blank${modifierPrefix}${status}`, [
                    style
                ])
            ])
        ])
    ]);
}
// child block
const cCB = ((...args) => {
    return c$1('>', [cB(...args)]);
});

var commonVariables$3 = {
    fontFamily: 'v-sans, system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"',
    fontFamilyMono: 'v-mono, SFMono-Regular, Menlo, Consolas, Courier, monospace',
    fontWeight: '400',
    fontWeightStrong: '500',
    cubicBezierEaseInOut: 'cubic-bezier(.4, 0, .2, 1)',
    cubicBezierEaseOut: 'cubic-bezier(0, 0, .2, 1)',
    cubicBezierEaseIn: 'cubic-bezier(.4, 0, 1, 1)',
    borderRadius: '3px',
    borderRadiusSmall: '2px',
    fontSize: '14px',
    fontSizeTiny: '12px',
    fontSizeSmall: '14px',
    fontSizeMedium: '14px',
    fontSizeLarge: '15px',
    fontSizeHuge: '16px',
    lineHeight: '1.6',
    heightTiny: '22px',
    heightSmall: '28px',
    heightMedium: '34px',
    heightLarge: '40px',
    heightHuge: '46px',
    transformDebounceScale: 'scale(1)'
};

// It is static and won't be changed in the app's lifetime
// If user want to overrides it they need to use `n-global-style` is provided
//
// Technically we can remove font-size & font-family & line-height to make
// it pure. However the coding cost doesn't worth it.
//
// -webkit-tap-hilight-color:
// https://developer.mozilla.org/en-US/docs/Web/CSS/-webkit-tap-highlight-color
// In some android devices, there will be the style.

var globalStyle = c$1('body', `
 margin: 0;
 font-size: ${commonVariables$3.fontSize};
 font-family: ${commonVariables$3.fontFamily};
 line-height: ${commonVariables$3.lineHeight};
 -webkit-text-size-adjust: 100%;
 -webkit-tap-highlight-color: transparent;
`, [c$1('input', `
 font-family: inherit;
 font-size: inherit;
 `)]);

function useFalseUntilTruthy(originalRef) {
    const currentRef = ref(!!originalRef.value);
    if (currentRef.value)
        return readonly(currentRef);
    const stop = watch(originalRef, (value) => {
        if (value) {
            currentRef.value = true;
            stop();
        }
    });
    return readonly(currentRef);
}

function useMemo(getterOrOptions) {
    const computedValueRef = computed(getterOrOptions);
    // Maybe it's not possible to lazy evaluate the value, since we can't make
    // render phase capture the deps behind useMemo
    const valueRef = ref(computedValueRef.value);
    watch(computedValueRef, (value) => {
        valueRef.value = value;
    });
    if (typeof getterOrOptions === 'function') {
        return valueRef;
    }
    else {
        return {
            __v_isRef: true,
            get value() {
                return valueRef.value;
            },
            set value(v) {
                getterOrOptions.set(v);
            }
        };
    }
}

const isBrowser$1 = typeof window !== 'undefined';

let fontsReady;
let isFontReady;
const init = () => {
    var _a, _b;
    fontsReady = isBrowser$1 ? (_b = (_a = document) === null || _a === void 0 ? void 0 : _a.fonts) === null || _b === void 0 ? void 0 : _b.ready : undefined;
    isFontReady = false;
    /* istanbul ignore if */
    if (fontsReady !== undefined) {
        void fontsReady.then(() => {
            isFontReady = true;
        });
    }
    else {
        isFontReady = true;
    }
};
init();
/**
 * Call callback on fontsReady is resolved. If fontsReady is already resolved,
 * callback won't be called.
 */
function onFontsReady(cb) {
    /* istanbul ignore next */
    if (isFontReady)
        return;
    let deactivated = false;
    onMounted(() => {
        /* istanbul ignore next */
        if (!isFontReady) {
            fontsReady === null || fontsReady === void 0 ? void 0 : fontsReady.then(() => {
                if (deactivated)
                    return;
                cb();
            });
        }
    });
    onBeforeUnmount(() => {
        deactivated = true;
    });
}

const traps = {
    mousemoveoutside: new WeakMap(),
    clickoutside: new WeakMap()
};
function createTrapHandler(name, el, originalHandler) {
    if (name === 'mousemoveoutside') {
        const moveHandler = (e) => {
            if (el.contains(e.target))
                return;
            originalHandler(e);
        };
        return {
            mousemove: moveHandler,
            touchstart: moveHandler
        };
    }
    else if (name === 'clickoutside') {
        let mouseDownOutside = false;
        const downHandler = (e) => {
            mouseDownOutside = !el.contains(e.target);
        };
        const upHanlder = (e) => {
            if (!mouseDownOutside)
                return;
            if (el.contains(e.target))
                return;
            originalHandler(e);
        };
        return {
            mousedown: downHandler,
            mouseup: upHanlder,
            touchstart: downHandler,
            touchend: upHanlder
        };
    }
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    console.error(`[evtd/create-trap-handler]: name \`${name}\` is invalid. This could be a bug of evtd.`);
    return {};
}
function ensureTrapHandlers(name, el, handler) {
    const handlers = traps[name];
    let elHandlers = handlers.get(el);
    if (elHandlers === undefined) {
        handlers.set(el, elHandlers = new WeakMap());
    }
    let trapHandler = elHandlers.get(handler);
    if (trapHandler === undefined) {
        elHandlers.set(handler, trapHandler = createTrapHandler(name, el, handler));
    }
    return trapHandler;
}
function trapOn(name, el, handler, options) {
    if (name === 'mousemoveoutside' ||
        name === 'clickoutside') {
        const trapHandlers = ensureTrapHandlers(name, el, handler);
        Object.keys(trapHandlers).forEach(key => {
            on(key, document, trapHandlers[key], options);
        });
        return true;
    }
    return false;
}
function trapOff(name, el, handler, options) {
    if (name === 'mousemoveoutside' ||
        name === 'clickoutside') {
        const trapHandlers = ensureTrapHandlers(name, el, handler);
        Object.keys(trapHandlers).forEach(key => {
            off(key, document, trapHandlers[key], options);
        });
        return true;
    }
    return false;
}

// currently `once` and `passive` is not supported
function createDelegate() {
    if (typeof window === 'undefined') {
        return {
            on: () => { },
            off: () => { }
        };
    }
    const propagationStopped = new WeakMap();
    const immediatePropagationStopped = new WeakMap();
    function trackPropagation() {
        propagationStopped.set(this, true);
    }
    function trackImmediate() {
        propagationStopped.set(this, true);
        immediatePropagationStopped.set(this, true);
    }
    function spy(event, propName, fn) {
        const source = event[propName];
        event[propName] = function () {
            fn.apply(event, arguments);
            return source.apply(event, arguments);
        };
        return event;
    }
    function unspy(event, propName) {
        event[propName] = Event.prototype[propName];
    }
    const currentTargets = new WeakMap();
    const currentTargetDescriptor = Object.getOwnPropertyDescriptor(Event.prototype, 'currentTarget');
    function getCurrentTarget() {
        var _a;
        return (_a = currentTargets.get(this)) !== null && _a !== void 0 ? _a : null;
    }
    function defineCurrentTarget(event, getter) {
        if (currentTargetDescriptor === undefined)
            return;
        Object.defineProperty(event, 'currentTarget', {
            configurable: true,
            enumerable: true,
            get: getter !== null && getter !== void 0 ? getter : currentTargetDescriptor.get
        });
    }
    const phaseToTypeToElToHandlers = {
        bubble: {},
        capture: {}
    };
    const typeToWindowEventHandlers = {};
    function createUnifiedHandler() {
        const delegeteHandler = function (e) {
            const { type, eventPhase, target, bubbles } = e;
            if (eventPhase === 2)
                return;
            const phase = eventPhase === 1 ? 'capture' : 'bubble';
            let cursor = target;
            const path = [];
            // collecting bubble path
            while (true) {
                if (cursor === null)
                    cursor = window;
                path.push(cursor);
                if (cursor === window) {
                    break;
                }
                // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
                cursor = (cursor.parentNode || null);
            }
            const captureElToHandlers = phaseToTypeToElToHandlers.capture[type];
            const bubbleElToHandlers = phaseToTypeToElToHandlers.bubble[type];
            spy(e, 'stopPropagation', trackPropagation);
            spy(e, 'stopImmediatePropagation', trackImmediate);
            defineCurrentTarget(e, getCurrentTarget);
            if (phase === 'capture') {
                if (captureElToHandlers === undefined)
                    return;
                // capture
                for (let i = path.length - 1; i >= 0; --i) {
                    if (propagationStopped.has(e))
                        break;
                    const target = path[i];
                    const handlers = captureElToHandlers.get(target);
                    if (handlers !== undefined) {
                        currentTargets.set(e, target);
                        for (const handler of handlers) {
                            if (immediatePropagationStopped.has(e))
                                break;
                            handler(e);
                        }
                    }
                    if (i === 0 && !bubbles && bubbleElToHandlers !== undefined) {
                        const bubbleHandlers = bubbleElToHandlers.get(target);
                        if (bubbleHandlers !== undefined) {
                            for (const handler of bubbleHandlers) {
                                if (immediatePropagationStopped.has(e))
                                    break;
                                handler(e);
                            }
                        }
                    }
                }
            }
            else if (phase === 'bubble') {
                if (bubbleElToHandlers === undefined)
                    return;
                // bubble
                for (let i = 0; i < path.length; ++i) {
                    if (propagationStopped.has(e))
                        break;
                    const target = path[i];
                    const handlers = bubbleElToHandlers.get(target);
                    if (handlers !== undefined) {
                        currentTargets.set(e, target);
                        for (const handler of handlers) {
                            if (immediatePropagationStopped.has(e))
                                break;
                            handler(e);
                        }
                    }
                }
            }
            unspy(e, 'stopPropagation');
            unspy(e, 'stopImmediatePropagation');
            defineCurrentTarget(e);
        };
        delegeteHandler.displayName = 'evtdUnifiedHandler';
        return delegeteHandler;
    }
    function createUnifiedWindowEventHandler() {
        const delegateHandler = function (e) {
            const { type, eventPhase } = e;
            if (eventPhase !== 2)
                return;
            const handlers = typeToWindowEventHandlers[type];
            if (handlers === undefined)
                return;
            handlers.forEach((handler) => handler(e));
        };
        delegateHandler.displayName = 'evtdUnifiedWindowEventHandler';
        return delegateHandler;
    }
    const unifiedHandler = createUnifiedHandler();
    const unfiendWindowEventHandler = createUnifiedWindowEventHandler();
    function ensureElToHandlers(phase, type) {
        const phaseHandlers = phaseToTypeToElToHandlers[phase];
        if (phaseHandlers[type] === undefined) {
            phaseHandlers[type] = new Map();
            window.addEventListener(type, unifiedHandler, phase === 'capture');
        }
        return phaseHandlers[type];
    }
    function ensureWindowEventHandlers(type) {
        const windowEventHandlers = typeToWindowEventHandlers[type];
        if (windowEventHandlers === undefined) {
            typeToWindowEventHandlers[type] = new Set();
            window.addEventListener(type, unfiendWindowEventHandler);
        }
        return typeToWindowEventHandlers[type];
    }
    function ensureHandlers(elToHandlers, el) {
        let elHandlers = elToHandlers.get(el);
        if (elHandlers === undefined) {
            elToHandlers.set(el, (elHandlers = new Set()));
        }
        return elHandlers;
    }
    function handlerExist(el, phase, type, handler) {
        const elToHandlers = phaseToTypeToElToHandlers[phase][type];
        // phase ${type} event has handlers
        if (elToHandlers !== undefined) {
            const handlers = elToHandlers.get(el);
            // phase using el with ${type} event has handlers
            if (handlers !== undefined) {
                if (handlers.has(handler))
                    return true;
            }
        }
        return false;
    }
    function windowEventHandlerExist(type, handler) {
        const handlers = typeToWindowEventHandlers[type];
        if (handlers !== undefined) {
            if (handlers.has(handler)) {
                return true;
            }
        }
        return false;
    }
    function on(type, el, handler, options) {
        const trapped = trapOn(type, el, handler, options);
        if (trapped)
            return;
        const phase = options === true ||
            (typeof options === 'object' && options.capture === true)
            ? 'capture'
            : 'bubble';
        const elToHandlers = ensureElToHandlers(phase, type);
        const handlers = ensureHandlers(elToHandlers, el);
        if (!handlers.has(handler))
            handlers.add(handler);
        if (el === window) {
            const windowEventHandlers = ensureWindowEventHandlers(type);
            if (!windowEventHandlers.has(handler)) {
                windowEventHandlers.add(handler);
            }
        }
    }
    function off(type, el, handler, options) {
        const trapped = trapOff(type, el, handler, options);
        if (trapped)
            return;
        const capture = options === true ||
            (typeof options === 'object' && options.capture === true);
        const phase = capture ? 'capture' : 'bubble';
        const elToHandlers = ensureElToHandlers(phase, type);
        const handlers = ensureHandlers(elToHandlers, el);
        if (el === window) {
            const mirrorPhase = capture ? 'bubble' : 'capture';
            if (!handlerExist(el, mirrorPhase, type, handler) &&
                windowEventHandlerExist(type, handler)) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                const windowEventHandlers = typeToWindowEventHandlers[type];
                windowEventHandlers.delete(handler);
                if (windowEventHandlers.size === 0) {
                    window.removeEventListener(type, unfiendWindowEventHandler);
                    typeToWindowEventHandlers[type] = undefined;
                }
            }
        }
        if (handlers.has(handler))
            handlers.delete(handler);
        if (handlers.size === 0) {
            elToHandlers.delete(el);
        }
        if (elToHandlers.size === 0) {
            window.removeEventListener(type, unifiedHandler, phase === 'capture');
            phaseToTypeToElToHandlers[phase][type] = undefined;
        }
    }
    return {
        on: on,
        off: off
    };
}
const { on, off } = createDelegate();

function useMergedState(controlledStateRef, uncontrolledStateRef) {
    watch(controlledStateRef, value => {
        if (value !== undefined) {
            uncontrolledStateRef.value = value;
        }
    });
    return computed(() => {
        if (controlledStateRef.value === undefined) {
            return uncontrolledStateRef.value;
        }
        return controlledStateRef.value;
    });
}

function isMounted() {
    const isMounted = ref(false);
    onMounted(() => { isMounted.value = true; });
    return readonly(isMounted);
}

function useCompitable(reactive, keys) {
    // @ts-expect-error
    return computed(() => {
        for (const key of keys) {
            if (reactive[key] !== undefined)
                return reactive[key];
        }
        return reactive[keys[keys.length - 1]];
    });
}

const isIos = (typeof window === 'undefined'
    ? false
    : /iPad|iPhone|iPod/.test(navigator.platform) ||
        (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1)) &&
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    !window.MSStream;
function useIsIos() {
    return isIos;
}

function getSlot$1(instance, slotName = 'default', fallback = []) {
    const slots = instance.$slots;
    const slot = slots[slotName];
    if (slot === undefined)
        return fallback;
    return slot();
}

function keep(object, keys = [], rest) {
    const keepedObject = {};
    keys.forEach((key) => {
        keepedObject[key] = object[key];
    });
    return Object.assign(keepedObject, rest);
}

// o(n) flatten
function flatten$1(vNodes, filterCommentNode = true, result = []) {
    vNodes.forEach((vNode) => {
        if (vNode === null)
            return;
        if (typeof vNode !== 'object') {
            if (typeof vNode === 'string' || typeof vNode === 'number') {
                result.push(createTextVNode(String(vNode)));
            }
            return;
        }
        if (Array.isArray(vNode)) {
            flatten$1(vNode, filterCommentNode, result);
            return;
        }
        if (vNode.type === Fragment) {
            if (vNode.children === null)
                return;
            if (Array.isArray(vNode.children)) {
                flatten$1(vNode.children, filterCommentNode, result);
            }
            // rawSlot
        }
        else if (vNode.type !== Comment) {
            result.push(vNode);
        }
    });
    return result;
}

function call(funcs, ...args) {
    if (Array.isArray(funcs)) {
        funcs.forEach((func) => call(func, ...args));
    }
    else
        return funcs(...args);
}

const render$3 = (r, ...args) => {
    if (typeof r === 'function') {
        return r(...args);
    }
    else if (typeof r === 'string') {
        return createTextVNode(r);
    }
    else if (typeof r === 'number') {
        return createTextVNode(String(r));
    }
    else {
        return null;
    }
};

function warn$2(location, message) {
    console.error(`[naive/${location}]: ${message}`);
}

function getTitleAttribute(value) {
    switch (typeof value) {
        case 'string':
            // The empty string should also be reset to undefined.
            return value || undefined;
        case 'number':
            return String(value);
        default:
            return undefined;
    }
}

function getFirstSlotVNode(slots, slotName = 'default', props = undefined) {
    const slot = slots[slotName];
    if (!slot) {
        warn$2('getFirstSlotVNode', `slot[${slotName}] is empty`);
        return null;
    }
    const slotContent = flatten$1(slot(props));
    // vue will normalize the slot, so slot must be an array
    if (slotContent.length === 1) {
        return slotContent[0];
    }
    else {
        warn$2('getFirstSlotVNode', `slot[${slotName}] should have exactly one child`);
        return null;
    }
}

const pureNumberRegex = /^(\d|\.)+$/;
const numberRegex = /(\d|\.)+/;
function formatLength(length, { c = 1, offset = 0, attachPx = true } = {}) {
    if (typeof length === 'number') {
        const result = (length + offset) * c;
        if (result === 0)
            return '0';
        return `${result}px`;
    }
    else if (typeof length === 'string') {
        if (pureNumberRegex.test(length)) {
            const result = (Number(length) + offset) * c;
            if (attachPx) {
                if (result === 0)
                    return '0';
                return `${result}px`;
            }
            else {
                return `${result}`;
            }
        }
        else {
            const result = numberRegex.exec(length);
            if (!result)
                return length;
            return length.replace(numberRegex, String((Number(result[0]) + offset) * c));
        }
    }
    return length;
}

const modalBodyInjectionKey = Symbol('modalBody');

const drawerBodyInjectionKey = Symbol('drawerBody');

const popoverBodyInjectionKey = Symbol('popoverBodyInjection');

const internalSelectionMenuInjectionKey = Symbol('internal-select-menu');
const internalSelectionMenuBodyInjectionKey = Symbol('internal-select-menu-body');

const teleportDisabled = '__disabled__';
function useAdjustedTo(props) {
    const modal = inject(modalBodyInjectionKey, null);
    const drawer = inject(drawerBodyInjectionKey, null);
    const popover = inject(popoverBodyInjectionKey, null);
    const selectMenu = inject(internalSelectionMenuBodyInjectionKey, null);
    return useMemo(() => {
        var _a;
        const { to } = props;
        if (to !== undefined) {
            if (to === false)
                return teleportDisabled;
            if (to === true)
                return 'body';
            return to;
        }
        if (modal === null || modal === void 0 ? void 0 : modal.value) {
            return (_a = modal.value.$el) !== null && _a !== void 0 ? _a : modal.value;
        }
        if (drawer === null || drawer === void 0 ? void 0 : drawer.value)
            return drawer.value;
        if (popover === null || popover === void 0 ? void 0 : popover.value)
            return popover.value;
        if (selectMenu === null || selectMenu === void 0 ? void 0 : selectMenu.value)
            return selectMenu.value;
        return to !== null && to !== void 0 ? to : 'body';
    });
}
// teleport disabled key
useAdjustedTo.tdkey = teleportDisabled;
useAdjustedTo.propTo = {
    type: [String, Object, Boolean],
    default: undefined
};

const configProviderInjectionKey = Symbol('configProviderInjection');
const configProviderProps = {
    abstract: Boolean,
    bordered: {
        type: Boolean,
        default: undefined
    },
    clsPrefix: String,
    locale: Object,
    dateLocale: Object,
    namespace: String,
    rtl: Array,
    tag: {
        type: String,
        default: 'div'
    },
    hljs: Object,
    theme: Object,
    themeOverrides: Object,
    componentOptions: Object,
    icons: Object,
    // deprecated
    as: {
        type: String,
        validator: () => {
            warn$2('config-provider', '`as` is deprecated, please use `tag` instead.');
            return true;
        },
        default: undefined
    }
};
defineComponent({
    name: 'ConfigProvider',
    alias: ['App'],
    props: configProviderProps,
    setup(props) {
        const NConfigProvider = inject(configProviderInjectionKey, null);
        const mergedThemeRef = computed(() => {
            const { theme } = props;
            if (theme === null)
                return undefined;
            const inheritedTheme = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeRef.value;
            return theme === undefined
                ? inheritedTheme
                : inheritedTheme === undefined
                    ? theme
                    : Object.assign({}, inheritedTheme, theme);
        });
        const mergedThemeOverridesRef = computed(() => {
            const { themeOverrides } = props;
            // stop inheriting themeOverrides
            if (themeOverrides === null)
                return undefined;
            // use inherited themeOverrides
            if (themeOverrides === undefined) {
                return NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeOverridesRef.value;
            }
            else {
                const inheritedThemeOverrides = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeOverridesRef.value;
                if (inheritedThemeOverrides === undefined) {
                    // no inherited, use self overrides
                    return themeOverrides;
                }
                else {
                    // merge overrides
                    return merge$2({}, inheritedThemeOverrides, themeOverrides);
                }
            }
        });
        const mergedNamespaceRef = useMemo(() => {
            const { namespace } = props;
            return namespace === undefined
                ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedNamespaceRef.value
                : namespace;
        });
        const mergedBorderedRef = useMemo(() => {
            const { bordered } = props;
            return bordered === undefined
                ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedBorderedRef.value
                : bordered;
        });
        const mergedIconsRef = computed(() => {
            const { icons } = props;
            return icons === undefined ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedIconsRef.value : icons;
        });
        const mergedComponentPropsRef = computed(() => {
            const { componentOptions } = props;
            if (componentOptions !== undefined)
                return componentOptions;
            return NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedComponentPropsRef.value;
        });
        const mergedClsPrefixRef = computed(() => {
            var _a;
            const { clsPrefix } = props;
            return (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedClsPrefixRef.value) !== null && _a !== void 0 ? _a : clsPrefix;
        });
        const mergedRtlRef = computed(() => {
            const { rtl } = props;
            if (rtl === undefined) {
                return NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedRtlRef.value;
            }
            const rtlEnabledState = {};
            for (const rtlInfo of rtl) {
                rtlEnabledState[rtlInfo.name] = markRaw(rtlInfo);
            }
            return rtlEnabledState;
        });
        provide(configProviderInjectionKey, {
            mergedRtlRef,
            mergedIconsRef,
            mergedComponentPropsRef,
            mergedBorderedRef,
            mergedNamespaceRef,
            mergedClsPrefixRef,
            mergedLocaleRef: computed(() => {
                const { locale } = props;
                if (locale === null)
                    return undefined;
                return locale === undefined
                    ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedLocaleRef.value
                    : locale;
            }),
            mergedDateLocaleRef: computed(() => {
                const { dateLocale } = props;
                if (dateLocale === null)
                    return undefined;
                return dateLocale === undefined
                    ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedDateLocaleRef.value
                    : dateLocale;
            }),
            mergedHljsRef: computed(() => {
                const { hljs } = props;
                return hljs === undefined ? NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedHljsRef.value : hljs;
            }),
            mergedThemeRef,
            mergedThemeOverridesRef
        });
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            mergedBordered: mergedBorderedRef,
            mergedNamespace: mergedNamespaceRef,
            mergedTheme: mergedThemeRef,
            mergedThemeOverrides: mergedThemeOverridesRef
        };
    },
    render() {
        return !this.abstract
            ? h(this.as || this.tag, {
                class: `${this.mergedClsPrefix || defaultClsPrefix}-config-provider`
            }, renderSlot(this.$slots, 'default'))
            : renderSlot(this.$slots, 'default');
    }
});

/* eslint-disable @typescript-eslint/consistent-type-assertions */
function createTheme(theme) {
    return theme;
}
function useTheme(resolveId, mountId, style, defaultTheme, props, clsPrefixRef) {
    const ssrAdapter = useSsrAdapter();
    if (style) {
        const mountStyle = () => {
            const clsPrefix = clsPrefixRef === null || clsPrefixRef === void 0 ? void 0 : clsPrefixRef.value;
            style.mount({
                id: clsPrefix === undefined ? mountId : clsPrefix + mountId,
                head: true,
                props: {
                    bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
                },
                ssr: ssrAdapter
            });
            globalStyle.mount({
                id: 'naive-ui/global',
                head: true,
                ssr: ssrAdapter
            });
        };
        if (ssrAdapter) {
            mountStyle();
        }
        else {
            onBeforeMount(mountStyle);
        }
    }
    const NConfigProvider = inject(configProviderInjectionKey, null);
    const mergedThemeRef = computed(() => {
        var _a;
        // keep props to make theme overrideable
        const { theme: { common: selfCommon, self, peers = {} } = {}, themeOverrides: selfOverrides = {}, builtinThemeOverrides: builtinOverrides = {} } = props;
        const { common: selfCommonOverrides, peers: peersOverrides } = selfOverrides;
        const { common: globalCommon = undefined, [resolveId]: { common: globalSelfCommon = undefined, self: globalSelf = undefined, peers: globalPeers = {} } = {} } = (NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeRef.value) || {};
        const { common: globalCommonOverrides = undefined, [resolveId]: globalSelfOverrides = {} } = (NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedThemeOverridesRef.value) || {};
        const { common: globalSelfCommonOverrides, peers: globalPeersOverrides = {} } = globalSelfOverrides;
        const mergedCommon = merge$2({}, selfCommon || globalSelfCommon || globalCommon || defaultTheme.common, globalCommonOverrides, globalSelfCommonOverrides, selfCommonOverrides);
        const mergedSelf = merge$2(
        // {}, executed every time, no need for empty obj
        (_a = (self || globalSelf || defaultTheme.self)) === null || _a === void 0 ? void 0 : _a(mergedCommon), builtinOverrides, globalSelfOverrides, selfOverrides);
        return {
            common: mergedCommon,
            self: mergedSelf,
            peers: merge$2({}, defaultTheme.peers, globalPeers, peers),
            peerOverrides: merge$2({}, globalPeersOverrides, peersOverrides)
        };
    });
    return mergedThemeRef;
}
useTheme.props = {
    theme: Object,
    themeOverrides: Object,
    builtinThemeOverrides: Object
};

const defaultClsPrefix = 'n';
function useConfig(props = {}, options = {
    defaultBordered: true
}) {
    const NConfigProvider = inject(configProviderInjectionKey, null);
    return {
        NConfigProvider,
        mergedBorderedRef: computed(() => {
            var _a, _b;
            const { bordered } = props;
            if (bordered !== undefined)
                return bordered;
            return ((_b = (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedBorderedRef.value) !== null && _a !== void 0 ? _a : options.defaultBordered) !== null && _b !== void 0 ? _b : true);
        }),
        mergedClsPrefixRef: computed(() => {
            const clsPrefix = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedClsPrefixRef.value;
            return clsPrefix || defaultClsPrefix;
        }),
        namespaceRef: computed(() => NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedNamespaceRef.value)
    };
}

const enUS = {
    name: 'en-US',
    global: {
        undo: 'Undo',
        redo: 'Redo',
        confirm: 'Confirm'
    },
    Popconfirm: {
        positiveText: 'Confirm',
        negativeText: 'Cancel'
    },
    Cascader: {
        placeholder: 'Please Select',
        loading: 'Loading',
        loadingRequiredMessage: (label) => `Please load all ${label}'s descedants before checking it.`
    },
    Time: {
        dateFormat: 'yyyy-MM-dd',
        dateTimeFormat: 'yyyy-MM-dd HH:mm:ss'
    },
    DatePicker: {
        yearFormat: 'yyyy',
        monthFormat: 'MMM',
        dayFormat: 'eeeeee',
        clear: 'Clear',
        now: 'Now',
        confirm: 'Confirm',
        selectTime: 'Select Time',
        selectDate: 'Select Date',
        datePlaceholder: 'Select Date',
        datetimePlaceholder: 'Select Date and Time',
        startDatePlaceholder: 'Start Date',
        endDatePlaceholder: 'End Date',
        startDatetimePlaceholder: 'Start Date and Time',
        endDatetimePlaceholder: 'End Date and Time',
        monthBeforeYear: true,
        firstDayOfWeek: 6,
        today: 'Today'
    },
    DataTable: {
        checkTableAll: 'Select all in the table',
        uncheckTableAll: 'Unselect all in the table',
        confirm: 'Confirm',
        clear: 'Clear'
    },
    Transfer: {
        sourceTitle: 'Source',
        targetTitle: 'Target'
    },
    Empty: {
        description: 'No Data'
    },
    Select: {
        placeholder: 'Please Select'
    },
    TimePicker: {
        placeholder: 'Select Time',
        positiveText: 'OK',
        negativeText: 'Cancel',
        now: 'Now'
    },
    Pagination: {
        goto: 'Goto',
        selectionSuffix: 'page'
    },
    DynamicTags: {
        add: 'Add'
    },
    Log: {
        loading: 'Loading'
    },
    Input: {
        placeholder: 'Please Input'
    },
    InputNumber: {
        placeholder: 'Please Input'
    },
    DynamicInput: {
        create: 'Create'
    },
    ThemeEditor: {
        title: 'Theme Editor',
        clearAllVars: 'Clear All Variables',
        clearSearch: 'Clear Search',
        filterCompName: 'Filter Component Name',
        filterVarName: 'Filter Variable Name',
        import: 'Import',
        export: 'Export',
        restore: 'Reset to Default'
    }
};
var enUS$1 = enUS;

function buildFormatLongFn(args) {
  return function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    // TODO: Remove String()
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format = args.formats[width] || args.formats[args.defaultWidth];
    return format;
  };
}

function buildLocalizeFn(args) {
  return function (dirtyIndex, dirtyOptions) {
    var options = dirtyOptions || {};
    var context = options.context ? String(options.context) : 'standalone';
    var valuesArray;

    if (context === 'formatting' && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;

      var _width = options.width ? String(options.width) : args.defaultWidth;

      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }

    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex; // @ts-ignore: For some reason TypeScript just don't want to match it, no matter how hard we try. I challange you to try to remove it!

    return valuesArray[index];
  };
}

function buildMatchPatternFn(args) {
  return function (string) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult) return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult) return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value: value,
      rest: rest
    };
  };
}

function buildMatchFn(args) {
  return function (string) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);

    if (!matchResult) {
      return null;
    }

    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function (pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function (pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value: value,
      rest: rest
    };
  };
}

function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }

  return undefined;
}

function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }

  return undefined;
}

var formatDistanceLocale = {
  lessThanXSeconds: {
    one: 'less than a second',
    other: 'less than {{count}} seconds'
  },
  xSeconds: {
    one: '1 second',
    other: '{{count}} seconds'
  },
  halfAMinute: 'half a minute',
  lessThanXMinutes: {
    one: 'less than a minute',
    other: 'less than {{count}} minutes'
  },
  xMinutes: {
    one: '1 minute',
    other: '{{count}} minutes'
  },
  aboutXHours: {
    one: 'about 1 hour',
    other: 'about {{count}} hours'
  },
  xHours: {
    one: '1 hour',
    other: '{{count}} hours'
  },
  xDays: {
    one: '1 day',
    other: '{{count}} days'
  },
  aboutXWeeks: {
    one: 'about 1 week',
    other: 'about {{count}} weeks'
  },
  xWeeks: {
    one: '1 week',
    other: '{{count}} weeks'
  },
  aboutXMonths: {
    one: 'about 1 month',
    other: 'about {{count}} months'
  },
  xMonths: {
    one: '1 month',
    other: '{{count}} months'
  },
  aboutXYears: {
    one: 'about 1 year',
    other: 'about {{count}} years'
  },
  xYears: {
    one: '1 year',
    other: '{{count}} years'
  },
  overXYears: {
    one: 'over 1 year',
    other: 'over {{count}} years'
  },
  almostXYears: {
    one: 'almost 1 year',
    other: 'almost {{count}} years'
  }
};

var formatDistance = function (token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];

  if (typeof tokenValue === 'string') {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace('{{count}}', count.toString());
  }

  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return 'in ' + result;
    } else {
      return result + ' ago';
    }
  }

  return result;
};

var formatDistance$1 = formatDistance;

var dateFormats = {
  full: 'EEEE, MMMM do, y',
  long: 'MMMM do, y',
  medium: 'MMM d, y',
  short: 'MM/dd/yyyy'
};
var timeFormats = {
  full: 'h:mm:ss a zzzz',
  long: 'h:mm:ss a z',
  medium: 'h:mm:ss a',
  short: 'h:mm a'
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: '{{date}}, {{time}}',
  short: '{{date}}, {{time}}'
};
var formatLong = {
  date: buildFormatLongFn({
    formats: dateFormats,
    defaultWidth: 'full'
  }),
  time: buildFormatLongFn({
    formats: timeFormats,
    defaultWidth: 'full'
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats,
    defaultWidth: 'full'
  })
};
var formatLong$1 = formatLong;

var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: 'P'
};

var formatRelative = function (token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};

var formatRelative$1 = formatRelative;

var eraValues = {
  narrow: ['B', 'A'],
  abbreviated: ['BC', 'AD'],
  wide: ['Before Christ', 'Anno Domini']
};
var quarterValues = {
  narrow: ['1', '2', '3', '4'],
  abbreviated: ['Q1', 'Q2', 'Q3', 'Q4'],
  wide: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter']
}; // Note: in English, the names of days of the week and months are capitalized.
// If you are making a new locale based on this one, check if the same is true for the language you're working on.
// Generally, formatted dates should look like they are in the middle of a sentence,
// e.g. in Spanish language the weekdays and months should be in the lowercase.

var monthValues = {
  narrow: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  abbreviated: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  wide: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
};
var dayValues = {
  narrow: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  short: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
  abbreviated: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  wide: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
};
var dayPeriodValues = {
  narrow: {
    am: 'a',
    pm: 'p',
    midnight: 'mi',
    noon: 'n',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  },
  abbreviated: {
    am: 'AM',
    pm: 'PM',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  },
  wide: {
    am: 'a.m.',
    pm: 'p.m.',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: 'a',
    pm: 'p',
    midnight: 'mi',
    noon: 'n',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  },
  abbreviated: {
    am: 'AM',
    pm: 'PM',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  },
  wide: {
    am: 'a.m.',
    pm: 'p.m.',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  }
};

var ordinalNumber = function (dirtyNumber, _options) {
  var number = Number(dirtyNumber); // If ordinal numbers depend on context, for example,
  // if they are different for different grammatical genders,
  // use `options.unit`.
  //
  // `unit` can be 'year', 'quarter', 'month', 'week', 'date', 'dayOfYear',
  // 'day', 'hour', 'minute', 'second'.

  var rem100 = number % 100;

  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + 'st';

      case 2:
        return number + 'nd';

      case 3:
        return number + 'rd';
    }
  }

  return number + 'th';
};

var localize = {
  ordinalNumber: ordinalNumber,
  era: buildLocalizeFn({
    values: eraValues,
    defaultWidth: 'wide'
  }),
  quarter: buildLocalizeFn({
    values: quarterValues,
    defaultWidth: 'wide',
    argumentCallback: function (quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues,
    defaultWidth: 'wide'
  }),
  day: buildLocalizeFn({
    values: dayValues,
    defaultWidth: 'wide'
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues,
    defaultWidth: 'wide',
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: 'wide'
  })
};
var localize$1 = localize;

var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function (value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseEraPatterns,
    defaultParseWidth: 'any'
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: 'any',
    valueCallback: function (index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: 'any'
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseDayPatterns,
    defaultParseWidth: 'any'
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: 'any',
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: 'any'
  })
};
var match$1 = match;

/**
 * @type {Locale}
 * @category Locales
 * @summary English locale (United States).
 * @language English
 * @iso-639-2 eng
 * @author Sasha Koss [@kossnocorp]{@link https://github.com/kossnocorp}
 * @author Lesha Koss [@leshakoss]{@link https://github.com/leshakoss}
 */
var locale = {
  code: 'en-US',
  formatDistance: formatDistance$1,
  formatLong: formatLong$1,
  formatRelative: formatRelative$1,
  localize: localize$1,
  match: match$1,
  options: {
    weekStartsOn: 0
    /* Sunday */
    ,
    firstWeekContainsDate: 1
  }
};
var defaultLocale = locale;

const dateEnUs = {
    name: 'en-US',
    locale: defaultLocale
};
var dateEnUS = dateEnUs;

function createLocaleMixin(ns) {
    const { mergedLocaleRef, mergedDateLocaleRef } = inject(configProviderInjectionKey, null) || {};
    const localeRef = computed(() => {
        var _a, _b;
        return (_b = (_a = mergedLocaleRef === null || mergedLocaleRef === void 0 ? void 0 : mergedLocaleRef.value) === null || _a === void 0 ? void 0 : _a[ns]) !== null && _b !== void 0 ? _b : enUS$1[ns];
    });
    const dateLocaleRef = computed(() => {
        var _a;
        return (_a = mergedDateLocaleRef === null || mergedDateLocaleRef === void 0 ? void 0 : mergedDateLocaleRef.value) !== null && _a !== void 0 ? _a : dateEnUS;
    });
    return {
        dateLocaleRef,
        localeRef
    };
}

function useStyle(mountId, style, clsPrefixRef) {
    if (!style) {
        return;
    }
    const ssrAdapter = useSsrAdapter();
    const mountStyle = () => {
        const clsPrefix = clsPrefixRef === null || clsPrefixRef === void 0 ? void 0 : clsPrefixRef.value;
        style.mount({
            id: clsPrefix === undefined ? mountId : clsPrefix + mountId,
            head: true,
            props: {
                bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
            },
            ssr: ssrAdapter
        });
        globalStyle.mount({
            id: 'naive-ui/global',
            head: true,
            ssr: ssrAdapter
        });
    };
    if (ssrAdapter) {
        mountStyle();
    }
    else {
        onBeforeMount(mountStyle);
    }
}

// eslint-disable-next-line @typescript-eslint/explicit-function-return-type
function replaceable(name, icon) {
    return defineComponent({
        name: upperFirst$1(name),
        setup() {
            const { NConfigProvider } = useConfig();
            return () => {
                var _a;
                const iconOverride = (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedIconsRef.value) === null || _a === void 0 ? void 0 : _a[name];
                return iconOverride ? iconOverride() : icon;
            };
        }
    });
}

var FinishedIcon = defineComponent({
    name: 'Checkmark',
    render() {
        return (h("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 16 16" },
            h("g", { fill: "none" },
                h("path", { d: "M14.046 3.486a.75.75 0 0 1-.032 1.06l-7.93 7.474a.85.85 0 0 1-1.188-.022l-2.68-2.72a.75.75 0 1 1 1.068-1.053l2.234 2.267l7.468-7.038a.75.75 0 0 1 1.06.032z", fill: "currentColor" }))));
    }
});

var ErrorIcon$1 = replaceable('close', h("svg", { viewBox: "0 0 12 12", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", fill: "none", "fill-rule": "evenodd" },
        h("g", { fill: "currentColor", "fill-rule": "nonzero" },
            h("path", { d: "M2.08859116,2.2156945 L2.14644661,2.14644661 C2.32001296,1.97288026 2.58943736,1.95359511 2.7843055,2.08859116 L2.85355339,2.14644661 L6,5.293 L9.14644661,2.14644661 C9.34170876,1.95118446 9.65829124,1.95118446 9.85355339,2.14644661 C10.0488155,2.34170876 10.0488155,2.65829124 9.85355339,2.85355339 L6.707,6 L9.85355339,9.14644661 C10.0271197,9.32001296 10.0464049,9.58943736 9.91140884,9.7843055 L9.85355339,9.85355339 C9.67998704,10.0271197 9.41056264,10.0464049 9.2156945,9.91140884 L9.14644661,9.85355339 L6,6.707 L2.85355339,9.85355339 C2.65829124,10.0488155 2.34170876,10.0488155 2.14644661,9.85355339 C1.95118446,9.65829124 1.95118446,9.34170876 2.14644661,9.14644661 L5.293,6 L2.14644661,2.85355339 C1.97288026,2.67998704 1.95359511,2.41056264 2.08859116,2.2156945 L2.14644661,2.14644661 L2.08859116,2.2156945 Z" })))));

var EmptyIcon = defineComponent({
    name: 'Empty',
    render() {
        return (h("svg", { viewBox: "0 0 28 28", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            h("path", { d: "M26 7.5C26 11.0899 23.0899 14 19.5 14C15.9101 14 13 11.0899 13 7.5C13 3.91015 15.9101 1 19.5 1C23.0899 1 26 3.91015 26 7.5ZM16.8536 4.14645C16.6583 3.95118 16.3417 3.95118 16.1464 4.14645C15.9512 4.34171 15.9512 4.65829 16.1464 4.85355L18.7929 7.5L16.1464 10.1464C15.9512 10.3417 15.9512 10.6583 16.1464 10.8536C16.3417 11.0488 16.6583 11.0488 16.8536 10.8536L19.5 8.20711L22.1464 10.8536C22.3417 11.0488 22.6583 11.0488 22.8536 10.8536C23.0488 10.6583 23.0488 10.3417 22.8536 10.1464L20.2071 7.5L22.8536 4.85355C23.0488 4.65829 23.0488 4.34171 22.8536 4.14645C22.6583 3.95118 22.3417 3.95118 22.1464 4.14645L19.5 6.79289L16.8536 4.14645Z", fill: "currentColor" }),
            h("path", { d: "M25 22.75V12.5991C24.5572 13.0765 24.053 13.4961 23.5 13.8454V16H17.5L17.3982 16.0068C17.0322 16.0565 16.75 16.3703 16.75 16.75C16.75 18.2688 15.5188 19.5 14 19.5C12.4812 19.5 11.25 18.2688 11.25 16.75L11.2432 16.6482C11.1935 16.2822 10.8797 16 10.5 16H4.5V7.25C4.5 6.2835 5.2835 5.5 6.25 5.5H12.2696C12.4146 4.97463 12.6153 4.47237 12.865 4H6.25C4.45507 4 3 5.45507 3 7.25V22.75C3 24.5449 4.45507 26 6.25 26H21.75C23.5449 26 25 24.5449 25 22.75ZM4.5 22.75V17.5H9.81597L9.85751 17.7041C10.2905 19.5919 11.9808 21 14 21L14.215 20.9947C16.2095 20.8953 17.842 19.4209 18.184 17.5H23.5V22.75C23.5 23.7165 22.7165 24.5 21.75 24.5H6.25C5.2835 24.5 4.5 23.7165 4.5 22.75Z", fill: "currentColor" })));
    }
});

var ErrorIcon = replaceable('error', h("svg", { viewBox: "0 0 48 48", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M17.8838835,16.1161165 L17.7823881,16.0249942 C17.3266086,15.6583353 16.6733914,15.6583353 16.2176119,16.0249942 L16.1161165,16.1161165 L16.0249942,16.2176119 C15.6583353,16.6733914 15.6583353,17.3266086 16.0249942,17.7823881 L16.1161165,17.8838835 L22.233,24 L16.1161165,30.1161165 L16.0249942,30.2176119 C15.6583353,30.6733914 15.6583353,31.3266086 16.0249942,31.7823881 L16.1161165,31.8838835 L16.2176119,31.9750058 C16.6733914,32.3416647 17.3266086,32.3416647 17.7823881,31.9750058 L17.8838835,31.8838835 L24,25.767 L30.1161165,31.8838835 L30.2176119,31.9750058 C30.6733914,32.3416647 31.3266086,32.3416647 31.7823881,31.9750058 L31.8838835,31.8838835 L31.9750058,31.7823881 C32.3416647,31.3266086 32.3416647,30.6733914 31.9750058,30.2176119 L31.8838835,30.1161165 L25.767,24 L31.8838835,17.8838835 L31.9750058,17.7823881 C32.3416647,17.3266086 32.3416647,16.6733914 31.9750058,16.2176119 L31.8838835,16.1161165 L31.7823881,16.0249942 C31.3266086,15.6583353 30.6733914,15.6583353 30.2176119,16.0249942 L30.1161165,16.1161165 L24,22.233 L17.8838835,16.1161165 L17.7823881,16.0249942 L17.8838835,16.1161165 Z" })))));

var InfoIcon = replaceable('info', h("svg", { viewBox: "0 0 28 28", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M14,2 C20.6274,2 26,7.37258 26,14 C26,20.6274 20.6274,26 14,26 C7.37258,26 2,20.6274 2,14 C2,7.37258 7.37258,2 14,2 Z M14,11 C13.4477,11 13,11.4477 13,12 L13,12 L13,20 C13,20.5523 13.4477,21 14,21 C14.5523,21 15,20.5523 15,20 L15,20 L15,12 C15,11.4477 14.5523,11 14,11 Z M14,6.75 C13.3096,6.75 12.75,7.30964 12.75,8 C12.75,8.69036 13.3096,9.25 14,9.25 C14.6904,9.25 15.25,8.69036 15.25,8 C15.25,7.30964 14.6904,6.75 14,6.75 Z" })))));

var SuccessIcon = replaceable('success', h("svg", { viewBox: "0 0 48 48", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M32.6338835,17.6161165 C32.1782718,17.1605048 31.4584514,17.1301307 30.9676119,17.5249942 L30.8661165,17.6161165 L20.75,27.732233 L17.1338835,24.1161165 C16.6457281,23.6279612 15.8542719,23.6279612 15.3661165,24.1161165 C14.9105048,24.5717282 14.8801307,25.2915486 15.2749942,25.7823881 L15.3661165,25.8838835 L19.8661165,30.3838835 C20.3217282,30.8394952 21.0415486,30.8698693 21.5323881,30.4750058 L21.6338835,30.3838835 L32.6338835,19.3838835 C33.1220388,18.8957281 33.1220388,18.1042719 32.6338835,17.6161165 Z" })))));

var WarningIcon = replaceable('warning', h("svg", { viewBox: "0 0 24 24", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", "fill-rule": "evenodd" },
        h("g", { "fill-rule": "nonzero" },
            h("path", { d: "M12,2 C17.523,2 22,6.478 22,12 C22,17.522 17.523,22 12,22 C6.477,22 2,17.522 2,12 C2,6.478 6.477,2 12,2 Z M12.0018002,15.0037242 C11.450254,15.0037242 11.0031376,15.4508407 11.0031376,16.0023869 C11.0031376,16.553933 11.450254,17.0010495 12.0018002,17.0010495 C12.5533463,17.0010495 13.0004628,16.553933 13.0004628,16.0023869 C13.0004628,15.4508407 12.5533463,15.0037242 12.0018002,15.0037242 Z M11.99964,7 C11.4868042,7.00018474 11.0642719,7.38637706 11.0066858,7.8837365 L11,8.00036004 L11.0018003,13.0012393 L11.00857,13.117858 C11.0665141,13.6151758 11.4893244,14.0010638 12.0021602,14.0008793 C12.514996,14.0006946 12.9375283,13.6145023 12.9951144,13.1171428 L13.0018002,13.0005193 L13,7.99964009 L12.9932303,7.8830214 C12.9352861,7.38570354 12.5124758,6.99981552 11.99964,7 Z" })))));

var ChevronDownIcon = defineComponent({
    name: 'ChevronDown',
    render() {
        return (h("svg", { viewBox: "0 0 16 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            h("path", { d: "M3.14645 5.64645C3.34171 5.45118 3.65829 5.45118 3.85355 5.64645L8 9.79289L12.1464 5.64645C12.3417 5.45118 12.6583 5.45118 12.8536 5.64645C13.0488 5.84171 13.0488 6.15829 12.8536 6.35355L8.35355 10.8536C8.15829 11.0488 7.84171 11.0488 7.64645 10.8536L3.14645 6.35355C2.95118 6.15829 2.95118 5.84171 3.14645 5.64645Z", fill: "currentColor" })));
    }
});

var ClearIcon = replaceable('clear', h("svg", { viewBox: "0 0 16 16", version: "1.1", xmlns: "http://www.w3.org/2000/svg" },
    h("g", { stroke: "none", "stroke-width": "1", fill: "none", "fill-rule": "evenodd" },
        h("g", { fill: "currentColor", "fill-rule": "nonzero" },
            h("path", { d: "M8,2 C11.3137085,2 14,4.6862915 14,8 C14,11.3137085 11.3137085,14 8,14 C4.6862915,14 2,11.3137085 2,8 C2,4.6862915 4.6862915,2 8,2 Z M6.5343055,5.83859116 C6.33943736,5.70359511 6.07001296,5.72288026 5.89644661,5.89644661 L5.89644661,5.89644661 L5.83859116,5.9656945 C5.70359511,6.16056264 5.72288026,6.42998704 5.89644661,6.60355339 L5.89644661,6.60355339 L7.293,8 L5.89644661,9.39644661 L5.83859116,9.4656945 C5.70359511,9.66056264 5.72288026,9.92998704 5.89644661,10.1035534 L5.89644661,10.1035534 L5.9656945,10.1614088 C6.16056264,10.2964049 6.42998704,10.2771197 6.60355339,10.1035534 L6.60355339,10.1035534 L8,8.707 L9.39644661,10.1035534 L9.4656945,10.1614088 C9.66056264,10.2964049 9.92998704,10.2771197 10.1035534,10.1035534 L10.1035534,10.1035534 L10.1614088,10.0343055 C10.2964049,9.83943736 10.2771197,9.57001296 10.1035534,9.39644661 L10.1035534,9.39644661 L8.707,8 L10.1035534,6.60355339 L10.1614088,6.5343055 C10.2964049,6.33943736 10.2771197,6.07001296 10.1035534,5.89644661 L10.1035534,5.89644661 L10.0343055,5.83859116 C9.83943736,5.70359511 9.57001296,5.72288026 9.39644661,5.89644661 L9.39644661,5.89644661 L8,7.293 L6.60355339,5.89644661 Z" })))));

var NIconSwitchTransition = defineComponent({
    name: 'BaseIconSwitchTransition',
    setup(_, { slots }) {
        const isMountedRef = isMounted();
        return () => (h(Transition, { name: "icon-switch-transition", appear: isMountedRef.value }, slots));
    }
});

var style$d = cB('base-icon', `
 height: 1em;
 width: 1em;
 line-height: 1em;
 text-align: center;
 display: inline-block;
 position: relative;
 fill: currentColor;
 transform: translateZ(0);
`, [c$1('svg', {
  height: '1em',
  width: '1em'
})]);

var NBaseIcon = defineComponent({
    name: 'BaseIcon',
    props: {
        role: String,
        ariaLabel: String,
        ariaDisabled: {
            type: Boolean,
            default: undefined
        },
        ariaHidden: {
            type: Boolean,
            default: undefined
        },
        clsPrefix: {
            type: String,
            required: true
        },
        onClick: Function,
        onMousedown: Function,
        onMouseup: Function
    },
    setup(props) {
        useStyle('BaseIcon', style$d, toRef(props, 'clsPrefix'));
    },
    render() {
        return (h("i", { class: `${this.clsPrefix}-base-icon`, onClick: this.onClick, onMousedown: this.onMousedown, onMouseup: this.onMouseup, role: this.role, "aria-label": this.ariaLabel, "aria-hidden": this.ariaHidden, "aria-disabled": this.ariaDisabled }, this.$slots));
    }
});

// --close-color
// --close-color-hover
// --close-color-pressed
// --close-color-disabled

var style$c = cB('base-close', `
 cursor: pointer;
 color: var(--close-color);
`, [c$1('&:hover', {
  color: 'var(--close-color-hover)'
}), c$1('&:active', {
  color: 'var(--close-color-pressed)'
}), cM('disabled', {
  cursor: 'not-allowed!important',
  color: 'var(--close-color-disabled)'
})]);

var NBaseClose = defineComponent({
    name: 'BaseClose',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        disabled: {
            type: Boolean,
            default: undefined
        },
        onClick: Function
    },
    setup(props) {
        useStyle('BaseClose', style$c, toRef(props, 'clsPrefix'));
        return () => {
            const { clsPrefix, disabled } = props;
            return (h(NBaseIcon, { role: "button", ariaDisabled: disabled, ariaLabel: "close", clsPrefix: clsPrefix, class: [
                    `${clsPrefix}-base-close`,
                    disabled && `${clsPrefix}-base-close--disabled`
                ], onClick: disabled ? undefined : props.onClick }, {
                default: () => h(ErrorIcon$1, null)
            }));
        };
    }
});

var FocusDetector = defineComponent({
    props: {
        onFocus: Function,
        onBlur: Function
    },
    setup(props) {
        return () => (h("div", { style: "width: 0; height: 0", tabindex: 0, onFocus: props.onFocus, onBlur: props.onBlur }));
    }
});

function createIconSwitchTransition ({
  originalTransform = '',
  left = 0,
  top = 0,
  transition = `all .3s ${commonVariables$3.cubicBezierEaseInOut} !important`
} = {}) {
  return [c$1('&.icon-switch-transition-enter-from, &.icon-switch-transition-leave-to', {
    transform: originalTransform + ' scale(0.75)',
    left,
    top,
    opacity: 0
  }), c$1('&.icon-switch-transition-enter-to, &.icon-switch-transition-leave-from', {
    transform: `${commonVariables$3.transformDebounceScale} ${originalTransform}`,
    left,
    top,
    opacity: 1
  }), c$1('&.icon-switch-transition-enter-active, &.icon-switch-transition-leave-active', {
    transformOrigin: 'center',
    position: 'absolute',
    left,
    top,
    transition
  })];
}

var style$b = cB('base-loading', `
 position: relative;
 line-height: 0;
 width: 1em;
 height: 1em;
`, [cE('placeholder', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 `, [createIconSwitchTransition({
  left: '50%',
  top: '50%',
  originalTransform: 'translateX(-50%) translateY(-50%)'
})]), cE('icon', `
 height: 1em;
 width: 1em;
 `, [createIconSwitchTransition()])]);

const duration = '1.6s';
// The loading svg dom comes from https://codepen.io/FezVrasta/pen/oXrgdR
var NBaseLoading = defineComponent({
    name: 'BaseLoading',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        scale: {
            type: Number,
            default: 1
        },
        radius: {
            type: Number,
            default: 100
        },
        strokeWidth: {
            type: Number,
            default: 28
        },
        stroke: {
            type: String,
            default: undefined
        },
        show: {
            type: Boolean,
            default: true
        }
    },
    setup(props) {
        useStyle('BaseLoading', style$b, toRef(props, 'clsPrefix'));
    },
    render() {
        const { clsPrefix, radius, strokeWidth, stroke, scale } = this;
        const scaledRadius = radius / scale;
        return (h("div", { class: `${clsPrefix}-base-loading`, role: "img", "aria-label": "loading" },
            h(NIconSwitchTransition, null, {
                default: () => this.show ? (h("svg", { class: `${clsPrefix}-base-loading__icon`, viewBox: `0 0 ${2 * scaledRadius} ${2 * scaledRadius}`, xmlns: "http://www.w3.org/2000/svg", style: { color: stroke } },
                    h("g", null,
                        h("animateTransform", { attributeName: "transform", type: "rotate", values: `0 ${scaledRadius} ${scaledRadius};270 ${scaledRadius} ${scaledRadius}`, begin: "0s", dur: duration, fill: "freeze", repeatCount: "indefinite" }),
                        h("circle", { fill: "none", stroke: "currentColor", "stroke-width": strokeWidth, "stroke-linecap": "round", cx: scaledRadius, cy: scaledRadius, r: radius - strokeWidth / 2, "stroke-dasharray": 5.67 * radius, "stroke-dashoffset": 18.48 * radius },
                            h("animateTransform", { attributeName: "transform", type: "rotate", values: `0 ${scaledRadius} ${scaledRadius};135 ${scaledRadius} ${scaledRadius};450 ${scaledRadius} ${scaledRadius}`, begin: "0s", dur: duration, fill: "freeze", repeatCount: "indefinite" }),
                            h("animate", { attributeName: "stroke-dashoffset", values: `${5.67 * radius};${1.42 * radius};${5.67 * radius}`, begin: "0s", dur: duration, fill: "freeze", repeatCount: "indefinite" }))))) : (h("div", { key: "placeholder", class: `${clsPrefix}-base-loading__placeholder` }, this.$slots))
            })));
    }
});

function toArray(arg) {
    if (Array.isArray(arg))
        return arg;
    return [arg];
}
// Do not use enum for lint plugin has error
const TRAVERSE_COMMAND = {
    STOP: 'STOP'
};
function traverseWithCb(treeNode, callback) {
    const command = callback(treeNode);
    if (treeNode.children !== undefined && command !== TRAVERSE_COMMAND.STOP) {
        treeNode.children.forEach((childNode) => traverseWithCb(childNode, callback));
    }
}
function getNonLeafKeys(treeNodes, options = {}) {
    const { preserveGroup = false } = options;
    const keys = [];
    const cb = preserveGroup
        ? (node) => {
            if (!node.isLeaf) {
                keys.push(node.key);
                traverse(node.children);
            }
        }
        : (node) => {
            if (!node.isLeaf) {
                if (!node.isGroup)
                    keys.push(node.key);
                traverse(node.children);
            }
        };
    function traverse(nodes) {
        nodes.forEach(cb);
    }
    traverse(treeNodes);
    return keys;
}
function isLeaf(rawNode, getChildren) {
    const { isLeaf } = rawNode;
    if (isLeaf !== undefined)
        return isLeaf;
    else if (!getChildren(rawNode))
        return true;
    return false;
}
function defaultGetChildren(node) {
    return node.children;
}
function defaultGetKey(node) {
    return node.key;
}
function isIgnored() {
    return false;
}
function isShallowLoaded(rawNode, getChildren) {
    const { isLeaf } = rawNode;
    if (isLeaf === false && !Array.isArray(getChildren(rawNode)))
        return false;
    return true;
}
function isDisabled(rawNode) {
    return rawNode.disabled === true;
}
function isExpilicitlyNotLoaded(rawNode, getChildren) {
    return (rawNode.isLeaf === false && !Array.isArray(getChildren(rawNode)));
}
function unwrapCheckedKeys(result) {
    var _a;
    if (result === undefined || result === null)
        return [];
    if (Array.isArray(result))
        return result;
    return (_a = result.checkedKeys) !== null && _a !== void 0 ? _a : [];
}
function unwrapIndeterminateKeys(result) {
    var _a;
    if (result === undefined || result === null || Array.isArray(result)) {
        return [];
    }
    return (_a = result.indeterminateKeys) !== null && _a !== void 0 ? _a : [];
}
function merge(originalKeys, keysToAdd) {
    const set = new Set(originalKeys);
    keysToAdd.forEach((key) => {
        if (!set.has(key)) {
            set.add(key);
        }
    });
    return Array.from(set);
}
function minus(originalKeys, keysToRemove) {
    const set = new Set(originalKeys);
    keysToRemove.forEach((key) => {
        if (set.has(key)) {
            set.delete(key);
        }
    });
    return Array.from(set);
}
function isGroup(rawNode) {
    return (rawNode === null || rawNode === void 0 ? void 0 : rawNode.type) === 'group';
}
function createIndexGetter(treeNodes) {
    const map = new Map();
    treeNodes.forEach((treeNode, i) => {
        map.set(treeNode.key, i);
    });
    return (key) => { var _a; return (_a = map.get(key)) !== null && _a !== void 0 ? _a : null; };
}

class SubtreeNotLoadedError extends Error {
    constructor() {
        super();
        this.message =
            'SubtreeNotLoadedError: checking a subtree whose required nodes are not fully loaded.';
    }
}
function getExtendedCheckedKeySetAfterCheck(checkKeys, currentCheckedKeys, treeMate) {
    return getExtendedCheckedKeySet(currentCheckedKeys.concat(checkKeys), treeMate);
}
function getAvailableAscendantNodeSet(uncheckedKeys, treeMate) {
    const visitedKeys = new Set();
    uncheckedKeys.forEach((uncheckedKey) => {
        const uncheckedTreeNode = treeMate.treeNodeMap.get(uncheckedKey);
        if (uncheckedTreeNode !== undefined) {
            let nodeCursor = uncheckedTreeNode.parent;
            while (nodeCursor !== null) {
                if (nodeCursor.disabled)
                    break;
                if (visitedKeys.has(nodeCursor.key))
                    break;
                else {
                    visitedKeys.add(nodeCursor.key);
                }
                nodeCursor = nodeCursor.parent;
            }
        }
    });
    return visitedKeys;
}
function getExtendedCheckedKeySetAfterUncheck(uncheckedKeys, currentCheckedKeys, treeMate) {
    const extendedCheckedKeySet = getExtendedCheckedKeySet(currentCheckedKeys, treeMate);
    const extendedKeySetToUncheck = getExtendedCheckedKeySet(uncheckedKeys, treeMate, true);
    const ascendantKeySet = getAvailableAscendantNodeSet(uncheckedKeys, treeMate);
    const keysToRemove = [];
    extendedCheckedKeySet.forEach((key) => {
        if (extendedKeySetToUncheck.has(key) || ascendantKeySet.has(key)) {
            keysToRemove.push(key);
        }
    });
    keysToRemove.forEach((key) => extendedCheckedKeySet.delete(key));
    return extendedCheckedKeySet;
}
function getCheckedKeys(options, treeMate) {
    const { checkedKeys, keysToCheck, keysToUncheck, indeterminateKeys, cascade, leafOnly, checkStrategy } = options;
    if (!cascade) {
        if (keysToCheck !== undefined) {
            return {
                checkedKeys: merge(checkedKeys, keysToCheck),
                indeterminateKeys: Array.from(indeterminateKeys)
            };
        }
        else if (keysToUncheck !== undefined) {
            return {
                checkedKeys: minus(checkedKeys, keysToUncheck),
                indeterminateKeys: Array.from(indeterminateKeys)
            };
        }
        else {
            return {
                checkedKeys: Array.from(checkedKeys),
                indeterminateKeys: Array.from(indeterminateKeys)
            };
        }
    }
    const { levelTreeNodeMap } = treeMate;
    let extendedCheckedKeySet;
    if (keysToUncheck !== undefined) {
        extendedCheckedKeySet = getExtendedCheckedKeySetAfterUncheck(keysToUncheck, checkedKeys, treeMate);
    }
    else if (keysToCheck !== undefined) {
        extendedCheckedKeySet = getExtendedCheckedKeySetAfterCheck(keysToCheck, checkedKeys, treeMate);
    }
    else {
        extendedCheckedKeySet = getExtendedCheckedKeySet(checkedKeys, treeMate);
    }
    const checkStrategyIsParent = checkStrategy === 'parent';
    const checkStrategyIsChild = checkStrategy === 'child' || leafOnly;
    const syntheticCheckedKeySet = extendedCheckedKeySet;
    const syntheticIndeterminateKeySet = new Set();
    const maxLevel = Math.max.apply(null, Array.from(levelTreeNodeMap.keys()));
    // cascade check
    // 1. if tree is fully loaded, it just works
    // 2. if the tree is not fully loaded, we assume that keys which is in not
    //    loaded tree are not in checked keys
    //    for example:
    //    a -- b(fully-loaded)   -- c(fully-loaded)
    //      |- d(partial-loaded) -- ?e(not-loaded)
    //    in the case, `e` is assumed not to be checked, nor we can't calc `d`'s
    //    and `a`'s status
    for (let level = maxLevel; level >= 0; level -= 1) {
        const levelIsZero = level === 0;
        // it should exists, nor it is a bug
        const levelTreeNodes = levelTreeNodeMap.get(level);
        for (const levelTreeNode of levelTreeNodes) {
            if (levelTreeNode.isLeaf)
                continue;
            const { key: levelTreeNodeKey, shallowLoaded } = levelTreeNode;
            if (checkStrategyIsChild && shallowLoaded) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                levelTreeNode.children.forEach((v) => {
                    if (!v.disabled &&
                        !v.isLeaf &&
                        v.shallowLoaded &&
                        syntheticCheckedKeySet.has(v.key)) {
                        syntheticCheckedKeySet.delete(v.key);
                    }
                });
            }
            if (levelTreeNode.disabled || !shallowLoaded) {
                continue;
            }
            let fullyChecked = true;
            let partialChecked = false;
            let allDisabled = true;
            // it is shallow loaded, so `children` must exist
            for (const childNode of levelTreeNode.children) {
                const childKey = childNode.key;
                if (childNode.disabled)
                    continue;
                if (allDisabled)
                    allDisabled = false;
                if (syntheticCheckedKeySet.has(childKey)) {
                    partialChecked = true;
                }
                else if (syntheticIndeterminateKeySet.has(childKey)) {
                    partialChecked = true;
                    fullyChecked = false;
                    break;
                }
                else {
                    fullyChecked = false;
                    if (partialChecked) {
                        break;
                    }
                }
            }
            if (fullyChecked && !allDisabled) {
                if (checkStrategyIsParent) {
                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                    levelTreeNode.children.forEach((v) => {
                        if (!v.disabled && syntheticCheckedKeySet.has(v.key)) {
                            syntheticCheckedKeySet.delete(v.key);
                        }
                    });
                }
                syntheticCheckedKeySet.add(levelTreeNodeKey);
            }
            else if (partialChecked) {
                syntheticIndeterminateKeySet.add(levelTreeNodeKey);
            }
            if (levelIsZero &&
                checkStrategyIsChild &&
                syntheticCheckedKeySet.has(levelTreeNodeKey)) {
                syntheticCheckedKeySet.delete(levelTreeNodeKey);
            }
        }
    }
    return {
        checkedKeys: Array.from(syntheticCheckedKeySet),
        indeterminateKeys: Array.from(syntheticIndeterminateKeySet)
    };
}
// unchecking is safe when doing cascade uncheck in async mode
function getExtendedCheckedKeySet(checkedKeys, treeMate, isUnchecking = false) {
    const { treeNodeMap, getChildren } = treeMate;
    const visitedKeySet = new Set();
    const extendedKeySet = new Set(checkedKeys);
    checkedKeys.forEach((checkedKey) => {
        const checkedTreeNode = treeNodeMap.get(checkedKey);
        if (checkedTreeNode !== undefined) {
            traverseWithCb(checkedTreeNode, (treeNode) => {
                if (treeNode.disabled) {
                    return TRAVERSE_COMMAND.STOP;
                }
                const { key } = treeNode;
                if (visitedKeySet.has(key))
                    return;
                visitedKeySet.add(key);
                // Adding keys before loaded check is okay, since if not valid error
                // would be thrown
                extendedKeySet.add(key);
                if (isExpilicitlyNotLoaded(treeNode.rawNode, getChildren)) {
                    if (isUnchecking) {
                        return TRAVERSE_COMMAND.STOP;
                    }
                    else {
                        throw new SubtreeNotLoadedError();
                    }
                }
            });
        }
    });
    return extendedKeySet;
}

function getPath(key, { includeGroup = false, includeSelf = true }, treeMate) {
    var _a;
    const treeNodeMap = treeMate.treeNodeMap;
    let treeNode = key === null || key === undefined ? null : (_a = treeNodeMap.get(key)) !== null && _a !== void 0 ? _a : null;
    const mergedPath = {
        keyPath: [],
        treeNodePath: [],
        treeNode: treeNode
    };
    if (treeNode === null || treeNode === void 0 ? void 0 : treeNode.ignored) {
        mergedPath.treeNode = null;
        return mergedPath;
    }
    while (treeNode) {
        if (!treeNode.ignored && (includeGroup || !treeNode.isGroup)) {
            mergedPath.treeNodePath.push(treeNode);
        }
        treeNode = treeNode.parent;
    }
    mergedPath.treeNodePath.reverse();
    if (!includeSelf)
        mergedPath.treeNodePath.pop();
    mergedPath.keyPath = mergedPath.treeNodePath.map((treeNode) => treeNode.key);
    return mergedPath;
}

function getFirstAvailableNode(nodes) {
    if (nodes.length === 0)
        return null;
    const node = nodes[0];
    if (node.isGroup || node.ignored || node.disabled) {
        return node.getNext();
    }
    return node;
}
function rawGetNext(node, loop) {
    const sibs = node.siblings;
    const l = sibs.length;
    const { index } = node;
    if (loop) {
        return sibs[(index + 1) % l];
    }
    else {
        if (index === sibs.length - 1)
            return null;
        return sibs[index + 1];
    }
}
function move(fromNode, dir, { loop = false, includeDisabled = false } = {}) {
    const iterate = dir === 'prev' ? rawGetPrev : rawGetNext;
    const getChildOptions = {
        reverse: dir === 'prev'
    };
    let meet = false;
    let endNode = null;
    function traverse(node) {
        if (node === null)
            return;
        if (node === fromNode) {
            if (!meet) {
                meet = true;
            }
            else if (!fromNode.disabled && !fromNode.isGroup) {
                endNode = fromNode;
                return;
            }
        }
        else {
            if ((!node.disabled || includeDisabled) &&
                !node.ignored &&
                !node.isGroup) {
                endNode = node;
                return;
            }
        }
        if (node.isGroup) {
            const child = getChild(node, getChildOptions);
            if (child !== null) {
                endNode = child;
            }
            else {
                traverse(iterate(node, loop));
            }
        }
        else {
            const nextNode = iterate(node, false);
            if (nextNode !== null) {
                traverse(nextNode);
            }
            else {
                const parent = rawGetParent(node);
                if (parent === null || parent === void 0 ? void 0 : parent.isGroup) {
                    traverse(iterate(parent, loop));
                }
                else if (loop) {
                    traverse(iterate(node, true));
                }
            }
        }
    }
    traverse(fromNode);
    return endNode;
}
function rawGetPrev(node, loop) {
    const sibs = node.siblings;
    const l = sibs.length;
    const { index } = node;
    if (loop) {
        return sibs[(index - 1 + l) % l];
    }
    else {
        if (index === 0)
            return null;
        return sibs[index - 1];
    }
}
function rawGetParent(node) {
    return node.parent;
}
function getChild(node, options = {}) {
    const { reverse = false } = options;
    const { children } = node;
    if (children) {
        const { length } = children;
        const start = reverse ? length - 1 : 0;
        const end = reverse ? -1 : length;
        const delta = reverse ? -1 : 1;
        for (let i = start; i !== end; i += delta) {
            const child = children[i];
            if (!child.disabled && !child.ignored) {
                if (child.isGroup) {
                    const childInGroup = getChild(child, options);
                    if (childInGroup !== null)
                        return childInGroup;
                }
                else {
                    return child;
                }
            }
        }
    }
    return null;
}
const moveMethods = {
    getChild() {
        if (this.ignored)
            return null;
        return getChild(this);
    },
    getParent() {
        const { parent } = this;
        if (parent === null || parent === void 0 ? void 0 : parent.isGroup) {
            return parent.getParent();
        }
        return parent;
    },
    getNext(options = {}) {
        return move(this, 'next', options);
    },
    getPrev(options = {}) {
        return move(this, 'prev', options);
    }
};

function flatten(treeNodes, expandedKeys) {
    const expandedKeySet = expandedKeys ? new Set(expandedKeys) : undefined;
    const flattenedNodes = [];
    function traverse(treeNodes) {
        treeNodes.forEach((treeNode) => {
            flattenedNodes.push(treeNode);
            if (treeNode.isLeaf || !treeNode.children || treeNode.ignored)
                return;
            if (treeNode.isGroup) {
                // group node shouldn't be expanded
                traverse(treeNode.children);
            }
            else if (
            // normal non-leaf node
            expandedKeySet === undefined ||
                expandedKeySet.has(treeNode.key)) {
                traverse(treeNode.children);
            }
        });
    }
    traverse(treeNodes);
    return flattenedNodes;
}

function contains(parent, child) {
    const parentKey = parent.key;
    // eslint-disable-next-line no-unmodified-loop-condition
    while (child) {
        if (child.key === parentKey)
            return true;
        child = child.parent;
    }
    return false;
}

function createTreeNodes(rawNodes, treeNodeMap, levelTreeNodeMap, nodeProto, getChildren, parent = null, level = 0) {
    const treeNodes = [];
    rawNodes.forEach((rawNode, index) => {
        var _a;
        const treeNode = Object.create(nodeProto);
        treeNode.rawNode = rawNode;
        treeNode.siblings = treeNodes;
        treeNode.level = level;
        treeNode.index = index;
        treeNode.isFirstChild = index === 0;
        treeNode.isLastChild = index + 1 === rawNodes.length;
        treeNode.parent = parent;
        if (!treeNode.ignored) {
            const rawChildren = getChildren(rawNode);
            if (Array.isArray(rawChildren)) {
                treeNode.children = createTreeNodes(rawChildren, treeNodeMap, levelTreeNodeMap, nodeProto, getChildren, treeNode, level + 1);
            }
        }
        treeNodes.push(treeNode);
        treeNodeMap.set(treeNode.key, treeNode);
        if (!levelTreeNodeMap.has(level))
            levelTreeNodeMap.set(level, []);
        (_a = levelTreeNodeMap.get(level)) === null || _a === void 0 ? void 0 : _a.push(treeNode);
    });
    return treeNodes;
}
function createTreeMate(rawNodes, options = {}) {
    const treeNodeMap = new Map();
    const levelTreeNodeMap = new Map();
    const { getDisabled = isDisabled, getIgnored = isIgnored, getChildren = defaultGetChildren, getIsGroup = isGroup, getKey = defaultGetKey } = options;
    const nodeProto = Object.assign({
        get key() {
            // do not pass parent or related things to it
            // the key need to be specified explicitly
            return getKey(this.rawNode);
        },
        get disabled() {
            return getDisabled(this.rawNode);
        },
        get isGroup() {
            return getIsGroup(this.rawNode);
        },
        get isLeaf() {
            return isLeaf(this.rawNode, getChildren);
        },
        get shallowLoaded() {
            return isShallowLoaded(this.rawNode, getChildren);
        },
        get ignored() {
            return getIgnored(this.rawNode);
        },
        contains(node) {
            return contains(this, node);
        }
    }, moveMethods);
    const treeNodes = createTreeNodes(rawNodes, treeNodeMap, levelTreeNodeMap, nodeProto, getChildren);
    function getNode(key) {
        if (key === null || key === undefined)
            return null;
        const tmNode = treeNodeMap.get(key);
        if (tmNode && !tmNode.isGroup && !tmNode.ignored) {
            return tmNode;
        }
        return null;
    }
    function _getNode(key) {
        if (key === null || key === undefined)
            return null;
        const tmNode = treeNodeMap.get(key);
        if (tmNode && !tmNode.ignored) {
            return tmNode;
        }
        return null;
    }
    function getPrev(key, options) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getPrev(options);
    }
    function getNext(key, options) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getNext(options);
    }
    function getParent(key) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getParent();
    }
    function getChild(key) {
        const node = _getNode(key);
        if (!node)
            return null;
        return node.getChild();
    }
    const treemate = {
        treeNodes,
        treeNodeMap,
        levelTreeNodeMap,
        maxLevel: Math.max(...levelTreeNodeMap.keys()),
        getChildren,
        getFlattenedNodes(expandedKeys) {
            return flatten(treeNodes, expandedKeys);
        },
        getNode,
        getPrev,
        getNext,
        getParent,
        getChild,
        getFirstAvailableNode() {
            return getFirstAvailableNode(treeNodes);
        },
        getPath(key, options = {}) {
            return getPath(key, options, treemate);
        },
        getCheckedKeys(checkedKeys, options = {}) {
            const { cascade = true, leafOnly = false, checkStrategy = 'all' } = options;
            return getCheckedKeys({
                checkedKeys: unwrapCheckedKeys(checkedKeys),
                indeterminateKeys: unwrapIndeterminateKeys(checkedKeys),
                cascade,
                leafOnly,
                checkStrategy
            }, treemate);
        },
        check(keysToCheck, checkedKeys, options = {}) {
            const { cascade = true, leafOnly = false, checkStrategy = 'all' } = options;
            return getCheckedKeys({
                checkedKeys: unwrapCheckedKeys(checkedKeys),
                indeterminateKeys: unwrapIndeterminateKeys(checkedKeys),
                keysToCheck: keysToCheck === undefined || keysToCheck === null
                    ? []
                    : toArray(keysToCheck),
                cascade,
                leafOnly,
                checkStrategy
            }, treemate);
        },
        uncheck(keysToUncheck, checkedKeys, options = {}) {
            const { cascade = true, leafOnly = false, checkStrategy = 'all' } = options;
            return getCheckedKeys({
                checkedKeys: unwrapCheckedKeys(checkedKeys),
                indeterminateKeys: unwrapIndeterminateKeys(checkedKeys),
                keysToUncheck: keysToUncheck === null || keysToUncheck === undefined
                    ? []
                    : toArray(keysToUncheck),
                cascade,
                leafOnly,
                checkStrategy
            }, treemate);
        },
        getNonLeafKeys(options = {}) {
            return getNonLeafKeys(treeNodes, options);
        }
    };
    return treemate;
}

function getSlot(slots, slotName = 'default') {
    const slot = slots[slotName];
    if (slot === undefined) {
        throw new Error(`[vueuc/binder]: slot[${slotName}] is empty.`);
    }
    return slot();
}
function getFirstVNode(slots, slotName = 'default') {
    const slot = slots[slotName];
    if (slot === undefined) {
        throw new Error(`[vueuc/binder]: slot[${slotName}] is empty.`);
    }
    const content = slot();
    // vue will normalize the slot, so slot must be an array
    if (content.length === 1) {
        return content[0];
    }
    else {
        throw new Error(`[vueuc/binder]: slot[${slotName}] should have exactly one child.`);
    }
}

let viewMeasurer = null;
function ensureViewBoundingRect() {
    if (viewMeasurer === null) {
        viewMeasurer = document.getElementById('v-binder-view-measurer');
        if (viewMeasurer === null) {
            viewMeasurer = document.createElement('div');
            viewMeasurer.id = 'v-binder-view-measurer';
            const { style } = viewMeasurer;
            style.position = 'fixed';
            style.left = '0';
            style.right = '0';
            style.top = '0';
            style.bottom = '0';
            style.pointerEvents = 'none';
            style.visibility = 'hidden';
            document.body.appendChild(viewMeasurer);
        }
    }
    return viewMeasurer.getBoundingClientRect();
}
function getPointRect(x, y) {
    const viewRect = ensureViewBoundingRect();
    return {
        top: y,
        left: x,
        height: 0,
        width: 0,
        right: viewRect.width - x,
        bottom: viewRect.height - y
    };
}
function getRect(el) {
    const elRect = el.getBoundingClientRect();
    const viewRect = ensureViewBoundingRect();
    return {
        left: elRect.left - viewRect.left,
        top: elRect.top - viewRect.top,
        bottom: viewRect.height + viewRect.top - elRect.bottom,
        right: viewRect.width + viewRect.left - elRect.right,
        width: elRect.width,
        height: elRect.height
    };
}
function getParentNode(node) {
    // document type
    if (node.nodeType === 9) {
        return null;
    }
    return node.parentNode;
}
function getScrollParent(node) {
    if (node === null)
        return null;
    const parentNode = getParentNode(node);
    if (parentNode === null) {
        return null;
    }
    // Document
    if (parentNode.nodeType === 9) {
        return document;
    }
    // Element
    if (parentNode.nodeType === 1) {
        // Firefox want us to check `-x` and `-y` variations as well
        const { overflow, overflowX, overflowY } = getComputedStyle(parentNode);
        if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
            return parentNode;
        }
    }
    return getScrollParent(parentNode);
}

/* eslint-disable @typescript-eslint/no-non-null-assertion */
const Binder = defineComponent({
    name: 'Binder',
    props: {
        syncTargetWithParent: Boolean,
        syncTarget: {
            type: Boolean,
            default: true
        }
    },
    setup(props) {
        var _a;
        provide('VBinder', (_a = getCurrentInstance()) === null || _a === void 0 ? void 0 : _a.proxy);
        const VBinder = inject('VBinder', null);
        const targetRef = ref(null);
        /**
         * If there's no nested vbinder, we can simply set the target ref.
         *
         * However, when it comes to:
         * <VBinder> <- syncTarget = false
         *
         *              Should hold target DOM ref, but can't get it directly from
         *              its VTarget. So if there are nested VBinder, we should:
         *              1. Stop setting target DOM from level-1 VTarget
         *              2. Set target DOM from level-2 VTarget
         *              For (1), we need `syncTarget` to `false`
         *              For (2), we need to set `syncTargetWithParent` to `true` on
         *              level-2 VBinder
         *   <VTarget>
         *     <VBinder> <- syncTargetWithParent = true
         *       <VTarget>target</VTarget>
         *     </VBinder>
         *     <VFollower>
         *       content1
         *     </VFollower>
         *   </VTarget>
         *   <VFollower>
         *     content2
         *   </VFollower>
         * </VBinder>
         */
        const setTargetRef = (el) => {
            targetRef.value = el;
            // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
            if (VBinder && props.syncTargetWithParent) {
                VBinder.setTargetRef(el);
            }
        };
        // scroll related
        let scrollableNodes = [];
        const ensureScrollListener = () => {
            let cursor = targetRef.value;
            while (true) {
                cursor = getScrollParent(cursor);
                if (cursor === null)
                    break;
                scrollableNodes.push(cursor);
            }
            for (const el of scrollableNodes) {
                on('scroll', el, onScroll, true);
            }
        };
        const removeScrollListeners = () => {
            for (const el of scrollableNodes) {
                off('scroll', el, onScroll, true);
            }
            scrollableNodes = [];
        };
        const followerScrollListeners = new Set();
        const addScrollListener = (listener) => {
            if (followerScrollListeners.size === 0) {
                ensureScrollListener();
            }
            if (!followerScrollListeners.has(listener)) {
                followerScrollListeners.add(listener);
            }
        };
        const removeScrollListener = (listener) => {
            if (followerScrollListeners.has(listener)) {
                followerScrollListeners.delete(listener);
            }
            if (followerScrollListeners.size === 0) {
                removeScrollListeners();
            }
        };
        const onScroll = () => {
            beforeNextFrameOnce(onScrollRaf);
        };
        const onScrollRaf = () => {
            followerScrollListeners.forEach((listener) => listener());
        };
        // resize related
        const followerResizeListeners = new Set();
        const addResizeListener = (listener) => {
            if (followerResizeListeners.size === 0) {
                on('resize', window, onResize);
            }
            if (!followerResizeListeners.has(listener)) {
                followerResizeListeners.add(listener);
            }
        };
        const removeResizeListener = (listener) => {
            if (followerResizeListeners.has(listener)) {
                followerResizeListeners.delete(listener);
            }
            if (followerResizeListeners.size === 0) {
                off('resize', window, onResize);
            }
        };
        const onResize = () => {
            followerResizeListeners.forEach((listener) => listener());
        };
        onBeforeUnmount(() => {
            off('resize', window, onResize);
            removeScrollListeners();
        });
        return {
            targetRef,
            setTargetRef,
            addScrollListener,
            removeScrollListener,
            addResizeListener,
            removeResizeListener
        };
    },
    render() {
        return getSlot(this.$slots);
    }
});
var VBinder = Binder;

/* eslint-disable @typescript-eslint/no-non-null-assertion */
var VTarget = defineComponent({
    name: 'Target',
    setup() {
        const { setTargetRef, syncTarget } = inject('VBinder');
        const setTargetDirective = {
            mounted: setTargetRef,
            updated: setTargetRef
        };
        return {
            syncTarget,
            setTargetDirective
        };
    },
    render() {
        const { syncTarget, setTargetDirective } = this;
        /**
         * If you are using VBinder as a child of VBinder, the children wouldn't be
         * a valid DOM or component that can be attached to by directive.
         * So we won't sync target on those kind of situation and control the
         * target sync logic manually.
         */
        if (syncTarget) {
            return withDirectives(getFirstVNode(this.$slots), [[setTargetDirective]]);
        }
        return getFirstVNode(this.$slots);
    }
});

const ctxKey$1 = '@@mmoContext';
const mousemoveoutside = {
    mounted(el, { value }) {
        el[ctxKey$1] = {
            handler: undefined
        };
        if (typeof value === 'function') {
            el[ctxKey$1].handler = value;
            on('mousemoveoutside', el, value);
        }
    },
    updated(el, { value }) {
        const ctx = el[ctxKey$1];
        if (typeof value === 'function') {
            if (ctx.handler) {
                if (ctx.handler !== value) {
                    off('mousemoveoutside', el, ctx.handler);
                    ctx.handler = value;
                    on('mousemoveoutside', el, value);
                }
            }
            else {
                el[ctxKey$1].handler = value;
                on('mousemoveoutside', el, value);
            }
        }
        else {
            if (ctx.handler) {
                off('mousemoveoutside', el, ctx.handler);
                ctx.handler = undefined;
            }
        }
    },
    unmounted(el) {
        const { handler } = el[ctxKey$1];
        if (handler) {
            off('mousemoveoutside', el, handler);
        }
        el[ctxKey$1].handler = undefined;
    }
};
var mousemoveoutside$1 = mousemoveoutside;

const ctxKey = '@@coContext';
const clickoutside = {
    mounted(el, { value }) {
        el[ctxKey] = {
            handler: undefined
        };
        if (typeof value === 'function') {
            el[ctxKey].handler = value;
            on('clickoutside', el, value);
        }
    },
    updated(el, { value }) {
        const ctx = el[ctxKey];
        if (typeof value === 'function') {
            if (ctx.handler) {
                if (ctx.handler !== value) {
                    off('clickoutside', el, ctx.handler);
                    ctx.handler = value;
                    on('clickoutside', el, value);
                }
            }
            else {
                el[ctxKey].handler = value;
                on('clickoutside', el, value);
            }
        }
        else {
            if (ctx.handler) {
                off('clickoutside', el, ctx.handler);
                ctx.handler = undefined;
            }
        }
    },
    unmounted(el) {
        const { handler } = el[ctxKey];
        if (handler) {
            off('clickoutside', el, handler);
        }
        el[ctxKey].handler = undefined;
    }
};
var clickoutside$1 = clickoutside;

function warn$1(location, message) {
    console.error(`[vdirs/${location}]: ${message}`);
}

class ZIndexManager {
    constructor() {
        this.elementZIndex = new Map();
        this.nextZIndex = 2000;
    }
    get elementCount() {
        return this.elementZIndex.size;
    }
    ensureZIndex(el, zIndex) {
        const { elementZIndex } = this;
        if (zIndex !== undefined) {
            el.style.zIndex = `${zIndex}`;
            elementZIndex.delete(el);
            return;
        }
        const { nextZIndex } = this;
        if (elementZIndex.has(el)) {
            const currentZIndex = elementZIndex.get(el);
            if (currentZIndex + 1 === this.nextZIndex)
                return;
        }
        el.style.zIndex = `${nextZIndex}`;
        elementZIndex.set(el, nextZIndex);
        this.nextZIndex = nextZIndex + 1;
        this.squashState();
    }
    unregister(el) {
        const { elementZIndex } = this;
        if (elementZIndex.has(el)) {
            elementZIndex.delete(el);
        }
        else {
            warn$1('vdirs/z-index-manager/unregister-element', 'Element not found when unregistering.');
        }
        this.squashState();
    }
    squashState() {
        const { elementCount } = this;
        if (!elementCount) {
            this.nextZIndex = 2000;
        }
        if (this.nextZIndex - elementCount > 2500)
            this.rearrange();
    }
    rearrange() {
        const elementZIndexPair = Array.from(this.elementZIndex.entries());
        elementZIndexPair.sort((pair1, pair2) => {
            return pair1[1] - pair2[1];
        });
        this.nextZIndex = 2000;
        elementZIndexPair.forEach(pair => {
            const el = pair[0];
            const zIndex = this.nextZIndex++;
            if (`${zIndex}` !== el.style.zIndex)
                el.style.zIndex = `${zIndex}`;
        });
    }
}
var zIndexManager = new ZIndexManager();

const ctx = '@@ziContext';
const zindexable = {
    mounted(el, bindings) {
        const { value = {} } = bindings;
        const { zIndex, enabled } = value;
        zIndexManager.ensureZIndex(el, zIndex);
        el[ctx] = {
            enabled
        };
    },
    updated(el, bindings) {
        const { value = {} } = bindings;
        const { zIndex, enabled } = value;
        const cachedEnabled = el[ctx].enabled;
        if (enabled && !cachedEnabled) {
            zIndexManager.ensureZIndex(el, zIndex);
        }
        el[ctx].enabled = enabled;
    },
    unmounted(el) {
        zIndexManager.unregister(el);
    }
};
var zindexable$1 = zindexable;

function warn(location, message) {
    console.error(`[vueuc/${location}]: ${message}`);
}

const { c } = CssRender();

function lowBit(n) {
    return n & -n;
}
class FinweckTree {
    /**
     * @param l length of the array
     * @param min min value of the array
     */
    constructor(l, min) {
        this.l = l;
        this.min = min;
        const ft = new Array(l + 1);
        for (let i = 0; i < l + 1; ++i) {
            ft[i] = 0;
        }
        this.ft = ft;
    }
    /**
     * Add arr[i] by n, start from 0
     * @param i the index of the element to be added
     * @param n the value to be added
     */
    add(i, n) {
        if (n === 0)
            return;
        const { l, ft } = this;
        i += 1;
        while (i <= l) {
            ft[i] += n;
            i += lowBit(i);
        }
    }
    /**
     * Get the value of index i
     * @param i index
     * @returns value of the index
     */
    get(i) {
        return this.sum(i + 1) - this.sum(i);
    }
    /**
     * Get the sum of first i elements
     * @param i count of head elements to be added
     * @returns the sum of first i elements
     */
    sum(i) {
        if (i === 0)
            return 0;
        const { ft, min, l } = this;
        if (i === undefined)
            i = l;
        if (i > l)
            throw new Error('[FinweckTree.sum]: `i` is larger than length.');
        let ret = i * min;
        while (i > 0) {
            ret += ft[i];
            i -= lowBit(i);
        }
        return ret;
    }
    /**
     * Get the largest count of head elements whose sum are <= threshold
     * @param threshold
     * @returns the largest count of head elements whose sum are <= threshold
     */
    getBound(threshold) {
        let l = 0;
        let r = this.l;
        while (r > l) {
            const m = Math.floor((l + r) / 2);
            const sumM = this.sum(m);
            if (sumM > threshold) {
                r = m;
                continue;
            }
            else if (sumM < threshold) {
                if (l === m) {
                    if (this.sum(l + 1) <= threshold)
                        return l + 1;
                    return m;
                }
                l = m;
            }
            else {
                return m;
            }
        }
        return l;
    }
}

var LazyTeleport = defineComponent({
    name: 'LazyTeleport',
    props: {
        to: {
            type: [String, Object],
            default: undefined
        },
        disabled: Boolean,
        show: {
            type: Boolean,
            required: true
        }
    },
    setup(props) {
        return {
            showTeleport: useFalseUntilTruthy(toRef(props, 'show')),
            mergedTo: computed(() => {
                const { to } = props;
                return to !== null && to !== void 0 ? to : 'body';
            })
        };
    },
    render() {
        return this.showTeleport
            ? this.disabled
                ? getSlot(this.$slots)
                : h(Teleport, {
                    disabled: this.disabled,
                    to: this.mergedTo
                }, getSlot(this.$slots))
            : null;
    }
});

const oppositionPositions = {
    top: 'bottom',
    bottom: 'top',
    left: 'right',
    right: 'left'
};
const oppositeAligns = {
    start: 'end',
    center: 'center',
    end: 'start'
};
const propToCompare = {
    top: 'height',
    bottom: 'height',
    left: 'width',
    right: 'width'
};
const transformOrigins = {
    'bottom-start': 'top left',
    bottom: 'top center',
    'bottom-end': 'top right',
    'top-start': 'bottom left',
    top: 'bottom center',
    'top-end': 'bottom right',
    'right-start': 'top left',
    right: 'center left',
    'right-end': 'bottom left',
    'left-start': 'top right',
    left: 'center right',
    'left-end': 'bottom right'
};
const overlapTransformOrigin = {
    'bottom-start': 'bottom left',
    bottom: 'bottom center',
    'bottom-end': 'bottom right',
    'top-start': 'top left',
    top: 'top center',
    'top-end': 'top right',
    'right-start': 'top right',
    right: 'center right',
    'right-end': 'bottom right',
    'left-start': 'top left',
    left: 'center left',
    'left-end': 'bottom left'
};
const oppositeAlignCssPositionProps = {
    'bottom-start': 'right',
    'bottom-end': 'left',
    'top-start': 'right',
    'top-end': 'left',
    'right-start': 'bottom',
    'right-end': 'top',
    'left-start': 'bottom',
    'left-end': 'top'
};
function getProperPlacementOfFollower(placement, targetRect, followerRect, flip, overlap) {
    if (!flip || overlap) {
        return placement;
    }
    const [position, align] = placement.split('-');
    let properAlign = align !== null && align !== void 0 ? align : 'center';
    if (align !== 'center') {
        const oppositeAlignCssPositionProp = oppositeAlignCssPositionProps[placement];
        const currentAlignCssPositionProp = oppositionPositions[oppositeAlignCssPositionProp];
        const oppositeAlignCssSizeProp = propToCompare[oppositeAlignCssPositionProp];
        // if follower rect is larger than target rect in align direction
        //           [ target ]
        //           [     follower     ]
        // [     follower     ] <---->
        if (followerRect[oppositeAlignCssSizeProp] > targetRect[oppositeAlignCssSizeProp]) {
            // [ target ]---|
            // [ follower   |  ]
            if (
            // overflow screen
            (targetRect[oppositeAlignCssPositionProp] + targetRect[oppositeAlignCssSizeProp] <= followerRect[oppositeAlignCssSizeProp]) &&
                // opposite align has larger space
                (targetRect[oppositeAlignCssPositionProp] < targetRect[currentAlignCssPositionProp])) {
                properAlign = oppositeAligns[align];
            }
        }
        // if follower rect is smaller than target rect in align direction
        // [     target     ]
        // [ follower ]         <---->
        if (followerRect[oppositeAlignCssSizeProp] < targetRect[oppositeAlignCssSizeProp]) {
            if (targetRect[currentAlignCssPositionProp] < 0 &&
                // opposite align has larger space
                targetRect[oppositeAlignCssPositionProp] > targetRect[currentAlignCssPositionProp]) {
                properAlign = oppositeAligns[align];
            }
        }
    }
    let properPosition = position;
    if (
    // space is not enough
    !(targetRect[position] >= followerRect[propToCompare[position]]) &&
        // opposite position's space is larger
        targetRect[oppositionPositions[position]] >= followerRect[propToCompare[position]]) {
        properPosition = oppositionPositions[position];
    }
    return properAlign !== 'center' ? `${properPosition}-${properAlign}` : properPosition;
}
function getProperTransformOrigin(placement, overlap) {
    if (overlap)
        return overlapTransformOrigin[placement];
    return transformOrigins[placement];
}
// ------------
// |  offset  |
// |          |
// | [target] |
// |          |
// ------------
function getOffset(placement, offsetRect, targetRect, overlap) {
    if (overlap) {
        switch (placement) {
            case 'bottom-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-100%)'
                };
            case 'bottom-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-100%)'
                };
            case 'top-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: ''
                };
            case 'top-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%)'
                };
            case 'right-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%)'
                };
            case 'right-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-100%)'
                };
            case 'left-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: ''
                };
            case 'left-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-100%)'
                };
            case 'top':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                    transform: 'translateX(-50%)'
                };
            case 'right':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-50%)'
                };
            case 'left':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-50%)'
                };
            case 'bottom':
            default:
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                    transform: 'translateX(-50%) translateY(-100%)'
                };
        }
    }
    switch (placement) {
        case 'bottom-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                transform: ''
            };
        case 'bottom-end':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                transform: 'translateX(-100%)'
            };
        case 'top-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                transform: 'translateY(-100%)'
            };
        case 'top-end':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                transform: 'translateX(-100%) translateY(-100%)'
            };
        case 'right-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                transform: ''
            };
        case 'right-end':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                transform: 'translateY(-100%)'
            };
        case 'left-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                transform: 'translateX(-100%)'
            };
        case 'left-end':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                transform: 'translateX(-100%) translateY(-100%)'
            };
        case 'top':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                transform: 'translateY(-100%) translateX(-50%)'
            };
        case 'right':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                transform: 'translateY(-50%)'
            };
        case 'left':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                transform: 'translateY(-50%) translateX(-100%)'
            };
        case 'bottom':
        default:
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                transform: 'translateX(-50%)'
            };
    }
}

/* eslint-disable @typescript-eslint/no-non-null-assertion */
const style$a = c([
    c('.v-binder-follower-container', {
        position: 'absolute',
        left: '0',
        right: '0',
        top: '0',
        height: '0',
        pointerEvents: 'none',
        zIndex: 'auto'
    }),
    c('.v-binder-follower-content', {
        position: 'absolute',
        zIndex: 'auto'
    }, [
        c('> *', {
            pointerEvents: 'all'
        })
    ])
]);
var VFollower = defineComponent({
    name: 'Follower',
    inheritAttrs: false,
    props: {
        show: Boolean,
        enabled: {
            type: Boolean,
            default: undefined
        },
        placement: {
            type: String,
            default: 'bottom'
        },
        syncTrigger: {
            type: Array,
            default: ['resize', 'scroll']
        },
        to: [String, Object],
        flip: {
            type: Boolean,
            default: true
        },
        x: Number,
        y: Number,
        width: String,
        minWidth: String,
        containerClass: String,
        teleportDisabled: Boolean,
        zindexable: {
            type: Boolean,
            default: true
        },
        zIndex: Number,
        overlap: Boolean
    },
    setup(props) {
        const VBinder = inject('VBinder');
        const mergedEnabledRef = useMemo(() => {
            return props.enabled !== undefined ? props.enabled : props.show;
        });
        const followerRef = ref(null);
        const offsetContainerRef = ref(null);
        const ensureListeners = () => {
            const { syncTrigger } = props;
            if (syncTrigger.includes('scroll')) {
                VBinder.addScrollListener(syncPosition);
            }
            if (syncTrigger.includes('resize')) {
                VBinder.addResizeListener(syncPosition);
            }
        };
        const removeListeners = () => {
            VBinder.removeScrollListener(syncPosition);
            VBinder.removeResizeListener(syncPosition);
        };
        onMounted(() => {
            if (mergedEnabledRef.value) {
                syncPosition();
                ensureListeners();
            }
        });
        const ssrAdapter = useSsrAdapter();
        style$a.mount({
            id: 'vueuc/binder',
            head: true,
            ssr: ssrAdapter
        });
        onBeforeUnmount(() => {
            removeListeners();
        });
        onFontsReady(() => {
            if (mergedEnabledRef.value) {
                syncPosition();
            }
        });
        const syncPosition = () => {
            if (!mergedEnabledRef.value) {
                return;
            }
            const follower = followerRef.value;
            // sometimes watched props change before its dom is ready
            // for example: show=false, x=undefined, y=undefined
            //              show=true,  x=0,         y=0
            // will cause error
            // I may optimize the watch start point later
            if (follower === null)
                return;
            const target = VBinder.targetRef;
            const { x, y, overlap } = props;
            const targetRect = x !== undefined && y !== undefined
                ? getPointRect(x, y)
                : getRect(target);
            const { width, minWidth, placement, flip } = props;
            follower.setAttribute('v-placement', placement);
            if (overlap) {
                follower.setAttribute('v-overlap', '');
            }
            else {
                follower.removeAttribute('v-overlap');
            }
            const { style } = follower;
            if (width === 'target') {
                style.width = `${targetRect.width}px`;
            }
            else if (width !== undefined) {
                style.width = width;
            }
            else {
                style.width = '';
            }
            if (minWidth === 'target') {
                style.minWidth = `${targetRect.width}px`;
            }
            else if (minWidth !== undefined) {
                style.minWidth = minWidth;
            }
            else {
                style.minWidth = '';
            }
            const followerRect = getRect(follower);
            const offsetContainerRect = getRect(offsetContainerRef.value);
            const properPlacement = getProperPlacementOfFollower(placement, targetRect, followerRect, flip, overlap);
            const properTransformOrigin = getProperTransformOrigin(properPlacement, overlap);
            const { left, top, transform } = getOffset(properPlacement, offsetContainerRect, targetRect, overlap);
            // we assume that the content size doesn't change after flip,
            // nor we need to make sync logic more complex
            follower.setAttribute('v-placement', properPlacement);
            follower.style.transform = `translateX(${left}) translateY(${top}) ${transform}`;
            follower.style.transformOrigin = properTransformOrigin;
        };
        watch(mergedEnabledRef, (value) => {
            if (value) {
                ensureListeners();
                syncOnNextTick();
            }
            else {
                removeListeners();
            }
        });
        const syncOnNextTick = () => {
            nextTick()
                .then(syncPosition)
                .catch((e) => console.error(e));
        };
        ['placement', 'x', 'y', 'flip', 'width', 'overlap', 'minWidth'].forEach((prop) => {
            watch(toRef(props, prop), syncPosition);
        });
        ['teleportDisabled'].forEach((prop) => {
            watch(toRef(props, prop), syncOnNextTick);
        });
        watch(toRef(props, 'syncTrigger'), (value) => {
            if (!value.includes('resize')) {
                VBinder.removeResizeListener(syncPosition);
            }
            else {
                VBinder.addResizeListener(syncPosition);
            }
            if (!value.includes('scroll')) {
                VBinder.removeScrollListener(syncPosition);
            }
            else {
                VBinder.addScrollListener(syncPosition);
            }
        });
        const isMountedRef = isMounted();
        const mergedToRef = useMemo(() => {
            const { to } = props;
            if (to !== undefined)
                return to;
            if (isMountedRef.value) {
                // TODO: find proper container
                return undefined;
            }
            return undefined;
        });
        return {
            VBinder,
            mergedEnabled: mergedEnabledRef,
            offsetContainerRef,
            followerRef,
            mergedTo: mergedToRef,
            syncPosition
        };
    },
    render() {
        return h(LazyTeleport, {
            show: this.show,
            to: this.mergedTo,
            disabled: this.teleportDisabled
        }, {
            default: () => {
                const vNode = h('div', {
                    class: ['v-binder-follower-container', this.containerClass],
                    ref: 'offsetContainerRef'
                }, [
                    h('div', {
                        class: 'v-binder-follower-content',
                        ref: 'followerRef'
                    }, this.$slots)
                ]);
                if (this.zindexable) {
                    return withDirectives(vNode, [
                        [
                            zindexable$1,
                            {
                                enabled: this.mergedEnabled,
                                zIndex: this.zIndex
                            }
                        ]
                    ]);
                }
                return vNode;
            }
        });
    }
});

/**
 * A collection of shims that provide minimal functionality of the ES6 collections.
 *
 * These implementations are not meant to be used outside of the ResizeObserver
 * modules as they cover only a limited range of use cases.
 */
/* eslint-disable require-jsdoc, valid-jsdoc */
var MapShim = (function () {
    if (typeof Map !== 'undefined') {
        return Map;
    }
    /**
     * Returns index in provided array that matches the specified key.
     *
     * @param {Array<Array>} arr
     * @param {*} key
     * @returns {number}
     */
    function getIndex(arr, key) {
        var result = -1;
        arr.some(function (entry, index) {
            if (entry[0] === key) {
                result = index;
                return true;
            }
            return false;
        });
        return result;
    }
    return /** @class */ (function () {
        function class_1() {
            this.__entries__ = [];
        }
        Object.defineProperty(class_1.prototype, "size", {
            /**
             * @returns {boolean}
             */
            get: function () {
                return this.__entries__.length;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {*} key
         * @returns {*}
         */
        class_1.prototype.get = function (key) {
            var index = getIndex(this.__entries__, key);
            var entry = this.__entries__[index];
            return entry && entry[1];
        };
        /**
         * @param {*} key
         * @param {*} value
         * @returns {void}
         */
        class_1.prototype.set = function (key, value) {
            var index = getIndex(this.__entries__, key);
            if (~index) {
                this.__entries__[index][1] = value;
            }
            else {
                this.__entries__.push([key, value]);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.delete = function (key) {
            var entries = this.__entries__;
            var index = getIndex(entries, key);
            if (~index) {
                entries.splice(index, 1);
            }
        };
        /**
         * @param {*} key
         * @returns {void}
         */
        class_1.prototype.has = function (key) {
            return !!~getIndex(this.__entries__, key);
        };
        /**
         * @returns {void}
         */
        class_1.prototype.clear = function () {
            this.__entries__.splice(0);
        };
        /**
         * @param {Function} callback
         * @param {*} [ctx=null]
         * @returns {void}
         */
        class_1.prototype.forEach = function (callback, ctx) {
            if (ctx === void 0) { ctx = null; }
            for (var _i = 0, _a = this.__entries__; _i < _a.length; _i++) {
                var entry = _a[_i];
                callback.call(ctx, entry[1], entry[0]);
            }
        };
        return class_1;
    }());
})();

/**
 * Detects whether window and document objects are available in current environment.
 */
var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && window.document === document;

// Returns global object of a current environment.
var global$1 = (function () {
    if (typeof global !== 'undefined' && global.Math === Math) {
        return global;
    }
    if (typeof self !== 'undefined' && self.Math === Math) {
        return self;
    }
    if (typeof window !== 'undefined' && window.Math === Math) {
        return window;
    }
    // eslint-disable-next-line no-new-func
    return Function('return this')();
})();

/**
 * A shim for the requestAnimationFrame which falls back to the setTimeout if
 * first one is not supported.
 *
 * @returns {number} Requests' identifier.
 */
var requestAnimationFrame$1 = (function () {
    if (typeof requestAnimationFrame === 'function') {
        // It's required to use a bounded function because IE sometimes throws
        // an "Invalid calling object" error if rAF is invoked without the global
        // object on the left hand side.
        return requestAnimationFrame.bind(global$1);
    }
    return function (callback) { return setTimeout(function () { return callback(Date.now()); }, 1000 / 60); };
})();

// Defines minimum timeout before adding a trailing call.
var trailingTimeout = 2;
/**
 * Creates a wrapper function which ensures that provided callback will be
 * invoked only once during the specified delay period.
 *
 * @param {Function} callback - Function to be invoked after the delay period.
 * @param {number} delay - Delay after which to invoke callback.
 * @returns {Function}
 */
function throttle (callback, delay) {
    var leadingCall = false, trailingCall = false, lastCallTime = 0;
    /**
     * Invokes the original callback function and schedules new invocation if
     * the "proxy" was called during current request.
     *
     * @returns {void}
     */
    function resolvePending() {
        if (leadingCall) {
            leadingCall = false;
            callback();
        }
        if (trailingCall) {
            proxy();
        }
    }
    /**
     * Callback invoked after the specified delay. It will further postpone
     * invocation of the original function delegating it to the
     * requestAnimationFrame.
     *
     * @returns {void}
     */
    function timeoutCallback() {
        requestAnimationFrame$1(resolvePending);
    }
    /**
     * Schedules invocation of the original function.
     *
     * @returns {void}
     */
    function proxy() {
        var timeStamp = Date.now();
        if (leadingCall) {
            // Reject immediately following calls.
            if (timeStamp - lastCallTime < trailingTimeout) {
                return;
            }
            // Schedule new call to be in invoked when the pending one is resolved.
            // This is important for "transitions" which never actually start
            // immediately so there is a chance that we might miss one if change
            // happens amids the pending invocation.
            trailingCall = true;
        }
        else {
            leadingCall = true;
            trailingCall = false;
            setTimeout(timeoutCallback, delay);
        }
        lastCallTime = timeStamp;
    }
    return proxy;
}

// Minimum delay before invoking the update of observers.
var REFRESH_DELAY = 20;
// A list of substrings of CSS properties used to find transition events that
// might affect dimensions of observed elements.
var transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight'];
// Check if MutationObserver is available.
var mutationObserverSupported = typeof MutationObserver !== 'undefined';
/**
 * Singleton controller class which handles updates of ResizeObserver instances.
 */
var ResizeObserverController = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserverController.
     *
     * @private
     */
    function ResizeObserverController() {
        /**
         * Indicates whether DOM listeners have been added.
         *
         * @private {boolean}
         */
        this.connected_ = false;
        /**
         * Tells that controller has subscribed for Mutation Events.
         *
         * @private {boolean}
         */
        this.mutationEventsAdded_ = false;
        /**
         * Keeps reference to the instance of MutationObserver.
         *
         * @private {MutationObserver}
         */
        this.mutationsObserver_ = null;
        /**
         * A list of connected observers.
         *
         * @private {Array<ResizeObserverSPI>}
         */
        this.observers_ = [];
        this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
        this.refresh = throttle(this.refresh.bind(this), REFRESH_DELAY);
    }
    /**
     * Adds observer to observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be added.
     * @returns {void}
     */
    ResizeObserverController.prototype.addObserver = function (observer) {
        if (!~this.observers_.indexOf(observer)) {
            this.observers_.push(observer);
        }
        // Add listeners if they haven't been added yet.
        if (!this.connected_) {
            this.connect_();
        }
    };
    /**
     * Removes observer from observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be removed.
     * @returns {void}
     */
    ResizeObserverController.prototype.removeObserver = function (observer) {
        var observers = this.observers_;
        var index = observers.indexOf(observer);
        // Remove observer if it's present in registry.
        if (~index) {
            observers.splice(index, 1);
        }
        // Remove listeners if controller has no connected observers.
        if (!observers.length && this.connected_) {
            this.disconnect_();
        }
    };
    /**
     * Invokes the update of observers. It will continue running updates insofar
     * it detects changes.
     *
     * @returns {void}
     */
    ResizeObserverController.prototype.refresh = function () {
        var changesDetected = this.updateObservers_();
        // Continue running updates if changes have been detected as there might
        // be future ones caused by CSS transitions.
        if (changesDetected) {
            this.refresh();
        }
    };
    /**
     * Updates every observer from observers list and notifies them of queued
     * entries.
     *
     * @private
     * @returns {boolean} Returns "true" if any observer has detected changes in
     *      dimensions of it's elements.
     */
    ResizeObserverController.prototype.updateObservers_ = function () {
        // Collect observers that have active observations.
        var activeObservers = this.observers_.filter(function (observer) {
            return observer.gatherActive(), observer.hasActive();
        });
        // Deliver notifications in a separate cycle in order to avoid any
        // collisions between observers, e.g. when multiple instances of
        // ResizeObserver are tracking the same element and the callback of one
        // of them changes content dimensions of the observed target. Sometimes
        // this may result in notifications being blocked for the rest of observers.
        activeObservers.forEach(function (observer) { return observer.broadcastActive(); });
        return activeObservers.length > 0;
    };
    /**
     * Initializes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.connect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already added.
        if (!isBrowser || this.connected_) {
            return;
        }
        // Subscription to the "Transitionend" event is used as a workaround for
        // delayed transitions. This way it's possible to capture at least the
        // final state of an element.
        document.addEventListener('transitionend', this.onTransitionEnd_);
        window.addEventListener('resize', this.refresh);
        if (mutationObserverSupported) {
            this.mutationsObserver_ = new MutationObserver(this.refresh);
            this.mutationsObserver_.observe(document, {
                attributes: true,
                childList: true,
                characterData: true,
                subtree: true
            });
        }
        else {
            document.addEventListener('DOMSubtreeModified', this.refresh);
            this.mutationEventsAdded_ = true;
        }
        this.connected_ = true;
    };
    /**
     * Removes DOM listeners.
     *
     * @private
     * @returns {void}
     */
    ResizeObserverController.prototype.disconnect_ = function () {
        // Do nothing if running in a non-browser environment or if listeners
        // have been already removed.
        if (!isBrowser || !this.connected_) {
            return;
        }
        document.removeEventListener('transitionend', this.onTransitionEnd_);
        window.removeEventListener('resize', this.refresh);
        if (this.mutationsObserver_) {
            this.mutationsObserver_.disconnect();
        }
        if (this.mutationEventsAdded_) {
            document.removeEventListener('DOMSubtreeModified', this.refresh);
        }
        this.mutationsObserver_ = null;
        this.mutationEventsAdded_ = false;
        this.connected_ = false;
    };
    /**
     * "Transitionend" event handler.
     *
     * @private
     * @param {TransitionEvent} event
     * @returns {void}
     */
    ResizeObserverController.prototype.onTransitionEnd_ = function (_a) {
        var _b = _a.propertyName, propertyName = _b === void 0 ? '' : _b;
        // Detect whether transition may affect dimensions of an element.
        var isReflowProperty = transitionKeys.some(function (key) {
            return !!~propertyName.indexOf(key);
        });
        if (isReflowProperty) {
            this.refresh();
        }
    };
    /**
     * Returns instance of the ResizeObserverController.
     *
     * @returns {ResizeObserverController}
     */
    ResizeObserverController.getInstance = function () {
        if (!this.instance_) {
            this.instance_ = new ResizeObserverController();
        }
        return this.instance_;
    };
    /**
     * Holds reference to the controller's instance.
     *
     * @private {ResizeObserverController}
     */
    ResizeObserverController.instance_ = null;
    return ResizeObserverController;
}());

/**
 * Defines non-writable/enumerable properties of the provided target object.
 *
 * @param {Object} target - Object for which to define properties.
 * @param {Object} props - Properties to be defined.
 * @returns {Object} Target object.
 */
var defineConfigurable = (function (target, props) {
    for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {
        var key = _a[_i];
        Object.defineProperty(target, key, {
            value: props[key],
            enumerable: false,
            writable: false,
            configurable: true
        });
    }
    return target;
});

/**
 * Returns the global object associated with provided element.
 *
 * @param {Object} target
 * @returns {Object}
 */
var getWindowOf = (function (target) {
    // Assume that the element is an instance of Node, which means that it
    // has the "ownerDocument" property from which we can retrieve a
    // corresponding global object.
    var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView;
    // Return the local global object if it's not possible extract one from
    // provided element.
    return ownerGlobal || global$1;
});

// Placeholder of an empty content rectangle.
var emptyRect = createRectInit(0, 0, 0, 0);
/**
 * Converts provided string to a number.
 *
 * @param {number|string} value
 * @returns {number}
 */
function toFloat(value) {
    return parseFloat(value) || 0;
}
/**
 * Extracts borders size from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @param {...string} positions - Borders positions (top, right, ...)
 * @returns {number}
 */
function getBordersSize(styles) {
    var positions = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        positions[_i - 1] = arguments[_i];
    }
    return positions.reduce(function (size, position) {
        var value = styles['border-' + position + '-width'];
        return size + toFloat(value);
    }, 0);
}
/**
 * Extracts paddings sizes from provided styles.
 *
 * @param {CSSStyleDeclaration} styles
 * @returns {Object} Paddings box.
 */
function getPaddings(styles) {
    var positions = ['top', 'right', 'bottom', 'left'];
    var paddings = {};
    for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {
        var position = positions_1[_i];
        var value = styles['padding-' + position];
        paddings[position] = toFloat(value);
    }
    return paddings;
}
/**
 * Calculates content rectangle of provided SVG element.
 *
 * @param {SVGGraphicsElement} target - Element content rectangle of which needs
 *      to be calculated.
 * @returns {DOMRectInit}
 */
function getSVGContentRect(target) {
    var bbox = target.getBBox();
    return createRectInit(0, 0, bbox.width, bbox.height);
}
/**
 * Calculates content rectangle of provided HTMLElement.
 *
 * @param {HTMLElement} target - Element for which to calculate the content rectangle.
 * @returns {DOMRectInit}
 */
function getHTMLElementContentRect(target) {
    // Client width & height properties can't be
    // used exclusively as they provide rounded values.
    var clientWidth = target.clientWidth, clientHeight = target.clientHeight;
    // By this condition we can catch all non-replaced inline, hidden and
    // detached elements. Though elements with width & height properties less
    // than 0.5 will be discarded as well.
    //
    // Without it we would need to implement separate methods for each of
    // those cases and it's not possible to perform a precise and performance
    // effective test for hidden elements. E.g. even jQuery's ':visible' filter
    // gives wrong results for elements with width & height less than 0.5.
    if (!clientWidth && !clientHeight) {
        return emptyRect;
    }
    var styles = getWindowOf(target).getComputedStyle(target);
    var paddings = getPaddings(styles);
    var horizPad = paddings.left + paddings.right;
    var vertPad = paddings.top + paddings.bottom;
    // Computed styles of width & height are being used because they are the
    // only dimensions available to JS that contain non-rounded values. It could
    // be possible to utilize the getBoundingClientRect if only it's data wasn't
    // affected by CSS transformations let alone paddings, borders and scroll bars.
    var width = toFloat(styles.width), height = toFloat(styles.height);
    // Width & height include paddings and borders when the 'border-box' box
    // model is applied (except for IE).
    if (styles.boxSizing === 'border-box') {
        // Following conditions are required to handle Internet Explorer which
        // doesn't include paddings and borders to computed CSS dimensions.
        //
        // We can say that if CSS dimensions + paddings are equal to the "client"
        // properties then it's either IE, and thus we don't need to subtract
        // anything, or an element merely doesn't have paddings/borders styles.
        if (Math.round(width + horizPad) !== clientWidth) {
            width -= getBordersSize(styles, 'left', 'right') + horizPad;
        }
        if (Math.round(height + vertPad) !== clientHeight) {
            height -= getBordersSize(styles, 'top', 'bottom') + vertPad;
        }
    }
    // Following steps can't be applied to the document's root element as its
    // client[Width/Height] properties represent viewport area of the window.
    // Besides, it's as well not necessary as the <html> itself neither has
    // rendered scroll bars nor it can be clipped.
    if (!isDocumentElement(target)) {
        // In some browsers (only in Firefox, actually) CSS width & height
        // include scroll bars size which can be removed at this step as scroll
        // bars are the only difference between rounded dimensions + paddings
        // and "client" properties, though that is not always true in Chrome.
        var vertScrollbar = Math.round(width + horizPad) - clientWidth;
        var horizScrollbar = Math.round(height + vertPad) - clientHeight;
        // Chrome has a rather weird rounding of "client" properties.
        // E.g. for an element with content width of 314.2px it sometimes gives
        // the client width of 315px and for the width of 314.7px it may give
        // 314px. And it doesn't happen all the time. So just ignore this delta
        // as a non-relevant.
        if (Math.abs(vertScrollbar) !== 1) {
            width -= vertScrollbar;
        }
        if (Math.abs(horizScrollbar) !== 1) {
            height -= horizScrollbar;
        }
    }
    return createRectInit(paddings.left, paddings.top, width, height);
}
/**
 * Checks whether provided element is an instance of the SVGGraphicsElement.
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
var isSVGGraphicsElement = (function () {
    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement
    // interface.
    if (typeof SVGGraphicsElement !== 'undefined') {
        return function (target) { return target instanceof getWindowOf(target).SVGGraphicsElement; };
    }
    // If it's so, then check that element is at least an instance of the
    // SVGElement and that it has the "getBBox" method.
    // eslint-disable-next-line no-extra-parens
    return function (target) { return (target instanceof getWindowOf(target).SVGElement &&
        typeof target.getBBox === 'function'); };
})();
/**
 * Checks whether provided element is a document element (<html>).
 *
 * @param {Element} target - Element to be checked.
 * @returns {boolean}
 */
function isDocumentElement(target) {
    return target === getWindowOf(target).document.documentElement;
}
/**
 * Calculates an appropriate content rectangle for provided html or svg element.
 *
 * @param {Element} target - Element content rectangle of which needs to be calculated.
 * @returns {DOMRectInit}
 */
function getContentRect(target) {
    if (!isBrowser) {
        return emptyRect;
    }
    if (isSVGGraphicsElement(target)) {
        return getSVGContentRect(target);
    }
    return getHTMLElementContentRect(target);
}
/**
 * Creates rectangle with an interface of the DOMRectReadOnly.
 * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly
 *
 * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.
 * @returns {DOMRectReadOnly}
 */
function createReadOnlyRect(_a) {
    var x = _a.x, y = _a.y, width = _a.width, height = _a.height;
    // If DOMRectReadOnly is available use it as a prototype for the rectangle.
    var Constr = typeof DOMRectReadOnly !== 'undefined' ? DOMRectReadOnly : Object;
    var rect = Object.create(Constr.prototype);
    // Rectangle's properties are not writable and non-enumerable.
    defineConfigurable(rect, {
        x: x, y: y, width: width, height: height,
        top: y,
        right: x + width,
        bottom: height + y,
        left: x
    });
    return rect;
}
/**
 * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.
 * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit
 *
 * @param {number} x - X coordinate.
 * @param {number} y - Y coordinate.
 * @param {number} width - Rectangle's width.
 * @param {number} height - Rectangle's height.
 * @returns {DOMRectInit}
 */
function createRectInit(x, y, width, height) {
    return { x: x, y: y, width: width, height: height };
}

/**
 * Class that is responsible for computations of the content rectangle of
 * provided DOM element and for keeping track of it's changes.
 */
var ResizeObservation = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObservation.
     *
     * @param {Element} target - Element to be observed.
     */
    function ResizeObservation(target) {
        /**
         * Broadcasted width of content rectangle.
         *
         * @type {number}
         */
        this.broadcastWidth = 0;
        /**
         * Broadcasted height of content rectangle.
         *
         * @type {number}
         */
        this.broadcastHeight = 0;
        /**
         * Reference to the last observed content rectangle.
         *
         * @private {DOMRectInit}
         */
        this.contentRect_ = createRectInit(0, 0, 0, 0);
        this.target = target;
    }
    /**
     * Updates content rectangle and tells whether it's width or height properties
     * have changed since the last broadcast.
     *
     * @returns {boolean}
     */
    ResizeObservation.prototype.isActive = function () {
        var rect = getContentRect(this.target);
        this.contentRect_ = rect;
        return (rect.width !== this.broadcastWidth ||
            rect.height !== this.broadcastHeight);
    };
    /**
     * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data
     * from the corresponding properties of the last observed content rectangle.
     *
     * @returns {DOMRectInit} Last observed content rectangle.
     */
    ResizeObservation.prototype.broadcastRect = function () {
        var rect = this.contentRect_;
        this.broadcastWidth = rect.width;
        this.broadcastHeight = rect.height;
        return rect;
    };
    return ResizeObservation;
}());

var ResizeObserverEntry = /** @class */ (function () {
    /**
     * Creates an instance of ResizeObserverEntry.
     *
     * @param {Element} target - Element that is being observed.
     * @param {DOMRectInit} rectInit - Data of the element's content rectangle.
     */
    function ResizeObserverEntry(target, rectInit) {
        var contentRect = createReadOnlyRect(rectInit);
        // According to the specification following properties are not writable
        // and are also not enumerable in the native implementation.
        //
        // Property accessors are not being used as they'd require to define a
        // private WeakMap storage which may cause memory leaks in browsers that
        // don't support this type of collections.
        defineConfigurable(this, { target: target, contentRect: contentRect });
    }
    return ResizeObserverEntry;
}());

var ResizeObserverSPI = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback function that is invoked
     *      when one of the observed elements changes it's content dimensions.
     * @param {ResizeObserverController} controller - Controller instance which
     *      is responsible for the updates of observer.
     * @param {ResizeObserver} callbackCtx - Reference to the public
     *      ResizeObserver instance which will be passed to callback function.
     */
    function ResizeObserverSPI(callback, controller, callbackCtx) {
        /**
         * Collection of resize observations that have detected changes in dimensions
         * of elements.
         *
         * @private {Array<ResizeObservation>}
         */
        this.activeObservations_ = [];
        /**
         * Registry of the ResizeObservation instances.
         *
         * @private {Map<Element, ResizeObservation>}
         */
        this.observations_ = new MapShim();
        if (typeof callback !== 'function') {
            throw new TypeError('The callback provided as parameter 1 is not a function.');
        }
        this.callback_ = callback;
        this.controller_ = controller;
        this.callbackCtx_ = callbackCtx;
    }
    /**
     * Starts observing provided element.
     *
     * @param {Element} target - Element to be observed.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.observe = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is already being observed.
        if (observations.has(target)) {
            return;
        }
        observations.set(target, new ResizeObservation(target));
        this.controller_.addObserver(this);
        // Force the update of observations.
        this.controller_.refresh();
    };
    /**
     * Stops observing provided element.
     *
     * @param {Element} target - Element to stop observing.
     * @returns {void}
     */
    ResizeObserverSPI.prototype.unobserve = function (target) {
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        // Do nothing if current environment doesn't have the Element interface.
        if (typeof Element === 'undefined' || !(Element instanceof Object)) {
            return;
        }
        if (!(target instanceof getWindowOf(target).Element)) {
            throw new TypeError('parameter 1 is not of type "Element".');
        }
        var observations = this.observations_;
        // Do nothing if element is not being observed.
        if (!observations.has(target)) {
            return;
        }
        observations.delete(target);
        if (!observations.size) {
            this.controller_.removeObserver(this);
        }
    };
    /**
     * Stops observing all elements.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.disconnect = function () {
        this.clearActive();
        this.observations_.clear();
        this.controller_.removeObserver(this);
    };
    /**
     * Collects observation instances the associated element of which has changed
     * it's content rectangle.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.gatherActive = function () {
        var _this = this;
        this.clearActive();
        this.observations_.forEach(function (observation) {
            if (observation.isActive()) {
                _this.activeObservations_.push(observation);
            }
        });
    };
    /**
     * Invokes initial callback function with a list of ResizeObserverEntry
     * instances collected from active resize observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.broadcastActive = function () {
        // Do nothing if observer doesn't have active observations.
        if (!this.hasActive()) {
            return;
        }
        var ctx = this.callbackCtx_;
        // Create ResizeObserverEntry instance for every active observation.
        var entries = this.activeObservations_.map(function (observation) {
            return new ResizeObserverEntry(observation.target, observation.broadcastRect());
        });
        this.callback_.call(ctx, entries, ctx);
        this.clearActive();
    };
    /**
     * Clears the collection of active observations.
     *
     * @returns {void}
     */
    ResizeObserverSPI.prototype.clearActive = function () {
        this.activeObservations_.splice(0);
    };
    /**
     * Tells whether observer has active observations.
     *
     * @returns {boolean}
     */
    ResizeObserverSPI.prototype.hasActive = function () {
        return this.activeObservations_.length > 0;
    };
    return ResizeObserverSPI;
}());

// Registry of internal observers. If WeakMap is not available use current shim
// for the Map collection as it has all required methods and because WeakMap
// can't be fully polyfilled anyway.
var observers = typeof WeakMap !== 'undefined' ? new WeakMap() : new MapShim();
/**
 * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation
 * exposing only those methods and properties that are defined in the spec.
 */
var ResizeObserver = /** @class */ (function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback that is invoked when
     *      dimensions of the observed elements change.
     */
    function ResizeObserver(callback) {
        if (!(this instanceof ResizeObserver)) {
            throw new TypeError('Cannot call a class as a function.');
        }
        if (!arguments.length) {
            throw new TypeError('1 argument required, but only 0 present.');
        }
        var controller = ResizeObserverController.getInstance();
        var observer = new ResizeObserverSPI(callback, controller, this);
        observers.set(this, observer);
    }
    return ResizeObserver;
}());
// Expose public methods of ResizeObserver.
[
    'observe',
    'unobserve',
    'disconnect'
].forEach(function (method) {
    ResizeObserver.prototype[method] = function () {
        var _a;
        return (_a = observers.get(this))[method].apply(_a, arguments);
    };
});

var index = (function () {
    // Export existing implementation if available.
    if (typeof global$1.ResizeObserver !== 'undefined') {
        return global$1.ResizeObserver;
    }
    return ResizeObserver;
})();

class ResizeObserverDelegate {
    constructor() {
        this.handleResize = this.handleResize.bind(this);
        this.observer = new index(this.handleResize);
        this.elHandlersMap = new Map();
    }
    handleResize(entries) {
        for (const entry of entries) {
            const handler = this.elHandlersMap.get(entry.target);
            if (handler !== undefined) {
                handler(entry);
            }
        }
    }
    registerHandler(el, handler) {
        this.elHandlersMap.set(el, handler);
        this.observer.observe(el);
    }
    unregisterHandler(el) {
        if (!this.elHandlersMap.has(el)) {
            return;
        }
        this.elHandlersMap.delete(el);
        this.observer.unobserve(el);
    }
}
var delegate = new ResizeObserverDelegate();

var VResizeObserver = defineComponent({
    name: 'ResizeObserver',
    props: {
        onResize: Function
    },
    setup(props) {
        return {
            registered: false,
            handleResize(entry) {
                const { onResize } = props;
                if (onResize !== undefined)
                    onResize(entry);
            }
        };
    },
    mounted() {
        const el = this.$el;
        if (el === undefined) {
            warn('resize-observer', '$el does not exist.');
        }
        else if (el.nextElementSibling !== el.nextSibling) {
            warn('resize-observer', '$el can not be observed (it may be a text node).');
        }
        else if (el.nextElementSibling !== null) {
            delegate.registerHandler(el.nextElementSibling, this.handleResize);
            this.registered = true;
        }
    },
    beforeUnmount() {
        if (this.registered) {
            delegate.unregisterHandler(this.$el.nextElementSibling);
        }
    },
    render() {
        return renderSlot(this.$slots, 'default');
    }
});

/* eslint-disable no-void */
const styles = c('.v-vl', {
    maxHeight: 'inherit',
    height: '100%',
    overflow: 'auto',
    minWidth: '1px' // a zero width container won't be scrollable
}, [
    c('&:not(.v-vl--show-scrollbar)', {
        scrollbarWidth: 'none'
    }, [
        c('&::-webkit-scrollbar, &::-webkit-scrollbar-track-piece, &::-webkit-scrollbar-thumb', {
            width: 0,
            height: 0,
            display: 'none'
        })
    ])
]);
var VVirtualList = defineComponent({
    name: 'VirtualList',
    inheritAttrs: false,
    props: {
        showScrollbar: {
            type: Boolean,
            default: true
        },
        items: {
            type: Array,
            default: () => []
        },
        // it is suppose to be the min height
        itemSize: {
            type: Number,
            required: true
        },
        itemResizable: Boolean,
        itemsStyle: [String, Object],
        visibleItemsTag: {
            type: [String, Object],
            default: 'div'
        },
        visibleItemsProps: Object,
        ignoreItemResize: Boolean,
        onScroll: Function,
        onWheel: Function,
        onResize: Function,
        defaultScrollKey: [Number, String],
        defaultScrollIndex: Number,
        keyField: {
            type: String,
            default: 'key'
        },
        // Whether it is a good API?
        // ResizeObserver + footer & header is not enough.
        // Too complex for simple case
        paddingTop: {
            type: [Number, String],
            default: 0
        },
        paddingBottom: {
            type: [Number, String],
            default: 0
        }
    },
    setup(props) {
        const ssrAdapter = useSsrAdapter();
        styles.mount({
            id: 'vueuc/virtual-list',
            head: true,
            ssr: ssrAdapter
        });
        onMounted(() => {
            const { defaultScrollIndex, defaultScrollKey } = props;
            if (defaultScrollIndex !== undefined && defaultScrollIndex !== null) {
                scrollTo({ index: defaultScrollIndex });
            }
            else if (defaultScrollKey !== undefined && defaultScrollKey !== null) {
                scrollTo({ key: defaultScrollKey });
            }
        });
        const keyIndexMapRef = computed(() => {
            const map = new Map();
            const { keyField } = props;
            props.items.forEach((item, index) => {
                map.set(item[keyField], index);
            });
            return map;
        });
        const listElRef = ref(null);
        const listHeightRef = ref(undefined);
        const keyToHeightOffset = new Map();
        const finweckTreeRef = computed(() => {
            const { items, itemSize, keyField } = props;
            const ft = new FinweckTree(items.length, itemSize);
            items.forEach((item, index) => {
                const key = item[keyField];
                const heightOffset = keyToHeightOffset.get(key);
                if (heightOffset !== undefined) {
                    ft.add(index, heightOffset);
                }
            });
            return ft;
        });
        const finweckTreeUpdateTrigger = ref(0);
        const scrollTopRef = ref(0);
        const startIndexRef = useMemo(() => {
            return Math.max(finweckTreeRef.value.getBound(scrollTopRef.value - depx(props.paddingTop)) - 1, 0);
        });
        const viewportItemsRef = computed(() => {
            const { value: listHeight } = listHeightRef;
            if (listHeight === undefined)
                return [];
            const { items, itemSize } = props;
            const startIndex = startIndexRef.value;
            const endIndex = Math.min(startIndex + Math.ceil(listHeight / itemSize + 1), items.length - 1);
            const viewportItems = [];
            for (let i = startIndex; i <= endIndex; ++i) {
                viewportItems.push(items[i]);
            }
            return viewportItems;
        });
        const scrollTo = (options) => {
            const { left, top, index, key, position, behavior, debounce = true } = options;
            if (left !== undefined || top !== undefined) {
                scrollToPosition(left, top, behavior);
            }
            else if (index !== undefined) {
                scrollToIndex(index, behavior, debounce);
            }
            else if (key !== undefined) {
                const toIndex = keyIndexMapRef.value.get(key);
                if (toIndex !== undefined)
                    scrollToIndex(toIndex, behavior, debounce);
            }
            else if (position === 'bottom') {
                scrollToPosition(0, Number.MAX_SAFE_INTEGER, behavior);
            }
            else if (position === 'top') {
                scrollToPosition(0, 0, behavior);
            }
        };
        function scrollToIndex(index, behavior, debounce) {
            const { value: ft } = finweckTreeRef;
            const targetTop = ft.sum(index) + depx(props.paddingTop);
            if (!debounce) {
                listElRef.value.scrollTo({
                    left: 0,
                    top: targetTop,
                    behavior
                });
            }
            else {
                const { scrollTop, offsetHeight } = listElRef.value;
                if (targetTop > scrollTop) {
                    const itemSize = ft.get(index);
                    if (targetTop + itemSize <= scrollTop + offsetHeight) ;
                    else {
                        listElRef.value.scrollTo({
                            left: 0,
                            top: targetTop + itemSize - offsetHeight,
                            behavior
                        });
                    }
                }
                else {
                    listElRef.value.scrollTo({
                        left: 0,
                        top: targetTop,
                        behavior
                    });
                }
            }
            lastScrollAnchorIndex = index;
        }
        function scrollToPosition(left, top, behavior) {
            listElRef.value.scrollTo({
                left,
                top,
                behavior
            });
        }
        function handleItemResize(key, entry) {
            var _a;
            if (props.ignoreItemResize)
                return;
            const { value: ft } = finweckTreeRef;
            const index = keyIndexMapRef.value.get(key);
            const height = entry.target.offsetHeight;
            // height offset based on itemSize
            // used when rebuild the finweck tree
            const offset = height - props.itemSize;
            if (offset === 0) {
                keyToHeightOffset.delete(key);
            }
            else {
                keyToHeightOffset.set(key, height - props.itemSize);
            }
            // delta height based on finweck tree data
            const delta = height - ft.get(index);
            if (delta === 0)
                return;
            if (lastAnchorIndex !== undefined && index <= lastAnchorIndex) {
                (_a = listElRef.value) === null || _a === void 0 ? void 0 : _a.scrollBy(0, delta);
            }
            ft.add(index, delta);
            finweckTreeUpdateTrigger.value++;
        }
        function handleListScroll(e) {
            beforeNextFrameOnce(syncViewport);
            const { onScroll } = props;
            if (onScroll !== undefined)
                onScroll(e);
        }
        function handleListResize(entry) {
            listHeightRef.value = entry.contentRect.height;
            const { onResize } = props;
            if (onResize !== undefined)
                onResize(entry);
        }
        let lastScrollAnchorIndex;
        let lastAnchorIndex;
        function syncViewport() {
            const { value: listEl } = listElRef;
            // sometime ref el can be null
            // https://github.com/TuSimple/naive-ui/issues/811
            if (listEl == null)
                return;
            lastAnchorIndex = lastScrollAnchorIndex !== null && lastScrollAnchorIndex !== void 0 ? lastScrollAnchorIndex : startIndexRef.value;
            lastScrollAnchorIndex = undefined;
            scrollTopRef.value = listElRef.value.scrollTop;
        }
        return {
            listHeight: listHeightRef,
            listStyle: {
                overflow: 'auto'
            },
            keyToIndex: keyIndexMapRef,
            itemsStyle: computed(() => {
                const { itemResizable } = props;
                const height = pxfy(finweckTreeRef.value.sum());
                // eslint-disable-next-line @typescript-eslint/no-unused-expressions
                finweckTreeUpdateTrigger.value;
                return [
                    props.itemsStyle,
                    {
                        boxSizing: 'content-box',
                        height: itemResizable ? '' : height,
                        minHeight: itemResizable ? height : '',
                        paddingTop: pxfy(props.paddingTop),
                        paddingBottom: pxfy(props.paddingBottom)
                    }
                ];
            }),
            visibleItemsStyle: computed(() => {
                // eslint-disable-next-line @typescript-eslint/no-unused-expressions
                finweckTreeUpdateTrigger.value;
                return {
                    transform: `translate3d(0, ${pxfy(finweckTreeRef.value.sum(startIndexRef.value))}, 0)`
                };
            }),
            viewportItems: viewportItemsRef,
            listElRef,
            itemsElRef: ref(null),
            scrollTo,
            handleListResize,
            handleListScroll,
            handleItemResize
        };
    },
    render() {
        const { itemResizable, keyField, keyToIndex, visibleItemsTag } = this;
        return h(VResizeObserver, {
            onResize: this.handleListResize
        }, {
            default: () => {
                var _a, _b;
                return h('div', mergeProps(this.$attrs, {
                    class: [
                        'v-vl',
                        this.showScrollbar && 'v-vl--show-scrollbar'
                    ],
                    onScroll: this.handleListScroll,
                    onWheel: this.onWheel,
                    ref: 'listElRef'
                }), [
                    this.items.length !== 0
                        ? h('div', {
                            ref: 'itemsElRef',
                            class: 'v-vl-items',
                            style: this.itemsStyle
                        }, [
                            h(visibleItemsTag, Object.assign({
                                class: 'v-vl-visible-items',
                                style: this.visibleItemsStyle
                            }, this.visibleItemsProps), {
                                default: () => this.viewportItems.map(item => {
                                    const key = item[keyField];
                                    const index = keyToIndex.get(key);
                                    const itemVNode = this.$slots.default({ item, index })[0];
                                    if (itemResizable) {
                                        return h(VResizeObserver, {
                                            key,
                                            onResize: (entry) => this.handleItemResize(key, entry)
                                        }, {
                                            default: () => itemVNode
                                        });
                                    }
                                    itemVNode.key = key;
                                    return itemVNode;
                                })
                            })
                        ])
                        : (_b = (_a = this.$slots).empty) === null || _b === void 0 ? void 0 : _b.call(_a)
                ]);
            }
        });
    }
});

/* eslint-disable @typescript-eslint/strict-boolean-expressions */
const hiddenAttr = 'v-hidden';
const style$9 = c('[v-hidden]', {
    display: 'none!important'
});
var VOverflow = defineComponent({
    name: 'Overflow',
    props: {
        getCounter: Function,
        getTail: Function,
        updateCounter: Function,
        onUpdateOverflow: Function
    },
    setup(props, { slots }) {
        const selfRef = ref(null);
        const counterRef = ref(null);
        function deriveCounter() {
            const { value: self } = selfRef;
            const { getCounter, getTail } = props;
            let counter;
            if (getCounter !== undefined)
                counter = getCounter();
            else {
                counter = counterRef.value;
            }
            if (!self || !counter)
                return;
            if (counter.hasAttribute(hiddenAttr)) {
                counter.removeAttribute(hiddenAttr);
            }
            const { children } = self;
            const containerWidth = self.offsetWidth;
            const childWidths = [];
            const tail = slots.tail ? getTail === null || getTail === void 0 ? void 0 : getTail() : null;
            let childWidthSum = tail ? tail.offsetWidth : 0;
            let overflow = false;
            const len = self.children.length - (slots.tail ? 1 : 0);
            for (let i = 0; i < len - 1; ++i) {
                if (i < 0)
                    continue;
                const child = children[i];
                if (overflow) {
                    if (!child.hasAttribute(hiddenAttr)) {
                        child.setAttribute(hiddenAttr, '');
                    }
                    continue;
                }
                else if (child.hasAttribute(hiddenAttr)) {
                    child.removeAttribute(hiddenAttr);
                }
                const childWidth = child.offsetWidth;
                childWidthSum += childWidth;
                childWidths[i] = childWidth;
                if (childWidthSum > containerWidth) {
                    const { updateCounter } = props;
                    for (let j = i; j >= 0; --j) {
                        const restCount = len - 1 - j;
                        if (updateCounter !== undefined) {
                            updateCounter(restCount);
                        }
                        else {
                            counter.textContent = `${restCount}`;
                        }
                        const counterWidth = counter.offsetWidth;
                        childWidthSum -= childWidths[j];
                        if (childWidthSum + counterWidth <= containerWidth || j === 0) {
                            overflow = true;
                            i = j - 1;
                            if (tail) {
                                // tail too long or 1st element too long
                                // we only consider tail now
                                if (i === -1) {
                                    tail.style.maxWidth = `${containerWidth - counterWidth}px`;
                                    tail.style.boxSizing = 'border-box';
                                }
                                else {
                                    tail.style.maxWidth = '';
                                }
                            }
                            break;
                        }
                    }
                }
            }
            const { onUpdateOverflow } = props;
            if (!overflow) {
                if (onUpdateOverflow !== undefined) {
                    onUpdateOverflow(false);
                }
                counter.setAttribute(hiddenAttr, '');
            }
            else {
                if (onUpdateOverflow !== undefined) {
                    onUpdateOverflow(true);
                }
            }
        }
        const ssrAdapter = useSsrAdapter();
        style$9.mount({
            id: 'vueuc/overflow',
            head: true,
            ssr: ssrAdapter
        });
        onMounted(deriveCounter);
        // besides onMounted, other case should be manually triggered, or we shoud watch items
        return {
            selfRef,
            counterRef,
            sync: deriveCounter
        };
    },
    render() {
        const { $slots } = this;
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        nextTick(this.sync);
        // It shouldn't have border
        return h('div', {
            class: 'v-overflow',
            ref: 'selfRef'
        }, [
            renderSlot($slots, 'default'),
            // $slots.counter should only has 1 element
            $slots.counter
                ? $slots.counter()
                : h('span', {
                    style: {
                        display: 'inline-block'
                    },
                    ref: 'counterRef'
                }),
            // $slots.tail should only has 1 element
            $slots.tail ? $slots.tail() : null
        ]);
    }
});

const base = {
    neutralBase: '#FFF',
    neutralInvertBase: '#000',
    neutralTextBase: '#000',
    neutralPopover: '#fff',
    neutralCard: '#fff',
    neutralModal: '#fff',
    neutralBody: '#fff',
    alpha1: '0.82',
    alpha2: '0.72',
    alpha3: '0.38',
    alpha4: '0.24',
    alpha5: '0.18',
    alphaClose: '0.52',
    alphaDisabled: '0.5',
    alphaDisabledInput: '0.02',
    alphaPending: '0.05',
    alphaTablePending: '0.02',
    alphaPressed: '0.07',
    alphaAvatar: '0.2',
    alphaRail: '0.14',
    alphaProgressRail: '.08',
    alphaBorder: '0.12',
    alphaDivider: '0.06',
    alphaInput: '0',
    alphaAction: '0.02',
    alphaTab: '0.04',
    alphaScrollbar: '0.25',
    alphaScrollbarHover: '0.4',
    alphaCode: '0.05',
    alphaTag: '0.02',
    // primary
    primaryHover: '#36ad6a',
    primaryDefault: '#18a058',
    primaryActive: '#0c7a43',
    primarySuppl: '#36ad6a',
    // info
    infoHover: '#4098fc',
    infoDefault: '#2080f0',
    infoActive: '#1060c9',
    infoSuppl: '#4098fc',
    // error
    errorHover: '#de576d',
    errorDefault: '#d03050',
    errorActive: '#ab1f3f',
    errorSuppl: '#de576d',
    // warning
    warningHover: '#fcb040',
    warningDefault: '#f0a020',
    warningActive: '#c97c10',
    warningSuppl: '#fcb040',
    // success
    successHover: '#36ad6a',
    successDefault: '#18a058',
    successActive: '#0c7a43',
    successSuppl: '#36ad6a'
};
const baseBackgroundRgb = rgba(base.neutralBase);
const baseInvertBackgroundRgb = rgba(base.neutralInvertBase);
const overlayPrefix = 'rgba(' + baseInvertBackgroundRgb.slice(0, 3).join(', ') + ', ';
function overlay(alpha) {
    return overlayPrefix + String(alpha) + ')';
}
function neutral(alpha) {
    const overlayRgba = Array.from(baseInvertBackgroundRgb);
    overlayRgba[3] = Number(alpha);
    return composite(baseBackgroundRgb, overlayRgba);
}
const derived = Object.assign(Object.assign({ name: 'common' }, commonVariables$3), { baseColor: base.neutralBase, 
    // primary color
    primaryColor: base.primaryDefault, primaryColorHover: base.primaryHover, primaryColorPressed: base.primaryActive, primaryColorSuppl: base.primarySuppl, 
    // info color
    infoColor: base.infoDefault, infoColorHover: base.infoHover, infoColorPressed: base.infoActive, infoColorSuppl: base.infoSuppl, 
    // success color
    successColor: base.successDefault, successColorHover: base.successHover, successColorPressed: base.successActive, successColorSuppl: base.successSuppl, 
    // warning color
    warningColor: base.warningDefault, warningColorHover: base.warningHover, warningColorPressed: base.warningActive, warningColorSuppl: base.warningSuppl, 
    // error color
    errorColor: base.errorDefault, errorColorHover: base.errorHover, errorColorPressed: base.errorActive, errorColorSuppl: base.errorSuppl, 
    // text color
    textColorBase: base.neutralTextBase, textColor1: 'rgb(31, 34, 37)', textColor2: 'rgb(51, 54, 57)', textColor3: 'rgb(158, 164, 170)', 
    // textColor4: neutral(base.alpha4), // disabled, placeholder, icon
    // textColor5: neutral(base.alpha5),
    textColorDisabled: neutral(base.alpha4), placeholderColor: neutral(base.alpha4), placeholderColorDisabled: neutral(base.alpha5), iconColor: neutral(base.alpha4), iconColorHover: scaleColor(neutral(base.alpha4), { lightness: 0.75 }), iconColorPressed: scaleColor(neutral(base.alpha4), { lightness: 0.9 }), iconColorDisabled: neutral(base.alpha5), opacity1: base.alpha1, opacity2: base.alpha2, opacity3: base.alpha3, opacity4: base.alpha4, opacity5: base.alpha5, dividerColor: 'rgb(239, 239, 245)', borderColor: 'rgb(224, 224, 230)', 
    // close
    closeColor: neutral(Number(base.alphaClose)), closeColorHover: neutral(Number(base.alphaClose) * 1.25), closeColorPressed: neutral(Number(base.alphaClose) * 0.8), closeColorDisabled: neutral(base.alpha4), 
    // clear
    clearColor: neutral(base.alpha4), clearColorHover: scaleColor(neutral(base.alpha4), { lightness: 0.75 }), clearColorPressed: scaleColor(neutral(base.alpha4), { lightness: 0.9 }), scrollbarColor: overlay(base.alphaScrollbar), scrollbarColorHover: overlay(base.alphaScrollbarHover), scrollbarWidth: '5px', scrollbarHeight: '5px', scrollbarBorderRadius: '5px', progressRailColor: neutral(base.alphaProgressRail), railColor: 'rgb(219, 219, 223)', popoverColor: base.neutralPopover, tableColor: base.neutralCard, cardColor: base.neutralCard, modalColor: base.neutralModal, bodyColor: base.neutralBody, tagColor: 'rgb(250, 250, 252)', avatarColor: neutral(base.alphaAvatar), invertedColor: 'rgb(0, 20, 40)', inputColor: neutral(base.alphaInput), codeColor: 'rgb(244, 244, 248)', tabColor: 'rgb(247, 247, 250)', actionColor: 'rgb(250, 250, 252)', tableHeaderColor: 'rgb(250, 250, 252)', hoverColor: 'rgb(243, 243, 245)', 
    // use color with alpha since it can be nested with header filter & sorter effect
    tableColorHover: 'rgba(0, 0, 100, 0.02)', pressedColor: 'rgb(237, 237, 239)', opacityDisabled: base.alphaDisabled, inputColorDisabled: 'rgb(250, 250, 252)', boxShadow1: '0 1px 2px -2px rgba(0, 0, 0, .08), 0 3px 6px 0 rgba(0, 0, 0, .06), 0 5px 12px 4px rgba(0, 0, 0, .04)', boxShadow2: '0 3px 6px -4px rgba(0, 0, 0, .12), 0 6px 16px 0 rgba(0, 0, 0, .08), 0 9px 28px 8px rgba(0, 0, 0, .05)', boxShadow3: '0 6px 16px -9px rgba(0, 0, 0, .08), 0 9px 28px 0 rgba(0, 0, 0, .05), 0 12px 48px 16px rgba(0, 0, 0, .03)' });
var commonLight = derived;

var commonVars$2 = {
    iconSizeSmall: '34px',
    iconSizeMedium: '40px',
    iconSizeLarge: '46px',
    iconSizeHuge: '52px'
};

const self$9 = (vars) => {
    const { textColorDisabled, iconColor, textColor2, fontSizeSmall, fontSizeMedium, fontSizeLarge, fontSizeHuge } = vars;
    return Object.assign(Object.assign({}, commonVars$2), { fontSizeSmall,
        fontSizeMedium,
        fontSizeLarge,
        fontSizeHuge, textColor: textColorDisabled, iconColor: iconColor, extraTextColor: textColor2 });
};
const emptyLight = {
    name: 'Empty',
    common: commonLight,
    self: self$9
};
var emptyLight$1 = emptyLight;

// --font-size
// --icon-size
// --icon-color
// --bezier
// --text-color
// --extra-text-color

var style$8 = cB('empty', `
 display: flex;
 flex-direction: column;
 align-items: center;
 font-size: var(--font-size);
`, [cE('icon', `
 width: var(--icon-size);
 height: var(--icon-size);
 font-size: var(--icon-size);
 line-height: var(--icon-size);
 color: var(--icon-color);
 transition:
 color .3s var(--bezier);
 `), cE('description', `
 margin-top: 8px;
 transition: color .3s var(--bezier);
 color: var(--text-color);
 `), cE('extra', `
 text-align: center;
 transition: color .3s var(--bezier);
 margin-top: 12px;
 color: var(--extra-text-color);
 `)]);

const emptyProps = Object.assign(Object.assign({}, useTheme.props), { description: {
        type: String,
        default: undefined
    }, showDescription: {
        type: Boolean,
        default: true
    }, size: {
        type: String,
        default: 'medium'
    }, renderIcon: Function });
var NEmpty = defineComponent({
    name: 'Empty',
    props: emptyProps,
    setup(props) {
        const { mergedClsPrefixRef } = useConfig(props);
        const themeRef = useTheme('Empty', 'Empty', style$8, emptyLight$1, props, mergedClsPrefixRef);
        const { localeRef } = createLocaleMixin('Empty');
        const NConfigProvider = inject(configProviderInjectionKey, null);
        const mergedDescriptionRef = computed(() => {
            var _a, _b, _c;
            return ((_a = props.description) !== null && _a !== void 0 ? _a : (_c = (_b = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedComponentPropsRef.value) === null || _b === void 0 ? void 0 : _b.Empty) === null || _c === void 0 ? void 0 : _c.description);
        });
        const mergedRenderIconRef = computed(() => {
            var _a, _b;
            return ((_b = (_a = NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedComponentPropsRef.value) === null || _a === void 0 ? void 0 : _a.Empty) === null || _b === void 0 ? void 0 : _b.renderIcon) ||
                (() => h(EmptyIcon, null));
        });
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            mergedRenderIcon: mergedRenderIconRef,
            localizedDescription: computed(() => {
                return mergedDescriptionRef.value || localeRef.value.description;
            }),
            cssVars: computed(() => {
                const { size } = props;
                const { common: { cubicBezierEaseInOut }, self: { [createKey('iconSize', size)]: iconSize, [createKey('fontSize', size)]: fontSize, textColor, iconColor, extraTextColor } } = themeRef.value;
                return {
                    '--icon-size': iconSize,
                    '--font-size': fontSize,
                    '--bezier': cubicBezierEaseInOut,
                    '--text-color': textColor,
                    '--icon-color': iconColor,
                    '--extra-text-color': extraTextColor
                };
            })
        };
    },
    render() {
        const { $slots, mergedClsPrefix } = this;
        return (h("div", { class: `${mergedClsPrefix}-empty`, style: this.cssVars },
            h("div", { class: `${mergedClsPrefix}-empty__icon` }, renderSlot($slots, 'icon', undefined, () => [
                h(NBaseIcon, { clsPrefix: mergedClsPrefix }, { default: this.mergedRenderIcon })
            ])),
            this.showDescription ? (h("div", { class: `${mergedClsPrefix}-empty__description` }, renderSlot($slots, 'default', undefined, () => [
                this.localizedDescription
            ]))) : null,
            $slots.extra ? (h("div", { class: `${mergedClsPrefix}-empty__extra` }, renderSlot($slots, 'extra'))) : null));
    }
});

const self$8 = (vars) => {
    const { scrollbarColor, scrollbarColorHover } = vars;
    return {
        color: scrollbarColor,
        colorHover: scrollbarColorHover
    };
};
const scrollbarLight = {
    name: 'Scrollbar',
    common: commonLight,
    self: self$8
};
var scrollbarLight$1 = scrollbarLight;

const {
  cubicBezierEaseInOut
} = commonVariables$3;
function fadeInTransition ({
  name = 'fade-in',
  enterDuration = '0.2s',
  leaveDuration = '0.2s',
  enterCubicBezier = cubicBezierEaseInOut,
  leaveCubicBezier = cubicBezierEaseInOut
} = {}) {
  return [c$1(`&.${name}-transition-enter-active`, {
    transition: `all ${enterDuration} ${enterCubicBezier}!important`
  }), c$1(`&.${name}-transition-leave-active`, {
    transition: `all ${leaveDuration} ${leaveCubicBezier}!important`
  }), c$1(`&.${name}-transition-enter-from, &.${name}-transition-leave-to`, {
    opacity: 0
  }), c$1(`&.${name}-transition-leave-from, &.${name}-transition-enter-to`, {
    opacity: 1
  })];
}

// --scrollbar-bezier
// --scrollbar-color
// --scrollbar-color-hover
// --scrollbar-width
// --scrollbar-height
// --scrollbar-border-radius

var style$7 = cB('scrollbar', `
 overflow: hidden;
 position: relative;
 z-index: auto;
 height: 100%;
 width: 100%;
`, [c$1('>', [cB('scrollbar-container', `
 width: 100%;
 overflow: scroll;
 height: 100%;
 max-height: inherit;
 scrollbar-width: none;
 `, [c$1('&::-webkit-scrollbar, &::-webkit-scrollbar-track-piece, &::-webkit-scrollbar-thumb', `
 width: 0;
 height: 0;
 display: none;
 `), c$1('>', [cB('scrollbar-content', `
 box-sizing: border-box;
 min-width: 100%;
 `)])]), cB('scrollbar-rail', `
 position: absolute;
 pointer-events: none;
 user-select: none;
 `, [cM('horizontal', `
 left: 2px;
 right: 2px;
 bottom: 4px;
 height: var(--scrollbar-height);
 `, [c$1('>', [cE('scrollbar', `
 height: var(--scrollbar-height);
 border-radius: var(--scrollbar-border-radius);
 right: 0;
 `)])]), cM('vertical', `
 right: 4px;
 top: 2px;
 bottom: 2px;
 width: var(--scrollbar-width);
 `, [c$1('>', [cE('scrollbar', `
 width: var(--scrollbar-width);
 border-radius: var(--scrollbar-border-radius);
 bottom: 0;
 `)])]), cM('disabled', [c$1('>', [cE('scrollbar', {
  pointerEvents: 'none'
})])]), c$1('>', [cE('scrollbar', `
 position: absolute;
 cursor: pointer;
 pointer-events: all;
 background-color: var(--scrollbar-color);
 transition: background-color .2s var(--scrollbar-bezier);
 `, [fadeInTransition(), c$1('&:hover', {
  backgroundColor: 'var(--scrollbar-color-hover)'
})])])])])]);

const scrollbarProps = Object.assign(Object.assign({}, useTheme.props), { size: {
        type: Number,
        default: 5
    }, duration: {
        type: Number,
        default: 0
    }, scrollable: {
        type: Boolean,
        default: true
    }, xScrollable: {
        type: Boolean,
        default: false
    }, 
    // If container is set, resize observer won't not attached
    container: Function, content: Function, containerStyle: [String, Object], contentClass: String, contentStyle: [String, Object], horizontalRailStyle: [String, Object], verticalRailStyle: [String, Object], onScroll: Function, onWheel: Function, onResize: Function, internalOnUpdateScrollLeft: Function });
const Scrollbar = defineComponent({
    name: 'Scrollbar',
    props: scrollbarProps,
    inheritAttrs: false,
    setup(props) {
        const { mergedClsPrefixRef } = useConfig(props);
        // dom ref
        const containerRef = ref(null);
        const contentRef = ref(null);
        const yRailRef = ref(null);
        const xRailRef = ref(null);
        // data ref
        const contentHeightRef = ref(null);
        const contentWidthRef = ref(null);
        const containerHeightRef = ref(null);
        const containerWidthRef = ref(null);
        const yRailSizeRef = ref(null);
        const xRailSizeRef = ref(null);
        const containerScrollTopRef = ref(0);
        const containerScrollLeftRef = ref(0);
        const isShowXBarRef = ref(false);
        const isShowYBarRef = ref(false);
        let yBarPressed = false;
        let xBarPressed = false;
        let xBarVanishTimerId;
        let yBarVanishTimerId;
        let memoYTop = 0;
        let memoXLeft = 0;
        let memoMouseX = 0;
        let memoMouseY = 0;
        const isIos = useIsIos();
        const yBarSizeRef = computed(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yRailSize } = yRailSizeRef;
            if (containerHeight === null ||
                contentHeight === null ||
                yRailSize === null) {
                return 0;
            }
            else {
                return Math.min(containerHeight, (yRailSize * containerHeight) / contentHeight + props.size * 1.5);
            }
        });
        const yBarSizePxRef = computed(() => {
            return `${yBarSizeRef.value}px`;
        });
        const xBarSizeRef = computed(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xRailSize } = xRailSizeRef;
            if (containerWidth === null ||
                contentWidth === null ||
                xRailSize === null) {
                return 0;
            }
            else {
                return (xRailSize * containerWidth) / contentWidth + props.size * 1.5;
            }
        });
        const xBarSizePxRef = computed(() => {
            return `${xBarSizeRef.value}px`;
        });
        const yBarTopRef = computed(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: containerScrollTop } = containerScrollTopRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yRailSize } = yRailSizeRef;
            if (containerHeight === null ||
                contentHeight === null ||
                yRailSize === null) {
                return 0;
            }
            else {
                return ((containerScrollTop / (contentHeight - containerHeight)) *
                    (yRailSize - yBarSizeRef.value));
            }
        });
        const yBarTopPxRef = computed(() => {
            return `${yBarTopRef.value}px`;
        });
        const xBarLeftRef = computed(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: containerScrollLeft } = containerScrollLeftRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xRailSize } = xRailSizeRef;
            if (containerWidth === null ||
                contentWidth === null ||
                xRailSize === null) {
                return 0;
            }
            else {
                return ((containerScrollLeft / (contentWidth - containerWidth)) *
                    (xRailSize - xBarSizeRef.value));
            }
        });
        const xBarLeftPxRef = computed(() => {
            return `${xBarLeftRef.value}px`;
        });
        const needYBarRef = computed(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            return (containerHeight !== null &&
                contentHeight !== null &&
                contentHeight > containerHeight);
        });
        const needXBarRef = computed(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            return (containerWidth !== null &&
                contentWidth !== null &&
                contentWidth > containerWidth);
        });
        const mergedContainerRef = computed(() => {
            const { container } = props;
            if (container)
                return container();
            return containerRef.value;
        });
        const mergedContentRef = computed(() => {
            const { content } = props;
            if (content)
                return content();
            return contentRef.value;
        });
        // methods
        const handleContentResize = sync;
        const handleContainerResize = (e) => {
            const { onResize } = props;
            if (onResize)
                onResize(e);
            sync();
        };
        const scrollTo = (options, y) => {
            if (!props.scrollable)
                return;
            if (typeof options === 'number') {
                scrollToPosition(options, y !== null && y !== void 0 ? y : 0, 0, false, 'auto');
                return;
            }
            const { left, top, index, elSize, position, behavior, el, debounce = true } = options;
            if (left !== undefined || top !== undefined) {
                scrollToPosition(left !== null && left !== void 0 ? left : 0, top !== null && top !== void 0 ? top : 0, 0, false, behavior);
            }
            if (el !== undefined) {
                scrollToPosition(0, el.offsetTop, el.offsetHeight, debounce, behavior);
            }
            else if (index !== undefined && elSize !== undefined) {
                scrollToPosition(0, index * elSize, elSize, debounce, behavior);
            }
            else if (position === 'bottom') {
                scrollToPosition(0, Number.MAX_SAFE_INTEGER, 0, false, behavior);
            }
            else if (position === 'top') {
                scrollToPosition(0, 0, 0, false, behavior);
            }
        };
        function scrollToPosition(left, top, elSize, debounce, behavior) {
            const { value: container } = mergedContainerRef;
            if (!container)
                return;
            if (debounce) {
                const { scrollTop, offsetHeight } = container;
                if (top > scrollTop) {
                    if (top + elSize <= scrollTop + offsetHeight) ;
                    else {
                        container.scrollTo({
                            left,
                            top: top + elSize - offsetHeight,
                            behavior
                        });
                    }
                    return;
                }
            }
            container.scrollTo({
                left,
                top,
                behavior
            });
        }
        function handleMouseEnterWrapper() {
            showXBar();
            showYBar();
            sync();
        }
        function handleMouseLeaveWrapper() {
            hideBar();
        }
        function hideBar() {
            hideYBar();
            hideXBar();
        }
        function hideYBar() {
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            yBarVanishTimerId = window.setTimeout(() => {
                isShowYBarRef.value = false;
            }, props.duration);
        }
        function hideXBar() {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            xBarVanishTimerId = window.setTimeout(() => {
                isShowXBarRef.value = false;
            }, props.duration);
        }
        function showXBar() {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            isShowXBarRef.value = true;
        }
        function showYBar() {
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            isShowYBarRef.value = true;
        }
        function handleScroll(e) {
            const { onScroll } = props;
            if (onScroll)
                onScroll(e);
            syncScrollState();
        }
        function syncScrollState() {
            // only collect scroll state, do not trigger any dom event
            const { value: container } = mergedContainerRef;
            if (container) {
                containerScrollTopRef.value = container.scrollTop;
                containerScrollLeftRef.value = container.scrollLeft;
            }
        }
        function syncPositionState() {
            // only collect position state, do not trigger any dom event
            // Don't use getClientBoundingRect because element may be scale transformed
            const { value: content } = mergedContentRef;
            if (content) {
                contentHeightRef.value = content.offsetHeight;
                contentWidthRef.value = content.offsetWidth;
            }
            const { value: container } = mergedContainerRef;
            if (container) {
                containerHeightRef.value = container.offsetHeight;
                containerWidthRef.value = container.offsetWidth;
            }
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                xRailSizeRef.value = xRailEl.offsetWidth;
            }
            if (yRailEl) {
                yRailSizeRef.value = yRailEl.offsetHeight;
            }
        }
        function sync() {
            if (!props.scrollable)
                return;
            syncPositionState();
            syncScrollState();
        }
        function handleXScrollMouseDown(e) {
            e.preventDefault();
            e.stopPropagation();
            xBarPressed = true;
            on('mousemove', window, handleXScrollMouseMove, true);
            on('mouseup', window, handleXScrollMouseUp, true);
            memoXLeft = containerScrollLeftRef.value;
            memoMouseX = e.clientX;
        }
        function handleXScrollMouseMove(e) {
            if (!xBarPressed)
                return;
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xBarSize } = xBarSizeRef;
            if (containerWidth === null || contentWidth === null)
                return;
            const dX = e.clientX - memoMouseX;
            const dScrollLeft = (dX * (contentWidth - containerWidth)) / (containerWidth - xBarSize);
            const toScrollLeftUpperBound = contentWidth - containerWidth;
            let toScrollLeft = memoXLeft + dScrollLeft;
            toScrollLeft = Math.min(toScrollLeftUpperBound, toScrollLeft);
            toScrollLeft = Math.max(toScrollLeft, 0);
            const { value: container } = mergedContainerRef;
            if (container) {
                container.scrollLeft = toScrollLeft;
                const { internalOnUpdateScrollLeft } = props;
                if (internalOnUpdateScrollLeft)
                    internalOnUpdateScrollLeft(toScrollLeft);
            }
        }
        function handleXScrollMouseUp(e) {
            e.preventDefault();
            e.stopPropagation();
            off('mousemove', window, handleXScrollMouseMove, true);
            off('mouseup', window, handleXScrollMouseUp, true);
            xBarPressed = false;
            sync();
            const { value: container } = mergedContainerRef;
            if (!(container === null || container === void 0 ? void 0 : container.contains(e.target))) {
                hideBar();
            }
        }
        function handleYScrollMouseDown(e) {
            e.preventDefault();
            e.stopPropagation();
            yBarPressed = true;
            on('mousemove', window, handleYScrollMouseMove, true);
            on('mouseup', window, handleYScrollMouseUp, true);
            memoYTop = containerScrollTopRef.value;
            memoMouseY = e.clientY;
        }
        function handleYScrollMouseMove(e) {
            if (!yBarPressed)
                return;
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yBarSize } = yBarSizeRef;
            if (containerHeight === null || contentHeight === null)
                return;
            const dY = e.clientY - memoMouseY;
            const dScrollTop = (dY * (contentHeight - containerHeight)) / (containerHeight - yBarSize);
            const toScrollTopUpperBound = contentHeight - containerHeight;
            let toScrollTop = memoYTop + dScrollTop;
            toScrollTop = Math.min(toScrollTopUpperBound, toScrollTop);
            toScrollTop = Math.max(toScrollTop, 0);
            const { value: container } = mergedContainerRef;
            if (container) {
                container.scrollTop = toScrollTop;
            }
        }
        function handleYScrollMouseUp(e) {
            e.preventDefault();
            e.stopPropagation();
            off('mousemove', window, handleYScrollMouseMove, true);
            off('mouseup', window, handleYScrollMouseUp, true);
            yBarPressed = false;
            sync();
            const { value: container } = mergedContainerRef;
            if (!(container === null || container === void 0 ? void 0 : container.contains(e.target))) {
                hideBar();
            }
        }
        watchEffect(() => {
            const { value: needXBar } = needXBarRef;
            const { value: needYBar } = needYBarRef;
            const { value: mergedClsPrefix } = mergedClsPrefixRef;
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                if (!needXBar) {
                    xRailEl.classList.add(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
                else {
                    xRailEl.classList.remove(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
            }
            if (yRailEl) {
                if (!needYBar) {
                    yRailEl.classList.add(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
                else {
                    yRailEl.classList.remove(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
            }
        });
        onMounted(() => {
            // if container exist, it always can't be resolved when scrollbar is mounted
            // for example:
            // - component
            //   - scrollbar
            //     - inner
            // if you pass inner to scrollbar, you may use a ref inside component
            // however, when scrollbar is mounted, ref is not ready at component
            // you need to init by yourself
            if (props.container)
                return;
            sync();
        });
        onBeforeUnmount(() => {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            off('mousemove', window, handleYScrollMouseMove, true);
            off('mouseup', window, handleYScrollMouseUp, true);
        });
        const themeRef = useTheme('Scrollbar', 'Scrollbar', style$7, scrollbarLight$1, props, mergedClsPrefixRef);
        return {
            sync,
            scrollTo,
            mergedClsPrefix: mergedClsPrefixRef,
            containerScrollTop: containerScrollTopRef,
            containerRef,
            contentRef,
            yRailRef,
            xRailRef,
            needYBar: needYBarRef,
            needXBar: needXBarRef,
            yBarSizePx: yBarSizePxRef,
            xBarSizePx: xBarSizePxRef,
            yBarTopPx: yBarTopPxRef,
            xBarLeftPx: xBarLeftPxRef,
            isShowXBar: isShowXBarRef,
            isShowYBar: isShowYBarRef,
            isIos,
            handleScroll,
            handleContentResize,
            handleContainerResize,
            handleMouseEnterWrapper,
            handleMouseLeaveWrapper,
            handleYScrollMouseDown,
            handleXScrollMouseDown,
            cssVars: computed(() => {
                const { common: { cubicBezierEaseInOut, scrollbarBorderRadius, scrollbarHeight, scrollbarWidth }, self: { color, colorHover } } = themeRef.value;
                return {
                    '--scrollbar-bezier': cubicBezierEaseInOut,
                    '--scrollbar-color': color,
                    '--scrollbar-color-hover': colorHover,
                    '--scrollbar-border-radius': scrollbarBorderRadius,
                    '--scrollbar-width': scrollbarWidth,
                    '--scrollbar-height': scrollbarHeight
                };
            })
        };
    },
    render() {
        const { $slots, mergedClsPrefix } = this;
        if (!this.scrollable)
            return renderSlot($slots, 'default');
        const createChildren = () => h('div', mergeProps(this.$attrs, {
            class: `${mergedClsPrefix}-scrollbar`,
            style: this.cssVars,
            onMouseenter: this.handleMouseEnterWrapper,
            onMouseleave: this.handleMouseLeaveWrapper
        }), [
            this.container ? (renderSlot($slots, 'default')) : (h("div", { ref: "containerRef", class: `${mergedClsPrefix}-scrollbar-container`, style: this.containerStyle, onScroll: this.handleScroll, onWheel: this.onWheel },
                h(VResizeObserver, { onResize: this.handleContentResize }, {
                    default: () => (h("div", { ref: "contentRef", style: [
                            {
                                width: this.xScrollable ? 'fit-content' : null
                            },
                            this.contentStyle
                        ], class: [
                            `${mergedClsPrefix}-scrollbar-content`,
                            this.contentClass
                        ] }, $slots))
                }))),
            h("div", { ref: "yRailRef", class: `${mergedClsPrefix}-scrollbar-rail ${mergedClsPrefix}-scrollbar-rail--vertical`, style: [this.horizontalRailStyle] },
                h(Transition, { name: "fade-in-transition" }, {
                    default: () => this.needYBar && this.isShowYBar && !this.isIos ? (h("div", { class: `${mergedClsPrefix}-scrollbar-rail__scrollbar`, style: {
                            height: this.yBarSizePx,
                            top: this.yBarTopPx
                        }, onMousedown: this.handleYScrollMouseDown })) : null
                })),
            h("div", { ref: "xRailRef", class: `${mergedClsPrefix}-scrollbar-rail ${mergedClsPrefix}-scrollbar-rail--horizontal`, style: [this.verticalRailStyle] },
                h(Transition, { name: "fade-in-transition" }, {
                    default: () => this.needXBar && this.isShowXBar && !this.isIos ? (h("div", { class: `${mergedClsPrefix}-scrollbar-rail__scrollbar`, style: {
                            width: this.xBarSizePx,
                            left: this.xBarLeftPx
                        }, onMousedown: this.handleXScrollMouseDown })) : null
                }))
        ]);
        return this.container ? (createChildren()) : (h(VResizeObserver, { onResize: this.handleContainerResize }, {
            default: createChildren
        }));
    }
});
var NScrollbar = Scrollbar;

const checkMarkIcon = h(FinishedIcon);
function renderCheckMark(show, clsPrefix) {
    return (h(Transition, { name: "fade-in-scale-up-transition" }, {
        default: () => show ? (h(NBaseIcon, { clsPrefix: clsPrefix, class: `${clsPrefix}-base-select-option__check` }, {
            default: () => checkMarkIcon
        })) : null
    }));
}
var NSelectOption = defineComponent({
    name: 'NBaseSelectOption',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        tmNode: {
            type: Object,
            required: true
        }
    },
    setup(props) {
        const { valueRef, pendingTmNodeRef, multipleRef, valueSetRef, renderLabelRef, renderOptionRef, handleOptionClick, handleOptionMouseEnter
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
         } = inject(internalSelectionMenuInjectionKey);
        const isPendingRef = useMemo(() => {
            const { value: pendingTmNode } = pendingTmNodeRef;
            if (!pendingTmNode)
                return false;
            return props.tmNode.key === pendingTmNode.key;
        });
        function handleClick(e) {
            const { tmNode } = props;
            if (tmNode.disabled)
                return;
            handleOptionClick(e, tmNode);
        }
        function handleMouseEnter(e) {
            const { tmNode } = props;
            if (tmNode.disabled)
                return;
            handleOptionMouseEnter(e, tmNode);
        }
        function handleMouseMove(e) {
            const { tmNode } = props;
            const { value: isPending } = isPendingRef;
            if (tmNode.disabled || isPending)
                return;
            handleOptionMouseEnter(e, tmNode);
        }
        return {
            multiple: multipleRef,
            isGrouped: useMemo(() => {
                const { tmNode } = props;
                const { parent } = tmNode;
                return parent && parent.rawNode.type === 'group';
            }),
            isPending: isPendingRef,
            isSelected: useMemo(() => {
                const { value } = valueRef;
                const { value: multiple } = multipleRef;
                if (value === null)
                    return false;
                const optionValue = props.tmNode.rawNode.value;
                if (multiple) {
                    const { value: valueSet } = valueSetRef;
                    return valueSet.has(optionValue);
                }
                else {
                    return value === optionValue;
                }
            }),
            renderLabel: renderLabelRef,
            renderOption: renderOptionRef,
            handleMouseMove,
            handleMouseEnter,
            handleClick
        };
    },
    render() {
        const { clsPrefix, tmNode: { rawNode }, isSelected, isPending, isGrouped, multiple, renderOption, renderLabel, handleClick, handleMouseEnter, handleMouseMove } = this;
        const showCheckMark = multiple && isSelected;
        const checkmark = renderCheckMark(showCheckMark, clsPrefix);
        const children = renderLabel
            ? [renderLabel(rawNode, isSelected), checkmark]
            : [render$3(rawNode.label, rawNode, isSelected), checkmark];
        const node = (h("div", { class: [
                `${clsPrefix}-base-select-option`,
                rawNode.class,
                {
                    [`${clsPrefix}-base-select-option--disabled`]: rawNode.disabled,
                    [`${clsPrefix}-base-select-option--selected`]: isSelected,
                    [`${clsPrefix}-base-select-option--grouped`]: isGrouped,
                    [`${clsPrefix}-base-select-option--pending`]: isPending
                }
            ], style: rawNode.style, onClick: handleClick, onMouseenter: handleMouseEnter, onMousemove: handleMouseMove },
            h("div", { class: `${clsPrefix}-base-select-option__content` }, children)));
        return rawNode.render
            ? rawNode.render({ node, option: rawNode, selected: isSelected })
            : renderOption
                ? renderOption({ node, option: rawNode, selected: isSelected })
                : node;
    }
});

var NSelectGroupHeader = defineComponent({
    name: 'NBaseSelectGroupHeader',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        tmNode: {
            type: Object,
            required: true
        }
    },
    setup() {
        const { renderLabelRef, renderOptionRef
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
         } = inject(internalSelectionMenuInjectionKey);
        return {
            renderLabel: renderLabelRef,
            renderOption: renderOptionRef
        };
    },
    render() {
        const { clsPrefix, renderLabel, renderOption, tmNode: { rawNode } } = this;
        const children = renderLabel
            ? renderLabel(rawNode, false)
            : render$3(rawNode.label, rawNode, false);
        const node = (h("div", { class: `${clsPrefix}-base-select-group-header` }, children));
        return rawNode.render
            ? rawNode.render({ node, option: rawNode })
            : renderOption
                ? renderOption({ node, option: rawNode, selected: false })
                : node;
    }
});

const {
  cubicBezierEaseIn,
  cubicBezierEaseOut,
  transformDebounceScale
} = commonVariables$3;
function fadeInScaleUpTransition ({
  transformOrigin = 'inherit',
  duration = '.2s',
  enterScale = '.9',
  originalTransform = '',
  originalTransition = ''
} = {}) {
  return [c$1('&.fade-in-scale-up-transition-leave-active', {
    transformOrigin,
    transition: `opacity ${duration} ${cubicBezierEaseIn}, transform ${duration} ${cubicBezierEaseIn} ${originalTransition && ',' + originalTransition}`
  }), c$1('&.fade-in-scale-up-transition-enter-active', {
    transformOrigin,
    transition: `opacity ${duration} ${cubicBezierEaseOut}, transform ${duration} ${cubicBezierEaseOut} ${originalTransition && ',' + originalTransition}`
  }), c$1('&.fade-in-scale-up-transition-enter-from, &.fade-in-scale-up-transition-leave-to', {
    opacity: 0,
    transform: `${originalTransform} scale(${enterScale})`
  }), c$1('&.fade-in-scale-up-transition-leave-from, &.fade-in-scale-up-transition-enter-to', {
    opacity: 1,
    transform: `${originalTransform} scale(${transformDebounceScale})`
  })];
}

// --loading-size

var style$6 = cB('base-select-menu', `
 line-height: 1.5;
 outline: none;
 z-index: 0;
 position: relative;
 border-radius: var(--border-radius);
 transition:
 background-color .3s var(--bezier),
 box-shadow .3s var(--bezier);
 background-color: var(--color);
`, [cM('multiple', [cB('base-select-option', `
 padding-right: 28px;
 `)]), cB('scrollbar', `
 max-height: var(--height);
 `), cB('virtual-list', `
 max-height: var(--height);
 `), cB('base-select-option', `
 min-height: var(--option-height);
 font-size: var(--option-font-size);
 display: flex;
 align-items: center;
 `, [cE('content', `
 white-space: nowrap;
 text-overflow: ellipsis;
 overflow: hidden;
 `)]), cB('base-select-group-header', `
 min-height: var(--option-height);
 font-size: .93em;
 display: flex;
 align-items: center;
 `), cB('base-select-menu-option-wrapper', `
 position: relative;
 width: 100%;
 `), cE('loading, empty', `
 display: flex;
 padding: 12px 32px;
 flex: 1;
 justify-content: center;
 `), cE('loading', `
 color: var(--loading-color);
 font-size: var(--loading-size);
 `), cE('action', `
 padding: 8px var(--option-padding-left);
 font-size: var(--option-font-size);
 transition: 
 color .3s var(--bezier);
 border-color .3s var(--bezier);
 border-top: 1px solid var(--action-divider-color);
 color: var(--action-text-color);
 `), cB('base-select-group-header', `
 position: relative;
 cursor: default;
 padding: var(--option-padding);
 color: var(--group-header-text-color);
 `), cB('base-select-option', `
 cursor: pointer;
 position: relative;
 padding: var(--option-padding);
 transition:
 background-color .3s var(--bezier),
 color .3s var(--bezier),
 opacity .3s var(--bezier);
 box-sizing: border-box;
 color: var(--option-text-color);
 opacity: 1;
 `, [c$1('&:active', `
 color: var(--option-text-color-pressed);
 `), cM('grouped', `
 padding-left: calc(var(--option-padding-left) * 1.5);
 `), cM('pending', `
 background-color: var(--option-color-pending);
 `), cM('selected', `
 color: var(--option-text-color-active);
 background-color: var(--option-color-active);
 `), cM('disabled', `
 cursor: not-allowed;
 `, [cNotM('selected', `
 color: var(--option-text-color-disabled);
 `), cM('selected', `
 opacity: var(--option-opacity-disabled);
 `)]), cE('check', `
 font-size: 16px;
 position: absolute;
 right: 8px;
 top: calc(50% - 7px);
 color: var(--option-check-color);
 transition: color .3s var(--bezier);
 `, [fadeInScaleUpTransition({
  enterScale: '0.5'
})])])]);

var commonVariables$2 = {
    height: 'calc(var(--option-height) * 7.6)',
    paddingSmall: '4px 0',
    paddingMedium: '4px 0',
    paddingLarge: '4px 0',
    paddingHuge: '4px 0',
    optionPaddingSmall: '0 12px',
    optionPaddingMedium: '0 12px',
    optionPaddingLarge: '0 12px',
    optionPaddingHuge: '0 12px',
    loadingSize: '18px'
};

const self$7 = (vars) => {
    const { borderRadius, popoverColor, textColor3, dividerColor, textColor2, primaryColorPressed, textColorDisabled, primaryColor, opacityDisabled, hoverColor, fontSizeSmall, fontSizeMedium, fontSizeLarge, fontSizeHuge, heightSmall, heightMedium, heightLarge, heightHuge } = vars;
    return Object.assign(Object.assign({}, commonVariables$2), { optionFontSizeSmall: fontSizeSmall, optionFontSizeMedium: fontSizeMedium, optionFontSizeLarge: fontSizeLarge, optionFontSizeHuge: fontSizeHuge, optionHeightSmall: heightSmall, optionHeightMedium: heightMedium, optionHeightLarge: heightLarge, optionHeightHuge: heightHuge, borderRadius: borderRadius, color: popoverColor, groupHeaderTextColor: textColor3, actionDividerColor: dividerColor, optionTextColor: textColor2, optionTextColorPressed: primaryColorPressed, optionTextColorDisabled: textColorDisabled, optionTextColorActive: primaryColor, optionOpacityDisabled: opacityDisabled, optionCheckColor: primaryColor, optionColorPending: hoverColor, optionColorActive: hoverColor, actionTextColor: textColor2, loadingColor: primaryColor });
};
const internalSelectMenuLight = createTheme({
    name: 'InternalSelectMenu',
    common: commonLight,
    peers: {
        Scrollbar: scrollbarLight$1,
        Empty: emptyLight$1
    },
    self: self$7
});
var internalSelectMenuLight$1 = internalSelectMenuLight;

var NInternalSelectMenu = defineComponent({
    name: 'InternalSelectMenu',
    props: Object.assign(Object.assign({}, useTheme.props), { clsPrefix: {
            type: String,
            required: true
        }, scrollable: {
            type: Boolean,
            default: true
        }, treeMate: {
            type: Object,
            required: true
        }, multiple: Boolean, size: {
            type: String,
            default: 'medium'
        }, value: {
            type: [String, Number, Array],
            default: null
        }, width: [Number, String], autoPending: Boolean, virtualScroll: {
            type: Boolean,
            default: true
        }, 
        // show is used to toggle pending state initialization
        show: {
            type: Boolean,
            default: true
        }, loading: Boolean, focusable: Boolean, renderLabel: Function, renderOption: Function, onMousedown: Function, onScroll: Function, onFocus: Function, onBlur: Function, onKeyup: Function, onKeydown: Function, onTabOut: Function, onMouseenter: Function, onMouseleave: Function, 
        // deprecated
        onToggle: Function }),
    setup(props) {
        const themeRef = useTheme('InternalSelectMenu', 'InternalSelectMenu', style$6, internalSelectMenuLight$1, props, toRef(props, 'clsPrefix'));
        const selfRef = ref(null);
        const virtualListRef = ref(null);
        const scrollbarRef = ref(null);
        const flattenedNodesRef = computed(() => props.treeMate.getFlattenedNodes());
        const fIndexGetterRef = computed(() => createIndexGetter(flattenedNodesRef.value));
        const pendingNodeRef = ref(null);
        function initPendingNode() {
            const { treeMate } = props;
            setPendingTmNode(props.autoPending
                ? props.value === null
                    ? treeMate.getFirstAvailableNode()
                    : props.multiple
                        ? treeMate.getNode((props.value || [])[(props.value || [])
                            .length - 1]) || treeMate.getFirstAvailableNode()
                        : treeMate.getNode(props.value) ||
                            treeMate.getFirstAvailableNode()
                : null);
        }
        initPendingNode();
        onMounted(() => {
            watchEffect(() => {
                if (props.show) {
                    initPendingNode();
                    void nextTick(scrollToPendingNode);
                }
            });
        });
        const itemSizeRef = computed(() => {
            return depx(themeRef.value.self[createKey('optionHeight', props.size)]);
        });
        const paddingRef = computed(() => {
            return getMargin(themeRef.value.self[createKey('padding', props.size)]);
        });
        const valueSetRef = computed(() => {
            if (props.multiple && Array.isArray(props.value)) {
                return new Set(props.value);
            }
            return new Set();
        });
        const emptyRef = computed(() => {
            const tmNodes = flattenedNodesRef.value;
            return tmNodes && tmNodes.length === 0;
        });
        const styleRef = computed(() => {
            return [{ width: formatLength(props.width) }, cssVarsRef.value];
        });
        watch(toRef(props, 'treeMate'), () => {
            if (props.autoPending) {
                const tmNode = props.treeMate.getFirstAvailableNode();
                setPendingTmNode(tmNode);
            }
            else {
                setPendingTmNode(null);
            }
        });
        function doToggle(tmNode) {
            const { onToggle } = props;
            if (onToggle)
                onToggle(tmNode);
        }
        function doScroll(e) {
            const { onScroll } = props;
            if (onScroll)
                onScroll(e);
        }
        // required, scroller sync need to be triggered manually
        function handleVirtualListScroll(e) {
            var _a;
            (_a = scrollbarRef.value) === null || _a === void 0 ? void 0 : _a.sync();
            doScroll(e);
        }
        function handleVirtualListResize() {
            var _a;
            (_a = scrollbarRef.value) === null || _a === void 0 ? void 0 : _a.sync();
        }
        function getPendingTmNode() {
            const { value: pendingTmNode } = pendingNodeRef;
            if (pendingTmNode)
                return pendingTmNode;
            return null;
        }
        function handleOptionMouseEnter(e, tmNode) {
            if (tmNode.disabled)
                return;
            setPendingTmNode(tmNode, false);
        }
        function handleOptionClick(e, tmNode) {
            if (tmNode.disabled)
                return;
            doToggle(tmNode);
        }
        // keyboard related methods
        function handleKeyUp(e) {
            var _a;
            if (happensIn(e, 'action'))
                return;
            (_a = props.onKeyup) === null || _a === void 0 ? void 0 : _a.call(props, e);
        }
        function handleKeyDown(e) {
            var _a;
            if (happensIn(e, 'action'))
                return;
            (_a = props.onKeydown) === null || _a === void 0 ? void 0 : _a.call(props, e);
        }
        function handleMouseDown(e) {
            var _a;
            (_a = props.onMousedown) === null || _a === void 0 ? void 0 : _a.call(props, e);
            if (props.focusable)
                return;
            e.preventDefault();
        }
        function next() {
            const { value: pendingTmNode } = pendingNodeRef;
            if (pendingTmNode) {
                setPendingTmNode(pendingTmNode.getNext({ loop: true }), true);
            }
        }
        function prev() {
            const { value: pendingTmNode } = pendingNodeRef;
            if (pendingTmNode) {
                setPendingTmNode(pendingTmNode.getPrev({ loop: true }), true);
            }
        }
        function setPendingTmNode(tmNode, doScroll = false) {
            pendingNodeRef.value = tmNode;
            if (doScroll)
                scrollToPendingNode();
        }
        function scrollToPendingNode() {
            var _a, _b;
            const tmNode = pendingNodeRef.value;
            if (!tmNode)
                return;
            const fIndex = fIndexGetterRef.value(tmNode.key);
            if (fIndex === null)
                return;
            if (props.virtualScroll) {
                (_a = virtualListRef.value) === null || _a === void 0 ? void 0 : _a.scrollTo({ index: fIndex });
            }
            else {
                (_b = scrollbarRef.value) === null || _b === void 0 ? void 0 : _b.scrollTo({
                    index: fIndex,
                    elSize: itemSizeRef.value
                });
            }
        }
        function handleFocusin(e) {
            var _a, _b;
            if ((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.target)) {
                (_b = props.onFocus) === null || _b === void 0 ? void 0 : _b.call(props, e);
            }
        }
        function handleFocusout(e) {
            var _a, _b;
            if (!((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.relatedTarget))) {
                (_b = props.onBlur) === null || _b === void 0 ? void 0 : _b.call(props, e);
            }
        }
        provide(internalSelectionMenuInjectionKey, {
            handleOptionMouseEnter,
            handleOptionClick,
            valueSetRef,
            multipleRef: toRef(props, 'multiple'),
            valueRef: toRef(props, 'value'),
            renderLabelRef: toRef(props, 'renderLabel'),
            renderOptionRef: toRef(props, 'renderOption'),
            pendingTmNodeRef: pendingNodeRef
        });
        provide(internalSelectionMenuBodyInjectionKey, selfRef);
        onMounted(() => {
            const { value } = scrollbarRef;
            if (value)
                value.sync();
        });
        const cssVarsRef = computed(() => {
            const { size } = props;
            const { common: { cubicBezierEaseInOut }, self: { height, borderRadius, color, groupHeaderTextColor, actionDividerColor, optionTextColorPressed, optionTextColor, optionTextColorDisabled, optionTextColorActive, optionOpacityDisabled, optionCheckColor, actionTextColor, optionColorPending, optionColorActive, loadingColor, loadingSize, [createKey('optionFontSize', size)]: fontSize, [createKey('optionHeight', size)]: optionHeight, [createKey('optionPadding', size)]: optionPadding } } = themeRef.value;
            return {
                '--height': height,
                '--action-divider-color': actionDividerColor,
                '--action-text-color': actionTextColor,
                '--bezier': cubicBezierEaseInOut,
                '--border-radius': borderRadius,
                '--color': color,
                '--option-font-size': fontSize,
                '--group-header-text-color': groupHeaderTextColor,
                '--option-check-color': optionCheckColor,
                '--option-color-pending': optionColorPending,
                '--option-color-active': optionColorActive,
                '--option-height': optionHeight,
                '--option-opacity-disabled': optionOpacityDisabled,
                '--option-text-color': optionTextColor,
                '--option-text-color-active': optionTextColorActive,
                '--option-text-color-disabled': optionTextColorDisabled,
                '--option-text-color-pressed': optionTextColorPressed,
                '--option-padding': optionPadding,
                '--option-padding-left': getMargin(optionPadding, 'left'),
                '--loading-color': loadingColor,
                '--loading-size': loadingSize
            };
        });
        const exposedProps = {
            selfRef,
            next,
            prev,
            getPendingTmNode
        };
        return Object.assign({ mergedTheme: themeRef, virtualListRef,
            scrollbarRef, style: styleRef, itemSize: itemSizeRef, padding: paddingRef, flattenedNodes: flattenedNodesRef, empty: emptyRef, virtualListContainer() {
                const { value } = virtualListRef;
                return value === null || value === void 0 ? void 0 : value.listElRef;
            },
            virtualListContent() {
                const { value } = virtualListRef;
                return value === null || value === void 0 ? void 0 : value.itemsElRef;
            },
            doScroll,
            handleFocusin,
            handleFocusout,
            handleKeyUp,
            handleKeyDown,
            handleMouseDown,
            handleVirtualListResize,
            handleVirtualListScroll }, exposedProps);
    },
    render() {
        const { $slots, virtualScroll, clsPrefix, mergedTheme } = this;
        return (h("div", { ref: "selfRef", tabindex: this.focusable ? 0 : -1, class: [
                `${clsPrefix}-base-select-menu`,
                this.multiple && `${clsPrefix}-base-select-menu--multiple`
            ], style: this.style, onFocusin: this.handleFocusin, onFocusout: this.handleFocusout, onKeyup: this.handleKeyUp, onKeydown: this.handleKeyDown, onMousedown: this.handleMouseDown, onMouseenter: this.onMouseenter, onMouseleave: this.onMouseleave },
            this.loading ? (h("div", { class: `${clsPrefix}-base-select-menu__loading` },
                h(NBaseLoading, { clsPrefix: clsPrefix, strokeWidth: 20 }))) : !this.empty ? (h(NScrollbar, { ref: "scrollbarRef", theme: mergedTheme.peers.Scrollbar, themeOverrides: mergedTheme.peerOverrides.Scrollbar, scrollable: this.scrollable, container: virtualScroll ? this.virtualListContainer : undefined, content: virtualScroll ? this.virtualListContent : undefined, onScroll: virtualScroll ? undefined : this.doScroll }, {
                default: () => {
                    return virtualScroll ? (h(VVirtualList, { ref: "virtualListRef", class: `${clsPrefix}-virtual-list`, items: this.flattenedNodes, itemSize: this.itemSize, showScrollbar: false, paddingTop: this.padding.top, paddingBottom: this.padding.bottom, onResize: this.handleVirtualListResize, onScroll: this.handleVirtualListScroll, itemResizable: true }, {
                        default: ({ item: tmNode }) => {
                            return tmNode.isGroup ? (h(NSelectGroupHeader, { key: tmNode.key, clsPrefix: clsPrefix, tmNode: tmNode })) : tmNode.ignored ? null : (h(NSelectOption, { clsPrefix: clsPrefix, key: tmNode.key, tmNode: tmNode }));
                        }
                    })) : (h("div", { class: `${clsPrefix}-base-select-menu-option-wrapper`, style: {
                            paddingTop: this.padding.top,
                            paddingBottom: this.padding.bottom
                        } }, this.flattenedNodes.map((tmNode) => tmNode.isGroup ? (h(NSelectGroupHeader, { key: tmNode.key, clsPrefix: clsPrefix, tmNode: tmNode })) : (h(NSelectOption, { clsPrefix: clsPrefix, key: tmNode.key, tmNode: tmNode })))));
                }
            })) : (h("div", { class: `${clsPrefix}-base-select-menu__empty` }, renderSlot($slots, 'empty', undefined, () => [
                h(NEmpty, { theme: mergedTheme.peers.Empty, themeOverrides: mergedTheme.peerOverrides.Empty })
            ]))),
            $slots.action && (h("div", { class: `${clsPrefix}-base-select-menu__action`, "data-action": true }, renderSlot($slots, 'action'))),
            $slots.action && h(FocusDetector, { onFocus: this.onTabOut })));
    }
});

var commonVariables$1 = {
    space: '6px',
    spaceArrow: '10px',
    arrowOffset: '10px',
    arrowOffsetVertical: '10px',
    arrowHeight: '6px',
    padding: '8px 14px'
};

const self$6 = (vars) => {
    const { boxShadow2, popoverColor, textColor2, borderRadius, fontSize, dividerColor } = vars;
    return Object.assign(Object.assign({}, commonVariables$1), { fontSize,
        borderRadius, color: popoverColor, dividerColor, textColor: textColor2, boxShadow: boxShadow2 });
};
const popoverLight = {
    name: 'Popover',
    common: commonLight,
    self: self$6
};
var popoverLight$1 = popoverLight;

const oppositePlacement = {
  top: 'bottom',
  bottom: 'top',
  left: 'right',
  right: 'left'
}; // vars:
// --bezier
// --bezier-ease-in
// --bezier-ease-out
// --font-size
// --text-color
// --color
// --border-radius
// --arrow-height
// --arrow-offset
// --arrow-offset-vertical
// --padding
// --space
// --space-arrow
// --divider-color

var style$5 = c$1([cB('popover', `
 transition:
 box-shadow .3s var(--bezier),
 background-color .3s var(--bezier),
 color .3s var(--bezier);
 transform-origin: inherit;
 position: relative;
 font-size: var(--font-size);
 color: var(--text-color);
 box-shadow: var(--box-shadow);
 `, [// body transition
c$1('&.popover-transition-enter-from, &.popover-transition-leave-to', `
 opacity: 0;
 transform: scale(.85);
 `), c$1('&.popover-transition-enter-to, &.popover-transition-leave-from', `
 transform: scale(1);
 opacity: 1;
 `), c$1('&.popover-transition-enter-active', `
 transition:
 opacity .15s var(--bezier-ease-out),
 transform .15s var(--bezier-ease-out);
 `), c$1('&.popover-transition-leave-active', `
 transition:
 opacity .15s var(--bezier-ease-in),
 transform .15s var(--bezier-ease-in);
 `), cNotM('raw', `
 background-color: var(--color);
 border-radius: var(--border-radius);
 var(--padding);
 `, [cNotM('show-header', 'padding: var(--padding);')]), cE('header', `
 padding: var(--padding);
 border-bottom: 1px solid var(--divider-color);
 transition: border-color .3s var(--bezier);
 `), cE('content', `
 padding: var(--padding);
 `), cB('popover-arrow-wrapper', `
 position: absolute;
 overflow: hidden;
 pointer-events: none;
 `, [cB('popover-arrow', `
 transition: background-color .3s var(--bezier);
 position: absolute;
 display: block;
 width: calc(var(--arrow-height) * 1.414);
 height: calc(var(--arrow-height) * 1.414);
 box-shadow: 0 0 8px 0 rgba(0, 0, 0, .12);
 transform: rotate(45deg);
 background-color: var(--color);
 pointer-events: all;
 `)])]), placementStyle('top-start', `
 top: calc(-0.707 * var(--arrow-height));
 left: var(--arrow-offset);
 `), placementStyle('top', `
 top: calc(-0.707 * var(--arrow-height));
 transform: translateX(calc(-0.707 * var(--arrow-height))) rotate(45deg);
 left: 50%;
 `), placementStyle('top-end', `
 top: calc(-0.707 * var(--arrow-height));
 right: var(--arrow-offset);
 `), placementStyle('bottom-start', `
 bottom: calc(-0.707 * var(--arrow-height));
 left: var(--arrow-offset);
 `), placementStyle('bottom', `
 bottom: calc(-0.707 * var(--arrow-height));
 transform: translateX(calc(-0.707 * var(--arrow-height))) rotate(45deg);
 left: 50%;
 `), placementStyle('bottom-end', `
 bottom: calc(-0.707 * var(--arrow-height));
 right: var(--arrow-offset);
 `), placementStyle('left-start', `
 left: calc(-0.707 * var(--arrow-height));
 top: var(--arrow-offset-vertical);
 `), placementStyle('left', `
 left: calc(-0.707 * var(--arrow-height));
 transform: translateY(calc(-0.707 * var(--arrow-height))) rotate(45deg);
 top: 50%;
 `), placementStyle('left-end', `
 left: calc(-0.707 * var(--arrow-height));
 bottom: var(--arrow-offset-vertical);
 `), placementStyle('right-start', `
 right: calc(-0.707 * var(--arrow-height));
 top: var(--arrow-offset-vertical);
 `), placementStyle('right', `
 right: calc(-0.707 * var(--arrow-height));
 transform: translateY(calc(-0.707 * var(--arrow-height))) rotate(45deg);
 top: 50%;
 `), placementStyle('right-end', `
 right: calc(-0.707 * var(--arrow-height));
 bottom: var(--arrow-offset-vertical);
 `)]);

function placementStyle(placement, arrowStyleLiteral) {
  const position = placement.split('-')[0];
  const sizeStyle = ['top', 'bottom'].includes(position) ? 'height: var(--space-arrow);' : 'width: var(--space-arrow);';
  return c$1(`[v-placement="${placement}"] >`, [cB('popover', `
 margin-${oppositePlacement[position]}: var(--space);
 `, [cM('show-arrow', `
 margin-${oppositePlacement[position]}: var(--space-arrow);
 `), cM('overlap', `
 margin: 0;
 `), cCB('popover-arrow-wrapper', `
 right: 0;
 left: 0;
 top: 0;
 bottom: 0;
 ${position}: 100%;
 ${oppositePlacement[position]}: auto;
 ${sizeStyle}
 `, [cB('popover-arrow', arrowStyleLiteral)])])]);
}

const popoverBodyProps = Object.assign(Object.assign({}, useTheme.props), { to: useAdjustedTo.propTo, show: Boolean, trigger: String, showArrow: Boolean, delay: Number, duration: Number, raw: Boolean, arrowStyle: [String, Object], displayDirective: String, x: Number, y: Number, filp: Boolean, overlap: Boolean, placement: String, width: [Number, String], 
    // private
    animated: Boolean, onClickoutside: Function, 
    /** @deprecated */
    minWidth: Number, maxWidth: Number });
const renderArrow = ({ arrowStyle, clsPrefix }) => {
    return (h("div", { key: "__popover-arrow__", class: `${clsPrefix}-popover-arrow-wrapper` },
        h("div", { class: `${clsPrefix}-popover-arrow`, style: arrowStyle })));
};
var NPopoverBody = defineComponent({
    name: 'PopoverBody',
    inheritAttrs: false,
    props: popoverBodyProps,
    setup(props, { slots, attrs }) {
        const { namespaceRef, mergedClsPrefixRef } = useConfig(props);
        const themeRef = useTheme('Popover', 'Popover', style$5, popoverLight$1, props, mergedClsPrefixRef);
        const followerRef = ref(null);
        const NPopover = inject('NPopover');
        const bodyRef = ref(null);
        const followerEnabledRef = ref(props.show);
        const directivesRef = computed(() => {
            const { trigger, onClickoutside } = props;
            const directives = [];
            const { positionManuallyRef: { value: positionManually } } = NPopover;
            if (!positionManually) {
                if (trigger === 'click' && !onClickoutside) {
                    directives.push([clickoutside$1, handleClickOutside]);
                }
                if (trigger === 'hover') {
                    directives.push([mousemoveoutside$1, handleMouseMoveOutside]);
                }
            }
            if (onClickoutside) {
                directives.push([clickoutside$1, handleClickOutside]);
            }
            if (props.displayDirective === 'show') {
                directives.push([vShow, props.show]);
            }
            return directives;
        });
        const styleRef = computed(() => {
            return [
                {
                    width: props.width === 'trigger' ? '' : formatLength(props.width),
                    maxWidth: formatLength(props.maxWidth),
                    minWidth: formatLength(props.minWidth)
                },
                cssVarsRef.value
            ];
        });
        const cssVarsRef = computed(() => {
            const { common: { cubicBezierEaseInOut, cubicBezierEaseIn, cubicBezierEaseOut }, self: { space, spaceArrow, padding, fontSize, textColor, dividerColor, color, boxShadow, borderRadius, arrowHeight, arrowOffset, arrowOffsetVertical } } = themeRef.value;
            return {
                '--box-shadow': boxShadow,
                '--bezier': cubicBezierEaseInOut,
                '--bezier-ease-in': cubicBezierEaseIn,
                '--bezier-ease-out': cubicBezierEaseOut,
                '--font-size': fontSize,
                '--text-color': textColor,
                '--color': color,
                '--divider-color': dividerColor,
                '--border-radius': borderRadius,
                '--arrow-height': arrowHeight,
                '--arrow-offset': arrowOffset,
                '--arrow-offset-vertical': arrowOffsetVertical,
                '--padding': padding,
                '--space': space,
                '--space-arrow': spaceArrow
            };
        });
        NPopover.setBodyInstance({
            syncPosition
        });
        onBeforeUnmount(() => {
            NPopover.setBodyInstance(null);
        });
        watch(toRef(props, 'show'), (value) => {
            // If no animation, no transition component will be applied to the
            // component. So we need to trigger follower manaully.
            if (props.animated)
                return;
            if (value) {
                followerEnabledRef.value = true;
            }
            else {
                followerEnabledRef.value = false;
            }
        });
        function syncPosition() {
            var _a;
            // eslint-disable-next-line no-unused-expressions
            (_a = followerRef.value) === null || _a === void 0 ? void 0 : _a.syncPosition();
        }
        function handleMouseEnter(e) {
            if (props.trigger === 'hover') {
                NPopover.handleMouseEnter(e);
            }
        }
        function handleMouseLeave(e) {
            if (props.trigger === 'hover') {
                NPopover.handleMouseLeave(e);
            }
        }
        function handleMouseMoveOutside(e) {
            if (props.trigger === 'hover' &&
                !getTriggerElement().contains(e.target)) {
                NPopover.handleMouseMoveOutside(e);
            }
        }
        function handleClickOutside(e) {
            if ((props.trigger === 'click' &&
                !getTriggerElement().contains(e.target)) ||
                props.onClickoutside) {
                NPopover.handleClickOutside(e);
            }
        }
        function getTriggerElement() {
            return NPopover.getTriggerElement();
        }
        provide(popoverBodyInjectionKey, bodyRef);
        provide(drawerBodyInjectionKey, null);
        provide(modalBodyInjectionKey, null);
        function renderContentNode() {
            let contentNode;
            const { internalRenderBodyRef: { value: renderBody } } = NPopover;
            const { value: mergedClsPrefix } = mergedClsPrefixRef;
            if (!renderBody) {
                const { value: extraClass } = NPopover.extraClassRef;
                contentNode = h('div', mergeProps({
                    class: [
                        `${mergedClsPrefix}-popover`,
                        extraClass.map((v) => `${mergedClsPrefix}-${v}`),
                        {
                            [`${mergedClsPrefix}-popover--overlap`]: props.overlap,
                            [`${mergedClsPrefix}-popover--show-arrow`]: props.showArrow,
                            [`${mergedClsPrefix}-popover--show-header`]: !!slots.header,
                            [`${mergedClsPrefix}-popover--raw`]: props.raw
                        }
                    ],
                    ref: bodyRef,
                    style: styleRef.value,
                    onMouseenter: handleMouseEnter,
                    onMouseleave: handleMouseLeave
                }, attrs), [
                    slots.header ? (h(Fragment, null,
                        h("div", { class: `${mergedClsPrefix}-popover__header` }, slots.header()),
                        h("div", { class: `${mergedClsPrefix}-popover__content` }, slots))) : (renderSlot(slots, 'default')),
                    props.showArrow
                        ? renderArrow({
                            arrowStyle: props.arrowStyle,
                            clsPrefix: mergedClsPrefix
                        })
                        : null
                ]);
            }
            else {
                contentNode = renderBody(
                // The popover class and overlap class must exists, they will be used
                // to place the body & transition animation.
                // Shadow class exists for reuse box-shadow.
                [
                    `${mergedClsPrefix}-popover`,
                    props.overlap && `${mergedClsPrefix}-popover--overlap`
                ], bodyRef, styleRef.value, handleMouseEnter, handleMouseLeave);
            }
            return props.displayDirective === 'show' || props.show
                ? withDirectives(contentNode, directivesRef.value)
                : null;
        }
        return {
            namespace: namespaceRef,
            isMounted: NPopover.isMountedRef,
            zIndex: NPopover.zIndexRef,
            followerRef,
            adjustedTo: useAdjustedTo(props),
            followerEnabled: followerEnabledRef,
            renderContentNode
        };
    },
    render() {
        return h(VFollower, {
            zIndex: this.zIndex,
            show: this.show,
            enabled: this.followerEnabled,
            to: this.adjustedTo,
            x: this.x,
            y: this.y,
            placement: this.placement,
            containerClass: this.namespace,
            ref: 'followerRef',
            overlap: this.overlap,
            width: this.width === 'trigger' ? 'target' : undefined,
            teleportDisabled: this.adjustedTo === useAdjustedTo.tdkey
        }, {
            default: () => {
                return this.animated
                    ? h(Transition, {
                        name: 'popover-transition',
                        appear: this.isMounted,
                        // Don't use watch to enable follower, since the transition may
                        // make position sync timing very subtle and buggy.
                        onEnter: () => {
                            this.followerEnabled = true;
                        },
                        onAfterLeave: () => {
                            this.followerEnabled = false;
                        }
                    }, {
                        default: this.renderContentNode
                    })
                    : this.renderContentNode();
            }
        });
    }
});

const bodyPropKeys = Object.keys(popoverBodyProps);
const triggerEventMap = {
    focus: ['onFocus', 'onBlur'],
    click: ['onClick'],
    hover: ['onMouseenter', 'onMouseleave'],
    manual: [],
    nested: ['onFocus', 'onBlur', 'onMouseenter', 'onMouseleave', 'onClick']
};
function appendEvents(vNode, trigger, events) {
    triggerEventMap[trigger].forEach((eventName) => {
        if (!vNode.props)
            vNode.props = {};
        else {
            vNode.props = Object.assign({}, vNode.props);
        }
        const originalHandler = vNode.props[eventName];
        const handler = events[eventName];
        if (!originalHandler)
            vNode.props[eventName] = handler;
        else {
            vNode.props[eventName] = (...args) => {
                originalHandler(...args);
                handler(...args);
            };
        }
    });
}
const textVNodeType = createTextVNode('').type;
const popoverBaseProps = {
    show: {
        type: Boolean,
        default: undefined
    },
    defaultShow: Boolean,
    showArrow: {
        type: Boolean,
        default: true
    },
    trigger: {
        type: String,
        default: 'hover'
    },
    delay: {
        type: Number,
        default: 100
    },
    duration: {
        type: Number,
        default: 100
    },
    raw: Boolean,
    placement: {
        type: String,
        default: 'top'
    },
    x: Number,
    y: Number,
    disabled: Boolean,
    getDisabled: Function,
    displayDirective: {
        type: String,
        default: 'if'
    },
    arrowStyle: [String, Object],
    filp: {
        type: Boolean,
        default: true
    },
    animated: {
        type: Boolean,
        default: true
    },
    width: {
        type: [Number, String],
        default: undefined
    },
    overlap: Boolean,
    internalExtraClass: {
        type: Array,
        default: () => []
    },
    onClickoutside: Function,
    // events
    'onUpdate:show': [Function, Array],
    onUpdateShow: [Function, Array],
    zIndex: Number,
    to: useAdjustedTo.propTo,
    internalSyncTargetWithParent: Boolean,
    internalInheritedEventHandlers: {
        type: Array,
        default: () => []
    },
    /** @deprecated */
    onShow: [Function, Array],
    /** @deprecated */
    onHide: [Function, Array],
    /** @deprecated */
    arrow: {
        type: Boolean,
        default: undefined
    },
    /** @deprecated */
    minWidth: Number,
    /** @deprecated */
    maxWidth: Number
};
const popoverProps = Object.assign(Object.assign(Object.assign({}, useTheme.props), popoverBaseProps), { internalRenderBody: Function });
var NPopover = defineComponent({
    name: 'Popover',
    inheritAttrs: false,
    props: popoverProps,
    __popover__: true,
    setup(props) {
        const isMountedRef = isMounted();
        const binderInstRef = ref(null);
        // setup show
        const controlledShowRef = computed(() => props.show);
        const uncontrolledShowRef = ref(props.defaultShow);
        const mergedShowWithoutDisabledRef = useMergedState(controlledShowRef, uncontrolledShowRef);
        const mergedShowConsideringDisabledPropRef = useMemo(() => {
            if (props.disabled)
                return false;
            return mergedShowWithoutDisabledRef.value;
        });
        const getMergedDisabled = () => {
            if (props.disabled)
                return true;
            const { getDisabled } = props;
            if (getDisabled === null || getDisabled === void 0 ? void 0 : getDisabled())
                return true;
            return false;
        };
        const getMergedShow = () => {
            if (getMergedDisabled())
                return false;
            return mergedShowWithoutDisabledRef.value;
        };
        // setup show-arrow
        const compatibleShowArrowRef = useCompitable(props, ['arrow', 'showArrow']);
        const mergedShowArrowRef = computed(() => {
            if (props.overlap)
                return false;
            return compatibleShowArrowRef.value;
        });
        // bodyInstance
        let bodyInstance = null;
        const showTimerIdRef = ref(null);
        const hideTimerIdRef = ref(null);
        const positionManuallyRef = useMemo(() => {
            return props.x !== undefined && props.y !== undefined;
        });
        // methods
        function doUpdateShow(value) {
            const { 'onUpdate:show': _onUpdateShow, onUpdateShow, onShow, onHide } = props;
            uncontrolledShowRef.value = value;
            if (_onUpdateShow) {
                call(_onUpdateShow, value);
            }
            if (onUpdateShow) {
                call(onUpdateShow, value);
            }
            if (value && onShow) {
                call(onShow, true);
            }
            if (value && onHide) {
                call(onHide, false);
            }
        }
        function syncPosition() {
            if (bodyInstance) {
                bodyInstance.syncPosition();
            }
        }
        function clearShowTimer() {
            const { value: showTimerId } = showTimerIdRef;
            if (showTimerId) {
                window.clearTimeout(showTimerId);
                showTimerIdRef.value = null;
            }
        }
        function clearHideTimer() {
            const { value: hideTimerId } = hideTimerIdRef;
            if (hideTimerId) {
                window.clearTimeout(hideTimerId);
                hideTimerIdRef.value = null;
            }
        }
        function handleFocus() {
            const mergedDisabled = getMergedDisabled();
            if (props.trigger === 'focus' && !mergedDisabled) {
                if (getMergedShow())
                    return;
                doUpdateShow(true);
            }
        }
        function handleBlur() {
            const mergedDisabled = getMergedDisabled();
            if (props.trigger === 'focus' && !mergedDisabled) {
                if (!getMergedShow())
                    return;
                doUpdateShow(false);
            }
        }
        function handleMouseEnter() {
            const mergedDisabled = getMergedDisabled();
            if (props.trigger === 'hover' && !mergedDisabled) {
                clearHideTimer();
                if (showTimerIdRef.value !== null)
                    return;
                if (getMergedShow())
                    return;
                const delayCallback = () => {
                    doUpdateShow(true);
                    showTimerIdRef.value = null;
                };
                const { delay } = props;
                if (delay === 0) {
                    delayCallback();
                }
                else {
                    showTimerIdRef.value = window.setTimeout(delayCallback, delay);
                }
            }
        }
        function handleMouseLeave() {
            const mergedDisabled = getMergedDisabled();
            if (props.trigger === 'hover' && !mergedDisabled) {
                clearShowTimer();
                if (hideTimerIdRef.value !== null)
                    return;
                if (!getMergedShow())
                    return;
                const delayedCallback = () => {
                    doUpdateShow(false);
                    hideTimerIdRef.value = null;
                };
                const { duration } = props;
                if (duration === 0) {
                    delayedCallback();
                }
                else {
                    hideTimerIdRef.value = window.setTimeout(delayedCallback, duration);
                }
            }
        }
        // will be called in popover-content
        function handleMouseMoveOutside() {
            handleMouseLeave();
        }
        // will be called in popover-content
        function handleClickOutside(e) {
            var _a;
            if (!getMergedShow())
                return;
            if (props.trigger === 'click') {
                clearShowTimer();
                clearHideTimer();
                doUpdateShow(false);
            }
            (_a = props.onClickoutside) === null || _a === void 0 ? void 0 : _a.call(props, e);
        }
        function handleClick() {
            if (props.trigger === 'click' && !getMergedDisabled()) {
                clearShowTimer();
                clearHideTimer();
                const nextShow = !getMergedShow();
                doUpdateShow(nextShow);
            }
        }
        function setShow(value) {
            uncontrolledShowRef.value = value;
        }
        function getTriggerElement() {
            var _a;
            return (_a = binderInstRef.value) === null || _a === void 0 ? void 0 : _a.targetRef;
        }
        function setBodyInstance(value) {
            bodyInstance = value;
        }
        provide('NPopover', {
            getTriggerElement,
            handleMouseEnter,
            handleMouseLeave,
            handleClickOutside,
            handleMouseMoveOutside,
            setBodyInstance,
            positionManuallyRef: positionManuallyRef,
            isMountedRef: isMountedRef,
            zIndexRef: toRef(props, 'zIndex'),
            extraClassRef: toRef(props, 'internalExtraClass'),
            internalRenderBodyRef: toRef(props, 'internalRenderBody')
        });
        return {
            binderInstRef,
            positionManually: positionManuallyRef,
            mergedShowConsideringDisabledProp: mergedShowConsideringDisabledPropRef,
            // if to show popover body
            uncontrolledShow: uncontrolledShowRef,
            mergedShowArrow: mergedShowArrowRef,
            getMergedShow,
            setShow,
            handleClick,
            handleMouseEnter,
            handleMouseLeave,
            handleFocus,
            handleBlur,
            syncPosition
        };
    },
    render() {
        var _a;
        const { positionManually, $slots: slots } = this;
        let triggerVNode;
        let popoverInside = false;
        if (!positionManually) {
            if (slots.activator) {
                triggerVNode = getFirstSlotVNode(slots, 'activator');
            }
            else {
                triggerVNode = getFirstSlotVNode(slots, 'trigger');
            }
            if (triggerVNode) {
                triggerVNode = cloneVNode(triggerVNode);
                triggerVNode =
                    triggerVNode.type === textVNodeType
                        ? h('span', [triggerVNode])
                        : triggerVNode;
                const handlers = {
                    onClick: this.handleClick,
                    onMouseenter: this.handleMouseEnter,
                    onMouseleave: this.handleMouseLeave,
                    onFocus: this.handleFocus,
                    onBlur: this.handleBlur
                };
                if ((_a = triggerVNode.type) === null || _a === void 0 ? void 0 : _a.__popover__) {
                    popoverInside = true;
                    // We assume that there's no DOM event handlers on popover element
                    if (!triggerVNode.props) {
                        triggerVNode.props = {
                            internalSyncTargetWithParent: true,
                            internalInheritedEventHandlers: []
                        };
                    }
                    triggerVNode.props.internalSyncTargetWithParent = true;
                    if (!triggerVNode.props.internalInheritedEventHandlers) {
                        triggerVNode.props.internalInheritedEventHandlers = [handlers];
                    }
                    else {
                        triggerVNode.props.internalInheritedEventHandlers = [
                            handlers,
                            ...triggerVNode.props.internalInheritedEventHandlers
                        ];
                    }
                }
                else {
                    const { internalInheritedEventHandlers } = this;
                    const ascendantAndCurrentHandlers = [
                        handlers,
                        ...internalInheritedEventHandlers
                    ];
                    const mergedHandlers = {
                        onBlur: (e) => {
                            ascendantAndCurrentHandlers.forEach((_handlers) => {
                                _handlers.onBlur(e);
                            });
                        },
                        onFocus: (e) => {
                            ascendantAndCurrentHandlers.forEach((_handlers) => {
                                _handlers.onBlur(e);
                            });
                        },
                        onClick: (e) => {
                            ascendantAndCurrentHandlers.forEach((_handlers) => {
                                _handlers.onClick(e);
                            });
                        },
                        onMouseenter: (e) => {
                            ascendantAndCurrentHandlers.forEach((_handlers) => {
                                _handlers.onMouseenter(e);
                            });
                        },
                        onMouseleave: (e) => {
                            ascendantAndCurrentHandlers.forEach((_handlers) => {
                                _handlers.onMouseleave(e);
                            });
                        }
                    };
                    appendEvents(triggerVNode, internalInheritedEventHandlers
                        ? 'nested'
                        : positionManually
                            ? 'manual'
                            : this.trigger, mergedHandlers);
                }
            }
        }
        return (h(VBinder, { ref: "binderInstRef", syncTarget: !popoverInside, syncTargetWithParent: this.internalSyncTargetWithParent }, {
            default: () => {
                // We need to subscribe it. Sometimes rerender won't ge triggered.
                // `mergedShowConsideringDisabledProp` is not the final disabled status.
                // In ellpisis it's dynamic.
                void this.mergedShowConsideringDisabledProp;
                const mergedShow = this.getMergedShow();
                return [
                    positionManually
                        ? null
                        : h(VTarget, null, {
                            default: () => triggerVNode
                        }),
                    h(NPopoverBody, keep(this.$props, bodyPropKeys, Object.assign(Object.assign({}, this.$attrs), { showArrow: this.mergedShowArrow, show: mergedShow })), slots)
                ];
            }
        }));
    }
});

var commonVariables = {
    closeSizeSmall: '14px',
    closeSizeMedium: '14px',
    closeSizeLarge: '14px',
    // closeSize
    padding: '0 7px',
    closeMargin: '0 0 0 3px',
    closeMarginRtl: '0 3px 0 0'
};

const self$5 = (vars) => {
    const { textColor2, primaryColorHover, primaryColorPressed, primaryColor, infoColor, successColor, warningColor, errorColor, baseColor, borderColor, opacityDisabled, tagColor, closeColor, closeColorHover, closeColorPressed, borderRadiusSmall: borderRadius, fontSizeTiny, fontSizeSmall, fontSizeMedium, heightTiny, heightSmall, heightMedium } = vars;
    return Object.assign(Object.assign({}, commonVariables), { heightSmall: heightTiny, heightMedium: heightSmall, heightLarge: heightMedium, borderRadius,
        opacityDisabled, fontSizeSmall: fontSizeTiny, fontSizeMedium: fontSizeSmall, fontSizeLarge: fontSizeMedium, 
        // checked
        textColorCheckable: textColor2, textColorHoverCheckable: primaryColorHover, textColorPressedCheckable: primaryColorPressed, textColorChecked: baseColor, colorCheckable: '#0000', colorHoverCheckable: '#0000', colorPressedCheckable: '#0000', colorChecked: primaryColor, colorCheckedHover: primaryColorHover, colorCheckedPressed: primaryColorPressed, 
        // default
        border: `1px solid ${borderColor}`, textColor: textColor2, color: tagColor, closeColor: closeColor, closeColorHover: closeColorHover, closeColorPressed: closeColorPressed, borderPrimary: `1px solid ${changeColor(primaryColor, { alpha: 0.3 })}`, textColorPrimary: primaryColor, colorPrimary: changeColor(primaryColor, { alpha: 0.1 }), closeColorPrimary: changeColor(primaryColor, { alpha: 0.75 }), closeColorHoverPrimary: changeColor(primaryColor, { alpha: 0.6 }), closeColorPressedPrimary: changeColor(primaryColor, { alpha: 0.9 }), borderInfo: `1px solid ${changeColor(infoColor, { alpha: 0.3 })}`, textColorInfo: infoColor, colorInfo: changeColor(infoColor, { alpha: 0.1 }), closeColorInfo: changeColor(infoColor, { alpha: 0.75 }), closeColorHoverInfo: changeColor(infoColor, { alpha: 0.6 }), closeColorPressedInfo: changeColor(infoColor, { alpha: 0.9 }), borderSuccess: `1px solid ${changeColor(successColor, { alpha: 0.3 })}`, textColorSuccess: successColor, colorSuccess: changeColor(successColor, { alpha: 0.1 }), closeColorSuccess: changeColor(successColor, { alpha: 0.75 }), closeColorHoverSuccess: changeColor(successColor, { alpha: 0.6 }), closeColorPressedSuccess: changeColor(successColor, { alpha: 0.9 }), borderWarning: `1px solid ${changeColor(warningColor, { alpha: 0.35 })}`, textColorWarning: warningColor, colorWarning: changeColor(warningColor, { alpha: 0.12 }), closeColorWarning: changeColor(warningColor, { alpha: 0.75 }), closeColorHoverWarning: changeColor(warningColor, { alpha: 0.6 }), closeColorPressedWarning: changeColor(warningColor, { alpha: 0.9 }), borderError: `1px solid ${changeColor(errorColor, { alpha: 0.23 })}`, textColorError: errorColor, colorError: changeColor(errorColor, { alpha: 0.08 }), closeColorError: changeColor(errorColor, { alpha: 0.65 }), closeColorHoverError: changeColor(errorColor, { alpha: 0.5 }), closeColorPressedError: changeColor(errorColor, { alpha: 0.8 }) });
};
const tagLight = {
    name: 'Tag',
    common: commonLight,
    self: self$5
};
var tagLight$1 = tagLight;

var commonProps = {
    color: Object,
    type: {
        type: String,
        default: 'default'
    },
    round: Boolean,
    size: {
        type: String,
        default: 'medium'
    },
    closable: Boolean,
    disabled: {
        type: Boolean,
        default: undefined
    }
};

// --bezier
// --border-radius
// --border
// --close-color
// --close-color-hover
// --close-color-pressed
// --close-margin
// --close-size
// --color
// --color-checkable
// --color-checked
// --color-checked-hover
// --color-checked-pressed
// --color-hover-checkable
// --color-pressed-checkable
// --font-size
// --height
// --opacity-disabled
// --padding
// --text-color
// --text-color-checkable
// --text-color-checked
// --text-color-hover-checkable
// --text-color-pressed-checkable

var style$4 = cB('tag', `
 white-space: nowrap;
 position: relative;
 box-sizing: border-box;
 cursor: default;
 display: inline-flex;
 align-items: center;
 flex-wrap: nowrap;
 padding: var(--padding);
 border-radius: var(--border-radius);
 color: var(--text-color);
 background-color: var(--color);
 transition: 
 border-color .3s var(--bezier),
 background-color .3s var(--bezier),
 color .3s var(--bezier),
 box-shadow .3s var(--bezier),
 opacity .3s var(--bezier);
 line-height: 1.5;
 height: var(--height);
 font-size: var(--font-size);
`, [cE('border', `
 pointer-events: none;
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 border-radius: inherit;
 border: var(--border);
 transition: border-color .3s var(--bezier);
 `), cE('close', `
 font-size: var(--close-size);
 margin: var(--close-margin);
 transition: color .3s var(--bezier);
 cursor: pointer;
 `), cM('round', `
 padding: 0 calc(var(--height) / 2);
 border-radius: calc(var(--height) / 2);
 `), cM('disabled', {
  cursor: 'not-allowed !important',
  opacity: 'var(--opacity-disabled)'
}), cM('checkable', `
 cursor: pointer;
 box-shadow: none;
 color: var(--text-color-checkable);
 background-color: var(--color-checkable);
 `, [cNotM('disabled', [c$1('&:hover', {
  backgroundColor: 'var(--color-hover-checkable)'
}, [cNotM('checked', {
  color: 'var(--text-color-hover-checkable)'
})]), c$1('&:active', {
  backgroundColor: 'var(--color-pressed-checkable)'
}, [cNotM('checked', {
  color: 'var(--text-color-pressed-checkable)'
})])]), cM('checked', {
  color: 'var(--text-color-checked)',
  backgroundColor: 'var(--color-checked)'
}, [cNotM('disabled', [c$1('&:hover', {
  backgroundColor: 'var(--color-checked-hover)'
}), c$1('&:active', {
  backgroundColor: 'var(--color-checked-pressed)'
})])])])]);

function useRtl(mountId, rtlStateRef, clsPrefixRef) {
    if (!rtlStateRef)
        return undefined;
    const ssrAdapter = useSsrAdapter();
    const componentRtlStateRef = computed(() => {
        const { value: rtlState } = rtlStateRef;
        if (!rtlState) {
            return undefined;
        }
        const componentRtlState = rtlState[mountId];
        if (!componentRtlState) {
            return undefined;
        }
        return componentRtlState;
    });
    const mountStyle = () => {
        watchEffect(() => {
            const { value: clsPrefix } = clsPrefixRef;
            const id = `${clsPrefix}${mountId}Rtl`;
            // if it already exists, we only need to watch clsPrefix, although in most
            // of time it's unnecessary... However we can at least listen less
            // handlers, which is great.
            if (exists(id, ssrAdapter))
                return;
            const { value: componentRtlState } = componentRtlStateRef;
            if (!componentRtlState)
                return;
            componentRtlState.style.mount({
                id,
                head: true,
                props: {
                    bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
                },
                ssr: ssrAdapter
            });
        });
    };
    if (ssrAdapter) {
        mountStyle();
    }
    else {
        onBeforeMount(mountStyle);
    }
    return componentRtlStateRef;
}

const tagProps = Object.assign(Object.assign(Object.assign({}, useTheme.props), commonProps), { bordered: {
        type: Boolean,
        default: undefined
    }, checked: Boolean, checkable: Boolean, onClose: [Array, Function], onMouseenter: Function, onMouseleave: Function, 'onUpdate:checked': Function, onUpdateChecked: Function, 
    // private
    internalStopClickPropagation: Boolean, 
    // deprecated
    onCheckedChange: {
        type: Function,
        validator: () => {
            return true;
        },
        default: undefined
    } });
var NTag = defineComponent({
    name: 'Tag',
    props: tagProps,
    setup(props) {
        const contentRef = ref(null);
        const { mergedBorderedRef, mergedClsPrefixRef, NConfigProvider } = useConfig(props);
        const themeRef = useTheme('Tag', 'Tag', style$4, tagLight$1, props, mergedClsPrefixRef);
        function handleClick(e) {
            if (!props.disabled) {
                if (props.checkable) {
                    const { checked, onCheckedChange, onUpdateChecked, 'onUpdate:checked': _onUpdateChecked } = props;
                    if (onUpdateChecked)
                        onUpdateChecked(!checked);
                    if (_onUpdateChecked)
                        _onUpdateChecked(!checked);
                    // deprecated
                    if (onCheckedChange)
                        onCheckedChange(!checked);
                }
            }
        }
        function handleCloseClick(e) {
            if (props.internalStopClickPropagation) {
                e.stopPropagation();
            }
            if (!props.disabled) {
                const { onClose } = props;
                if (onClose)
                    call(onClose, e);
            }
        }
        const tagPublicMethods = {
            setTextContent(textContent) {
                const { value } = contentRef;
                if (value)
                    value.textContent = textContent;
            }
        };
        const rtlEnabledRef = useRtl('Tag', NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.mergedRtlRef, mergedClsPrefixRef);
        return Object.assign(Object.assign({}, tagPublicMethods), { rtlEnabled: rtlEnabledRef, mergedClsPrefix: mergedClsPrefixRef, contentRef, mergedBordered: mergedBorderedRef, handleClick,
            handleCloseClick, cssVars: computed(() => {
                const { type, size, color: { color, textColor } = {} } = props;
                const { common: { cubicBezierEaseInOut }, self: { padding, closeMargin, closeMarginRtl, borderRadius, opacityDisabled, textColorCheckable, textColorHoverCheckable, textColorPressedCheckable, textColorChecked, colorCheckable, colorHoverCheckable, colorPressedCheckable, colorChecked, colorCheckedHover, colorCheckedPressed, [createKey('closeSize', size)]: closeSize, [createKey('fontSize', size)]: fontSize, [createKey('height', size)]: height, [createKey('color', type)]: typedColor, [createKey('textColor', type)]: typeTextColor, [createKey('border', type)]: border, [createKey('closeColor', type)]: closeColor, [createKey('closeColorHover', type)]: closeColorHover, [createKey('closeColorPressed', type)]: closeColorPressed } } = themeRef.value;
                return {
                    '--bezier': cubicBezierEaseInOut,
                    '--border-radius': borderRadius,
                    '--border': border,
                    '--close-color': closeColor,
                    '--close-color-hover': closeColorHover,
                    '--close-color-pressed': closeColorPressed,
                    '--close-margin': closeMargin,
                    '--close-margin-rtl': closeMarginRtl,
                    '--close-size': closeSize,
                    '--color': color || typedColor,
                    '--color-checkable': colorCheckable,
                    '--color-checked': colorChecked,
                    '--color-checked-hover': colorCheckedHover,
                    '--color-checked-pressed': colorCheckedPressed,
                    '--color-hover-checkable': colorHoverCheckable,
                    '--color-pressed-checkable': colorPressedCheckable,
                    '--font-size': fontSize,
                    '--height': height,
                    '--opacity-disabled': opacityDisabled,
                    '--padding': padding,
                    '--text-color': textColor || typeTextColor,
                    '--text-color-checkable': textColorCheckable,
                    '--text-color-checked': textColorChecked,
                    '--text-color-hover-checkable': textColorHoverCheckable,
                    '--text-color-pressed-checkable': textColorPressedCheckable
                };
            }) });
    },
    render() {
        const { mergedClsPrefix, rtlEnabled, color: { borderColor } = {} } = this;
        return (h("div", { class: [
                `${mergedClsPrefix}-tag`,
                {
                    [`${mergedClsPrefix}-tag--rtl`]: rtlEnabled,
                    [`${mergedClsPrefix}-tag--disabled`]: this.disabled,
                    [`${mergedClsPrefix}-tag--checkable`]: this.checkable,
                    [`${mergedClsPrefix}-tag--checked`]: this.checkable && this.checked,
                    [`${mergedClsPrefix}-tag--round`]: this.round
                }
            ], style: this.cssVars, onClick: this.handleClick, onMouseenter: this.onMouseenter, onMouseleave: this.onMouseleave },
            h("span", { class: `${mergedClsPrefix}-tag__content`, ref: "contentRef" }, this.$slots),
            !this.checkable && this.closable ? (h(NBaseClose, { clsPrefix: mergedClsPrefix, class: `${mergedClsPrefix}-tag__close`, disabled: this.disabled, onClick: this.handleCloseClick })) : null,
            !this.checkable && this.mergedBordered ? (h("div", { class: `${mergedClsPrefix}-tag__border`, style: { borderColor } })) : null));
    }
});

// --bezier
// --clear-color
// --clear-size
// --clear-color-hover
// --clear-color-pressed

var style$3 = cB('base-clear', `
 flex-shrink: 0;
 height: 1em;
 width: 1em;
 position: relative;
`, [c$1('>', [cE('clear', `
 font-size: var(--clear-size);
 cursor: pointer;
 color: var(--clear-color);
 transition: color .3s var(--bezier);
 `, [c$1('&:hover', `
 color: var(--clear-color-hover)!important;
 `), c$1('&:active', `
 color: var(--clear-color-pressed)!important;
 `)]), cE('placeholder', `
 display: flex;
 `), cE('clear, placeholder', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 `, [createIconSwitchTransition({
  originalTransform: 'translateX(-50%) translateY(-50%)',
  left: '50%',
  top: '50%'
})])])]);

var NBaseClear = defineComponent({
    name: 'BaseClear',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        show: Boolean,
        onClear: Function
    },
    setup(props) {
        useStyle('BaseClear', style$3, toRef(props, 'clsPrefix'));
        const { NConfigProvider } = useConfig();
        return {
            NConfigProvider,
            handleMouseDown(e) {
                e.preventDefault();
            }
        };
    },
    render() {
        const { clsPrefix } = this;
        return (h("div", { class: `${clsPrefix}-base-clear` },
            h(NIconSwitchTransition, null, {
                default: () => {
                    return this.show ? (h(NBaseIcon, { clsPrefix: clsPrefix, key: "dismiss", class: `${clsPrefix}-base-clear__clear`, onClick: this.onClear, onMousedown: this.handleMouseDown, "data-clear": true }, {
                        default: () => h(ClearIcon, null)
                    })) : (h("div", { key: "icon", class: `${clsPrefix}-base-clear__placeholder` }, this.$slots));
                }
            })));
    }
});

var NBaseSuffix = defineComponent({
    name: 'InternalSelectionSuffix',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        showArrow: {
            type: Boolean,
            default: undefined
        },
        showClear: {
            type: Boolean,
            default: undefined
        },
        loading: Boolean,
        onClear: Function
    },
    setup(props) {
        return () => {
            const { clsPrefix } = props;
            return (h(NBaseLoading, { clsPrefix: clsPrefix, class: `${clsPrefix}-base-suffix`, strokeWidth: 24, scale: 0.85, show: props.loading }, {
                default: () => props.showArrow ? (h(NBaseClear, { clsPrefix: clsPrefix, show: props.showClear, onClear: props.onClear }, {
                    default: () => (h(NBaseIcon, { clsPrefix: clsPrefix, class: `${clsPrefix}-base-suffix__arrow` }, { default: () => h(ChevronDownIcon, null) }))
                })) : null
            }));
        };
    }
});

var commonVars$1 = {
    paddingSingle: '0 26px 0 14px',
    clearSize: '16px',
    arrowSize: '16px'
};

const self$4 = (vars) => {
    const { borderRadius, textColor2, textColorDisabled, inputColor, inputColorDisabled, primaryColor, primaryColorHover, warningColor, warningColorHover, errorColor, errorColorHover, borderColor, iconColor, iconColorDisabled, clearColor, clearColorHover, clearColorPressed, placeholderColor, placeholderColorDisabled, fontSizeTiny, fontSizeSmall, fontSizeMedium, fontSizeLarge, heightTiny, heightSmall, heightMedium, heightLarge } = vars;
    return Object.assign(Object.assign({}, commonVars$1), { fontSizeTiny,
        fontSizeSmall,
        fontSizeMedium,
        fontSizeLarge,
        heightTiny,
        heightSmall,
        heightMedium,
        heightLarge,
        borderRadius, 
        // default
        textColor: textColor2, textColorDisabled,
        placeholderColor,
        placeholderColorDisabled, color: inputColor, colorDisabled: inputColorDisabled, colorActive: inputColor, border: `1px solid ${borderColor}`, borderHover: `1px solid ${primaryColorHover}`, borderActive: `1px solid ${primaryColor}`, borderFocus: `1px solid ${primaryColorHover}`, boxShadowHover: null, boxShadowActive: `0 0 0 2px ${changeColor(primaryColor, {
            alpha: 0.2
        })}`, boxShadowFocus: `0 0 0 2px ${changeColor(primaryColor, {
            alpha: 0.2
        })}`, caretColor: primaryColor, arrowColor: iconColor, arrowColorDisabled: iconColorDisabled, loadingColor: primaryColor, 
        // warning
        borderWarning: `1px solid ${warningColor}`, borderHoverWarning: `1px solid ${warningColorHover}`, borderActiveWarning: `1px solid ${warningColor}`, borderFocusWarning: `1px solid ${warningColorHover}`, boxShadowHoverWarning: null, boxShadowActiveWarning: `0 0 0 2px ${changeColor(warningColor, {
            alpha: 0.2
        })}`, boxShadowFocusWarning: `0 0 0 2px ${changeColor(warningColor, {
            alpha: 0.2
        })}`, colorActiveWarning: inputColor, caretColorWarning: warningColor, 
        // error
        borderError: `1px solid ${errorColor}`, borderHoverError: `1px solid ${errorColorHover}`, borderActiveError: `1px solid ${errorColor}`, borderFocusError: `1px solid ${errorColorHover}`, boxShadowHoverError: null, boxShadowActiveError: `0 0 0 2px ${changeColor(errorColor, {
            alpha: 0.2
        })}`, boxShadowFocusError: `0 0 0 2px ${changeColor(errorColor, {
            alpha: 0.2
        })}`, colorActiveError: inputColor, caretColorError: errorColor, clearColor,
        clearColorHover,
        clearColorPressed });
};
const internalSelectionLight = createTheme({
    name: 'InternalSelection',
    common: commonLight,
    peers: {
        Popover: popoverLight$1
    },
    self: self$4
});
var internalSelectionLight$1 = internalSelectionLight;

// --bezier
// --border
// --border-active
// --border-focus
// --border-hover
// --border-radius
// --box-shadow-active
// --box-shadow-focus
// --box-shadow-hover
// --caret-color
// --color
// --color-active
// --color-disabled
// --font-size
// --height
// --padding-single
// --placeholder-color
// --placeholder-color-disabled
// --text-color
// --text-color-disabled
// --arrow-color
// --arrow-size
// --loading-color
// ...clear vars
// ...form item vars

var style$2 = c$1([cB('base-selection', `
 position: relative;
 z-index: auto;
 box-shadow: none;
 width: 100%;
 max-width: 100%;
 display: inline-block;
 vertical-align: bottom;
 border-radius: var(--border-radius);
 min-height: var(--height);
 line-height: 1.5;
 font-size: var(--font-size);
 `, [cB('base-loading', `
 color: var(--loading-color);
 `), cB('base-selection-tags', {
  minHeight: 'var(--height)'
}), cE('border, state-border', `
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 pointer-events: none;
 border: var(--border);
 border-radius: inherit;
 transition:
 box-shadow .3s var(--bezier),
 border-color .3s var(--bezier);
 `), cE('state-border', `
 z-index: 1;
 border-color: #0000;
 `), cB('base-suffix', `
 cursor: pointer;
 position: absolute;
 top: 50%;
 transform: translateY(-50%);
 right: 10px;
 `, [cE('arrow', `
 font-size: var(--arrow-size);
 color: var(--arrow-color);
 transition: color .3s var(--bezier);
 `)]), cB('base-selection-overlay', `
 display: flex;
 align-items: center;
 white-space: nowrap;
 overflow: hidden;
 pointer-events: none;
 position: absolute;
 top: 0;
 right: 0;
 bottom: 0;
 left: 0;
 padding: var(--padding-single);
 transition: color .3s var(--bezier);
 `), cB('base-selection-placeholder', `
 color: var(--placeholder-color);
 `), cB('base-selection-tags', `
 cursor: pointer;
 outline: none;
 box-sizing: border-box;
 position: relative;
 z-index: auto;
 display: flex;
 padding: 3px 26px 0 14px;
 flex-wrap: wrap;
 align-items: center;
 width: 100%;
 vertical-align: bottom;
 background-color: var(--color);
 border-radius: inherit;
 transition:
 color .3s var(--bezier),
 box-shadow .3s var(--bezier),
 background-color .3s var(--bezier);
 `), cB('base-selection-label', `
 height: var(--height);
 display: inline-flex;
 width: 100%;
 vertical-align: bottom;
 cursor: pointer;
 outline: none;
 z-index: auto;
 box-sizing: border-box;
 position: relative;
 transition:
 color .3s var(--bezier),
 box-shadow .3s var(--bezier),
 background-color .3s var(--bezier);
 border-radius: inherit;
 background-color: var(--color);
 align-items: center;
 `, [cB('base-selection-input', `
 line-height: inherit;
 outline: none;
 cursor: pointer;
 box-sizing: border-box;
 border:none;
 width: 100%;
 padding: var(--padding-single);
 background-color: #0000;
 color: var(--text-color);
 transition: color .3s var(--bezier);
 caret-color: var(--caret-color);
 `, [cE('content', `
 text-overflow: ellipsis;
 overflow: hidden;
 white-space: nowrap; 
 `)]), cE('render-label', `
 color: var(--text-color);
 `)]), cNotM('disabled', [c$1('&:hover', [cE('state-border', `
 box-shadow: var(--box-shadow-hover);
 border: var(--border-hover);
 `)]), cM('focus', [cE('state-border', `
 box-shadow: var(--box-shadow-focus);
 border: var(--border-focus);
 `)]), cM('active', [cE('state-border', `
 box-shadow: var(--box-shadow-active);
 border: var(--border-active);
 `), cB('base-selection-label', {
  backgroundColor: 'var(--color-active)'
}), cB('base-selection-tags', {
  backgroundColor: 'var(--color-active)'
})])]), cM('disabled', {
  cursor: 'not-allowed'
}, [cE('arrow', `
 color: var(--arrow-color-disabled);
 `), cB('base-selection-label', `
 cursor: not-allowed;
 background-color: var(--color-disabled);
 `, [cB('base-selection-input', `
 cursor: not-allowed;
 color: var(--text-color-disabled);
 `), cE('render-label', `
 color: var(--text-color-disabled);
 `)]), cB('base-selection-tags', `
 cursor: not-allowed;
 background-color: var(--color-disabled);
 `), cB('base-selection-placeholder', `
 cursor: not-allowed;
 color: var(--placeholder-color-disabled);
 `)]), cB('base-selection-input-tag', `
 height: calc(var(--height) - 6px);
 line-height: calc(var(--height) - 6px);
 outline: none;
 display: none;
 position: relative;
 margin-bottom: 3px;
 max-width: 100%;
 vertical-align: bottom;
 `, [cE('input', `
 min-width: 1px;
 padding: 0;
 background-color: #0000;
 outline: none;
 border: none;
 max-width: 100%;
 overflow: hidden;
 width: 1em;
 line-height: inherit;
 cursor: pointer;
 color: var(--text-color);
 caret-color: var(--caret-color);
 `), cE('mirror', `
 position: absolute;
 left: 0;
 top: 0;
 white-space: pre;
 visibility: hidden;
 user-select: none;
 opacity: 0;
 `)])]), cB('base-selection-popover', `
 margin-bottom: -3px;
 display: flex;
 flex-wrap: wrap;
 `), cB('base-selection-tag-wrapper', `
 max-width: 100%;
 display: inline-flex;
 padding: 0 7px 3px 0;
 `, [c$1('&:last-child', {
  paddingRight: 0
}), cB('tag', `
 font-size: 14px;
 max-width: 100%;
 `, [cE('content', `
 text-overflow: ellipsis;
 overflow: hidden;
 `)])]), ['warning', 'error'].map(status => insideFormItem(status, cB('base-selection', [cE('state-border', {
  border: `var(--border-${status})`
}), cNotM('disabled', [c$1('&:hover', [cE('state-border', `
 box-shadow: var(--box-shadow-hover-${status});
 border: var(--border-hover-${status});
 `)]), cM('active', [cE('state-border', `
 box-shadow: var(--box-shadow-active-${status});
 border: var(--border-active-${status});
 `), cB('base-selection-label', {
  backgroundColor: `var(--color-active-${status})`
}), cB('base-selection-tags', {
  backgroundColor: `var(--box-shadow-active-${status})`
})]), cM('focus', [cE('state-border', `
 box-shadow: var(--box-shadow-focus-${status});
 border: var(--border-focus-${status});
 `)])])])))]);

/* eslint-disable @typescript-eslint/no-non-null-assertion */
var NInternalSelection = defineComponent({
    name: 'InternalSelection',
    props: Object.assign(Object.assign({}, useTheme.props), { clsPrefix: {
            type: String,
            required: true
        }, bordered: {
            type: Boolean,
            default: undefined
        }, active: Boolean, pattern: {
            type: String,
            default: null
        }, placeholder: String, selectedOption: {
            type: Object,
            default: null
        }, selectedOptions: {
            type: Array,
            default: null
        }, multiple: Boolean, filterable: Boolean, clearable: Boolean, disabled: Boolean, size: {
            type: String,
            default: 'medium'
        }, loading: Boolean, autofocus: Boolean, showArrow: {
            type: Boolean,
            default: true
        }, inputProps: Object, focused: Boolean, renderTag: Function, onKeyup: Function, onKeydown: Function, onClick: Function, onBlur: Function, onFocus: Function, onDeleteOption: Function, maxTagCount: [String, Number], onClear: Function, onPatternInput: Function, renderLabel: Function }),
    setup(props) {
        const patternInputMirrorRef = ref(null);
        const patternInputRef = ref(null);
        const selfRef = ref(null);
        const multipleElRef = ref(null);
        const singleElRef = ref(null);
        const patternInputWrapperRef = ref(null);
        const counterRef = ref(null);
        const counterWrapperRef = ref(null);
        const overflowRef = ref(null);
        const inputTagElRef = ref(null);
        const showTagsPopoverRef = ref(false);
        const patternInputFocusedRef = ref(false);
        const hoverRef = ref(false);
        const themeRef = useTheme('InternalSelection', 'InternalSelection', style$2, internalSelectionLight$1, props, toRef(props, 'clsPrefix'));
        const mergedClearableRef = computed(() => {
            return (props.clearable && !props.disabled && (hoverRef.value || props.active));
        });
        const filterablePlaceholderRef = computed(() => {
            return props.selectedOption
                ? props.renderTag
                    ? props.renderTag({
                        option: props.selectedOption,
                        handleClose: () => { }
                    })
                    : props.renderLabel
                        ? props.renderLabel(props.selectedOption, true)
                        : render$3(props.selectedOption.label, props.selectedOption, true)
                : props.placeholder;
        });
        const labelRef = computed(() => {
            const option = props.selectedOption;
            if (!option)
                return undefined;
            return option.label;
        });
        const selectedRef = computed(() => {
            if (props.multiple) {
                return !!(Array.isArray(props.selectedOptions) && props.selectedOptions.length);
            }
            else {
                return props.selectedOption !== null;
            }
        });
        function syncMirrorWidth() {
            var _a;
            const { value: patternInputMirrorEl } = patternInputMirrorRef;
            if (patternInputMirrorEl) {
                const { value: patternInputEl } = patternInputRef;
                if (patternInputEl) {
                    patternInputEl.style.width = `${patternInputMirrorEl.offsetWidth}px`;
                    if (props.maxTagCount !== 'responsive') {
                        (_a = overflowRef.value) === null || _a === void 0 ? void 0 : _a.sync();
                    }
                }
            }
        }
        function hideInputTag() {
            const { value: inputTagEl } = inputTagElRef;
            if (inputTagEl)
                inputTagEl.style.display = 'none';
        }
        function showInputTag() {
            const { value: inputTagEl } = inputTagElRef;
            if (inputTagEl)
                inputTagEl.style.display = 'inline-block';
        }
        watch(toRef(props, 'active'), (value) => {
            if (!value)
                hideInputTag();
        });
        watch(toRef(props, 'pattern'), () => {
            if (props.multiple) {
                void nextTick(syncMirrorWidth);
            }
        });
        function doFocus(e) {
            const { onFocus } = props;
            if (onFocus)
                onFocus(e);
        }
        function doBlur(e) {
            const { onBlur } = props;
            if (onBlur)
                onBlur(e);
        }
        function doDeleteOption(value) {
            const { onDeleteOption } = props;
            if (onDeleteOption)
                onDeleteOption(value);
        }
        function doClear(e) {
            const { onClear } = props;
            if (onClear)
                onClear(e);
        }
        function doPatternInput(value) {
            const { onPatternInput } = props;
            if (onPatternInput)
                onPatternInput(value);
        }
        function handleFocusin(e) {
            var _a;
            if (!e.relatedTarget ||
                !((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.relatedTarget))) {
                doFocus(e);
            }
        }
        function handleFocusout(e) {
            var _a;
            if ((_a = selfRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.relatedTarget))
                return;
            doBlur(e);
        }
        function handleClear(e) {
            doClear(e);
        }
        function handleMouseEnter() {
            hoverRef.value = true;
        }
        function handleMouseLeave() {
            hoverRef.value = false;
        }
        function handleMouseDown(e) {
            if (!props.active || !props.filterable)
                return;
            if (e.target === patternInputRef.value)
                return;
            e.preventDefault();
        }
        function handleDeleteOption(option) {
            doDeleteOption(option);
        }
        function handlePatternKeyDown(e) {
            if (e.code === 'Backspace') {
                if (!props.pattern.length) {
                    const { selectedOptions } = props;
                    if (selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length) {
                        handleDeleteOption(selectedOptions[selectedOptions.length - 1]);
                    }
                }
            }
        }
        const isCompositingRef = ref(false);
        // the composition end is later than its input so we can cached the event
        // and return the input event
        let cachedInputEvent = null;
        function handlePatternInputInput(e) {
            // we should sync mirror width here
            const { value: patternInputMirrorEl } = patternInputMirrorRef;
            if (patternInputMirrorEl) {
                const inputText = e.target.value;
                patternInputMirrorEl.textContent = inputText;
                syncMirrorWidth();
            }
            if (!isCompositingRef.value) {
                doPatternInput(e);
            }
            else {
                cachedInputEvent = e;
            }
        }
        function handleCompositionStart() {
            isCompositingRef.value = true;
        }
        function handleCompositionEnd() {
            isCompositingRef.value = false;
            doPatternInput(cachedInputEvent);
            cachedInputEvent = null;
        }
        function handlePatternInputFocus() {
            patternInputFocusedRef.value = true;
        }
        function handlePatternInputBlur(e) {
            patternInputFocusedRef.value = false;
        }
        function focus() {
            if (props.filterable) {
                patternInputFocusedRef.value = false;
                const { value: patternInputWrapperEl } = patternInputWrapperRef;
                if (patternInputWrapperEl)
                    patternInputWrapperEl.focus();
            }
            else if (props.multiple) {
                const { value: multipleEl } = multipleElRef;
                multipleEl === null || multipleEl === void 0 ? void 0 : multipleEl.focus();
            }
            else {
                const { value: singleEl } = singleElRef;
                singleEl === null || singleEl === void 0 ? void 0 : singleEl.focus();
            }
        }
        function focusInput() {
            const { value: patternInputEl } = patternInputRef;
            if (patternInputEl) {
                showInputTag();
                patternInputEl.focus();
            }
        }
        function blurInput() {
            const { value: patternInputEl } = patternInputRef;
            if (patternInputEl) {
                patternInputEl.blur();
            }
        }
        function updateCounter(count) {
            const { value } = counterRef;
            if (value) {
                value.setTextContent(`+${count}`);
            }
        }
        function getCounter() {
            const { value } = counterWrapperRef;
            return value;
        }
        function getTail() {
            return patternInputRef.value;
        }
        let enterTimerId = null;
        function clearEnterTimer() {
            if (enterTimerId !== null)
                window.clearTimeout(enterTimerId);
        }
        function handleMouseEnterCounter() {
            if (props.disabled || props.active)
                return;
            clearEnterTimer();
            enterTimerId = window.setTimeout(() => {
                showTagsPopoverRef.value = true;
            }, 100);
        }
        function handleMouseLeaveCounter() {
            clearEnterTimer();
        }
        function onPopoverUpdateShow(show) {
            if (!show) {
                clearEnterTimer();
                showTagsPopoverRef.value = false;
            }
        }
        onMounted(() => {
            watchEffect(() => {
                const patternInputWrapperEl = patternInputWrapperRef.value;
                if (!patternInputWrapperEl)
                    return;
                patternInputWrapperEl.tabIndex =
                    props.disabled || patternInputFocusedRef.value ? -1 : 0;
            });
        });
        return {
            mergedTheme: themeRef,
            mergedClearable: mergedClearableRef,
            patternInputFocused: patternInputFocusedRef,
            filterablePlaceholder: filterablePlaceholderRef,
            label: labelRef,
            selected: selectedRef,
            showTagsPanel: showTagsPopoverRef,
            isCompositing: isCompositingRef,
            // dom ref
            counterRef,
            counterWrapperRef,
            patternInputMirrorRef,
            patternInputRef,
            selfRef,
            multipleElRef,
            singleElRef,
            patternInputWrapperRef,
            overflowRef,
            inputTagElRef,
            handleMouseDown,
            handleFocusin,
            handleClear,
            handleMouseEnter,
            handleMouseLeave,
            handleDeleteOption,
            handlePatternKeyDown,
            handlePatternInputInput,
            handlePatternInputBlur,
            handlePatternInputFocus,
            handleMouseEnterCounter,
            handleMouseLeaveCounter,
            handleFocusout,
            handleCompositionEnd,
            handleCompositionStart,
            onPopoverUpdateShow,
            focus,
            focusInput,
            blurInput,
            updateCounter,
            getCounter,
            getTail,
            renderLabel: props.renderLabel,
            cssVars: computed(() => {
                const { size } = props;
                const { common: { cubicBezierEaseInOut }, self: { borderRadius, color, placeholderColor, textColor, paddingSingle, caretColor, colorDisabled, textColorDisabled, placeholderColorDisabled, colorActive, boxShadowFocus, boxShadowActive, boxShadowHover, border, borderFocus, borderHover, borderActive, arrowColor, arrowColorDisabled, loadingColor, 
                // form warning
                colorActiveWarning, boxShadowFocusWarning, boxShadowActiveWarning, boxShadowHoverWarning, borderWarning, borderFocusWarning, borderHoverWarning, borderActiveWarning, 
                // form error
                colorActiveError, boxShadowFocusError, boxShadowActiveError, boxShadowHoverError, borderError, borderFocusError, borderHoverError, borderActiveError, 
                // clear
                clearColor, clearColorHover, clearColorPressed, clearSize, 
                // arrow
                arrowSize, [createKey('height', size)]: height, [createKey('fontSize', size)]: fontSize } } = themeRef.value;
                return {
                    '--bezier': cubicBezierEaseInOut,
                    '--border': border,
                    '--border-active': borderActive,
                    '--border-focus': borderFocus,
                    '--border-hover': borderHover,
                    '--border-radius': borderRadius,
                    '--box-shadow-active': boxShadowActive,
                    '--box-shadow-focus': boxShadowFocus,
                    '--box-shadow-hover': boxShadowHover,
                    '--caret-color': caretColor,
                    '--color': color,
                    '--color-active': colorActive,
                    '--color-disabled': colorDisabled,
                    '--font-size': fontSize,
                    '--height': height,
                    '--padding-single': paddingSingle,
                    '--placeholder-color': placeholderColor,
                    '--placeholder-color-disabled': placeholderColorDisabled,
                    '--text-color': textColor,
                    '--text-color-disabled': textColorDisabled,
                    '--arrow-color': arrowColor,
                    '--arrow-color-disabled': arrowColorDisabled,
                    '--loading-color': loadingColor,
                    // form warning
                    '--color-active-warning': colorActiveWarning,
                    '--box-shadow-focus-warning': boxShadowFocusWarning,
                    '--box-shadow-active-warning': boxShadowActiveWarning,
                    '--box-shadow-hover-warning': boxShadowHoverWarning,
                    '--border-warning': borderWarning,
                    '--border-focus-warning': borderFocusWarning,
                    '--border-hover-warning': borderHoverWarning,
                    '--border-active-warning': borderActiveWarning,
                    // form error
                    '--color-active-error': colorActiveError,
                    '--box-shadow-focus-error': boxShadowFocusError,
                    '--box-shadow-active-error': boxShadowActiveError,
                    '--box-shadow-hover-error': boxShadowHoverError,
                    '--border-error': borderError,
                    '--border-focus-error': borderFocusError,
                    '--border-hover-error': borderHoverError,
                    '--border-active-error': borderActiveError,
                    // clear
                    '--clear-size': clearSize,
                    '--clear-color': clearColor,
                    '--clear-color-hover': clearColorHover,
                    '--clear-color-pressed': clearColorPressed,
                    // arrow-size
                    '--arrow-size': arrowSize
                };
            })
        };
    },
    render() {
        const { multiple, size, disabled, filterable, maxTagCount, bordered, clsPrefix, renderTag, renderLabel } = this;
        const maxTagCountResponsive = maxTagCount === 'responsive';
        const maxTagCountNumeric = typeof maxTagCount === 'number';
        const useMaxTagCount = maxTagCountResponsive || maxTagCountNumeric;
        const suffix = (h(NBaseSuffix, { clsPrefix: clsPrefix, loading: this.loading, showArrow: this.showArrow, showClear: this.mergedClearable && this.selected, onClear: this.handleClear }));
        let body;
        if (multiple) {
            const createTag = (option) => (h("div", { class: `${clsPrefix}-base-selection-tag-wrapper`, key: option.value }, renderTag ? (renderTag({
                option,
                handleClose: () => this.handleDeleteOption(option)
            })) : (h(NTag, { size: size, closable: !option.disabled, disabled: disabled, internalStopClickPropagation: true, onClose: () => this.handleDeleteOption(option) }, {
                default: () => renderLabel
                    ? renderLabel(option, true)
                    : render$3(option.label, option, true)
            }))));
            const originalTags = (maxTagCountNumeric
                ? this.selectedOptions.slice(0, maxTagCount)
                : this.selectedOptions).map(createTag);
            const input = filterable ? (h("div", { class: `${clsPrefix}-base-selection-input-tag`, ref: "inputTagElRef", key: "__input-tag__" },
                h("input", Object.assign({}, this.inputProps, { ref: "patternInputRef", tabindex: -1, disabled: disabled, value: this.pattern, autofocus: this.autofocus, class: `${clsPrefix}-base-selection-input-tag__input`, onBlur: this.handlePatternInputBlur, onFocus: this.handlePatternInputFocus, onKeydown: this.handlePatternKeyDown, onInput: this.handlePatternInputInput, onCompositionstart: this.handleCompositionStart, onCompositionend: this.handleCompositionEnd })),
                h("span", { ref: "patternInputMirrorRef", class: `${clsPrefix}-base-selection-input-tag__mirror` }, this.pattern ? this.pattern : ''))) : null;
            // May Overflow
            const renderCounter = maxTagCountResponsive
                ? () => (h("div", { class: `${clsPrefix}-base-selection-tag-wrapper`, ref: "counterWrapperRef" },
                    h(NTag, { ref: "counterRef", onMouseenter: this.handleMouseEnterCounter, onMouseleave: this.handleMouseLeaveCounter, disabled: disabled })))
                : undefined;
            let counter;
            if (maxTagCountNumeric) {
                const rest = this.selectedOptions.length - maxTagCount;
                if (rest > 0) {
                    counter = (h("div", { class: `${clsPrefix}-base-selection-tag-wrapper`, key: "__counter__" },
                        h(NTag, { ref: "counterRef", onMouseenter: this.handleMouseEnterCounter, disabled: disabled }, {
                            default: () => `+${rest}`
                        })));
                }
            }
            const tags = maxTagCountResponsive ? (filterable ? (h(VOverflow, { ref: "overflowRef", updateCounter: this.updateCounter, getCounter: this.getCounter, getTail: this.getTail, style: {
                    width: '100%',
                    display: 'flex',
                    overflow: 'hidden'
                } }, {
                default: () => originalTags,
                counter: renderCounter,
                tail: () => input
            })) : (h(VOverflow, { ref: "overflowRef", updateCounter: this.updateCounter, getCounter: this.getCounter, style: {
                    width: '100%',
                    display: 'flex',
                    overflow: 'hidden'
                } }, {
                default: () => originalTags,
                counter: renderCounter
            }))) : maxTagCountNumeric ? (originalTags.concat(counter)) : (originalTags);
            const renderPopover = useMaxTagCount
                ? () => (h("div", { class: `${clsPrefix}-base-selection-popover` }, maxTagCountResponsive
                    ? originalTags
                    : this.selectedOptions.map(createTag)))
                : undefined;
            const popoverProps = useMaxTagCount
                ? {
                    show: this.showTagsPanel,
                    trigger: 'hover',
                    overlap: true,
                    placement: 'top',
                    width: 'trigger',
                    onUpdateShow: this.onPopoverUpdateShow,
                    theme: this.mergedTheme.peers.Popover,
                    themeOverrides: this.mergedTheme.peerOverrides.Popover
                }
                : null;
            const placeholder = !this.selected && !this.pattern && !this.isCompositing ? (h("div", { class: `${clsPrefix}-base-selection-placeholder ${clsPrefix}-base-selection-overlay` }, this.placeholder)) : null;
            if (filterable) {
                const popoverTrigger = (h("div", { ref: "patternInputWrapperRef", class: `${clsPrefix}-base-selection-tags` },
                    tags,
                    maxTagCountResponsive ? null : input,
                    suffix));
                body = (h(Fragment, null,
                    useMaxTagCount ? (h(NPopover, Object.assign({}, popoverProps), {
                        trigger: () => popoverTrigger,
                        default: renderPopover
                    })) : (popoverTrigger),
                    placeholder));
            }
            else {
                const popoverTrigger = (h("div", { ref: "multipleElRef", class: `${clsPrefix}-base-selection-tags`, tabindex: disabled ? undefined : 0 },
                    tags,
                    suffix));
                body = (h(Fragment, null,
                    useMaxTagCount ? (h(NPopover, Object.assign({}, popoverProps), {
                        trigger: () => popoverTrigger,
                        default: renderPopover
                    })) : (popoverTrigger),
                    placeholder));
            }
        }
        else {
            if (filterable) {
                const showPlaceholder = !this.pattern &&
                    (this.active || !this.selected) &&
                    !this.isCompositing;
                body = (h("div", { ref: "patternInputWrapperRef", class: `${clsPrefix}-base-selection-label` },
                    h("input", Object.assign({}, this.inputProps, { ref: "patternInputRef", class: `${clsPrefix}-base-selection-input`, value: this.patternInputFocused && this.active ? this.pattern : '', placeholder: "", readonly: disabled, disabled: disabled, tabindex: -1, autofocus: this.autofocus, onFocus: this.handlePatternInputFocus, onBlur: this.handlePatternInputBlur, onInput: this.handlePatternInputInput, onCompositionstart: this.handleCompositionStart, onCompositionend: this.handleCompositionEnd })),
                    showPlaceholder ? null : this.patternInputFocused &&
                        this.active ? null : (h("div", { class: `${clsPrefix}-base-selection-label__render-label ${clsPrefix}-base-selection-overlay`, key: "input" }, renderTag
                        ? renderTag({
                            option: this.selectedOption,
                            handleClose: () => { }
                        })
                        : renderLabel
                            ? renderLabel(this.selectedOption, true)
                            : render$3(this.label, this.selectedOption, true))),
                    showPlaceholder ? (h("div", { class: `${clsPrefix}-base-selection-placeholder ${clsPrefix}-base-selection-overlay`, key: "placeholder" }, this.filterablePlaceholder)) : null,
                    suffix));
            }
            else {
                body = (h("div", { ref: "singleElRef", class: `${clsPrefix}-base-selection-label`, tabindex: this.disabled ? undefined : 0 },
                    this.label !== undefined ? (h("div", { class: `${clsPrefix}-base-selection-input`, title: getTitleAttribute(this.label), key: "input" },
                        h("div", { class: `${clsPrefix}-base-selection-input__content` }, renderTag
                            ? renderTag({
                                option: this.selectedOption,
                                handleClose: () => { }
                            })
                            : renderLabel
                                ? renderLabel(this.selectedOption, true)
                                : render$3(this.label, this.selectedOption, true)))) : (h("div", { class: `${clsPrefix}-base-selection-placeholder ${clsPrefix}-base-selection-overlay`, key: "placeholder" }, this.placeholder)),
                    suffix));
            }
        }
        return (h("div", { ref: "selfRef", class: [
                `${clsPrefix}-base-selection`,
                {
                    [`${clsPrefix}-base-selection--active`]: this.active,
                    [`${clsPrefix}-base-selection--selected`]: this.selected || (this.active && this.pattern),
                    [`${clsPrefix}-base-selection--disabled`]: this.disabled,
                    [`${clsPrefix}-base-selection--multiple`]: this.multiple,
                    // focus is not controlled by selection itself since it always need
                    // to be managed together with menu. provide :focus style will cause
                    // many redundant codes.
                    [`${clsPrefix}-base-selection--focus`]: this.focused
                }
            ], style: this.cssVars, onClick: this.onClick, onMouseenter: this.handleMouseEnter, onMouseleave: this.handleMouseLeave, onKeyup: this.onKeyup, onKeydown: this.onKeydown, onFocusin: this.handleFocusin, onFocusout: this.handleFocusout, onMousedown: this.handleMouseDown },
            body,
            bordered ? (h("div", { class: `${clsPrefix}-base-selection__border` })) : null,
            bordered ? (h("div", { class: `${clsPrefix}-base-selection__state-border` })) : null));
    }
});

function getKey(option) {
    if (getIsGroup(option)) {
        return (option.name ||
            option.key ||
            'key-required');
    }
    return option.value;
}
function getIsGroup(option) {
    return option.type === 'group';
}
function getIgnored(option) {
    return option.type === 'ignored';
}
const tmOptions = {
    getKey,
    getIsGroup,
    getIgnored
};
function patternMatched(pattern, value) {
    try {
        return !!(1 + value.toString().toLowerCase().indexOf(pattern.trim().toLowerCase()));
    }
    catch (err) {
        return false;
    }
}
function filterOptions(originalOpts, filter, pattern) {
    if (!filter)
        return originalOpts;
    function traverse(options) {
        if (!Array.isArray(options))
            return [];
        const filteredOptions = [];
        for (const option of options) {
            if (getIsGroup(option)) {
                const children = traverse(option.children);
                if (children.length) {
                    filteredOptions.push(Object.assign({}, option, {
                        children
                    }));
                }
            }
            else if (getIgnored(option)) {
                continue;
            }
            else if (filter(pattern, option)) {
                filteredOptions.push(option);
            }
        }
        return filteredOptions;
    }
    return traverse(originalOpts);
}
function createValOptMap(options) {
    const valOptMap = new Map();
    options.forEach((option) => {
        if (getIsGroup(option)) {
            option.children.forEach((SelectGroupOption) => {
                valOptMap.set(SelectGroupOption.value, SelectGroupOption);
            });
        }
        else {
            valOptMap.set(option.value, option);
        }
    });
    return valOptMap;
}
function defaultFilter(pattern, option) {
    if (!option)
        return false;
    if (typeof option.label === 'string') {
        return patternMatched(pattern, option.label);
    }
    else if (option.value !== undefined) {
        return patternMatched(pattern, String(option.value));
    }
    return false;
}

function self$3(vars) {
    const { boxShadow2 } = vars;
    return {
        menuBoxShadow: boxShadow2
    };
}
const selectLight = createTheme({
    name: 'Select',
    common: commonLight,
    peers: {
        InternalSelection: internalSelectionLight$1,
        InternalSelectMenu: internalSelectMenuLight$1
    },
    self: self$3
});
var selectLight$1 = selectLight;

var style$1 = c$1([cB('select', `
 z-index: auto;
 outline: none;
 width: 100%;
 position: relative;
 `), cB('select-menu', `
 margin: 4px 0;
 box-shadow: var(--menu-box-shadow);
 `, [fadeInScaleUpTransition()])]);

const selectProps = Object.assign(Object.assign({}, useTheme.props), { to: useAdjustedTo.propTo, bordered: {
        type: Boolean,
        default: undefined
    }, clearable: Boolean, options: {
        type: Array,
        default: () => []
    }, defaultValue: {
        type: [String, Number, Array],
        default: null
    }, value: [String, Number, Array], placeholder: String, multiple: Boolean, size: String, filterable: Boolean, disabled: {
        type: Boolean,
        default: undefined
    }, remote: Boolean, loading: Boolean, filter: {
        type: Function,
        default: defaultFilter
    }, placement: {
        type: String,
        default: 'bottom-start'
    }, widthMode: {
        type: String,
        default: 'trigger'
    }, tag: Boolean, onCreate: {
        type: Function,
        default: (label) => ({
            label: label,
            value: label
        })
    }, fallbackOption: {
        type: [Function, Boolean],
        default: () => (value) => ({
            label: String(value),
            value
        })
    }, show: {
        type: Boolean,
        default: undefined
    }, showArrow: {
        type: Boolean,
        default: true
    }, maxTagCount: [Number, String], consistentMenuWidth: {
        type: Boolean,
        default: true
    }, virtualScroll: {
        type: Boolean,
        default: true
    }, renderLabel: Function, renderOption: Function, renderTag: Function, 'onUpdate:value': [Function, Array], inputProps: Object, 
    // for jsx
    onUpdateValue: [Function, Array], onBlur: [Function, Array], onClear: [Function, Array], onFocus: [Function, Array], onScroll: [Function, Array], onSearch: [Function, Array], onUpdateShow: [Function, Array], 'onUpdate:show': [Function, Array], 
    /** deprecated */
    onChange: {
        type: [Function, Array],
        validator: () => {
            return true;
        },
        default: undefined
    }, items: {
        type: Array,
        validator: () => {
            return true;
        },
        default: undefined
    }, displayDirective: {
        type: String,
        default: 'show'
    } });
var NSelect = defineComponent({
    name: 'Select',
    props: selectProps,
    setup(props) {
        const { mergedClsPrefixRef, mergedBorderedRef, namespaceRef } = useConfig(props);
        const themeRef = useTheme('Select', 'Select', style$1, selectLight$1, props, mergedClsPrefixRef);
        const uncontrolledValueRef = ref(props.defaultValue);
        const controlledValueRef = toRef(props, 'value');
        const mergedValueRef = useMergedState(controlledValueRef, uncontrolledValueRef);
        const focusedRef = ref(false);
        const patternRef = ref('');
        const treeMateRef = computed(() => createTreeMate(filteredOptionsRef.value, tmOptions));
        const valOptMapRef = computed(() => createValOptMap(props.options));
        const uncontrolledShowRef = ref(false);
        const mergedShowRef = useMergedState(toRef(props, 'show'), uncontrolledShowRef);
        const triggerRef = ref(null);
        const followerRef = ref(null);
        const menuRef = ref(null);
        const { localeRef } = createLocaleMixin('Select');
        const localizedPlaceholderRef = computed(() => {
            var _a;
            return (_a = props.placeholder) !== null && _a !== void 0 ? _a : localeRef.value.placeholder;
        });
        const compitableOptionsRef = useCompitable(props, ['items', 'options']);
        const createdOptionsRef = ref([]);
        const beingCreatedOptionsRef = ref([]);
        const memoValOptMapRef = ref(new Map());
        const wrappedFallbackOptionRef = computed(() => {
            const { fallbackOption } = props;
            if (!fallbackOption)
                return false;
            return (value) => {
                return Object.assign(fallbackOption(value), {
                    value
                });
            };
        });
        const localOptionsRef = computed(() => {
            return beingCreatedOptionsRef.value.concat(createdOptionsRef.value).concat(compitableOptionsRef.value);
        });
        const filteredOptionsRef = computed(() => {
            if (props.remote) {
                return compitableOptionsRef.value;
            }
            else {
                const { value: localOptions } = localOptionsRef;
                const { value: pattern } = patternRef;
                if (!pattern.length || !props.filterable) {
                    return localOptions;
                }
                else {
                    const { filter } = props;
                    return filterOptions(localOptions, filter, pattern);
                }
            }
        });
        function getMergedOptions(values) {
            const remote = props.remote;
            const { value: memoValOptMap } = memoValOptMapRef;
            const { value: valOptMap } = valOptMapRef;
            const { value: wrappedFallbackOption } = wrappedFallbackOptionRef;
            const options = [];
            values.forEach((value) => {
                if (valOptMap.has(value)) {
                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                    options.push(valOptMap.get(value));
                }
                else if (remote && memoValOptMap.has(value)) {
                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                    options.push(memoValOptMap.get(value));
                }
                else if (wrappedFallbackOption) {
                    const option = wrappedFallbackOption(value);
                    if (option) {
                        options.push(option);
                    }
                }
            });
            return options;
        }
        const selectedOptionsRef = computed(() => {
            if (props.multiple) {
                const { value: values } = mergedValueRef;
                if (!Array.isArray(values))
                    return [];
                return getMergedOptions(values);
            }
            return null;
        });
        const selectedOptionRef = computed(() => {
            const { value: mergedValue } = mergedValueRef;
            if (!props.multiple && !Array.isArray(mergedValue)) {
                if (mergedValue === null)
                    return null;
                return getMergedOptions([mergedValue])[0] || null;
            }
            return null;
        });
        const formItem = useFormItem(props);
        const { mergedSizeRef, mergedDisabledRef } = formItem;
        function doUpdateValue(value, option) {
            const { onChange, 'onUpdate:value': _onUpdateValue, onUpdateValue } = props;
            const { nTriggerFormChange, nTriggerFormInput } = formItem;
            if (onChange)
                call(onChange, value, option);
            if (onUpdateValue)
                call(onUpdateValue, value, option);
            if (_onUpdateValue) {
                call(_onUpdateValue, value, option);
            }
            uncontrolledValueRef.value = value;
            nTriggerFormChange();
            nTriggerFormInput();
        }
        function doBlur(e) {
            const { onBlur } = props;
            const { nTriggerFormBlur } = formItem;
            if (onBlur)
                call(onBlur, e);
            nTriggerFormBlur();
        }
        function doClear() {
            const { onClear } = props;
            if (onClear)
                call(onClear);
        }
        function doFocus(e) {
            const { onFocus } = props;
            const { nTriggerFormFocus } = formItem;
            if (onFocus)
                call(onFocus, e);
            nTriggerFormFocus();
        }
        function doSearch(value) {
            const { onSearch } = props;
            if (onSearch)
                call(onSearch, value);
        }
        function doScroll(e) {
            const { onScroll } = props;
            if (onScroll)
                call(onScroll, e);
        }
        // remote related methods
        function updateMemorizedOptions() {
            var _a;
            const { remote, multiple } = props;
            if (remote) {
                const { value: memoValOptMap } = memoValOptMapRef;
                if (multiple) {
                    (_a = selectedOptionsRef.value) === null || _a === void 0 ? void 0 : _a.forEach((option) => {
                        memoValOptMap.set(option.value, option);
                    });
                }
                else {
                    const option = selectedOptionRef.value;
                    if (option) {
                        memoValOptMap.set(option.value, option);
                    }
                }
            }
        }
        // menu related methods
        function doUpdateShow(value) {
            const { onUpdateShow, 'onUpdate:show': _onUpdateShow } = props;
            if (onUpdateShow)
                call(onUpdateShow, value);
            if (_onUpdateShow)
                call(_onUpdateShow, value);
            uncontrolledShowRef.value = value;
        }
        function openMenu() {
            if (!mergedDisabledRef.value) {
                patternRef.value = '';
                doUpdateShow(true);
                uncontrolledShowRef.value = true;
                if (props.filterable) {
                    focusSelectionInput();
                }
            }
        }
        function closeMenu() {
            doUpdateShow(false);
        }
        function handleMenuLeave() {
            patternRef.value = '';
        }
        function handleTriggerClick() {
            if (mergedDisabledRef.value)
                return;
            if (!mergedShowRef.value) {
                openMenu();
            }
            else {
                if (!props.filterable) {
                    // already focused, don't need to return focus
                    closeMenu();
                }
            }
        }
        function handleTriggerBlur(e) {
            var _a, _b;
            if ((_b = (_a = menuRef.value) === null || _a === void 0 ? void 0 : _a.selfRef) === null || _b === void 0 ? void 0 : _b.contains(e.relatedTarget)) {
                return;
            }
            focusedRef.value = false;
            doBlur(e);
            // outside select, don't need to return focus
            closeMenu();
        }
        function handleTriggerFocus(e) {
            doFocus(e);
            focusedRef.value = true;
        }
        function handleMenuFocus(e) {
            focusedRef.value = true;
        }
        function handleMenuBlur(e) {
            var _a;
            if ((_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.$el.contains(e.relatedTarget))
                return;
            focusedRef.value = false;
            doBlur(e);
            // outside select, don't need to return focus
            closeMenu();
        }
        function handleMenuTabOut() {
            var _a;
            (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focus();
            closeMenu();
        }
        function handleMenuClickOutside(e) {
            var _a;
            if (mergedShowRef.value) {
                if (!((_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.$el.contains(e.target))) {
                    // outside select, don't need to return focus
                    closeMenu();
                }
            }
        }
        function createClearedMultipleSelectValue(value) {
            if (!Array.isArray(value))
                return [];
            if (wrappedFallbackOptionRef.value) {
                // if option has a fallback, I can't help user to clear some unknown value
                return Array.from(value);
            }
            else {
                // if there's no option fallback, unappeared options are treated as invalid
                const { remote } = props;
                const { value: valOptMap } = valOptMapRef;
                if (remote) {
                    const { value: memoValOptMap } = memoValOptMapRef;
                    return value.filter((v) => valOptMap.has(v) || memoValOptMap.has(v));
                }
                else {
                    return value.filter((v) => valOptMap.has(v));
                }
            }
        }
        function handleToggleByTmNode(tmNode) {
            handleToggleByOption(tmNode.rawNode);
        }
        function handleToggleByOption(option) {
            if (mergedDisabledRef.value)
                return;
            const { tag, remote } = props;
            if (tag && !remote) {
                const { value: beingCreatedOptions } = beingCreatedOptionsRef;
                const beingCreatedOption = beingCreatedOptions[0] || null;
                if (beingCreatedOption) {
                    createdOptionsRef.value.push(beingCreatedOption);
                    beingCreatedOptionsRef.value = [];
                }
            }
            if (remote) {
                memoValOptMapRef.value.set(option.value, option);
            }
            if (props.multiple) {
                const changedValue = createClearedMultipleSelectValue(mergedValueRef.value);
                const index = changedValue.findIndex((value) => value === option.value);
                if (~index) {
                    changedValue.splice(index, 1);
                    if (tag && !remote) {
                        const createdOptionIndex = getCreatedOptionIndex(option.value);
                        if (~createdOptionIndex) {
                            createdOptionsRef.value.splice(createdOptionIndex, 1);
                            patternRef.value = '';
                        }
                    }
                }
                else {
                    changedValue.push(option.value);
                    patternRef.value = '';
                }
                doUpdateValue(changedValue, getMergedOptions(changedValue));
            }
            else {
                if (tag && !remote) {
                    const createdOptionIndex = getCreatedOptionIndex(option.value);
                    if (~createdOptionIndex) {
                        createdOptionsRef.value = [
                            createdOptionsRef.value[createdOptionIndex]
                        ];
                    }
                    else {
                        createdOptionsRef.value = [];
                    }
                }
                focusSelection();
                closeMenu();
                doUpdateValue(option.value, option);
            }
        }
        function getCreatedOptionIndex(optionValue) {
            const createdOptions = createdOptionsRef.value;
            return createdOptions.findIndex((createdOption) => createdOption.value === optionValue);
        }
        function handlePatternInput(e) {
            if (!mergedShowRef.value) {
                openMenu();
            }
            const { value } = e.target;
            patternRef.value = value;
            const { tag, remote } = props;
            doSearch(value);
            if (tag && !remote) {
                if (!value) {
                    beingCreatedOptionsRef.value = [];
                    return;
                }
                const optionBeingCreated = props.onCreate(value);
                if (compitableOptionsRef.value.some((option) => option.value === optionBeingCreated.value) ||
                    createdOptionsRef.value.some((option) => option.value === optionBeingCreated.value)) {
                    beingCreatedOptionsRef.value = [];
                }
                else {
                    beingCreatedOptionsRef.value = [optionBeingCreated];
                }
            }
        }
        function handleClear(e) {
            e.stopPropagation();
            const { multiple } = props;
            if (!multiple && props.filterable) {
                closeMenu();
            }
            doClear();
            if (multiple) {
                doUpdateValue([], []);
            }
            else {
                doUpdateValue(null, null);
            }
        }
        function handleMenuMousedown(e) {
            if (!happensIn(e, 'action'))
                e.preventDefault();
        }
        // scroll events on menu
        function handleMenuScroll(e) {
            doScroll(e);
        }
        // keyboard events
        // also for menu keyup
        function handleKeyUp(e) {
            var _a, _b, _c, _d;
            switch (e.code) {
                case 'Space':
                    if (props.filterable)
                        break;
                // eslint-disable-next-line no-fallthrough
                case 'Enter':
                case 'NumpadEnter':
                    if (mergedShowRef.value) {
                        const pendingTmNode = (_a = menuRef.value) === null || _a === void 0 ? void 0 : _a.getPendingTmNode();
                        if (pendingTmNode) {
                            handleToggleByTmNode(pendingTmNode);
                        }
                        else if (!props.filterable) {
                            closeMenu();
                            focusSelection();
                        }
                    }
                    else {
                        openMenu();
                    }
                    e.preventDefault();
                    break;
                case 'ArrowUp':
                    if (props.loading)
                        return;
                    if (mergedShowRef.value) {
                        (_b = menuRef.value) === null || _b === void 0 ? void 0 : _b.prev();
                    }
                    break;
                case 'ArrowDown':
                    if (props.loading)
                        return;
                    if (mergedShowRef.value) {
                        (_c = menuRef.value) === null || _c === void 0 ? void 0 : _c.next();
                    }
                    else {
                        openMenu();
                    }
                    break;
                case 'Escape':
                    closeMenu();
                    (_d = triggerRef.value) === null || _d === void 0 ? void 0 : _d.focus();
                    break;
            }
        }
        // also for menu
        function handleKeyDown(e) {
            switch (e.code) {
                case 'Space':
                    if (!props.filterable) {
                        e.preventDefault();
                    }
                    break;
                case 'ArrowUp':
                case 'ArrowDown':
                    e.preventDefault();
                    break;
            }
        }
        function focusSelection() {
            var _a;
            (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focus();
        }
        function focusSelectionInput() {
            var _a;
            (_a = triggerRef.value) === null || _a === void 0 ? void 0 : _a.focusInput();
        }
        function syncPosition() {
            var _a;
            (_a = followerRef.value) === null || _a === void 0 ? void 0 : _a.syncPosition();
        }
        updateMemorizedOptions();
        watch(toRef(props, 'options'), updateMemorizedOptions);
        watch(filteredOptionsRef, () => {
            if (!mergedShowRef.value)
                return;
            void nextTick(syncPosition);
        });
        watch(mergedValueRef, () => {
            if (!mergedShowRef.value)
                return;
            void nextTick(syncPosition);
        });
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            mergedBordered: mergedBorderedRef,
            namespace: namespaceRef,
            treeMate: treeMateRef,
            isMounted: isMounted(),
            triggerRef,
            menuRef,
            pattern: patternRef,
            uncontrolledShow: uncontrolledShowRef,
            mergedShow: mergedShowRef,
            adjustedTo: useAdjustedTo(props),
            uncontrolledValue: uncontrolledValueRef,
            mergedValue: mergedValueRef,
            followerRef,
            localizedPlaceholder: localizedPlaceholderRef,
            selectedOption: selectedOptionRef,
            selectedOptions: selectedOptionsRef,
            mergedSize: mergedSizeRef,
            mergedDisabled: mergedDisabledRef,
            focused: focusedRef,
            handleMenuFocus,
            handleMenuBlur,
            handleMenuTabOut,
            handleTriggerClick,
            handleToggle: handleToggleByTmNode,
            handleDeleteOption: handleToggleByOption,
            handlePatternInput,
            handleClear,
            handleTriggerBlur,
            handleTriggerFocus,
            handleKeyDown,
            handleKeyUp,
            syncPosition,
            handleMenuLeave,
            handleMenuClickOutside,
            handleMenuScroll,
            handleMenuKeyup: handleKeyUp,
            handleMenuKeydown: handleKeyDown,
            handleMenuMousedown,
            mergedTheme: themeRef,
            cssVars: computed(() => {
                const { self: { menuBoxShadow } } = themeRef.value;
                return {
                    '--menu-box-shadow': menuBoxShadow
                };
            })
        };
    },
    render() {
        const { $slots, mergedClsPrefix } = this;
        return (h("div", { class: `${mergedClsPrefix}-select` },
            h(VBinder, null, {
                default: () => [
                    h(VTarget, null, {
                        default: () => (h(NInternalSelection, { ref: "triggerRef", inputProps: this.inputProps, clsPrefix: mergedClsPrefix, showArrow: this.showArrow, maxTagCount: this.maxTagCount, bordered: this.mergedBordered, active: this.mergedShow, pattern: this.pattern, placeholder: this.localizedPlaceholder, selectedOption: this.selectedOption, selectedOptions: this.selectedOptions, multiple: this.multiple, renderTag: this.renderTag, renderLabel: this.renderLabel, filterable: this.filterable, clearable: this.clearable, disabled: this.mergedDisabled, size: this.mergedSize, theme: this.mergedTheme.peers.InternalSelection, themeOverrides: this.mergedTheme.peerOverrides.InternalSelection, loading: this.loading, focused: this.focused, onClick: this.handleTriggerClick, onDeleteOption: this.handleDeleteOption, onPatternInput: this.handlePatternInput, onClear: this.handleClear, onBlur: this.handleTriggerBlur, onFocus: this.handleTriggerFocus, onKeydown: this.handleKeyDown, onKeyup: this.handleKeyUp }))
                    }),
                    h(VFollower, { ref: "followerRef", show: this.mergedShow, to: this.adjustedTo, teleportDisabled: this.adjustedTo === useAdjustedTo.tdkey, containerClass: this.namespace, width: this.consistentMenuWidth ? 'target' : undefined, minWidth: "target", placement: this.placement }, {
                        default: () => (h(Transition, { name: "fade-in-scale-up-transition", appear: this.isMounted, onLeave: this.handleMenuLeave }, {
                            default: () => (this.mergedShow ||
                                this.displayDirective === 'show') &&
                                withDirectives(h(NInternalSelectMenu, { ref: "menuRef", virtualScroll: this.consistentMenuWidth && this.virtualScroll, class: `${mergedClsPrefix}-select-menu`, clsPrefix: mergedClsPrefix, focusable: true, autoPending: true, theme: this.mergedTheme.peers.InternalSelectMenu, themeOverrides: this.mergedTheme.peerOverrides
                                        .InternalSelectMenu, treeMate: this.treeMate, multiple: this.multiple, size: "medium", renderOption: this.renderOption, renderLabel: this.renderLabel, value: this.mergedValue, style: this.cssVars, onToggle: this.handleToggle, onScroll: this.handleMenuScroll, onFocus: this.handleMenuFocus, onBlur: this.handleMenuBlur, onKeyup: this.handleMenuKeyup, onKeydown: this.handleMenuKeydown, onTabOut: this.handleMenuTabOut, onMousedown: this.handleMenuMousedown, show: this.mergedShow }, $slots), this.displayDirective === 'show'
                                    ? [
                                        [vShow, this.mergedShow],
                                        [clickoutside$1, this.handleMenuClickOutside]
                                    ]
                                    : [[clickoutside$1, this.handleMenuClickOutside]])
                        }))
                    })
                ]
            })));
    }
});

var commonVars = {
    gapSmall: '4px 8px',
    gapMedium: '8px 12px',
    gapLarge: '12px 16px'
};

const self$2 = () => {
    return commonVars;
};
const spaceLight = {
    name: 'Space',
    self: self$2
};
var spaceLight$1 = spaceLight;

const spaceProps = Object.assign(Object.assign({}, useTheme.props), { align: String, justify: {
        type: String,
        default: 'start'
    }, inline: Boolean, vertical: Boolean, size: {
        type: [String, Number, Array],
        default: 'medium'
    }, itemStyle: [String, Object], wrap: {
        type: Boolean,
        default: true
    } });
var NSpace = defineComponent({
    name: 'Space',
    props: spaceProps,
    setup(props) {
        const { mergedClsPrefixRef } = useConfig(props);
        const themeRef = useTheme('Space', 'Space', undefined, spaceLight$1, props, mergedClsPrefixRef);
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            margin: computed(() => {
                const { size } = props;
                if (Array.isArray(size)) {
                    return {
                        horizontal: size[0],
                        vertical: size[1]
                    };
                }
                if (typeof size === 'number') {
                    return {
                        horizontal: size,
                        vertical: size
                    };
                }
                const { self: { [createKey('gap', size)]: gap } } = themeRef.value;
                const { row, col } = getGap(gap);
                return {
                    horizontal: depx(col),
                    vertical: depx(row)
                };
            })
        };
    },
    render() {
        const { vertical, align, inline, justify, itemStyle, margin, wrap, mergedClsPrefix } = this;
        const children = flatten$1(getSlot$1(this));
        const horizontalMargin = `${margin.horizontal}px`;
        const semiHorizontalMargin = `${margin.horizontal / 2}px`;
        const verticalMargin = `${margin.vertical}px`;
        const semiVerticalMargin = `${margin.vertical / 2}px`;
        const lastIndex = children.length - 1;
        const isJustifySpace = justify.startsWith('space-');
        return (h("div", { role: "none", class: `${mergedClsPrefix}-space`, style: {
                display: inline ? 'inline-flex' : 'flex',
                flexDirection: vertical ? 'column' : 'row',
                justifyContent: ['start', 'end'].includes(justify)
                    ? 'flex-' + justify
                    : justify,
                flexWrap: !wrap || vertical ? 'nowrap' : 'wrap',
                marginTop: vertical ? '' : `-${semiVerticalMargin}`,
                marginBottom: vertical ? '' : `-${semiVerticalMargin}`,
                alignItems: align
            } }, children.map((child, index) => (h("div", { role: "none", style: [
                itemStyle,
                {
                    maxWidth: '100%'
                },
                vertical
                    ? {
                        marginBottom: index !== lastIndex ? verticalMargin : ''
                    }
                    : {
                        marginRight: isJustifySpace
                            ? justify === 'space-between' && index === lastIndex
                                ? ''
                                : semiHorizontalMargin
                            : index !== lastIndex
                                ? horizontalMargin
                                : '',
                        marginLeft: isJustifySpace
                            ? justify === 'space-between' && index === 0
                                ? ''
                                : semiHorizontalMargin
                            : '',
                        paddingTop: semiVerticalMargin,
                        paddingBottom: semiVerticalMargin
                    }
            ] }, child)))));
    }
});

const self$1 = (vars) => {
    const { infoColor, successColor, warningColor, errorColor, textColor2, progressRailColor, fontSize, fontWeight } = vars;
    return {
        fontSize,
        fontSizeCircle: '28px',
        fontWeightCircle: fontWeight,
        railColor: progressRailColor,
        railHeight: '8px',
        iconSizeCircle: '36px',
        iconSizeLine: '18px',
        iconColor: infoColor,
        iconColorInfo: infoColor,
        iconColorSuccess: successColor,
        iconColorWarning: warningColor,
        iconColorError: errorColor,
        textColorCircle: textColor2,
        textColorLineInner: 'rgb(255, 255, 255)',
        textColorLineOuter: textColor2,
        fillColor: infoColor,
        fillColorInfo: infoColor,
        fillColorSuccess: successColor,
        fillColorWarning: warningColor,
        fillColorError: errorColor,
        lineBgProcessing: 'linear-gradient(90deg, rgba(255, 255, 255, .3) 0%, rgba(255, 255, 255, .5) 100%)'
    };
};
const progressLight = {
    name: 'Progress',
    common: commonLight,
    self: self$1
};
var progressLight$1 = progressLight;

// --bezier
// --fill-color
// --font-size
// --font-size-circle
// --font-weight-circle
// --icon-color
// --icon-size-circle
// --icon-size-line
// --line-bg-processing
// --rail-color
// --rail-height
// --text-color-circle
// --text-color-line-inner
// --text-color-line-outer

var style = c$1([cB('progress', {
  display: 'inline-block'
}, [cB('progress-icon', `
 color: var(--icon-color);
 transition: color .3s var(--bezier);
 `), cM('line', `
 width: 100%;
 display: block;
 `, [cB('progress-content', `
 display: flex;
 align-items: center;
 `, [cB('progress-graph', {
  flex: 1
})]), cB('progress-custom-content', {
  marginLeft: '14px'
}), cB('progress-icon', `
 width: 30px;
 padding-left: 14px;
 height: var(--icon-size-line);
 line-height: var(--icon-size-line);
 font-size: var(--icon-size-line);
 `, [cM('as-text', `
 color: var(--text-color-line-outer);
 text-align: center;
 width: 40px;
 font-size: var(--font-size);
 padding-left: 4px;
 transition: color .3s var(--bezier);
 `)])]), cM('circle', {
  width: '120px'
}, [cB('progress-custom-content', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 justify-content: center;
 `), cB('progress-text', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 color: inherit;
 font-size: var(--font-size-circle);
 color: var(--text-color-circle);
 font-weight: var(--font-weight-circle);
 transition: color .3s var(--bezier);
 white-space: nowrap;
 `), cB('progress-icon', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 color: var(--icon-color);
 font-size: var(--icon-size-circle);
 `)]), cM('multiple-circle', {
  width: '200px',
  color: 'inherit'
}, [cB('progress-text', `
 font-weight: var(--font-weight-circle);
 color: var(--text-color-circle);
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 display: flex;
 align-items: center;
 justify-content: center;
 transition: color .3s var(--bezier);
 `)]), cB('progress-content', {
  position: 'relative'
}), cB('progress-graph', {
  position: 'relative'
}, [cB('progress-graph-circle', [c$1('svg', {
  verticalAlign: 'bottom'
}), cB('progress-graph-circle-fill', `
 stroke: var(--fill-color);
 transition:
 opacity .3s var(--bezier),
 stroke .3s var(--bezier),
 stroke-dasharray .3s var(--bezier);
 `, [cM('empty', {
  opacity: 0
})]), cB('progress-graph-circle-rail', `
 transition: stroke .3s var(--bezier);
 overflow: hidden;
 stroke: var(--rail-color);
 `)]), cB('progress-graph-line', [cM('indicator-inside', [cB('progress-graph-line-rail', {
  height: '16px',
  borderRadius: '10px'
}, [cB('progress-graph-line-fill', {
  height: 'inherit',
  borderRadius: '10px'
}), cB('progress-graph-line-indicator', `
 background: #0000;
 white-space: nowrap;
 text-align: right;
 margin-left: 14px;
 margin-right: 14px;
 height: inherit;
 line-height: 16px;
 font-size: 12px;
 color: var(--text-color-line-inner);
 transition: color .3s var(--bezier);
 `)])]), cM('indicator-inside-label', `
 height: 16px;
 display: flex;
 align-items: center;
 `, [cB('progress-graph-line-rail', {
  flex: 1,
  transition: 'background-color .3s var(--bezier)'
}), cB('progress-graph-line-indicator', `
 background: var(--fill-color);
 font-size: 12px;
 transform: translateZ(0);
 display: flex;
 vertical-align: middle;
 height: 16px;
 line-height: 16px;
 padding: 0 10px;
 border-radius: 10px;
 position: absolute;
 white-space: nowrap;
 color: var(--text-color-line-inner);
 transition:
 right .2s var(--bezier),
 color .3s var(--bezier),
 background-color .3s var(--bezier);
 `)]), cB('progress-graph-line-rail', `
 position: relative;
 overflow: hidden;
 height: var(--rail-height);
 border-radius: 5px;
 background-color: var(--rail-color);
 transition: background-color .3s var(--bezier);
 `, [cB('progress-graph-line-fill', `
 background: var(--fill-color);
 position: relative;
 border-radius: 5px;
 height: inherit;
 width: 100%;
 max-width: 0%;
 transition:
 background-color .3s var(--bezier),
 max-width .2s var(--bezier);
 `, [cM('processing', [c$1('&::after', `
 content: "";
 background-image: var(--line-bg-processing);
 animation: progress-processing-animation 2s var(--bezier) infinite;
 `)])])])])])]), c$1('@keyframes progress-processing-animation', `
 0% {
 position: absolute;
 left: 0;
 top: 0;
 bottom: 0;
 right: 100%;
 opacity: 1;
 }
 66% {
 position: absolute;
 left: 0;
 top: 0;
 bottom: 0;
 right: 0;
 opacity: 0;
 }
 100% {
 position: absolute;
 left: 0;
 top: 0;
 bottom: 0;
 right: 0;
 opacity: 0;
 }
 `)]);

const iconMap$1 = {
    success: h(SuccessIcon, null),
    error: h(ErrorIcon, null),
    warning: h(WarningIcon, null),
    info: h(InfoIcon, null)
};
var Line = defineComponent({
    name: 'ProgressLine',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        percentage: {
            type: Number,
            default: 0
        },
        railColor: String,
        railStyle: [String, Object],
        fillColor: String,
        status: {
            type: String,
            required: true
        },
        indicatorPlacement: {
            type: String,
            required: true
        },
        indicatorTextColor: String,
        unit: {
            type: String,
            default: '%'
        },
        processing: {
            type: Boolean,
            required: true
        },
        showIndicator: {
            type: Boolean,
            required: true
        },
        height: [String, Number],
        railBorderRadius: [String, Number],
        fillBorderRadius: [String, Number]
    },
    setup(props, { slots }) {
        const styleHeightRef = computed(() => {
            return formatLength(props.height);
        });
        const styleRailBorderRadiusRef = computed(() => {
            if (props.railBorderRadius !== undefined) {
                return formatLength(props.railBorderRadius);
            }
            if (props.height !== undefined) {
                return formatLength(props.height, { c: 0.5 });
            }
            return '';
        });
        const styleFillBorderRadiusRef = computed(() => {
            if (props.fillBorderRadius !== undefined) {
                return formatLength(props.fillBorderRadius);
            }
            if (props.railBorderRadius !== undefined) {
                return formatLength(props.railBorderRadius);
            }
            if (props.height !== undefined) {
                return formatLength(props.height, { c: 0.5 });
            }
            return '';
        });
        return () => {
            const { indicatorPlacement, railColor, railStyle, percentage, unit, indicatorTextColor, status, showIndicator, fillColor, processing, clsPrefix } = props;
            return (h("div", { class: `${clsPrefix}-progress-content`, role: "none" },
                h("div", { class: `${clsPrefix}-progress-graph`, "aria-hidden": true },
                    h("div", { class: [
                            `${clsPrefix}-progress-graph-line`,
                            {
                                [`${clsPrefix}-progress-graph-line--indicator-${indicatorPlacement}`]: true
                            }
                        ] },
                        h("div", { class: `${clsPrefix}-progress-graph-line-rail`, style: [
                                {
                                    backgroundColor: railColor,
                                    height: styleHeightRef.value,
                                    borderRadius: styleRailBorderRadiusRef.value
                                },
                                railStyle
                            ] },
                            h("div", { class: [
                                    `${clsPrefix}-progress-graph-line-fill`,
                                    processing &&
                                        `${clsPrefix}-progress-graph-line-fill--processing`
                                ], style: {
                                    maxWidth: `${props.percentage}%`,
                                    backgroundColor: fillColor,
                                    height: styleHeightRef.value,
                                    borderRadius: styleFillBorderRadiusRef.value
                                } }, indicatorPlacement === 'inside' ? (h("div", { class: `${clsPrefix}-progress-graph-line-indicator` }, `${percentage}${unit}`)) : null)))),
                showIndicator && indicatorPlacement === 'outside' ? (h("div", null, slots.default ? (h("div", { class: `${clsPrefix}-progress-custom-content`, style: {
                        color: indicatorTextColor
                    }, role: "none" }, slots.default())) : status === 'default' ? (h("div", { role: "none", class: `${clsPrefix}-progress-icon ${clsPrefix}-progress-icon--as-text`, style: {
                        color: indicatorTextColor
                    } },
                    percentage,
                    unit)) : (h("div", { class: `${clsPrefix}-progress-icon`, "aria-hidden": true },
                    h(NBaseIcon, { clsPrefix: clsPrefix }, { default: () => iconMap$1[status] }))))) : null));
        };
    }
});

const iconMap = {
    success: h(SuccessIcon, null),
    error: h(ErrorIcon, null),
    warning: h(WarningIcon, null),
    info: h(InfoIcon, null)
};
var Circle = defineComponent({
    name: 'ProgressCircle',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        status: {
            type: String,
            required: true
        },
        strokeWidth: {
            type: Number,
            required: true
        },
        fillColor: String,
        railColor: String,
        railStyle: [String, Object],
        percentage: {
            type: Number,
            default: 0
        },
        showIndicator: {
            type: Boolean,
            reqiuired: true
        },
        indicatorTextColor: String,
        unit: String,
        viewBoxWidth: {
            type: Number,
            required: true
        }
    },
    setup(props, { slots }) {
        const strokeDasharrayRef = computed(() => {
            return `${Math.PI * props.percentage}, ${props.viewBoxWidth * 8}`;
        });
        return () => {
            const { fillColor, railColor, railStyle, strokeWidth, status, percentage, showIndicator, indicatorTextColor, unit, clsPrefix } = props;
            return (h("div", { class: `${clsPrefix}-progress-content`, role: "none" },
                h("div", { class: `${clsPrefix}-progress-graph`, "aria-hidden": true },
                    h("div", { class: `${clsPrefix}-progress-graph-circle` },
                        h("svg", { viewBox: "0 0 110 110" },
                            h("g", null,
                                h("path", { class: `${clsPrefix}-progress-graph-circle-rail`, d: "m 55 5 a 50 50 0 1 1 0 100 a 50 50 0 1 1 0 -100", "stroke-width": strokeWidth * 1.1, "stroke-linecap": "round", fill: "none", style: [
                                        {
                                            strokeDashoffset: 0,
                                            stroke: railColor
                                        },
                                        railStyle
                                    ] })),
                            h("g", null,
                                h("path", { class: [
                                        `${clsPrefix}-progress-graph-circle-fill`,
                                        percentage === 0 &&
                                            `${clsPrefix}-progress-graph-circle-fill--empty`
                                    ], d: "m 55 5 a 50 50 0 1 1 0 100 a 50 50 0 1 1 0 -100", "stroke-width": strokeWidth * 1.1, "stroke-linecap": "round", fill: "none", style: {
                                        strokeDasharray: strokeDasharrayRef.value,
                                        strokeDashoffset: 0,
                                        stroke: fillColor
                                    } }))))),
                showIndicator ? (h("div", null, slots.default ? (h("div", { class: `${clsPrefix}-progress-custom-content`, role: "none" }, slots.default())) : status !== 'default' ? (h("div", { class: `${clsPrefix}-progress-icon`, "aria-hidden": true },
                    h(NBaseIcon, { clsPrefix: clsPrefix }, {
                        default: () => iconMap[status]
                    }))) : (h("div", { class: `${clsPrefix}-progress-text`, style: {
                        color: indicatorTextColor
                    }, role: "none" },
                    h("span", { class: `${clsPrefix}-progress-text__percentage` }, percentage),
                    h("span", { class: `${clsPrefix}-progress-text__unit` }, unit))))) : null));
        };
    }
});

function circlePath(r, sw, vw = 100) {
    return `m ${vw / 2} ${vw / 2 - r} a ${r} ${r} 0 1 1 0 ${2 * r} a ${r} ${r} 0 1 1 0 -${2 * r}`;
}
var MultipleCircle = defineComponent({
    name: 'ProgressMultipleCircle',
    props: {
        clsPrefix: {
            type: String,
            required: true
        },
        viewBoxWidth: {
            type: Number,
            required: true
        },
        percentage: {
            type: Array,
            default: [0]
        },
        strokeWidth: {
            type: Number,
            required: true
        },
        circleGap: {
            type: Number,
            required: true
        },
        showIndicator: {
            type: Boolean,
            required: true
        },
        fillColor: {
            type: Array,
            default: () => []
        },
        railColor: {
            type: Array,
            default: () => []
        },
        railStyle: {
            type: Array,
            default: () => []
        }
    },
    setup(props, { slots }) {
        const strokeDasharrayRef = computed(() => {
            const strokeDasharrays = props.percentage.map((v, i) => `${((Math.PI * v) / 100) *
                (props.viewBoxWidth / 2 -
                    (props.strokeWidth / 2) * (1 + 2 * i) -
                    props.circleGap * i) *
                2}, ${props.viewBoxWidth * 8}`);
            return strokeDasharrays;
        });
        return () => {
            const { viewBoxWidth, strokeWidth, circleGap, showIndicator, fillColor, railColor, railStyle, percentage, clsPrefix } = props;
            return (h("div", { class: `${clsPrefix}-progress-content`, role: "none" },
                h("div", { class: `${clsPrefix}-progress-graph`, "aria-hidden": true },
                    h("div", { class: `${clsPrefix}-progress-graph-circle` },
                        h("svg", { viewBox: `0 0 ${viewBoxWidth} ${viewBoxWidth}` }, percentage.map((p, index) => {
                            return (h("g", { key: index },
                                h("path", { class: `${clsPrefix}-progress-graph-circle-rail`, d: circlePath(viewBoxWidth / 2 -
                                        (strokeWidth / 2) * (1 + 2 * index) -
                                        circleGap * index, strokeWidth, viewBoxWidth), "stroke-width": strokeWidth, "stroke-linecap": "round", fill: "none", style: [
                                        {
                                            strokeDashoffset: 0,
                                            stroke: railColor[index]
                                        },
                                        railStyle[index]
                                    ] }),
                                h("path", { class: [
                                        `${clsPrefix}-progress-graph-circle-fill`,
                                        p === 0 &&
                                            `${clsPrefix}-progress-graph-circle-fill--empty`
                                    ], d: circlePath(viewBoxWidth / 2 -
                                        (strokeWidth / 2) * (1 + 2 * index) -
                                        circleGap * index, strokeWidth, viewBoxWidth), "stroke-width": strokeWidth, "stroke-linecap": "round", fill: "none", style: {
                                        strokeDasharray: strokeDasharrayRef.value[index],
                                        strokeDashoffset: 0,
                                        stroke: fillColor[index]
                                    } })));
                        })))),
                showIndicator && slots.default ? (h("div", null,
                    h("div", { class: `${clsPrefix}-progress-text` }, slots.default()))) : null));
        };
    }
});

const progressProps = Object.assign(Object.assign({}, useTheme.props), { processing: Boolean, type: {
        type: String,
        default: 'line'
    }, status: {
        type: String,
        default: 'default'
    }, railColor: [String, Array], railStyle: [String, Array], color: [String, Array], viewBoxWidth: {
        type: Number,
        default: 100
    }, strokeWidth: {
        type: Number,
        default: 7
    }, percentage: [Number, Array], unit: {
        type: String,
        default: '%'
    }, showIndicator: {
        type: Boolean,
        default: true
    }, indicatorPosition: {
        type: String,
        default: 'outside'
    }, indicatorPlacement: {
        type: String,
        default: 'outside'
    }, indicatorTextColor: String, circleGap: {
        type: Number,
        default: 1
    }, height: Number, borderRadius: [String, Number], fillBorderRadius: [String, Number] });
var NProgress = defineComponent({
    name: 'Progress',
    props: progressProps,
    setup(props) {
        const mergedIndicatorPlacementRef = computed(() => {
            return props.indicatorPlacement || props.indicatorPosition;
        });
        const { mergedClsPrefixRef } = useConfig(props);
        const themeRef = useTheme('Progress', 'Progress', style, progressLight$1, props, mergedClsPrefixRef);
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            mergedIndicatorPlacement: mergedIndicatorPlacementRef,
            cssVars: computed(() => {
                const { status } = props;
                const { common: { cubicBezierEaseInOut }, self: { fontSize, fontSizeCircle, railColor, railHeight, iconSizeCircle, iconSizeLine, textColorCircle, textColorLineInner, textColorLineOuter, lineBgProcessing, fontWeightCircle, [createKey('iconColor', status)]: iconColor, [createKey('fillColor', status)]: fillColor } } = themeRef.value;
                return {
                    '--bezier': cubicBezierEaseInOut,
                    '--fill-color': fillColor,
                    '--font-size': fontSize,
                    '--font-size-circle': fontSizeCircle,
                    '--font-weight-circle': fontWeightCircle,
                    '--icon-color': iconColor,
                    '--icon-size-circle': iconSizeCircle,
                    '--icon-size-line': iconSizeLine,
                    '--line-bg-processing': lineBgProcessing,
                    '--rail-color': railColor,
                    '--rail-height': railHeight,
                    '--text-color-circle': textColorCircle,
                    '--text-color-line-inner': textColorLineInner,
                    '--text-color-line-outer': textColorLineOuter
                };
            })
        };
    },
    render() {
        // it's ok to expand all prop here since no slots' deps
        const { type, cssVars, indicatorTextColor, showIndicator, status, railColor, railStyle, color, percentage, viewBoxWidth, strokeWidth, mergedIndicatorPlacement, unit, borderRadius, fillBorderRadius, height, processing, circleGap, mergedClsPrefix, $slots } = this;
        return (h("div", { class: [
                `${mergedClsPrefix}-progress`,
                `${mergedClsPrefix}-progress--${type}`,
                `${mergedClsPrefix}-progress--${status}`
            ], style: cssVars, "aria-valuemax": 100, "aria-valuemin": 0, "aria-valuenow": percentage, role: type === 'circle' || type === 'line' ? 'progressbar' : 'none' }, type === 'circle' ? (h(Circle, { clsPrefix: mergedClsPrefix, status: status, showIndicator: showIndicator, indicatorTextColor: indicatorTextColor, railColor: railColor, fillColor: color, railStyle: railStyle, percentage: percentage, viewBoxWidth: viewBoxWidth, strokeWidth: strokeWidth, unit: unit }, $slots)) : type === 'line' ? (h(Line, { clsPrefix: mergedClsPrefix, status: status, showIndicator: showIndicator, indicatorTextColor: indicatorTextColor, railColor: railColor, fillColor: color, railStyle: railStyle, percentage: percentage, processing: processing, indicatorPlacement: mergedIndicatorPlacement, unit: unit, fillBorderRadius: fillBorderRadius, railBorderRadius: borderRadius, height: height }, $slots)) : type === 'multiple-circle' ? (h(MultipleCircle, { clsPrefix: mergedClsPrefix, strokeWidth: strokeWidth, railColor: railColor, fillColor: color, railStyle: railStyle, viewBoxWidth: viewBoxWidth, percentage: percentage, showIndicator: showIndicator, circleGap: circleGap }, $slots)) : null));
    }
});

var img$d = "data:image/png;base64,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";
  var CircleBg = img$d;

var script$h = /*#__PURE__*/defineComponent({
  props: {
    color: {
      type: [String, Array],
      default: '#F7933E'
    },
    railColor: {
      type: [String, Array],
      default: 'rgba(255,255,255,0.1)'
    },
    value: {
      type: Number,
      default: 0
    },
    radius: {
      type: Number,
      default: 0
    },
    strokeWidth: {
      type: Number,
      default: 8
    },
    showInfo: {
      type: Boolean,
      default: true
    }
  },

  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: "circle",
        style: normalizeStyle(`background-image:url(${unref(CircleBg)})`)
      }, [createVNode(unref(NProgress), {
        class: "circle-item",
        type: "circle",
        percentage: +__props.value,
        color: __props.color,
        "border-radius": __props.radius,
        "fill-border-radius": __props.radius,
        "stroke-width": +__props.strokeWidth,
        "indicator-text-color": "#fff",
        "show-indicator": __props.showInfo,
        "rail-color": __props.railColor
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["percentage", "color", "border-radius", "fill-border-radius", "stroke-width", "show-indicator", "rail-color"])], 4);
    };
  }

});

var css_248z$i = ".circle[data-v-76fe074a] {\n  width: 100%;\n  height: 100%;\n  background-repeat: no-repeat;\n  background-size: 100% 100%;\n  background-position: center;\n  padding: 0.05rem;\n  box-sizing: border-box;\n}\n.circle .circle-item[data-v-76fe074a] {\n  width: 100%;\n  height: 100%;\n}\n";
styleInject(css_248z$i);

script$h.__scopeId = "data-v-76fe074a";

const _withScopeId$7 = n => (pushScopeId("data-v-5e9684ef"), n = n(), popScopeId(), n);

const _hoisted_1$g = {
  class: "sum"
};
const _hoisted_2$d = {
  class: "content"
};
const _hoisted_3$d = {
  class: "cross"
};

const _hoisted_4$c = /*#__PURE__*/createTextVNode(" 个");

const _hoisted_5$a = /*#__PURE__*/_withScopeId$7(() => /*#__PURE__*/createElementVNode("span", null, "交叉任职数", -1));

const _hoisted_6$a = {
  class: "chart"
};
const __default__$d = {
  name: 'A003',
  title: '党建引领',
  row: 1
};

function setup$d(__props) {
  const fontSize = computed(() => Math.floor(screen.height * 1.6 / 100));
  const summary = [{
    name: '居委会',
    value: 10
  }, {
    name: '业委会',
    value: 10
  }, {
    name: '物业企业',
    value: 20
  }];
  const barData = {
    dimensions: [{
      name: 'street',
      displayName: '街道'
    }, {
      name: 'partyNum',
      displayName: '党小组数量'
    }, {
      name: 'data1',
      displayName: '居委会'
    }, {
      name: 'data2',
      displayName: '业委会'
    }, {
      name: 'data3',
      displayName: '物业企业'
    }],
    source: [{
      street: '街道1',
      partyNum: 60,
      data1: 20,
      data2: 20,
      data3: 20
    }, {
      street: '街道2',
      partyNum: 90,
      data1: 20,
      data2: 30,
      data3: 40
    }, {
      street: '街道3',
      partyNum: 130,
      data1: 30,
      data2: 40,
      data3: 60
    }, {
      street: '街道4',
      partyNum: 120,
      data1: 40,
      data2: 50,
      data3: 30
    }, {
      street: '街道5',
      partyNum: 120,
      data1: 50,
      data2: 60,
      data3: 10
    }, {
      street: '街道6',
      partyNum: 140,
      data1: 50,
      data2: 60,
      data3: 30
    }, {
      street: '街道7',
      partyNum: 130,
      data1: 50,
      data2: 60,
      data3: 20
    }, {
      street: '街道8',
      partyNum: 110,
      data1: 20,
      data2: 60,
      data3: 30
    }]
  };
  const barOption = {
    color: ['#785CDD', '#77BFF9', '#EDB872', '#64C29D'],
    legend: {
      right: '2%',
      itemWidth: fontSize.value * 0.6,
      itemHeight: fontSize.value * 0.8
    },
    yAxis: {
      minInterval: 1
    },
    xAxis: [{
      type: 'category',
      axisLabel: {
        interval: 0
      }
    }],
    series: [{
      type: 'bar',
      barWidth: '18%',
      itemStyle: {
        borderRadius: 8
      },
      barGap: 0
    }, ...[1, 2, 3].map(() => ({
      type: 'bar',
      barWidth: '18%',
      itemStyle: {
        borderRadius: 8
      },
      barGap: 0,
      stack: '总量'
    }))]
  };
  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_bar = resolveComponent("m-bar");

    const _component_m_empty = resolveComponent("m-empty");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "党建引领"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$g, [(openBlock(), createElementBlock(Fragment, null, renderList(summary, item => {
        return createElementVNode("div", {
          key: item.name,
          class: "rate"
        }, [createVNode(script$h, {
          value: item.value
        }, {
          default: withCtx(() => [createElementVNode("div", _hoisted_2$d, [createVNode(_component_m_count, {
            value: item.value
          }, null, 8, ["value"]), createElementVNode("p", null, toDisplayString(item.name), 1)])]),
          _: 2
        }, 1032, ["value"])]);
      }), 64)), createElementVNode("div", _hoisted_3$d, [createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 5
      }), _hoisted_4$c]), _hoisted_5$a])]), createElementVNode("div", _hoisted_6$a, [barData.source.length > 0 ? (openBlock(), createBlock(_component_m_bar, {
        key: 0,
        dataset: barData,
        option: barOption
      })) : (openBlock(), createBlock(_component_m_empty, {
        key: 1
      }))])]),
      _: 1
    });
  };
}

var script$g = /*#__PURE__*/defineComponent({ ...__default__$d,
  setup: setup$d
});

var css_248z$h = ".content[data-v-5e9684ef] {\n  text-align: center;\n  white-space: nowrap;\n}\n.sum[data-v-5e9684ef] {\n  display: flex;\n}\n.sum >div[data-v-5e9684ef] {\n  flex: 1;\n}\n.sum >div.rate[data-v-5e9684ef] {\n  box-sizing: border-box;\n  padding: 0.06rem;\n}\n.sum >div.cross[data-v-5e9684ef] {\n  flex: 1.4;\n  margin: 0.08rem 0.05rem;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex-direction: column;\n}\n.sum >div.cross .count[data-v-5e9684ef] {\n  color: #f7933e;\n  font-size: 0.12rem;\n}\n.chart[data-v-5e9684ef] {\n  width: 100%;\n  height: 1.1rem;\n}\n";
styleInject(css_248z$h);

script$g.__scopeId = "data-v-5e9684ef";

var script$f = {
  name: 'A004',
  title: '公共收益',
  row: 1
};

const _withScopeId$6 = n => (pushScopeId("data-v-7f51faa6"), n = n(), popScopeId(), n);

const _hoisted_1$f = /*#__PURE__*/createTextVNode(" 存量总额 ");

const _hoisted_2$c = {
  class: "wrapper"
};

const _hoisted_3$c = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("p", null, "收入（季度）", -1));

const _hoisted_4$b = {
  class: "count"
};

const _hoisted_5$9 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("span", null, "元", -1));

const _hoisted_6$9 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("p", null, "总额", -1));

const _hoisted_7$9 = /*#__PURE__*/createTextVNode(" | ");

const _hoisted_8$9 = {
  class: "count"
};

const _hoisted_9$8 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("span", null, "个", -1));

const _hoisted_10$7 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("p", null, "小区", -1));

const _hoisted_11$7 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("p", null, "支出（季度）", -1));

const _hoisted_12$4 = {
  class: "count"
};

const _hoisted_13$4 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("span", null, "元", -1));

const _hoisted_14$4 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("p", null, "总额", -1));

const _hoisted_15$4 = /*#__PURE__*/createTextVNode(" | ");

const _hoisted_16$3 = {
  class: "count"
};

const _hoisted_17$1 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("span", null, "个", -1));

const _hoisted_18$1 = /*#__PURE__*/_withScopeId$6(() => /*#__PURE__*/createElementVNode("p", null, "小区", -1));

const _hoisted_19$1 = /*#__PURE__*/createTextVNode("维修资金总额");

function render$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_sub = resolveComponent("m-sub");

  const _component_m_count = resolveComponent("m-count");

  const _component_m_card = resolveComponent("m-card");

  return openBlock(), createBlock(_component_m_card, {
    title: "公共收益"
  }, {
    default: withCtx(() => [createVNode(_component_m_sub, {
      addition: {
        value: 6000,
        unit: '元'
      }
    }, {
      default: withCtx(() => [_hoisted_1$f]),
      _: 1
    }), createElementVNode("div", _hoisted_2$c, [createElementVNode("div", null, [_hoisted_3$c, createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("p", _hoisted_4$b, [createVNode(_component_m_count, {
      value: 100
    }), _hoisted_5$9]), _hoisted_6$9]), _hoisted_7$9, createElementVNode("div", null, [createElementVNode("p", _hoisted_8$9, [createVNode(_component_m_count, {
      value: 180
    }), _hoisted_9$8]), _hoisted_10$7])])]), createElementVNode("div", null, [_hoisted_11$7, createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("p", _hoisted_12$4, [createVNode(_component_m_count, {
      value: 169
    }), _hoisted_13$4]), _hoisted_14$4]), _hoisted_15$4, createElementVNode("div", null, [createElementVNode("p", _hoisted_16$3, [createVNode(_component_m_count, {
      value: 156
    }), _hoisted_17$1]), _hoisted_18$1])])])]), createVNode(_component_m_sub, {
      addition: {
        value: 1684,
        unit: '万元'
      }
    }, {
      default: withCtx(() => [_hoisted_19$1]),
      _: 1
    })]),
    _: 1
  });
}

var css_248z$g = ".wrapper[data-v-7f51faa6] {\n  display: flex;\n  justify-content: space-between;\n  margin: 0.05rem 0;\n}\n.wrapper >div[data-v-7f51faa6] {\n  width: 48%;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.06rem 0.1rem;\n}\n.wrapper >div >div[data-v-7f51faa6] {\n  display: flex;\n  align-items: center;\n  margin-top: 0.05rem;\n}\n.wrapper >div >div >div[data-v-7f51faa6] {\n  flex: 1;\n  text-align: center;\n}\n.wrapper >div >div >div .count[data-v-7f51faa6] {\n  font-size: 0.14rem;\n  color: #edb872;\n  font-family: DIN, 'Avenir', Helvetica, Arial, sans-serif;\n  font-weight: bold;\n}\n.wrapper >div >div >div .count >span[data-v-7f51faa6] {\n  color: #ccc;\n  font-size: 0.09rem;\n  font-weight: normal;\n}\n.wrapper >div >div >div >p[data-v-7f51faa6] {\n  color: #ccc;\n}\n";
styleInject(css_248z$g);

script$f.render = render$2;
script$f.__scopeId = "data-v-7f51faa6";

const _hoisted_1$e = {
  class: "sum"
};

const _hoisted_2$b = /*#__PURE__*/createTextVNode("公开招投标数");

const _hoisted_3$b = /*#__PURE__*/createTextVNode("招标中 ");

const _hoisted_4$a = /*#__PURE__*/createTextVNode("已完成 ");

const _hoisted_5$8 = /*#__PURE__*/createTextVNode("邀请招标");

const _hoisted_6$8 = /*#__PURE__*/createTextVNode("招标中 ");

const _hoisted_7$8 = /*#__PURE__*/createTextVNode("已完成 ");

const _hoisted_8$8 = {
  class: "rate"
};
const _hoisted_9$7 = {
  class: "des"
};

const _hoisted_10$6 = /*#__PURE__*/createTextVNode(" 前期物业招标 ");

const _hoisted_11$6 = /*#__PURE__*/createTextVNode(" 业主大会公开招标 ");
const __default__$c = {
  name: 'A005',
  title: '招投标',
  row: 1
};

function setup$c(__props) {
  return (_ctx, _cache) => {
    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_count = resolveComponent("m-count");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "招投标"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$e, [createElementVNode("div", null, [createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_2$b]),
        _: 1
      }), createElementVNode("span", null, [_hoisted_3$b, createVNode(_component_m_count, {
        class: "count",
        value: 31
      })]), createElementVNode("span", null, [_hoisted_4$a, createVNode(_component_m_count, {
        class: "count",
        value: 24
      })])]), createElementVNode("div", null, [createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_5$8]),
        _: 1
      }), createElementVNode("span", null, [_hoisted_6$8, createVNode(_component_m_count, {
        class: "count",
        value: 31
      })]), createElementVNode("span", null, [_hoisted_7$8, createVNode(_component_m_count, {
        class: "count",
        value: 24
      })])])]), createElementVNode("div", _hoisted_8$8, [createVNode(script$h, {
        class: "circle",
        color: "#F7B500",
        "rail-color": "#0091FF",
        value: 30,
        "show-info": false
      }), createElementVNode("div", _hoisted_9$7, [createElementVNode("p", null, [_hoisted_10$6, createVNode(_component_m_count, {
        class: "count",
        style: {
          "color": "#f7b500"
        },
        value: 120
      })]), createElementVNode("p", null, [_hoisted_11$6, createVNode(_component_m_count, {
        class: "count",
        style: {
          "color": "#0091ff"
        },
        value: 350
      })])])])]),
      _: 1
    });
  };
}

var script$e = /*#__PURE__*/defineComponent({ ...__default__$c,
  setup: setup$c
});

var css_248z$f = ".sum[data-v-1fc6afdb] {\n  display: flex;\n}\n.sum >div[data-v-1fc6afdb] {\n  flex: 1;\n  margin: 0 0.05rem;\n}\n.sum >div .count[data-v-1fc6afdb] {\n  font-size: 0.14rem;\n  margin-left: 0.04rem;\n  color: #fff;\n  font-weight: bold;\n}\n.sum >div span[data-v-1fc6afdb] {\n  color: #ccc;\n}\n.sum >div span[data-v-1fc6afdb]:last-child {\n  float: right;\n}\n.rate[data-v-1fc6afdb] {\n  display: flex;\n  margin-top: 0.05rem;\n  padding-left: 0.1rem;\n}\n.rate .circle[data-v-1fc6afdb] {\n  width: 24%;\n}\n.rate .des[data-v-1fc6afdb] {\n  flex: 1;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  margin-left: 0.3rem;\n}\n.rate .des .count[data-v-1fc6afdb] {\n  font-size: 0.14rem;\n  margin-left: 0.1rem;\n}\n";
styleInject(css_248z$f);

script$e.__scopeId = "data-v-1fc6afdb";

var script$d = {
  name: 'A006',
  title: '行业监管',
  row: 1
};

const _withScopeId$5 = n => (pushScopeId("data-v-1273eb53"), n = n(), popScopeId(), n);

const _hoisted_1$d = {
  class: "summary"
};
const _hoisted_2$a = {
  class: "rate"
};

const _hoisted_3$a = /*#__PURE__*/createTextVNode("/");

const _hoisted_4$9 = /*#__PURE__*/_withScopeId$5(() => /*#__PURE__*/createElementVNode("p", null, "督查", -1));

const _hoisted_5$7 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_6$7 = /*#__PURE__*/_withScopeId$5(() => /*#__PURE__*/createElementVNode("p", null, "整改率", -1));

const _hoisted_7$7 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_8$7 = /*#__PURE__*/_withScopeId$5(() => /*#__PURE__*/createElementVNode("p", null, "日查", -1));

const _hoisted_9$6 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_10$5 = /*#__PURE__*/_withScopeId$5(() => /*#__PURE__*/createElementVNode("p", null, "双周查", -1));

const _hoisted_11$5 = /*#__PURE__*/createTextVNode("% ");

const _hoisted_12$3 = /*#__PURE__*/_withScopeId$5(() => /*#__PURE__*/createElementVNode("p", null, "月查", -1));

const _hoisted_13$3 = {
  class: "month"
};

const _hoisted_14$3 = /*#__PURE__*/_withScopeId$5(() => /*#__PURE__*/createElementVNode("p", null, "房办月查完成情况", -1));

const _hoisted_15$3 = /*#__PURE__*/createTextVNode("重大事件清单");

const _hoisted_16$2 = /*#__PURE__*/_withScopeId$5(() => /*#__PURE__*/createElementVNode("div", {
  class: "content"
}, [/*#__PURE__*/createElementVNode("div", {
  class: "title"
}, [/*#__PURE__*/createElementVNode("p", null, "小区名称"), /*#__PURE__*/createElementVNode("span", {
  class: "line"
}), /*#__PURE__*/createElementVNode("span", null, "上报主题")]), /*#__PURE__*/createElementVNode("div", {
  class: "info"
}, [/*#__PURE__*/createElementVNode("div", null, [/*#__PURE__*/createElementVNode("span", null, "事件类型"), /*#__PURE__*/createElementVNode("p", null, "事件类型")]), /*#__PURE__*/createElementVNode("div", null, [/*#__PURE__*/createElementVNode("span", null, "人员伤亡"), /*#__PURE__*/createElementVNode("p", null, "0人")]), /*#__PURE__*/createElementVNode("div", null, [/*#__PURE__*/createElementVNode("span", null, "财产损失"), /*#__PURE__*/createElementVNode("p", null, "0元")])])], -1));

function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_count = resolveComponent("m-count");

  const _component_m_sub = resolveComponent("m-sub");

  const _component_m_card = resolveComponent("m-card");

  return openBlock(), createBlock(_component_m_card, {
    title: "行业监管"
  }, {
    default: withCtx(() => [createElementVNode("div", _hoisted_1$d, [createElementVNode("div", _hoisted_2$a, [createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count orange-count",
      value: 31
    }), _hoisted_3$a, createVNode(_component_m_count, {
      value: 50
    })]), _hoisted_4$9]), createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count orange-count",
      value: 31
    }), _hoisted_5$7]), _hoisted_6$7])]), createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count",
      value: 90
    }), _hoisted_7$7]), _hoisted_8$7]), createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count",
      value: 82
    }), _hoisted_9$6]), _hoisted_10$5]), createElementVNode("div", null, [createElementVNode("span", null, [createVNode(_component_m_count, {
      class: "count",
      value: 76
    }), _hoisted_11$5]), _hoisted_12$3])])]), createElementVNode("div", _hoisted_13$3, [_hoisted_14$3, createElementVNode("div", null, [(openBlock(true), createElementBlock(Fragment, null, renderList(new Array(12), (_, i) => {
      return openBlock(), createElementBlock("span", {
        key: i
      }, toDisplayString(i + 1), 1);
    }), 128))])])]), createVNode(_component_m_sub, null, {
      default: withCtx(() => [_hoisted_15$3]),
      _: 1
    }), _hoisted_16$2]),
    _: 1
  });
}

var css_248z$e = ".summary[data-v-1273eb53] {\n  display: flex;\n}\n.summary .rate[data-v-1273eb53] {\n  width: 45%;\n}\n.summary .rate >div >div[data-v-1273eb53] {\n  display: inline-block;\n  width: 33.3%;\n}\n.summary .rate >div .count[data-v-1273eb53] {\n  font-size: 0.14rem;\n  color: #fff;\n}\n.summary .rate >div span[data-v-1273eb53],\n.summary .rate >div p[data-v-1273eb53] {\n  font-size: 0.09rem;\n  color: #ccc;\n}\n.summary .month[data-v-1273eb53] {\n  flex: 1;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.05rem 0.1rem;\n  display: flex;\n  flex-direction: column;\n  margin: 0.04rem 0;\n}\n.summary .month >div[data-v-1273eb53] {\n  margin-top: 0.04rem;\n  flex: 1;\n  display: grid;\n  grid-template-columns: 1fr 1fr 1fr 1fr 1fr 1fr;\n  grid-template-rows: 1fr 1fr;\n  grid-gap: 0.04rem;\n}\n.summary .month >div span[data-v-1273eb53] {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 0.02rem;\n  background: #4f953b;\n}\n.content[data-v-1273eb53] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.04rem 0.1rem;\n  margin-bottom: 0.04rem;\n}\n.content .title[data-v-1273eb53] {\n  display: flex;\n  align-items: center;\n}\n.content .title .line[data-v-1273eb53] {\n  flex: 1;\n  height: 0;\n  border-bottom: 0.01rem dashed #2f86ee;\n  margin: 0 0.05rem;\n}\n.content .info[data-v-1273eb53] {\n  display: flex;\n}\n.content .info >div[data-v-1273eb53] {\n  flex: 1;\n}\n.content .info >div span[data-v-1273eb53] {\n  color: #ccc;\n  font-size: 0.08rem;\n}\n";
styleInject(css_248z$e);

script$d.render = render$1;
script$d.__scopeId = "data-v-1273eb53";

const _hoisted_1$c = {
  class: "sum"
};

const _hoisted_2$9 = /*#__PURE__*/createTextVNode(" 全区物业保修数 ");

const _hoisted_3$9 = /*#__PURE__*/createTextVNode(" 个 ");

const _hoisted_4$8 = /*#__PURE__*/createTextVNode(" 应急维修数 ");

const _hoisted_5$6 = {
  class: "orange-count"
};

const _hoisted_6$6 = /*#__PURE__*/createTextVNode("/");

const _hoisted_7$6 = /*#__PURE__*/createTextVNode("/");

const _hoisted_8$6 = /*#__PURE__*/createTextVNode(" 个 ");

const _hoisted_9$5 = {
  class: "bar"
};
const _hoisted_10$4 = {
  class: "content"
};
const _hoisted_11$4 = {
  class: "progress"
};
const __default__$b = {
  name: 'A007',
  title: '物业报修',
  row: 1
};

function setup$b(__props) {
  const list = [{
    name: '商品房',
    value: 60,
    rate: 20,
    count: 0.1,
    color: '#72c011'
  }, {
    name: '老旧小区',
    value: 135,
    rate: 45,
    count: 0.5,
    color: '#ff9d26'
  }, {
    name: '保障房',
    value: 105,
    rate: 35,
    count: 0.3,
    color: '#01bffe'
  }];
  const total = 255;
  const companyData = [{
    name: '物业企业1',
    value: 21,
    rate: (21 / total * 100).toFixed(0),
    count: 0.5
  }, {
    name: '物业企业2',
    value: 12,
    rate: (12 / total * 100).toFixed(0),
    count: 0.4
  }, {
    name: '物业企业3',
    value: 12,
    rate: (12 / total * 100).toFixed(0),
    count: 0.4
  }, {
    name: '其他',
    value: 210,
    rate: (210 / total * 100).toFixed(0),
    count: 0.9
  }];
  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_progress = resolveComponent("m-progress");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "物业报修"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$c, [createElementVNode("div", null, [_hoisted_2$9, createElementVNode("span", null, [createVNode(_component_m_count, {
        class: "orange-count",
        value: 100
      })]), _hoisted_3$9]), createElementVNode("div", null, [_hoisted_4$8, createElementVNode("span", _hoisted_5$6, [createVNode(_component_m_count, {
        value: 2
      }), _hoisted_6$6, createVNode(_component_m_count, {
        value: 4
      }), _hoisted_7$6, createVNode(_component_m_count, {
        value: 18
      })]), _hoisted_8$6])]), createElementVNode("div", _hoisted_9$5, [(openBlock(), createElementBlock(Fragment, null, renderList(list, item => {
        return createElementVNode("div", {
          key: item.name,
          style: normalizeStyle({
            flex: item.rate,
            background: item.color
          })
        }, [createElementVNode("div", {
          style: normalizeStyle({
            borderColor: item.color
          })
        }, [createElementVNode("p", null, [createElementVNode("span", {
          style: normalizeStyle({
            color: item.color
          })
        }, toDisplayString(item.value) + " / " + toDisplayString(item.rate) + "% / " + toDisplayString(item.count), 5), createTextVNode(" " + toDisplayString(item.name), 1)])], 4)], 4);
      }), 64))]), createElementVNode("div", _hoisted_10$4, [(openBlock(), createElementBlock(Fragment, null, renderList(companyData, item => {
        return createElementVNode("div", {
          key: item.name
        }, [createElementVNode("span", null, toDisplayString(item.name), 1), createElementVNode("div", _hoisted_11$4, [createVNode(_component_m_progress, {
          color: ['#FF692D', '#F7973D'],
          value: +item.rate
        }, null, 8, ["value"])]), createElementVNode("p", null, toDisplayString(item.value) + " / " + toDisplayString(item.rate) + "% / " + toDisplayString(item.count), 1)]);
      }), 64))])]),
      _: 1
    });
  };
}

var script$c = /*#__PURE__*/defineComponent({ ...__default__$b,
  setup: setup$b
});

var css_248z$d = ".sum[data-v-40fd0ac8] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding: 0.03rem 0.05rem;\n}\n.sum span[data-v-40fd0ac8] {\n  margin-left: 0.1rem;\n}\n.bar[data-v-40fd0ac8] {\n  display: flex;\n  width: 100%;\n  height: 0.06rem;\n  margin: 0.35rem 0 0.05rem;\n}\n.bar >div[data-v-40fd0ac8] {\n  position: relative;\n}\n.bar >div .count[data-v-40fd0ac8] {\n  font-size: 0.12rem;\n}\n.bar >div p[data-v-40fd0ac8] {\n  position: absolute;\n  min-width: 1rem;\n}\n.bar >div p span[data-v-40fd0ac8] {\n  display: block;\n}\n.bar >div >div[data-v-40fd0ac8] {\n  height: 0.25rem;\n}\n.bar >div:nth-of-type(1) >div[data-v-40fd0ac8] {\n  transform: translateY(-90%);\n  border-left: 0.01rem solid;\n}\n.bar >div:nth-of-type(1) p[data-v-40fd0ac8] {\n  top: -0.09rem;\n  left: 0.05rem;\n}\n.bar >div:nth-of-type(2) >div[data-v-40fd0ac8],\n.bar >div:nth-of-type(3) >div[data-v-40fd0ac8] {\n  transform: translateY(-90%);\n  border-right: 0.01rem solid;\n}\n.bar >div:nth-of-type(2) p[data-v-40fd0ac8],\n.bar >div:nth-of-type(3) p[data-v-40fd0ac8] {\n  top: -0.09rem;\n  right: 0.05rem;\n  text-align: right;\n}\n.content >div[data-v-40fd0ac8] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n.content >div .progress[data-v-40fd0ac8] {\n  flex: 1;\n  margin: 0 0.05rem;\n}\n.content >div span[data-v-40fd0ac8] {\n  min-width: 0.5rem;\n}\n.content >div p[data-v-40fd0ac8] {\n  min-width: 0.5rem;\n  text-align: right;\n}\n";
styleInject(css_248z$d);

script$c.__scopeId = "data-v-40fd0ac8";

const _hoisted_1$b = {
  class: "chart"
};
const __default__$a = {
  name: 'A008',
  title: '小区健康度',
  row: 1
};

function setup$a(__props) {
  const data = {
    dimensions: [{
      name: 'class1',
      displayName: '行政检查',
      max: 100
    }, {
      name: 'class2',
      displayName: '履行行业管理',
      max: 100
    }, {
      name: 'class3',
      displayName: '履行物业服务规范',
      max: 100
    }, {
      name: 'class4',
      displayName: '投诉及处置情况',
      max: 100
    }, {
      name: 'class5',
      displayName: '诚信积分',
      max: 100
    }],
    source: [{
      seriesName: '健康度',
      class1: 85.6,
      class2: 87.6,
      class3: 54.6,
      class4: 96,
      class5: 72.7
    }]
  };
  const option = {
    color: [['#0078D0', '#61FAFA']],
    legend: {
      show: false
    },
    tooltip: null,
    radar: {
      radius: '60%',
      axisName: {
        formatter: function (value, {
          name
        }) {
          var _data$dimensions$find;

          const key = (_data$dimensions$find = data.dimensions.find(e => e.displayName === name)) === null || _data$dimensions$find === void 0 ? void 0 : _data$dimensions$find.name;
          if (!key) return value;
          const val = data.source[0][key] || 0;
          let displayNum = '';

          if (val <= 60) {
            displayNum = `{b|${val}}`;
          } else if (val > 60 && val <= 80) {
            displayNum = `{c|${val}}`;
          } else if (val > 80) {
            displayNum = `{d|${val}}`;
          }

          return [`{a|${value}}`, displayNum].join('\n');
        },
        rich: {
          a: {
            color: '#ccc',
            fontSize: '.09rem',
            lineHeight: 14
          },
          b: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#F7B500',
            align: 'center'
          },
          c: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#32C5FF',
            align: 'center'
          },
          d: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#42FC5A',
            align: 'center'
          }
        }
      }
    }
  };
  return (_ctx, _cache) => {
    const _component_m_radar = resolveComponent("m-radar");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "小区健康度"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$b, [createVNode(_component_m_radar, {
        dataset: data,
        option: option
      })])]),
      _: 1
    });
  };
}

var script$b = /*#__PURE__*/defineComponent({ ...__default__$a,
  setup: setup$a
});

var css_248z$c = ".chart[data-v-3e2456cf] {\n  width: 100%;\n  height: 1.5rem;\n}\n";
styleInject(css_248z$c);

script$b.__scopeId = "data-v-3e2456cf";

const _hoisted_1$a = {
  class: "chart"
};
const __default__$9 = {
  name: 'A009',
  title: '企业履职评分',
  row: 1
};

function setup$9(__props) {
  const data = {
    dimensions: [{
      name: 'class1',
      displayName: '物业服务履约质量',
      max: 100
    }, {
      name: 'class2',
      displayName: '综合能力等级',
      max: 100
    }, {
      name: 'class3',
      displayName: '诉求处置及信息报送',
      max: 100
    }, {
      name: 'class4',
      displayName: '社会责任履行社区满意度',
      max: 100
    }, {
      name: 'class5',
      displayName: '社会公众满意度',
      max: 100
    }, {
      name: 'class6',
      displayName: '企业信用计分情况',
      max: 100
    }],
    source: [{
      seriesName: '健康度',
      class1: 85.6,
      class2: 72.7,
      class3: 69.2,
      class4: 96.0,
      class5: 54.6,
      class6: 87.6
    }]
  };
  const option = {
    color: [['#F76B1C', '#FAD961']],
    legend: {
      show: false
    },
    tooltip: null,
    radar: {
      center: ['50%', '50%'],
      radius: '52%',
      axisName: {
        formatter: function (value, {
          name
        }) {
          var _data$dimensions$find;

          const key = (_data$dimensions$find = data.dimensions.find(e => e.displayName === name)) === null || _data$dimensions$find === void 0 ? void 0 : _data$dimensions$find.name;
          if (!key) return value;
          const val = data.source[0][key] || 0;
          let displayNum = '';

          if (val <= 60) {
            displayNum = `{b|${val}}`;
          } else if (val > 60 && val <= 80) {
            displayNum = `{c|${val}}`;
          } else if (val > 80) {
            displayNum = `{d|${val}}`;
          }

          return [`{a|${value}}`, displayNum].join('\n');
        },
        rich: {
          a: {
            color: '#ccc',
            fontSize: '.09rem',
            lineHeight: 14
          },
          b: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#F7B500',
            align: 'center'
          },
          c: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#32C5FF',
            align: 'center'
          },
          d: {
            fontSize: '.12rem',
            fontWeight: 'bold',
            color: '#42FC5A',
            align: 'center'
          }
        }
      }
    }
  };
  return (_ctx, _cache) => {
    const _component_m_radar = resolveComponent("m-radar");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "企业履职评分"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$a, [createVNode(_component_m_radar, {
        dataset: data,
        option: option
      })])]),
      _: 1
    });
  };
}

var script$a = /*#__PURE__*/defineComponent({ ...__default__$9,
  setup: setup$9
});

var css_248z$b = ".chart[data-v-5792548e] {\n  width: 100%;\n  height: 1.5rem;\n}\n";
styleInject(css_248z$b);

script$a.__scopeId = "data-v-5792548e";

const _withScopeId$4 = n => (pushScopeId("data-v-415a95ff"), n = n(), popScopeId(), n);

const _hoisted_1$9 = {
  class: "sum"
};

const _hoisted_2$8 = /*#__PURE__*/createTextVNode("新建商品房");

const _hoisted_3$8 = {
  class: "house"
};
const _hoisted_4$7 = {
  class: "title"
};

const _hoisted_5$5 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("p", null, "福新名苑", -1));

const _hoisted_6$5 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("span", {
  class: "line"
}, null, -1));

const _hoisted_7$5 = /*#__PURE__*/createTextVNode("万㎡ ");

const _hoisted_8$5 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("div", {
  class: "company"
}, "上海北航置业发展有限公司", -1));

const _hoisted_9$4 = {
  class: "info"
};

const _hoisted_10$3 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("span", null, "上市套数", -1));

const _hoisted_11$3 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("span", null, "套", -1));

const _hoisted_12$2 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("span", null, "上市面积", -1));

const _hoisted_13$2 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("span", null, "万㎡", -1));

const _hoisted_14$2 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("span", null, "去化率", -1));

const _hoisted_15$2 = /*#__PURE__*/_withScopeId$4(() => /*#__PURE__*/createElementVNode("span", null, "%", -1));

const __default__$8 = {
  name: 'A010',
  title: '交易数据',
  row: 1
};

function setup$8(__props) {
  const summary = [{
    name: '房屋供应总套数',
    value: 714,
    unit: '套'
  }, {
    name: '房屋成交总套数',
    value: 1564,
    unit: '套'
  }, {
    name: '车位成交总数',
    value: 1353,
    unit: '个'
  }];
  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "交易数据"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$9, [(openBlock(), createElementBlock(Fragment, null, renderList(summary, item => {
        return createElementVNode("p", {
          key: item.name
        }, [createTextVNode(toDisplayString(item.name) + " ", 1), createElementVNode("span", null, [createVNode(_component_m_count, {
          class: "orange-count",
          value: item.value
        }, null, 8, ["value"]), createTextVNode(" " + toDisplayString(item.unit), 1)])]);
      }), 64))]), createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_2$8]),
        _: 1
      }), createElementVNode("div", _hoisted_3$8, [createElementVNode("div", _hoisted_4$7, [_hoisted_5$5, _hoisted_6$5, createElementVNode("span", null, [createVNode(_component_m_count, {
        class: "orange-count",
        value: 13.2,
        decimal: 2
      }, null, 8, ["value"]), _hoisted_7$5])]), _hoisted_8$5, createElementVNode("div", _hoisted_9$4, [createElementVNode("div", null, [_hoisted_10$3, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 199
      }), _hoisted_11$3])]), createElementVNode("div", null, [_hoisted_12$2, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 29.6,
        decimal: 2
      }, null, 8, ["value"]), _hoisted_13$2])]), createElementVNode("div", null, [_hoisted_14$2, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 100
      }), _hoisted_15$2])])])])]),
      _: 1
    });
  };
}

var script$9 = /*#__PURE__*/defineComponent({ ...__default__$8,
  setup: setup$8
});

var css_248z$a = ".sum[data-v-415a95ff] {\n  display: flex;\n  flex-wrap: wrap;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.05rem 0;\n  margin-bottom: 0.05rem;\n}\n.sum >p[data-v-415a95ff] {\n  width: 50%;\n  padding: 0 0.05rem;\n  box-sizing: inherit;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n.house[data-v-415a95ff] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.04rem 0.1rem;\n  margin-bottom: 0.04rem;\n}\n.house .title[data-v-415a95ff] {\n  display: flex;\n  align-items: center;\n}\n.house .title .line[data-v-415a95ff] {\n  flex: 1;\n  height: 0;\n  border-bottom: 0.01rem dashed #2f86ee;\n  margin: 0 0.05rem;\n}\n.house .info[data-v-415a95ff] {\n  display: flex;\n  justify-content: space-between;\n}\n.house .info >div[data-v-415a95ff] {\n  display: flex;\n}\n.house .info >div span[data-v-415a95ff] {\n  color: #ccc;\n  font-size: 0.08rem;\n}\n.house .info >div .count[data-v-415a95ff] {\n  color: #edb872;\n  margin-left: 0.04rem;\n}\n";
styleInject(css_248z$a);

script$9.__scopeId = "data-v-415a95ff";

const _withScopeId$3 = n => (pushScopeId("data-v-395a6d16"), n = n(), popScopeId(), n);

const _hoisted_1$8 = {
  class: "sum"
};

const _hoisted_2$7 = /*#__PURE__*/createTextVNode("新建商品房");

const _hoisted_3$7 = {
  class: "house"
};
const _hoisted_4$6 = {
  class: "title"
};

const _hoisted_5$4 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("p", null, "福新名苑", -1));

const _hoisted_6$4 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", {
  class: "line"
}, null, -1));

const _hoisted_7$4 = /*#__PURE__*/createTextVNode("万㎡ ");

const _hoisted_8$4 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("div", {
  class: "company"
}, "上海北航置业发展有限公司", -1));

const _hoisted_9$3 = {
  class: "info"
};

const _hoisted_10$2 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "上市套数", -1));

const _hoisted_11$2 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "套", -1));

const _hoisted_12$1 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "上市面积", -1));

const _hoisted_13$1 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "万㎡", -1));

const _hoisted_14$1 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "去化率", -1));

const _hoisted_15$1 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "%", -1));

const _hoisted_16$1 = /*#__PURE__*/createTextVNode("租赁住房");

const _hoisted_17 = {
  class: "lease"
};
const _hoisted_18 = {
  class: "house"
};
const _hoisted_19 = {
  class: "title"
};

const _hoisted_20 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("p", null, "魔方公寓", -1));

const _hoisted_21 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", {
  class: "line"
}, null, -1));

const _hoisted_22 = /*#__PURE__*/createTextVNode("元 ");

const _hoisted_23 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("div", {
  class: "company"
}, "上海盛派投资管理有限公司", -1));

const _hoisted_24 = {
  class: "info"
};

const _hoisted_25 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "上市套数", -1));

const _hoisted_26 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "套", -1));

const _hoisted_27 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "上市面积", -1));

const _hoisted_28 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "㎡", -1));

const _hoisted_29 = {
  class: "house"
};
const _hoisted_30 = {
  class: "title"
};

const _hoisted_31 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("p", null, "宁家公寓止园路", -1));

const _hoisted_32 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", {
  class: "line"
}, null, -1));

const _hoisted_33 = /*#__PURE__*/createTextVNode("元 ");

const _hoisted_34 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("div", {
  class: "company"
}, "上海金茂实业有限公司", -1));

const _hoisted_35 = {
  class: "info"
};

const _hoisted_36 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "上市套数", -1));

const _hoisted_37 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "套", -1));

const _hoisted_38 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "上市面积", -1));

const _hoisted_39 = /*#__PURE__*/_withScopeId$3(() => /*#__PURE__*/createElementVNode("span", null, "㎡", -1));

const __default__$7 = {
  name: 'A010',
  title: '交易数据',
  row: 2
};

function setup$7(__props) {
  const summary = [{
    name: '房屋供应总套数',
    value: 714,
    unit: '套'
  }, {
    name: '房屋成交总套数',
    value: 1564,
    unit: '套'
  }, {
    name: '车位成交总数',
    value: 1353,
    unit: '个'
  }];
  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "交易数据"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$8, [(openBlock(), createElementBlock(Fragment, null, renderList(summary, item => {
        return createElementVNode("p", {
          key: item.name
        }, [createTextVNode(toDisplayString(item.name) + " ", 1), createElementVNode("span", null, [createVNode(_component_m_count, {
          class: "orange-count",
          value: item.value
        }, null, 8, ["value"]), createTextVNode(" " + toDisplayString(item.unit), 1)])]);
      }), 64))]), createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_2$7]),
        _: 1
      }), createElementVNode("div", _hoisted_3$7, [createElementVNode("div", _hoisted_4$6, [_hoisted_5$4, _hoisted_6$4, createElementVNode("span", null, [createVNode(_component_m_count, {
        class: "orange-count",
        value: 13.2,
        decimal: 2
      }, null, 8, ["value"]), _hoisted_7$4])]), _hoisted_8$4, createElementVNode("div", _hoisted_9$3, [createElementVNode("div", null, [_hoisted_10$2, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 199
      }), _hoisted_11$2])]), createElementVNode("div", null, [_hoisted_12$1, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 29.6,
        decimal: 2
      }, null, 8, ["value"]), _hoisted_13$1])]), createElementVNode("div", null, [_hoisted_14$1, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 100
      }), _hoisted_15$1])])])]), createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_16$1]),
        _: 1
      }), createElementVNode("div", _hoisted_17, [createElementVNode("div", _hoisted_18, [createElementVNode("div", _hoisted_19, [_hoisted_20, _hoisted_21, createElementVNode("span", null, [createVNode(_component_m_count, {
        class: "orange-count",
        value: 5000
      }), _hoisted_22])]), _hoisted_23, createElementVNode("div", _hoisted_24, [createElementVNode("div", null, [_hoisted_25, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 499
      }), _hoisted_26])]), createElementVNode("div", null, [_hoisted_27, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 8595
      }), _hoisted_28])])])]), createElementVNode("div", _hoisted_29, [createElementVNode("div", _hoisted_30, [_hoisted_31, _hoisted_32, createElementVNode("span", null, [createVNode(_component_m_count, {
        class: "orange-count",
        value: 4500
      }), _hoisted_33])]), _hoisted_34, createElementVNode("div", _hoisted_35, [createElementVNode("div", null, [_hoisted_36, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 113
      }), _hoisted_37])]), createElementVNode("div", null, [_hoisted_38, createElementVNode("p", null, [createVNode(_component_m_count, {
        class: "count",
        value: 4146
      }), _hoisted_39])])])])])]),
      _: 1
    });
  };
}

var script$8 = /*#__PURE__*/defineComponent({ ...__default__$7,
  setup: setup$7
});

var css_248z$9 = ".sum[data-v-395a6d16] {\n  display: flex;\n  flex-wrap: wrap;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.05rem 0;\n  margin-bottom: 0.05rem;\n}\n.sum >p[data-v-395a6d16] {\n  width: 50%;\n  padding: 0 0.05rem;\n  box-sizing: inherit;\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n}\n.house[data-v-395a6d16] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.04rem 0.1rem;\n  margin-bottom: 0.05rem;\n}\n.house .title[data-v-395a6d16] {\n  display: flex;\n  align-items: center;\n}\n.house .title .line[data-v-395a6d16] {\n  flex: 1;\n  height: 0;\n  border-bottom: 0.01rem dashed #2f86ee;\n  margin: 0 0.05rem;\n}\n.house .info[data-v-395a6d16] {\n  display: flex;\n  justify-content: space-between;\n}\n.house .info >div[data-v-395a6d16] {\n  display: flex;\n}\n.house .info >div span[data-v-395a6d16] {\n  color: #ccc;\n  font-size: 0.08rem;\n}\n.house .info >div .count[data-v-395a6d16] {\n  color: #edb872;\n  margin-left: 0.04rem;\n}\n";
styleInject(css_248z$9);

script$8.__scopeId = "data-v-395a6d16";

const _hoisted_1$7 = {
  class: "chart"
};
const __default__$6 = {
  name: 'A012',
  title: '加装电梯',
  row: 1
};

function setup$6(__props) {
  const data = {
    dimensions: [{
      name: 'year',
      displayName: '年'
    }, {
      name: 'value',
      displayName: '竣工项目'
    }],
    source: [{
      year: '2016',
      value: 2
    }, {
      year: '2017',
      value: 4
    }, {
      year: '2018',
      value: 7
    }, {
      year: '2019',
      value: 10
    }, {
      year: '2020',
      value: 18
    }]
  };
  const option = {
    color: [['#8CD5FF', '#1990BE']],
    legend: {
      right: '2%'
    },
    series: [{
      type: 'bar',
      barWidth: '30%'
    }]
  };
  return (_ctx, _cache) => {
    const _component_m_bar = resolveComponent("m-bar");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "加装电梯"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$7, [createVNode(_component_m_bar, {
        dataset: data,
        option: option
      })])]),
      _: 1
    });
  };
}

var script$7 = /*#__PURE__*/defineComponent({ ...__default__$6,
  setup: setup$6
});

var css_248z$8 = ".chart[data-v-18f61d98] {\n  width: 100%;\n  height: 1.5rem;\n}\n";
styleInject(css_248z$8);

script$7.__scopeId = "data-v-18f61d98";

const _hoisted_1$6 = {
  class: "tabs"
};
const _hoisted_2$6 = ["onClick"];
const _hoisted_3$6 = {
  class: "content"
};
const _hoisted_4$5 = {
  class: "status"
};
const __default__$5 = {
  name: 'A013',
  title: '加装电梯',
  row: 2
};

function setup$5(__props) {
  const tabs = [{
    name: '开工项目',
    key: 'start'
  }, {
    name: '竣工项目',
    key: 'done'
  }];
  const curTab = ref('start');
  const yearOptions = [{
    label: '2021',
    value: '2021'
  }, {
    label: '2020',
    value: '2020'
  }, {
    label: '2019',
    value: '2019'
  }];
  const areaOptions = [{
    label: '全区',
    value: '全区'
  }, {
    label: '1区',
    value: '1区'
  }, {
    label: '2区',
    value: '2区'
  }];
  const year = ref('2021');
  const area = ref('全区');
  const list = [{
    name: '长安小区',
    address: '长安路288号',
    status: '不可加装'
  }, {
    name: '闻喜路1110弄小区',
    address: '曲沃路',
    status: '不可加装'
  }, {
    name: '象山小区',
    address: '临山路186号',
    status: '可加装'
  }, {
    name: '499弄小区',
    address: '宝山路519号',
    status: '不可加装'
  }, {
    name: '长安小区',
    address: '长安路288号',
    status: '不可加装'
  }, {
    name: '闻喜路1110弄小区',
    address: '曲沃路',
    status: '不可加装'
  }, {
    name: '象山小区',
    address: '临山路186号',
    status: '可加装'
  }, {
    name: '499弄小区',
    address: '宝山路519号',
    status: '不可加装'
  }, {
    name: '长安小区',
    address: '长安路288号',
    status: '不可加装'
  }, {
    name: '闻喜路1110弄小区',
    address: '曲沃路',
    status: '不可加装'
  }];
  return (_ctx, _cache) => {
    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "加装电梯"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$6, [createVNode(unref(NSpace), null, {
        default: withCtx(() => [(openBlock(), createElementBlock(Fragment, null, renderList(tabs, tab => {
          return createElementVNode("p", {
            key: tab.key,
            class: normalizeClass(["tab", {
              on: curTab.value === tab.key
            }]),
            onClick: $event => curTab.value = tab.key
          }, toDisplayString(tab.name), 11, _hoisted_2$6);
        }), 64))]),
        _: 1
      }), createVNode(unref(NSpace), null, {
        default: withCtx(() => [createVNode(unref(NSelect), {
          value: year.value,
          "onUpdate:value": _cache[0] || (_cache[0] = $event => year.value = $event),
          class: "my-select",
          size: "small",
          options: yearOptions
        }, null, 8, ["value"]), createVNode(unref(NSelect), {
          value: area.value,
          "onUpdate:value": _cache[1] || (_cache[1] = $event => area.value = $event),
          class: "my-select",
          size: "small",
          options: areaOptions
        }, null, 8, ["value"])]),
        _: 1
      })]), createElementVNode("div", _hoisted_3$6, [(openBlock(), createElementBlock(Fragment, null, renderList(list, (item, i) => {
        return createElementVNode("div", {
          key: i
        }, [createElementVNode("span", null, toDisplayString(i + 1), 1), createElementVNode("span", null, toDisplayString(item.name), 1), createElementVNode("span", null, toDisplayString(item.address), 1), createElementVNode("span", _hoisted_4$5, toDisplayString(item.status), 1)]);
      }), 64))])]),
      _: 1
    });
  };
}

var script$6 = /*#__PURE__*/defineComponent({ ...__default__$5,
  setup: setup$5
});

var css_248z$7 = ".tabs[data-v-15bec1ac] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  padding: 0 0.04rem;\n  box-sizing: border-box;\n}\n.tabs .tab[data-v-15bec1ac] {\n  cursor: pointer;\n  transition: transform 0.2s ease-in-out;\n}\n.tabs .tab[data-v-15bec1ac]:hover {\n  color: #edb872;\n}\n.tabs .tab.on[data-v-15bec1ac] {\n  font-weight: bold;\n  color: #edb872;\n  transform: scale(1.1);\n}\n.content[data-v-15bec1ac] {\n  margin-top: 0.1rem;\n  flex: 1;\n  overflow-y: auto;\n}\n.content >div[data-v-15bec1ac] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  padding: 0.04rem 0.06rem;\n}\n.content >div+div[data-v-15bec1ac] {\n  margin-top: 0.05rem;\n}\n.content >div >span+span[data-v-15bec1ac] {\n  margin-left: 0.06rem;\n}\n.content >div >span[data-v-15bec1ac]:nth-of-type(2),\n.content >div >span[data-v-15bec1ac]:nth-of-type(3) {\n  flex: 1;\n}\n.content >div >span.status[data-v-15bec1ac] {\n  color: #edb872;\n}\n";
styleInject(css_248z$7);

var css_248z$6 = ".n-select.my-select {\n  height: 0.2rem;\n}\n.n-select.my-select .n-base-selection {\n  height: inherit;\n}\n.n-select.my-select .n-base-selection .n-base-selection-label {\n  height: inherit;\n  background: rgba(70,83,97,0.4) !important;\n  box-shadow: inset 0 0.01rem 0.02rem 0 rgba(204,204,204,0.2);\n}\n.n-select.my-select .n-base-selection .n-base-selection-label .n-base-selection-input {\n  color: #fff;\n  font-size: 0.09rem;\n}\n.n-select.my-select .n-base-selection .n-base-selection-label .n-base-icon.n-base-suffix__arrow {\n  color: #edb872;\n  font-size: 0.09rem;\n}\n.n-select.my-select .n-base-selection .n-base-selection__border,\n.n-select.my-select .n-base-selection .n-base-selection__state-border {\n  display: none;\n}\n.n-base-select-menu.n-select-menu {\n  background: rgba(70,83,97,0.8) !important;\n  backdrop-filter: blur(0.05rem);\n  -webkit-backdrop-filter: blur(0.05rem);\n}\n.n-base-select-menu.n-select-menu .n-base-select-option {\n  background: transparent !important;\n  font-size: 0.09rem;\n  color: #fff;\n}\n.n-base-select-menu.n-select-menu .n-base-select-option.n-base-select-option--selected {\n  color: #edb872;\n  font-weight: bold;\n}\n.n-base-select-menu.n-select-menu .n-base-select-option.n-base-select-option--pending {\n  color: #edb872;\n}\n";
styleInject(css_248z$6);

script$6.__scopeId = "data-v-15bec1ac";

var script$5 = {
  name: 'A014',
  title: '保障',
  row: 1
};

const _withScopeId$2 = n => (pushScopeId("data-v-1b5160db"), n = n(), popScopeId(), n);

const _hoisted_1$5 = {
  class: "row"
};

const _hoisted_2$5 = /*#__PURE__*/createTextVNode("公租房");

const _hoisted_3$5 = /*#__PURE__*/createTextVNode("廉租房");

const _hoisted_4$4 = {
  class: "legend"
};

const _hoisted_5$3 = /*#__PURE__*/_withScopeId$2(() => /*#__PURE__*/createElementVNode("i", null, null, -1));

const _hoisted_6$3 = /*#__PURE__*/_withScopeId$2(() => /*#__PURE__*/createElementVNode("span", null, "实物", -1));

const _hoisted_7$3 = /*#__PURE__*/_withScopeId$2(() => /*#__PURE__*/createElementVNode("i", null, null, -1));

const _hoisted_8$3 = /*#__PURE__*/_withScopeId$2(() => /*#__PURE__*/createElementVNode("span", null, "租金", -1));

const _hoisted_9$2 = {
  class: "row"
};

const _hoisted_10$1 = /*#__PURE__*/createTextVNode("共有产权房");

const _hoisted_11$1 = /*#__PURE__*/createTextVNode("动迁安置房");

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_m_sub = resolveComponent("m-sub");

  const _component_m_progress = resolveComponent("m-progress");

  const _component_m_count = resolveComponent("m-count");

  const _component_m_card = resolveComponent("m-card");

  return openBlock(), createBlock(_component_m_card, {
    title: "保障"
  }, {
    default: withCtx(() => [createElementVNode("div", _hoisted_1$5, [createElementVNode("div", null, [createVNode(_component_m_sub, null, {
      default: withCtx(() => [_hoisted_2$5]),
      _: 1
    }), createVNode(_component_m_progress, {
      value: 50,
      msg: {
        name: '公共租赁',
        value: '2253/38863',
        color: '#fff'
      },
      color: "#EDB872"
    }), createVNode(_component_m_progress, {
      value: 50,
      msg: {
        name: '单位租赁',
        value: '3554/468833',
        color: '#fff'
      },
      color: "#EDB872"
    })]), createElementVNode("div", null, [createVNode(_component_m_sub, null, {
      default: withCtx(() => [_hoisted_3$5]),
      _: 1
    }), createElementVNode("div", _hoisted_4$4, [createElementVNode("p", null, [_hoisted_5$3, _hoisted_6$3, createVNode(_component_m_count, {
      class: "count",
      value: 33
    })]), createElementVNode("p", null, [_hoisted_7$3, _hoisted_8$3, createVNode(_component_m_count, {
      class: "count",
      value: 798
    })])]), createVNode(_component_m_progress, {
      value: 10,
      msg: {
        name: '补贴金额',
        value: '426万元',
        color: '#fff'
      },
      color: "#F7D600",
      "background-color": "#0091FF"
    })])]), createElementVNode("div", _hoisted_9$2, [createElementVNode("div", null, [createVNode(_component_m_sub, null, {
      default: withCtx(() => [_hoisted_10$1]),
      _: 1
    }), createVNode(_component_m_progress, {
      value: 50,
      msg: {
        name: '已办入户/已分配',
        value: '8763/19324',
        color: '#fff'
      },
      color: "#EDB872"
    })]), createElementVNode("div", null, [createVNode(_component_m_sub, null, {
      default: withCtx(() => [_hoisted_11$1]),
      _: 1
    }), createVNode(_component_m_progress, {
      value: 50,
      msg: {
        name: '剩余套数/总套数',
        value: '4183/94028',
        color: '#fff'
      },
      color: "#EDB872"
    })])])]),
    _: 1
  });
}

var css_248z$5 = ".row[data-v-1b5160db] {\n  display: flex;\n}\n.row+.row[data-v-1b5160db] {\n  margin-top: 0.1rem;\n}\n.row >div[data-v-1b5160db] {\n  flex: 1;\n}\n.row >div+div[data-v-1b5160db] {\n  margin-left: 0.04rem;\n}\n.row >div .legend[data-v-1b5160db] {\n  display: flex;\n  width: 100%;\n  justify-content: space-between;\n  margin: 0.08rem 0 0.02rem;\n}\n.row >div .legend p[data-v-1b5160db] {\n  display: flex;\n  align-items: center;\n}\n.row >div .legend p i[data-v-1b5160db] {\n  width: 0.06rem;\n  height: 0.06rem;\n  border-radius: 50%;\n}\n.row >div .legend p span[data-v-1b5160db] {\n  margin: 0 0.05rem;\n}\n.row >div .legend p .count[data-v-1b5160db] {\n  font-size: 0.14rem;\n  color: #edb872;\n}\n.row >div .legend p:first-child i[data-v-1b5160db] {\n  background: #f7d600;\n}\n.row >div .legend p:last-child i[data-v-1b5160db] {\n  background: #0091ff;\n}\n";
styleInject(css_248z$5);

script$5.render = render;
script$5.__scopeId = "data-v-1b5160db";

var img$c = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFwAAABcCAMAAADUMSJqAAAAvVBMVEUAAABcZnBGU2FHVGJGU2JHVGJIVGJLWmVKVmdHVGJGVGJGU2FGU2FHU2JHU2FGU2FGVGFHU2FGU2JHVGFGVGJHVGFHVGJHVGJIVWJIU2NIVGNIVmRIVWJIU2SAgIBIU2JGU2H////d3+JPW2n8/P34+Pnk5uhjbnpWYm/x8vNdaXXp6+23vMHc3+HR1djFyc309fZyfIZLV2X7+/vW2dy+w8imrLOMlJ14goxbZ3OvtLqepayFjpdteIPJzdEJKXV6AAAAIHRSTlMABvh9+6NEIx/+8+/s49/a0srEv6edj4h1X1VKPC4ChxwaMwQAAALJSURBVGjezZrpcuIwDIAdh9BS7jMlECoTGrqUm3L02vd/rB2Y7gbGCrGdaJbvH8Pw4UkkxZbCVLB8z3YatUqJ81Kl1nBsz7dYFlh9u8lBgjftfso/GOSdB4jlwckPjNX3bhkSKLv3Ruq7dg4UyLXv9NWtAihSaOnpLZuDBtzWuLf5KmhSzasuuwMGdCylGKmDEXWFuOkVwZBiL8ndzYExue519yOk4vGa+wlS8pSwbqK1dyEDujFxkoMMyPXQ+C5CJhSReLfqkBF1OVc7kBkdqVYBxss0HEVMj/X1Lfq8me3WgJG/dFtoHXwPxTm/jn8nLpgHaI28vDA2+hR4E0lyMQUM++K5wwFhJ5Ll4gsQ+B2LaAHCaqQiX74DQuts4djzMngVKnIxx35ciJbeBoStUJOLT0Bo/8tNLO/3QlU++saqwN88dUFmslSWixCLR5edGJTRKFSW4/FYHsQm507oyMVXbJo6WBTqyPF4dE6Zj+xjQ6EnFwtkD3ysAX2QmT9jTK99JdOXyooxeIFpAhFNxiwORHCL+YAQaAMIPvNAZi60+QAZD72fI335EL2jDp3cYQ06eYPV6OQ1VqGTV1iJTl5inE7OSeWkl4X0hpKGImkSkaY/beHy4uWb1xMbU7nH/Fj5dg0ngoWh3GcWj5O/wA9jMzm3GGvGycfww7eZvBltLWT5bDU5cQjN5PZxU0QVLX1pO2csx7dzzKGRO9EWGpMvwzOedeX5aPOPyKcFOGO9TZDjm3/m4vIALpjoyV3pwCXHecQqSY4fuFgbj/PD+IxDqCVv44dc82jBD7mslVo+Q47neGMh1JcvkMYC3hL50JfvpbIS18wJhukWXrWutaHWn7+H6swWeyk56RpopK0/yqYlZbuVslFM2eKmbM5TjhUoByKUoxzKIRTl+Oz/D/6MRpa3MmzVGxPf2oBbbTR/qy8VpHwd4g9iIkihG8B+EgAAAABJRU5ErkJggg==";
  var icon9 = img$c;

var img$b = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAP1BMVEUAAACWb/+Gdv+HdP+Dc/+Dc/+Cc/+Bcf+BcP+Ccf+BcP+AcP+Bb/+Bcf+Cbv+Abv+AcP+Bcv+Cb/+Bbv+Bbf/yFeDEAAAAFHRSTlMAAwcMERYgJjsvRRwzN+WEQCu/rFPHZkwAAAEySURBVFjD7dbbzoIwEARg/6OlQAvY939WZ7ctJWDi1k240M6Fl19mUEsvLS0tb5SvXfRKyavM9yYvUavys2a16h1WflPYqpVSHVb+UthKpeocMFD6/p/T92TlUnUOGCjXFFigsiR3UIeZueu6YcDHTBRKyaXiEDOMhjMORBVJVgi72CFmspyJKEi0jivJCmUHjF9cCG7xoKIkrbRxRmM9lBjnrRmL9BTKw7iPvYVNbpY75XECiAvN0dlLM1ViSLaMhk0+7OInGifbFpfFQm4PuVgJ22QQlpVCx0rYJoawzNjlCC3WYFst5I6Qq4fwiMKD4CGdAOmn6R+2/us/5Qep/4vo/7T6Y0R/sJ141OoPf/3rSP+C1L+y9ZeIM641+ouW/uqnv4zqr8dq69LS0tLySbkDIYwu4SaaDEsAAAAASUVORK5CYII=";
  var c1 = img$b;

var img$a = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAQlBMVEUAAABQsP9NtP9Mtf9Nsv9MtP9Ktf9LtP9Jtf9JtP9Jtf9Is/9Js/9Ks/9Is/9Isv9ItP9JtP9Is/9HtP9Hs/9Hs/8vysiEAAAAFXRSTlMABQoWDxwRICZFLjI2KTw65YRAv6yOh+p7AAABWklEQVRYw+3X626DMAyG4VIGJOQcyv3f6myzzFOHNHNYfuWdtE6a9OgrbYE+Wq1W6z/r8AejPy4oXNGuME/oPMUGd4YqzAc0QvhYqBMMIv1XgCF1XEIGlGEYJggewAKKR4n3IAOIUso5+AUYUoc2FQfGKDfPBppnp2AWSdIj/r2HGGND8D4Ea5BiSRI7wPisqeyBYkk6iBw325B1WuK6xiXpHOzsSMJJ0kG0x3qdQNmKSXtLm4STyiByXuuPXiTxJOEgZ0JxWArGiSfxoJzWt1LmSTIIB3kd36GoPU4iSHSIeND+JBn03KCgl9/QosMGgSSAxn5SJvAz46IORk39KIfwEK074UGqDMmfWpWDjd328ovekDU/Ip30Q1vrNHL9xMbddartrp78OcnlqMoFkrt8yWbpj5uIhzjBbU3dGy2mOGYOOkhRbED4jxN1nICRaXd+CWi1Wq29PgGu6y/ePNuKAgAAAABJRU5ErkJggg==";
  var c2 = img$a;

var img$9 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAS1BMVEUAAABBdP8kff8qgP8ffP8iff8gev8de/8de/8efP8hfP8bff8dev8eev8eef8efP8afP8eef8Bd/8Adv8EeP8Gd/8Kef8KeP8Adv+qw/+XAAAAGHRSTlMAAwcMEBYmGz0uHgk3QzIhRinl9r+shYKhV88tAAABSklEQVRYw+3Wy7KCMBAEUO9DIEBiEhD4/y91egwWRTYDU7JKL1ye6lYJuZWUlJR8MT+7KJQsZ5nfTU5Rq9J1fyldt1onHCj/KbAOS4lh5Z4Ca6WOOcSQUtctp67JIipJYgd1wLSPqqpCoI9HCwqlWBI7qAMmGOMoxgRQKCWWeBfXAeP6vqH0vQPFpXidsBDtgkNMY62nWNsQRRLWySrxMHaCIcZPYxyGOE6eKBNY6kSVeBj3gTPHJSXOkLgTj5MWauH457LJ00NqhZUAvYe5xsLZSrZx73ECaFPIzssus/1UEkJcyMc9FD1XkkJYhkLTkmVCJWyTQrxszKGRtx2C1mX5tmNQIGjIoYGgcAGknqb/svU//yV/SP0jon9o9ceI/mC78KjVH/7615H+Bal/ZesvEVdca/QXLf3VT38Z1V+P1datpKSk5Ht5AYUMN8FE7CpaAAAAAElFTkSuQmCC";
  var c3 = img$9;

var img$8 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAARVBMVEUAAADVeNrZcOvccPXabvrYcPXdbfvebf7abfvbbPzbbf3bbfvcbPzbbP3bbfvba/vbbPzcbf3havvga/3ga/vga/vgavtYBKihAAAAFnRSTlMABAcKFg4RKBs7Lh43QTIlIUblhL+svGqqFwAAAUNJREFUWMPt1t2OwiAQBeC6K9tSCghU3v9Rd4ZMDbEm/EzsFefCxJsvZ7SFmUZGRka+mNt0y9PNnAJwb5mfLH2tDuUXIgR+HlaPg4b4SxGoUat2BpU7BS2k2iB0gAFlWVTKsoAlBEltDjLqYe0MsfahkCKp0UFmXlcDWdcZqTbp5SBjtk1Cts0g9ZIqC5GDjNTaQbSWSJFUVylzgHFh9zH6PTigMql2sMMJPlJ8OCQarrKQsuC4Z8zydCBZhZXqICpkpEYnl7Q0WImg8mRUSIf4lqCpEs1WniwVcv4d8i5VotmqJssKnSot91qIJtvP0E6z1UPZZKfZqiFBUPwQgsRVEH80/o/N//v5D+QFrwj/peUfI/yDjX/UXnf4868j/gXJv7L5S0Q5NWsNf9G6fPWjFJZR1n5MDNtK3zuZaWRkZKSUf4StNZq8ICefAAAAAElFTkSuQmCC";
  var c4 = img$8;

var img$7 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAAQlBMVEUAAAD/bGz/amr/ZWX/Z2f/Y2P/ZWX/Y2P/ZGT/Y2P/YmL/YmL/Y2P/Y2P/YmL/YWH/YmL/ZGT/Y2P/YWH/YmL/YWEsPPC8AAAAFXRSTlMAAwoQBhYcICZFOy4yKTXlhEA4v6yjYypYAAABP0lEQVRYw+3WQXODIBQE4La2CgKCGP7/X+1mcUaG9AB9E0/sIbl9s89EeB8jIyMjb8xnFZnyzfzbKpAvpMD6HRplTqvXITMVIdUnlczPmZLqdKjM87wg+KJ1Sn0OGCBKKefwAQzUJfU4KKOcMRYxxinU6pAIwUEdMnaLKxI3C4qlIBFqdKanY2xcd83sa7TmKU2tEgej48wGJhw+JX8EUJtxlDBcA8RC7ANHByg5PmhI7MRKLZOxEJ1HKvKgxEqcrbGQs3QqybrWSlehuIdUJewxV2qGciFfQz5Xaof4hFjopRKfUgsEJ0NRH6/QoWOGIDVBi7omq2dTSw/kAKU/AsjdAAlHkz9s+c9/0x9S/orIX1r5MSI/2G48auWHv/w6kl+Q8itbvkTcsdbIFy356idfRuXrsXxhHxkZGXlffgHTfDGN1Cbg6AAAAABJRU5ErkJggg==";
  var c5 = img$7;

var img$6 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAABICAMAAABiM0N1AAAARVBMVEUAAAD/y0L/zkD/zjr/zTj/zTX/zTf/yjv/0Dz/zjb/zTX/zTX/zjX/zDX/zjX/zTj/zzT/zzT/zjX/zzb/0DX/0TX/zjR1cRBqAAAAFnRSTlMABgoQHT0YDRUmLkQ3MiEp5b+shYJIyjlI5gAAAXFJREFUWMPt1t1ugzAMBeB467oQCAkF8v6PupPMFVUZqi0yaZpy+sNF1U+2W5KYlpaWlt8M4ckPQ2cYekzmTjBnKWbekE8kXzdKyxTknZMxthRhB4q19orgAguSqigydwbIhQOsUKqS2LFQxq7rQsDbCMveJVI4uRwwwTmPOBdA5aKypHKY8cPwgQyDZ6pIhoQQ+sqO81D6EljeZQndESkcexmDA7POU0wpTvMKyoXxYiHJIG5s7OD0S0ycuPSQupGbI3Fjxbmlh9yKxM3JOiuN+c3ZJF+ak1W0FbSkpyyakjJkr7mgNT5Dcc0lXa0UQme5oDntMueS0JsK6qc9NPViiIjKiDDquIcixl2GJKmozDoASj8EUPie9kunFmRqtUaiYdf/+ev/IevfIvVvWqNaRs4vbEaQakutaPEXUYLtSBQyrzdIqrJl1ztEUKVjjSpkjg5aRpmjo59RV4TXLvyBmnq0Tpy1j7/3N7iWlpZ/li/TUzGH6nqubQAAAABJRU5ErkJggg==";
  var c6 = img$6;

var img$5 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAAC6AgMAAACRnjTSAAAADFBMVEUAAACtcQD/03utcQAx08x/AAAAAnRSTlMA32D/An0AAAKRSURBVGje7NGxbcMwEIXhpCAygtdRl1ZFjJQaJfucCo/gFRJAWcK9GgPRBRKPfHoWz0zpAHqFCuoH8Vl+2vcoC8e49m/5i8Z9/stc5u35Q+bPbt6U8tA4+XNbyg+tk4ehlHeDkx/GEv1jdPLup4APaqfI0z3aFuiqbTEPqkOBbqeU2z1jgT6dx2LeTWfgQb+e4ilyu+d6Ah70S2+nnIf5xbCli9gp5wcVAR50kYhHbnQR4EEXiXjkRhcBHnQRw1Me4othSzc88kRPeKYbHnmiJzzTDY880ROe6YZHnujAE93wyI0OPNENjzzRgQc94ZEbPeKbFX3JDY/c6JvfGnSSjEcOupz1bW1XyXjkoIvSh+/0kvHIQe/pyzAeOegz0sEjB53+VcYjZ7qDzznTPXzOme7hc850D59zpnv4V8u/iO7i3y3/JrqLV8uV6C4+50R38Tknuo+3nOk+3nKm+3jLme7jLWe6j7ec6T7ecqLfwy9Pot/FL0+i38UvT58OPA90H4+B7uMx0H08xvQ6HvQavk4Hvk4Hvk5nfJ0OvOotXZub5LiaGh50Xb9u5htp1xs6bZtPTK/lyvRKzvi+kCOorN/zPf9tz1yNAIShIPiaoB9KQFA4glaQDOgIZudmBTBJ9BNR99kb5386ByUQOmNUjDUyVWDWd+Ue7E3G+dhXlWtzJjCJg/OMSkucxUzS4xypUipnYJOwOb+rdsDdwzQb7k2qlXHnM42S+6pow9y1t4qa/F4RJzgqohDnnDGOpZigPH2e+UyLooj+tCgqY0vTxeRqDblYRt1CphcSQ8EjmXYalsqkVnBgpsyGYTMhF/yd6b7ZDniZELsHrypms+FFKNybPr+VjfPXp2RxHmzyXb8bJCpPpk1Qjg4AAAAASUVORK5CYII=";
  var NoresIcon = img$5;

let BASE_URL = '';

switch ("production") {
  case 'production':
    BASE_URL = 'http://ja-hm.omniview.pro/api/v2';
    break;

  default:
    BASE_URL = 'http://ja-hm.omniview.pro/api/v2';
}

var api = {
  BASE_URL,
  CONFIGS: '/service-bigscreen/public/bigscreenConfigs' // 配置

};

const Axios = axios.create({
  baseURL: api.BASE_URL,
  timeout: 15000
});
Axios.interceptors.request.use(config => {
  config.baseURL = window._base_url || api.BASE_URL; // 添加token
  // config.headers.Authorization = ''

  return config;
}, error => {
  return Promise.reject(error);
});
Axios.interceptors.response.use(response => {
  // TODO 返回的数据status判断错误操作等……
  return response.data;
}, error => {
  return Promise.reject(error);
});
/**
 * 请求
 * @param {String} method [请求方法]
 * @param {String} url [请求地址]
 * @param {Object} params [请求参数]
 * @param {String} contentType [请求头，默认为'application/json;charset=UTF-8']
 * @param {Object} headers [自定义请求头]
 */

const ajax = ({
  method = 'GET',
  url,
  params = {},
  contentType = 'application/json;charset=UTF-8',
  headers = {}
}) => {
  if (!url || typeof url != 'string') {
    throw new Error('接口URL不正确');
  }

  let config = {
    method,
    url,
    headers: {
      'X-Requested-With': 'XMLHttpRequest',
      'Content-Type': contentType,
      'Access-Control-Allow-Origin': '*',
      'Access-Control-Allow-Headers': 'Authorization,Origin, X-Requested-With, Content-Type, Accept',
      'Access-Control-Allow-Methods': '*',
      ...headers
    }
  };

  if (method === 'GET') {
    config = Object.assign(config, {
      params
    });
  } else {
    if (contentType.toLowerCase().indexOf('x-www-form-urlencoded') >= 0) {
      config = Object.assign(config, {
        data: qs.stringify(params)
      });
    } else {
      config = Object.assign(config, {
        data: params
      });
    }
  }

  return Axios(config);
};

var ajax$1 = {
  get(args) {
    return ajax({
      method: 'GET',
      ...args
    });
  },

  post(args) {
    // args.contentType = 'application/x-www-form-urlencoded;charset=UTF-8'
    return ajax({
      method: 'POST',
      ...args
    });
  },

  put(args) {
    return ajax({
      method: 'PUT',
      ...args
    });
  },

  delete(args) {
    return ajax({
      method: 'DELETE',
      ...args
    });
  }

};

function usePointType() {
  const curPointType = ref(0);
  EventBus.on('curPointType', key => {
    if (typeof key === 'number') {
      curPointType.value = key;
    }
  });

  const setCurPointType = (key = 0) => {
    EventBus.emit('curPointType', key);
  };

  return {
    curPointType,
    setCurPointType
  };
}

const _withScopeId$1 = n => (pushScopeId("data-v-72a8e10b"), n = n(), popScopeId(), n);

const _hoisted_1$4 = /*#__PURE__*/createTextVNode(" 住宅房屋 ");

const _hoisted_2$4 = /*#__PURE__*/createTextVNode(" 非居建筑 ");

const _hoisted_3$4 = /*#__PURE__*/createTextVNode(" 服务主体 ");

const _hoisted_4$3 = /*#__PURE__*/_withScopeId$1(() => /*#__PURE__*/createElementVNode("p", null, null, -1));
const _config$4 = {
  name: 'A015',
  title: '体征指标',
  row: 1,
  baseUrl: window._base_url,
  apis: {
    // community: '/service-basicdatasync-ddd/public/communities',
    community: '/service-customkey-ddd/public/communities/v2?pageSize=9000',
    nonResident: '/service-basicdatasync-ddd/public/nonResi/buildings',
    api1: '/service-basicdatasync-ddd/public/indCous',
    api2: '/service-basicdatasync-ddd/public/residentsCommitteesV2',
    api3: '/service-basicdatasync-ddd/public/propCompanies'
  }
};
const __default__$4 = _config$4;

function setup$4(__props) {
  const totalCommunityCount = ref(0);
  const summary = ref([{
    icon: icon4,
    name: '商品房',
    value: 0
  }, {
    icon: icon5,
    name: '公房',
    value: 0
  }, {
    icon: icon1,
    name: '公租房',
    value: 0
  }, {
    icon: icon6,
    name: '混合',
    value: 0
  }, {
    icon: icon7,
    name: '军产',
    value: 0
  }, {
    icon: icon8,
    name: '售后房',
    value: 0
  }]);
  onMounted(() => {
    ajax$1.post({
      url: _config$4.apis.community,
      params: {
        conditions: [{
          conditionsGroup: []
        }],
        subject: 'tbl_community'
      }
    }).then(res => {
      var _res$data, _list$type, _list$type2, _list$type3, _list$type4, _list$type5, _list$type6;

      const data = (res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.content) || [];
      EventBus.emit('communityList', data);
      totalCommunityCount.value = data.length; // 1商品房 2动迁房 3共有产权保障房 4售后房 5直管公房 6混合 7系统公房 8集体土地集资房 9军产 10私产 11公租房

      const list = {
        type1: data.filter(item => (item === null || item === void 0 ? void 0 : item.stKind) == '01'),
        type2: data.filter(item => (item === null || item === void 0 ? void 0 : item.stKind) == '07' || (item === null || item === void 0 ? void 0 : item.stKind) == '05'),
        type3: data.filter(item => (item === null || item === void 0 ? void 0 : item.stKind) == '11'),
        type4: data.filter(item => (item === null || item === void 0 ? void 0 : item.stKind) == '06'),
        type5: data.filter(item => (item === null || item === void 0 ? void 0 : item.stKind) == '09'),
        type6: data.filter(item => (item === null || item === void 0 ? void 0 : item.stKind) == '04')
      };
      summary.value = [{
        icon: icon4,
        name: '商品房',
        value: ((_list$type = list.type1) === null || _list$type === void 0 ? void 0 : _list$type.length) || 0,
        data: list.type1,
        point: c1,
        key: 1
      }, {
        icon: icon5,
        name: '公房',
        value: ((_list$type2 = list.type2) === null || _list$type2 === void 0 ? void 0 : _list$type2.length) || 0,
        data: list.type2,
        point: c2,
        key: 2
      }, {
        icon: icon1,
        name: '公租房',
        value: ((_list$type3 = list.type3) === null || _list$type3 === void 0 ? void 0 : _list$type3.length) || 0,
        data: list.type3,
        point: c3,
        key: 3
      }, {
        icon: icon6,
        name: '混合',
        value: ((_list$type4 = list.type4) === null || _list$type4 === void 0 ? void 0 : _list$type4.length) || 0,
        data: list.type4,
        point: c4,
        key: 4
      }, {
        icon: icon7,
        name: '军产',
        value: ((_list$type5 = list.type5) === null || _list$type5 === void 0 ? void 0 : _list$type5.length) || 0,
        data: list.type5,
        point: c5,
        key: 5
      }, {
        icon: icon8,
        name: '售后房',
        value: ((_list$type6 = list.type6) === null || _list$type6 === void 0 ? void 0 : _list$type6.length) || 0,
        data: list.type6,
        point: c6,
        key: 6
      }];
    });
  });
  const {
    curPointType,
    setCurPointType
  } = usePointType();

  const onTouch = i => {
    const {
      data,
      point,
      key
    } = summary.value[i];
    EventBus.emit('addPoints', {
      icon: point,
      data
    });
    setCurPointType(key);
  };

  const nonResident = ref([]);
  ajax$1.get({
    url: _config$4.apis.nonResident,
    params: {
      pageSize: 9000
    }
  }).then(res => {
    var _res$data2;

    nonResident.value = (res === null || res === void 0 ? void 0 : (_res$data2 = res.data) === null || _res$data2 === void 0 ? void 0 : _res$data2.content) || [];
  });

  const onSelect = () => {
    EventBus.emit('addPoints', {
      icon: NoresIcon,
      size: 6,
      data: nonResident.value
    });
    setCurPointType(7);
  };

  const list = ref([{
    icon: icon9,
    name: '业委会',
    value: 0
  }, {
    icon: icon9,
    name: '居委会',
    value: 0
  }, {
    icon: icon9,
    name: '物业企业',
    value: 0
  }]);
  Promise.all([ajax$1.get({
    url: _config$4.apis.api1,
    params: {
      sectType_in: '1'
    }
  }), ajax$1.get({
    url: _config$4.apis.api2,
    params: {
      sectType_in: '1'
    }
  }), ajax$1.get({
    url: _config$4.apis.api3,
    params: {
      sectType_in: '1',
      managedNum_desc: '1'
    }
  })]).then(([data1, data2, data3]) => {
    var _data1$data, _data2$data, _data3$data;

    list.value = [{
      icon: icon9,
      name: '业委会',
      value: (data1 === null || data1 === void 0 ? void 0 : (_data1$data = data1.data) === null || _data1$data === void 0 ? void 0 : _data1$data.totalRows) || 0
    }, {
      icon: icon9,
      name: '居委会',
      value: (data2 === null || data2 === void 0 ? void 0 : (_data2$data = data2.data) === null || _data2$data === void 0 ? void 0 : _data2$data.totalRows) || 0
    }, {
      icon: icon9,
      name: '物业企业',
      value: (data3 === null || data3 === void 0 ? void 0 : (_data3$data = data3.data) === null || _data3$data === void 0 ? void 0 : _data3$data.totalRows) || 0
    }];
  });
  return (_ctx, _cache) => {
    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "体征指标"
    }, {
      default: withCtx(() => {
        var _nonResident$value;

        return [createVNode(_component_m_sub, {
          addition: {
            value: totalCommunityCount.value,
            unit: '个小区'
          }
        }, {
          default: withCtx(() => [_hoisted_1$4]),
          _: 1
        }, 8, ["addition"]), createVNode(script$l, {
          list: summary.value,
          "click-able": "",
          onTouch: onTouch
        }, null, 8, ["list"]), createVNode(_component_m_sub, {
          addition: {
            value: ((_nonResident$value = nonResident.value) === null || _nonResident$value === void 0 ? void 0 : _nonResident$value.length) || 0,
            unit: '幢'
          },
          "click-able": "",
          onSelct: onSelect
        }, {
          default: withCtx(() => [_hoisted_2$4]),
          _: 1
        }, 8, ["addition"]), createVNode(_component_m_sub, null, {
          default: withCtx(() => [_hoisted_3$4]),
          _: 1
        }), createVNode(script$l, {
          list: list.value
        }, null, 8, ["list"]), _hoisted_4$3];
      }),
      _: 1
    });
  };
}

var script$4 = /*#__PURE__*/defineComponent({ ...__default__$4,
  setup: setup$4
});

var css_248z$4 = "";
styleInject(css_248z$4);

script$4.__scopeId = "data-v-72a8e10b";

const _withScopeId = n => (pushScopeId("data-v-2b156870"), n = n(), popScopeId(), n);

const _hoisted_1$3 = {
  class: "wrapper"
};
const _hoisted_2$3 = {
  class: "left"
};
const _hoisted_3$3 = {
  class: "right"
};

const _hoisted_4$2 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "整改执行", -1));

const _hoisted_5$2 = {
  class: "count"
};

const _hoisted_6$2 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "已开", -1));

const _hoisted_7$2 = /*#__PURE__*/createTextVNode(" | ");

const _hoisted_8$2 = {
  class: "count"
};

const _hoisted_9$1 = /*#__PURE__*/createTextVNode("%");

const _hoisted_10 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("p", null, "完成率", -1));

const _hoisted_11 = /*#__PURE__*/createTextVNode(" 维修资金 ");

const _hoisted_12 = {
  class: "warn"
};

const _hoisted_13 = /*#__PURE__*/_withScopeId(() => /*#__PURE__*/createElementVNode("span", null, "户", -1));

const _hoisted_14 = {
  class: "chart"
};

const _hoisted_15 = /*#__PURE__*/createTextVNode("物业党建");

const _hoisted_16 = {
  class: "party"
};
const _config$3 = {
  name: 'A016',
  title: '物业监管',
  row: 2,
  apis: {
    main: '/service-documents-ddd/public/checkOrder/operatingIndex'
  }
};
const __default__$3 = _config$3;

function setup$3(__props) {
  onMounted(() => {
    ajax$1.get({
      url: _config$3.apis.main
    }).then(res => {
      var _res$data;

      const {
        alreadyCheckCount = 0,
        //已开
        ycRatio = 0,
        //月查
        rectifyRatio = 0,
        //执行率
        shouldCheckCount = 0,
        //应开
        szRatio = 0,
        //双周查
        zcRatio = 0 //自查

      } = (res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.content) || {};
      summary.value = [{
        name: '房办月查',
        value: ycRatio
      }, {
        name: '物企双周查',
        value: szRatio
      }, {
        name: '物业日查',
        value: zcRatio
      }];
      info.value = {
        alreadyCheckCount,
        rectifyRatio
      };
    });
  });
  const info = ref({
    alreadyCheckCount: 0,
    rectifyRatio: 0
  });
  const summary = ref([{
    name: '房办月查',
    value: 0
  }, {
    name: '物企双周查',
    value: 0
  }, {
    name: '物业日查',
    value: 0
  }]);
  const list = ref([{
    name: '续筹预警',
    value: 47520
  }, {
    name: '涉及门牌',
    value: 3960
  }, {
    name: '涉及小区',
    value: 45
  }]);
  const partys = [{
    name: '业委会党小组',
    value: 29
  }, {
    name: '居委交叉任职',
    value: 51
  }, {
    name: '物业公司党小组',
    value: 167
  }];
  const barData = {
    dimensions: [{
      name: 'street',
      displayName: '街道'
    }, {
      name: 'value',
      displayName: '数量'
    }],
    source: [{
      street: '街道1',
      value: 20
    }, {
      street: '街道2',
      value: 20
    }, {
      street: '街道3',
      value: 30
    }, {
      street: '街道4',
      value: 40
    }, {
      street: '街道5',
      value: 50
    }, {
      street: '街道6',
      value: 50
    }, {
      street: '街道7',
      value: 50
    }, {
      street: '街道8',
      value: 20
    }]
  };
  const barOption = {
    legend: false,
    yAxis: {
      minInterval: 1
    },
    grid: {
      bottom: 0
    },
    xAxis: [{
      type: 'category',
      show: false
    }],
    series: [{
      type: 'bar',
      barWidth: '30%'
    }]
  };
  return (_ctx, _cache) => {
    const _component_m_progress = resolveComponent("m-progress");

    const _component_m_count = resolveComponent("m-count");

    const _component_m_sub = resolveComponent("m-sub");

    const _component_m_bar = resolveComponent("m-bar");

    const _component_m_empty = resolveComponent("m-empty");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "物业监管"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$3, [createElementVNode("div", _hoisted_2$3, [(openBlock(true), createElementBlock(Fragment, null, renderList(summary.value, item => {
        return openBlock(), createBlock(_component_m_progress, {
          key: item.name,
          value: item.value,
          msg: {
            name: item.name,
            value: item.value,
            unit: '%',
            color: '#fff',
            decimal: 2
          },
          color: ['rgb(36,59,86)', '#F4923E']
        }, null, 8, ["value", "msg", "color"]);
      }), 128))]), createElementVNode("div", _hoisted_3$3, [_hoisted_4$2, createElementVNode("div", null, [createElementVNode("div", null, [createElementVNode("p", _hoisted_5$2, [createVNode(_component_m_count, {
        value: info.value.alreadyCheckCount
      }, null, 8, ["value"])]), _hoisted_6$2]), _hoisted_7$2, createElementVNode("div", null, [createElementVNode("p", _hoisted_8$2, [createVNode(_component_m_count, {
        value: info.value.rectifyRatio
      }, null, 8, ["value"]), _hoisted_9$1]), _hoisted_10])])])]), createVNode(_component_m_sub, {
        addition: {
          value: 1684,
          unit: '万元'
        }
      }, {
        default: withCtx(() => [_hoisted_11]),
        _: 1
      }), createElementVNode("div", _hoisted_12, [createElementVNode("div", null, [createElementVNode("p", null, toDisplayString(list.value[0].name), 1), createVNode(_component_m_count, {
        class: "orange-count",
        value: list.value[0].value
      }, null, 8, ["value"]), _hoisted_13]), (openBlock(true), createElementBlock(Fragment, null, renderList(list.value.slice(1), item => {
        return openBlock(), createElementBlock("div", {
          key: item.name
        }, [createVNode(_component_m_count, {
          value: item.value
        }, null, 8, ["value"]), createElementVNode("p", null, toDisplayString(item.name), 1)]);
      }), 128))]), createElementVNode("div", _hoisted_14, [barData.source.length > 0 ? (openBlock(), createBlock(_component_m_bar, {
        key: 0,
        dataset: barData,
        option: barOption
      })) : (openBlock(), createBlock(_component_m_empty, {
        key: 1
      }))]), createVNode(_component_m_sub, null, {
        default: withCtx(() => [_hoisted_15]),
        _: 1
      }), createElementVNode("div", _hoisted_16, [(openBlock(), createElementBlock(Fragment, null, renderList(partys, item => {
        return createElementVNode("div", {
          key: item.name
        }, [createVNode(_component_m_count, {
          class: "orange-count",
          value: item.value
        }, null, 8, ["value"]), createElementVNode("p", null, toDisplayString(item.name), 1)]);
      }), 64))])]),
      _: 1
    });
  };
}

var script$3 = /*#__PURE__*/defineComponent({ ...__default__$3,
  setup: setup$3
});

var css_248z$3 = ".wrapper[data-v-2b156870] {\n  display: flex;\n  padding-bottom: 0.04rem;\n}\n.wrapper .left[data-v-2b156870] {\n  flex: 1.8;\n}\n.wrapper .right[data-v-2b156870] {\n  flex: 1;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  margin: 0.06rem 0.06rem 0 0.1rem;\n  padding: 0.06rem 0.1rem;\n}\n.wrapper .right >div[data-v-2b156870] {\n  display: flex;\n  align-items: center;\n  margin-top: 0.1rem;\n}\n.wrapper .right >div >div[data-v-2b156870] {\n  flex: 1;\n  text-align: center;\n}\n.wrapper .right >div >div .count[data-v-2b156870] {\n  font-size: 0.12rem;\n  color: #edb872;\n  font-family: DIN, 'Avenir', Helvetica, Arial, sans-serif;\n  font-weight: bold;\n}\n.wrapper .right >div >div >p[data-v-2b156870] {\n  color: #ccc;\n}\n.warn[data-v-2b156870] {\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  padding: 0.05rem 0.1rem;\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n}\n.warn >div[data-v-2b156870] {\n  text-align: center;\n  flex: 1;\n  position: relative;\n}\n.warn >div p[data-v-2b156870] {\n  color: #ccc;\n}\n.warn >div span[data-v-2b156870] {\n  font-size: 0.08rem;\n  margin-left: 0.05rem;\n  color: #ccc;\n}\n.warn >div[data-v-2b156870]:first-child {\n  flex: 1.5;\n}\n.warn >div:first-child p[data-v-2b156870] {\n  font-size: 0.12rem;\n  color: #fff;\n}\n.warn >div[data-v-2b156870]:last-child:before {\n  content: '|';\n  position: absolute;\n  top: 50%;\n  transform: translateY(-50%);\n  left: 0;\n}\n.chart[data-v-2b156870] {\n  width: 100%;\n  height: 0.8rem;\n  margin-bottom: 0.03rem;\n}\n.party[data-v-2b156870] {\n  display: flex;\n  justify-content: space-between;\n  text-align: center;\n  margin-bottom: 0.04rem;\n}\n.party p[data-v-2b156870] {\n  font-size: 0.09rem;\n  color: #ccc;\n}\n";
styleInject(css_248z$3);

script$3.__scopeId = "data-v-2b156870";

var img$4 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADoAAABACAMAAAB83JS9AAABL1BMVEUAAAAAYtQAYNEAY9YAZNoAYNEAat4AY9cAdeMAYNEAYdEAZNMAYNEAYNAAYdEAYdIAYtMAat4AYdEAYNEAYdIAYdEAYdEAYtEAYdEAZNQAZdgAaNYAYNEAYNEAYNEAYdEAYNEAYdEAYdEAYdEAYNEAYtIAYtMAiP8AYdAAYdEAYdEAYNEAYNEAYtMAYNEAYdEAdv////8AYNFJnf8AdPv9/f/k8P9rr//e7f8Adf0Abu8Abetkq/8AaeScyv8Aa+iEvP8DeP8AcvgAcfYAb/Emiv/n8v+t0v9fqf8xkP8rjf8AcPPM5P8jiP8AZ9+Qw/8Gef/1+v/t9f9Sov8MfP/7/P/X6f/A3f+32P+Wx/8TgP8AZdyNwf98uP91tf9tsf9Dmv8dhv/S5v/O5P9WpP+mEhg2AAAAMHRSTlMA/fr9/u8K/gXbhSH18oxKOg/MwJ2XaV1RKhsV6+K3rqR+d21hVyYC1dPGqm9BkzJd9676AAADZElEQVRIx62WaVfiMBSGk5ayCSgKirjvu3NzLWKL7K6guOG+z8z//w1DQEpDaameeT72nIebexPehPx/xseCG9Prw+vTs3NLy+4179iMghwqU+RMzQ76XdWLhRA9Wb2sAUct61kf4mQk2U9c3mh4GRVESnkfSvEJx6UGJfRUoRe6jOGFFVtzYBVlHWzQMhRH7ApvKZgHB7QsBsZ7mqMSPQBnMhgeJFYiKJegH1WKo9aa6FGhPyVZ6q67JcncdOFSZVmcrUKbq62cpVg3vw8F9wADUfN+rmJrQmesB0eim8Fpkzrf3pUUO7vZMXPE7lPdbg0ThjkRljVowtgNCOyx9EmK7QquSgP+zr7o0FZ3LCpw9xxM5I0dGpA84KRaXI1OeltqDKuOast9EiY13xpvyAMO6vFly90XygYIZwwz9uo9a5MGE1kc4uoMqvbqx1VPtYyRhrmieMBehaeP1v6KKtDhhvoLs7aqOC7xWEQJWcQDUS3u7Lf5tFXzvNkglkT1LzPYs1V1XORT0kT1/Gy3TcFWLWGQkBEKP+hVxTghw67U3NWpGHE4S8iqz40KdRDBGfsFO6NijJAN7FLrhVzuBODzJdfgjX89TF+kK2Ad0zaqonrCGEvVocCaVKBYuOVfCpdCquICIXNYFtWnx+Pjd4Dz3HGDQpH/xtHDLmMX4r4u8dOkO/Z6eMtyl1C8YKlK92ka6HOG99kRX2pxj71Bh+cQj6eA7Ki+sHvgPJhXrLUCNY4lJzVtVH015/gmVxOY6dPrY7HZ66E5Jca5Gg37nFQ+4d2HPcauTi3ZRIJ8xkKECxQLzXvoil0bbh4Xv8Kf57DNxdGM38r742vl9NpwNTrVjv+4EcR/WBepTnQ33Lt2DG8SI/59GkDPS/KuDh33LgcclYd/56bLgnueMUEMVkbwwLWZwRgxkQxT1aVZxoCXmFlCn+rOpNKQ5QUjq+5M68tpgbsuTavr4rVmmCIJBbOaU5TVcGqI9CY5grJ9YZ3ibJTYsTIvoU/v/aSVUVkiTiQjIfTlyyBSzVKcnIuSPkwEFURa040OMzWKOLXpJS7wb0XW0HhVe1BanxvyE9ck17D6FSXxKPkeyyGqNvNr2E++yxg+879meIB8nxjmwYMJ8gO8a1jDbfIjxkOWRt23qzg1+g/trepQHNm+xgAAAABJRU5ErkJggg==";
  var p1 = img$4;

var img$3 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADoAAABACAMAAAB83JS9AAABO1BMVEUAAADRohDUpRLOoA7OoA/QoQ/erhjXqBTQohPSog/YpBXNoA7OoA/OoA/OoQ/Onw7OoA7Onw7OoA/PoA7QoRHOoA/OoA/OoA/OoA7OoQ/PohH/wz3VphPOoA7OoA7OoA/OoA7OoA/OoRDPpBPXrinOoA/OoA7Onw/PoRDOoA/QoQ/UoxXOoA/NoA/OoA7PoQ7PohDQog7/zjT////Nnw7/7rv//vv/9NH+zDL6yS/ntiH/2mXtvSbquSP/zjb8yjDwvyf/7K//0Dv1xCv/+OL/9db/3nb/1EvgsRz/+ej/8MH/11j3xi3ywin//PP/+/H/99//6KD/3G//1VL/0kXZqxb/+uv/9tv/5pn/0UP/883/8sn/5ZL/4ID/22rjsx3crRn//Pb/7bP/44z/33r/2Fz/0D//6af/6aQvdQWxAAAAMnRSTlMA/f358f0K/ighEPz1XFPb1K2CeDrMwKWdiEsE/u7rlY1oYRoG5MaYb25BF+C5tmowR4Xdet0AAAPcSURBVEjHrZbnVuJAFICTAKJ0cRXsXdd168w19I50ULGAbXVtu+//BHsjJDNhJ5Rz9vsXku/cMneGkf4/373B0Je9+b2voaBvenxtyju7ChqyIoPGbmhpeRxxOuwBcD4kC1GikSkkKysAaxvbI8VZNzhTMWImFl8B2/7h0FSDNnA2iYikAvYD67RnAqAkiQXRlAwLLgvz0yrEo8SaTAU+i7u96XZkyXBS4FkSmBugNMgomrJ78x/zG1xmyGhiivvHYJ1uBc0xaMh2c70zqw6Wbbl0l7spXrVU9eSqeJO7K5VNOYPfxa9nAPodert/KtJ/KD7dv3G9+sKpcxAnSP6lptIearUTub2NdKrGD7WXfN+tgM8wXXYlSpBjqvHrtts+T5M+6fN29/YX1TjWW+XwL7N16c0Qvq7+ThgWI534XcWX+mMcNvUe2Zykr9aIJTWmRuW1qZ4ahqyuHlmrR6iyTs312utxkslUDOt/V72QmlQlD/BBU2chI1QTp8+WagEWNdXuJCI1fULptVhF5Hk0v8ODUC3hShFL9dGN07gFWaGKi3Fmrca1YhehIVIvcALPrdUsbGldiorUZ0pviLXa0Pq04CAitUPp/RA1BvuSNC+L1DqlauknUharUQhJUmBFpP6hfVploUpgFhMWRn2iOm2hmoGwVZvKtWMEd9pJ3qJNQUlahxivmohQ2hXX2oQD7XAp6M8tGjGZCTwyjFm8oS3CSIJPm6YkC3KSHtjdf7iRjgxO0wxU9OccpSXCOMcFMtbmhdIcYVx6dnD+/QqX4DFh5Liv03jkJbgGO75KyDo0uLbcEZ1rfoq71JRvFj5qqg9SXFj11VgflTU8oXJBkQpM905hNk9nlF4ZkUq5C30sW+YdmHH4pXcWWY/TmHKxTAaoX2G6aVN/t3rqoc3JCuxg3LrZTGDMzjU/+/KufvyvQ5Nt8VMcvjZv3mOdpxeEI4VNMo5/JcpczFntEp18jmK2JjOGhz/3T1dhb/JH2sd1/UTFh6M84bnEIWQsQJYw7lQMfIbfv2kh1WdiIg5h07+6XY4RxqsWq9huVymW+Wo2Cw7/lMTjBYV382cqRXrBzaZs+zB4a+JdpB6hrGSTuSS4/aDLUyoWS8Ta5DkAeeRtzYGmCN8qVIbeER/hM9YpZHsBFMvA0aQMIZdkyZwNnEmhmFLA7pWGsb3hASVeGPCacRnW5lzSCA6DdgC5YsTOpB4dALsfp6Qx2Pm0GACIGxPr3gt+WJbGZjvQ34gPsO+SJmPa8z7VWZjfkSbFC5fa1rTPSJMThjjbmpOBl+RHWJ/MYeWyQifFO7TQv7z2Aj6Pe0qxAAAAAElFTkSuQmCC";
  var p3 = img$3;

var img$2 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADoAAABACAMAAAB83JS9AAABI1BMVEUAAADBGhq6EhK8FRW9FRW6EhK6EhLEHR26EhK6EhK6EhK6ExO6EhK/Fxe/GxvDFBS+Fha6EhK6EhK6ExO6EhK6EhLNHh66ExO6ExO5ExO7ExO7ExO7ExO6EhK6EhK7FBS7FBS7Fha6ExO6EhK6EhK7ExO7ExO7ExP/YWG6EhL/////kJD/7+//gYH/39//4+P/bm7/5eX/c3P/cXH/5OT1VFT/8/P/4uL/hIT7W1v/9/f/8fH/u7v/a2v/lJT/6+v/29v/v7/8XV3nRUXhPT34WFjyUVHqR0fYNDTRLCzHISH/i4v/fHz+X1/sSkrkQkLbNzf/f3/eOjrVMDD/+vr/5+f/hob/aWnJIyP/x8f/wsL/np7/dnbNJyf/tbXtTEzvT0/kdYJzAAAAKHRSTlMA/fv+I/Ls/mBxtpOBHBIM/eDGrqZTCPfazXpaTdPBQDIt55yNa0Y50HvxhQAAA2ZJREFUSMet1mlT2lAUBuCbpKwCBUU20bYu9b4QQGwDEmpt2ZeyKO5L2///K2pCQhaSmMz0/Xhmnpl7DvceQv5/PgYjyfBmdi+czG2/c8/eB7d8AMDFmTikJA4+u4LvDtLAaNDutaiUxt/ZggH2I+/fgrENFqNOgxojzBn4QyknmMr5MPpDrTJjkNhxOGsGgTa1SeuKQ9ju1J99uJpQ+zSG2LWedojlptQ5V/B/sJAbCAj0rfQ5dr3hEO4b9O0IDHts7pMNGOW4uMqtvt7j9qPG2frixtOWxMIqtV9UlzayKf3Vy2BKjbTJ18tyKs0LA6VzJHU0gitqppUTKue0aqL0BdqYY77AxAMVsKn7XdrUA6ULbKszYkfUE+1yGYUmsbrxX9Tc6unlqry6VcHleNP3qrzkvyq5ETUqVtUqf6ncZm7ZbRAdlRYLIr9M81qj102lKBaKdJkh5HewhYZGy6Vlxnzl5NuPZ5k2x0qxvKJ9hCTqG1EdVcf0Sn8UvsuULylFjbYQlnYf5t4pvffJrfZtaPXang6kZg8h2NDTMbWlM+SlKbVs6NPjuS2dSnPa46gNrTv02kOEkCxjpOOn9TE9P52aqIBDQnYDBnp+IZ6t0YfCo4l2sbF24PN6bZ3+LHyzOnASLQOtuKJTHEmPtWvo9ffD3RotPoxNdCY92Rx6Bvpcomv07vbORDs4lm5TW0/vbmolmd6clQu/X+/87Q1fehTNB14gSkgUQ8sxiXytIL+2a6temQR5TYaxpDXlgVdrFlTAwXKpCVa0cvpFjuWEO8vFlkfHiqpb4qRiQV/YmERTfmbikQoIq7u/7ZEu1P0fSwec6ZmJdrX1f4i+Svk6L0r/U1VRo2L9onBRfg2v0AHyKo2mmYZCtfAq5bXakvawS1Y5Uq9FUcvlaq9rNVm2AuxHoiWMNnWbBXJEl6g/LriUbewRQ/Is48724Y8SY3Yk60p+UoQXq0lzgiw3c4atgSrN+bCPYcNBCgFs2n2Rx7bAzCY2sDEHGyH2CfrAdFoWsDvgkDl2/u7P+REfTFtG1x4CuzvkraSOEgBeOhO1w8EIwGaeuMqnUDiNudIiA38yGCXu8z6rfDUOEXKNtG/Vrry/tojnbON+QntIxIj3bGDekJ+m96SyGKmNem931aj3dh0b/Qd6jK+rxcBnHwAAAABJRU5ErkJggg==";
  var p4 = img$2;

const _hoisted_1$2 = {
  class: "summary"
};
const _hoisted_2$2 = ["onClick"];

const _hoisted_3$2 = /*#__PURE__*/createTextVNode(" % ");

const _hoisted_4$1 = {
  class: "chart-wrapper"
};
const _hoisted_5$1 = {
  class: "chart"
};
const _hoisted_6$1 = {
  class: "legend"
};
const _hoisted_7$1 = {
  class: "inner"
};
const _hoisted_8$1 = ["title"];

const _hoisted_9 = /*#__PURE__*/createTextVNode("%");
const _config$2 = {
  name: 'A017',
  title: '安全排查',
  row: 1,
  baseUrl: window._base_url,
  apis: {
    main: '/service-special-ja-ddd/public/risk/type/statistical',
    list: '/service-special-ja-ddd/public/wholeBuildingRiskss'
  }
};
const __default__$2 = _config$2;

function setup$2(__props) {
  ajax$1.get({
    url: _config$2.apis.main
  }).then(res => {
    var _res$data;

    const {
      checkRate,
      riskTypeStatistical = []
    } = (res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.content) || {};
    list.value = [{
      name: '需专业排查',
      value: +checkRate.judgeType * 100 || 0,
      query: {
        judgeType: '需专业排查评估'
      },
      icon: p1
    }, {
      name: '需应急排险',
      value: +checkRate.isEmergencyRisk * 100 || 0,
      query: {
        isEmergencyRisk: true
      },
      icon: p3
    }, {
      name: '小梁薄板',
      value: +checkRate.isThinPlate * 100 || 0,
      query: {
        isThinPlate: true
      },
      icon: p4
    }];
    const total = riskTypeStatistical.reduce((acc, cur) => acc + +cur.num, 0);
    pieData.source = riskTypeStatistical.map(item => ({
      type: item.riskType,
      value: +item.num || 0,
      rate: +(+item.num / total * 100).toFixed(0)
    }));
  });
  const pieData = {
    dimensions: [{
      name: 'type',
      displayName: '安全排查类型'
    }, {
      name: 'value',
      displayName: '占比'
    }],
    source: []
  };
  const pieOption = {
    color: ['#0076FF', '#00BFFF', '#9FC444', '#FFCE34', '#FF9D27', '#FF6161', '#BABABA', '#ff0000', '#00ff00', '#0000ff', '#9FE6B8', '#FFDB5C', '#ff9f7f', '#fb7293', '#E062AE', '#E690D1', '#e7bcf3', '#9d96f5', '#8378EA', '#96BFFF'],
    legend: false,
    series: [{
      type: 'pie',
      radius: ['60%', '90%'],
      label: {
        show: false,
        position: 'center'
      }
    }]
  };
  const list = ref([{
    name: '需专业排查',
    value: 0
  }, {
    name: '需应急排险',
    value: 0
  }, {
    name: '小梁薄板',
    value: 0
  }]);

  async function onClick({
    query,
    icon
  }) {
    var _await$ajax$get, _await$ajax$get$data;

    const data = ((_await$ajax$get = await ajax$1.get({
      url: _config$2.apis.list,
      params: {
        pageSize: 9000,
        createTime_desc: 'desc',
        ...query
      }
    })) === null || _await$ajax$get === void 0 ? void 0 : (_await$ajax$get$data = _await$ajax$get.data) === null || _await$ajax$get$data === void 0 ? void 0 : _await$ajax$get$data.content) || [];
    EventBus.emit('addPoints', {
      data,
      icon
    });
  }

  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_pie = resolveComponent("m-pie");

    const _component_m_empty = resolveComponent("m-empty");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "安全排查"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$2, [(openBlock(true), createElementBlock(Fragment, null, renderList(list.value, item => {
        return openBlock(), createElementBlock("div", {
          key: item.name,
          onClick: $event => onClick(item)
        }, [createVNode(_component_m_count, {
          class: "orange-count",
          value: item.value,
          decimal: 2
        }, null, 8, ["value"]), _hoisted_3$2, createElementVNode("p", null, toDisplayString(item.name), 1)], 8, _hoisted_2$2);
      }), 128))]), createElementVNode("div", _hoisted_4$1, [pieData.source.length > 0 ? (openBlock(), createElementBlock(Fragment, {
        key: 0
      }, [createElementVNode("div", _hoisted_5$1, [pieData.source.length > 0 ? (openBlock(), createBlock(_component_m_pie, {
        key: 0,
        dataset: pieData,
        option: pieOption
      })) : createCommentVNode("", true)]), createElementVNode("div", _hoisted_6$1, [createElementVNode("div", _hoisted_7$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(pieData.source, (item, i) => {
        return openBlock(), createElementBlock("div", {
          key: item.type
        }, [createElementVNode("i", {
          class: "dot",
          style: normalizeStyle(`background:${pieOption.color[i]}`)
        }, null, 4), createElementVNode("p", {
          title: item.type
        }, toDisplayString(item.type), 9, _hoisted_8$1), createElementVNode("span", null, [createVNode(_component_m_count, {
          value: item.rate
        }, null, 8, ["value"]), _hoisted_9])]);
      }), 128))])])], 64)) : (openBlock(), createBlock(_component_m_empty, {
        key: 1
      }))])]),
      _: 1
    });
  };
}

var script$2 = /*#__PURE__*/defineComponent({ ...__default__$2,
  setup: setup$2
});

var css_248z$2 = ".chart-wrapper[data-v-366208e7] {\n  display: flex;\n}\n.chart-wrapper .chart[data-v-366208e7] {\n  width: 25%;\n  height: 1rem;\n}\n.chart-wrapper .legend[data-v-366208e7] {\n  flex: 1;\n}\n.chart-wrapper .legend .inner[data-v-366208e7] {\n  display: flex;\n  flex-wrap: wrap;\n}\n.chart-wrapper .legend .inner >div[data-v-366208e7] {\n  display: flex;\n  align-items: center;\n  width: 48%;\n  font-size: 0.08rem;\n}\n.chart-wrapper .legend .inner >div[data-v-366208e7]:nth-of-type(2n) {\n  margin-left: 0.05rem;\n}\n.chart-wrapper .legend .inner >div .dot[data-v-366208e7] {\n  display: inline-block;\n  width: 0.06rem;\n  height: 0.06rem;\n  border-radius: 50%;\n}\n.chart-wrapper .legend .inner >div p[data-v-366208e7] {\n  margin: 0 0.04rem;\n  flex: 1;\n  color: #ccc;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n.summary[data-v-366208e7] {\n  display: flex;\n  justify-content: space-between;\n  margin-bottom: 0.04rem;\n}\n.summary >div[data-v-366208e7] {\n  text-align: center;\n  cursor: pointer;\n}\n.summary >div[data-v-366208e7]:hover {\n  color: #edb872;\n}\n";
styleInject(css_248z$2);

script$2.__scopeId = "data-v-366208e7";

var img$1 = "data:image/png;base64,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";
  var ele1 = img$1;

var img = "data:image/png;base64,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";
  var ele2 = img;

const _hoisted_1$1 = {
  class: "sum"
};
const _hoisted_2$1 = ["onClick"];
const _hoisted_3$1 = {
  class: "chart"
};
const _config$1 = {
  name: 'A018',
  title: '电梯加装',
  row: 1,
  baseUrl: window._base_url,
  apis: {
    main: '/service-special-ja-ddd/public/elevator/statistical',
    elevator: '/service-special-ja-ddd/public/elevatorInstallationInfos'
  }
};
const __default__$1 = _config$1;

function setup$1(__props) {
  ajax$1.get({
    url: _config$1.apis.main
  }).then(res => {
    var _res$data;

    const {
      statistical,
      streetData = []
    } = (res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.content) || {};
    list.value = [// { name: '多层住宅房屋', value: +statistical.totalNum || 0, unit: '幢' },
    // { name: '可加梯门牌数', value: +statistical.caddNum || 0, unit: '幢' },
    {
      name: '完成加梯征询',
      value: +statistical.passNum || 0,
      unit: '幢',
      state: '2'
    }, {
      name: '加梯完工',
      value: +statistical.finishNum || 0,
      unit: '幢',
      state: '7'
    }];
    charData.value.source = streetData;
  });
  const fontSize = computed(() => Math.floor(screen.height * 1.6 / 100));
  const charData = ref({
    dimensions: [{
      name: 'streetName',
      displayName: '街道'
    }, {
      name: 'passNum',
      displayName: '已完成征询'
    }, {
      name: 'shouldPassNum',
      displayName: '应完成征询'
    }, {
      name: 'startNum',
      displayName: '已开工'
    }, {
      name: 'shouldStartNum',
      displayName: '应开工'
    }, {
      name: 'finishNum',
      displayName: '已完工'
    }, {
      name: 'shouldFinishNum',
      displayName: '应完工'
    }],
    source: []
  });
  const option = {
    color: ['#0076FF', '#00BFFF', '#9FC444', '#FFCE34', '#FF9D27', '#FF6161', '#BABABA', '#ff0000', '#00ff00'],
    grid: {
      left: '2%',
      right: '1%',
      bottom: '1%',
      top: '20%',
      containLabel: true
    },
    legend: {
      left: 0,
      right: 0,
      itemWidth: fontSize.value * 0.6,
      itemHeight: fontSize.value * 0.8,
      textStyle: {
        fontSize: fontSize.value * 0.8
      }
    },
    xAxis: [{
      type: 'category',
      axisLabel: {
        interval: 0,
        rotate: 45,
        fontSize: fontSize.value * 0.8
      }
    }],
    series: [{
      type: 'bar',
      barWidth: '20%'
    }, {
      type: 'line'
    }, {
      type: 'bar',
      barWidth: '20%'
    }, {
      type: 'line'
    }, {
      type: 'bar',
      barWidth: '20%'
    }, {
      type: 'line'
    }]
  };
  const list = ref([// { name: '多层住宅房屋', value: 0, unit: '幢' },
  // { name: '可加梯门牌数', value: 0, unit: '幢' },
  {
    name: '完成加梯征询',
    value: 0,
    unit: '幢',
    state: '2'
  }, {
    name: '加梯完工',
    value: 0,
    unit: '幢',
    state: '7'
  }]);

  const onClick = state => {
    const icon = state === '2' ? ele1 : ele2;
    ajax$1.get({
      url: _config$1.apis.elevator,
      params: {
        state,
        createTime_desc: 'desc',
        pageSize: 9000
      }
    }).then(res => {
      var _res$data2;

      const data = (res === null || res === void 0 ? void 0 : (_res$data2 = res.data) === null || _res$data2 === void 0 ? void 0 : _res$data2.content) || [];
      EventBus.emit('addPoints', {
        data,
        icon
      });
    });
  };

  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_bar = resolveComponent("m-bar");

    const _component_m_empty = resolveComponent("m-empty");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "电梯加装"
    }, {
      default: withCtx(() => [createElementVNode("div", _hoisted_1$1, [(openBlock(true), createElementBlock(Fragment, null, renderList(list.value, item => {
        return openBlock(), createElementBlock("div", {
          key: item.name,
          onClick: $event => onClick(item.state)
        }, [createElementVNode("span", null, toDisplayString(item.name), 1), createVNode(_component_m_count, {
          class: "orange-count",
          value: item.value
        }, null, 8, ["value"]), createElementVNode("span", null, toDisplayString(item.unit), 1)], 8, _hoisted_2$1);
      }), 128))]), createElementVNode("div", _hoisted_3$1, [charData.value.source.length > 0 ? (openBlock(), createBlock(_component_m_bar, {
        key: 0,
        dataset: charData.value,
        option: option
      }, null, 8, ["dataset"])) : (openBlock(), createBlock(_component_m_empty, {
        key: 1
      }))])]),
      _: 1
    });
  };
}

var script$1 = /*#__PURE__*/defineComponent({ ...__default__$1,
  setup: setup$1
});

var css_248z$1 = ".sum[data-v-a1b5cab6] {\n  display: flex;\n  justify-content: space-around;\n}\n.sum >div[data-v-a1b5cab6] {\n  display: flex;\n  align-items: center;\n  font-size: 0.09rem;\n  color: #ccc;\n  cursor: pointer;\n}\n.sum >div .orange-count[data-v-a1b5cab6] {\n  margin: 0 0.04rem 0.02rem;\n}\n.sum >div[data-v-a1b5cab6]:hover {\n  color: #edb872;\n}\n.chart[data-v-a1b5cab6] {\n  width: 100%;\n  height: 1.5rem;\n}\n";
styleInject(css_248z$1);

script$1.__scopeId = "data-v-a1b5cab6";

const _hoisted_1 = /*#__PURE__*/createTextVNode(" 住宅预销售金额 ");

const _hoisted_2 = {
  style: {
    "margin-left": "0.1rem"
  }
};

const _hoisted_3 = /*#__PURE__*/createTextVNode(" 万元 ");

const _hoisted_4 = {
  class: "bar"
};

const _hoisted_5 = /*#__PURE__*/createTextVNode(" 张 ");

const _hoisted_6 = /*#__PURE__*/createTextVNode(" % ");

const _hoisted_7 = {
  class: "name"
};
const _hoisted_8 = {
  class: "areas"
};
const _config = {
  name: 'A019',
  title: '市场预售',
  row: 1,
  baseUrl: window._base_url,
  apis: {
    main: '/service-special-ja-ddd/public/presale/statistical'
  }
};
const __default__ = _config;

function setup(__props) {
  const year = ref('2021');
  const total = ref(0);
  watch(() => year.value, val => {
    ajax$1.get({
      url: _config.apis.main,
      params: {
        year: val
      }
    }).then(res => {
      var _res$data;

      const {
        noLivePresaleNum = 0,
        //非居预售证数
        totalSets = 0,
        //总套数
        liveRate = 0,
        //居住占比
        totalPrice = 0,
        //总金额
        presaleNum = 0,
        //预售证数
        noLiveRate = 0,
        //非居占比
        livePresaleNum = 0,
        //居住预售证数
        totalArea = 0 //总面积

      } = (res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.content) || {};
      total.value = totalPrice;
      list.value = [{
        name: '住房',
        value: livePresaleNum,
        rate: liveRate * 100,
        color: '#ff9d26'
      }, {
        name: '商办',
        value: noLivePresaleNum,
        rate: noLiveRate * 100,
        color: '#01bffe'
      }];
      areas.value = [{
        name: '预销售面积',
        value: totalArea,
        unit: '㎡',
        decimal: 2
      }, {
        name: '预销售套数',
        value: totalSets,
        unit: '套',
        decimal: 0
      }];
    });
  }, {
    immediate: true
  });
  const yearOptions = [{
    label: '2021',
    value: '2021'
  }, {
    label: '2020',
    value: '2020'
  }, {
    label: '2019',
    value: '2019'
  }];
  const list = ref([{
    name: '住房',
    value: 0,
    rate: 0,
    color: '#ff9d26'
  }, {
    name: '商办',
    value: 0,
    rate: 0,
    color: '#01bffe'
  }]);
  const areas = ref([{
    name: '预销售面积',
    value: 0,
    unit: '㎡',
    decimal: 2
  }, {
    name: '预销售套数',
    value: 0,
    unit: '套',
    decimal: 0
  }]);
  return (_ctx, _cache) => {
    const _component_m_count = resolveComponent("m-count");

    const _component_m_card = resolveComponent("m-card");

    return openBlock(), createBlock(_component_m_card, {
      title: "市场预售"
    }, {
      default: withCtx(() => [createVNode(unref(NSpace), {
        justify: "space-between"
      }, {
        default: withCtx(() => [createElementVNode("p", null, [_hoisted_1, createElementVNode("span", _hoisted_2, [createVNode(_component_m_count, {
          class: "orange-count",
          value: total.value
        }, null, 8, ["value"]), _hoisted_3])]), createVNode(unref(NSelect), {
          value: year.value,
          "onUpdate:value": _cache[0] || (_cache[0] = $event => year.value = $event),
          class: "my-select",
          size: "small",
          options: yearOptions
        }, null, 8, ["value"])]),
        _: 1
      }), createElementVNode("div", _hoisted_4, [(openBlock(true), createElementBlock(Fragment, null, renderList(list.value, item => {
        return openBlock(), createElementBlock("div", {
          key: item.name,
          style: normalizeStyle({
            flex: item.rate,
            background: item.color
          })
        }, [createElementVNode("div", {
          style: normalizeStyle({
            borderColor: item.color
          })
        }, [createElementVNode("p", null, [createElementVNode("span", {
          style: normalizeStyle({
            color: item.color
          })
        }, toDisplayString(item.value), 5), _hoisted_5, createElementVNode("span", {
          style: normalizeStyle({
            color: item.color
          })
        }, toDisplayString(item.rate), 5), _hoisted_6]), createElementVNode("p", _hoisted_7, toDisplayString(item.name), 1)], 4)], 4);
      }), 128))]), createElementVNode("div", _hoisted_8, [(openBlock(true), createElementBlock(Fragment, null, renderList(areas.value, item => {
        return openBlock(), createElementBlock("div", {
          key: item.name
        }, [createElementVNode("p", null, toDisplayString(item.name), 1), createElementVNode("span", null, [createVNode(_component_m_count, {
          class: "orange-count",
          value: item.value,
          decimal: item.decimal
        }, null, 8, ["value", "decimal"]), createTextVNode(" " + toDisplayString(item.unit), 1)])]);
      }), 128))])]),
      _: 1
    });
  };
}

var script = /*#__PURE__*/defineComponent({ ...__default__,
  setup
});

var css_248z = ".bar[data-v-4fa7064f] {\n  display: flex;\n  width: 100%;\n  height: 0.06rem;\n  margin: 0.14rem 0;\n}\n.bar >div[data-v-4fa7064f] {\n  position: relative;\n}\n.bar >div .count[data-v-4fa7064f] {\n  font-size: 0.12rem;\n}\n.bar >div >div[data-v-4fa7064f] {\n  height: 0.15rem;\n  transform: translateY(-100%);\n}\n.bar >div >div p[data-v-4fa7064f] {\n  min-width: 0.5rem;\n}\n.bar >div >div .name[data-v-4fa7064f] {\n  margin-top: 0.05rem;\n}\n.bar >div:nth-of-type(1) >div[data-v-4fa7064f] {\n  border-left: 0.01rem solid;\n}\n.bar >div:nth-of-type(1) p[data-v-4fa7064f] {\n  width: 100%;\n  margin-left: 0.05rem;\n}\n.bar >div:nth-of-type(2) >div[data-v-4fa7064f] {\n  border-right: 0.01rem solid;\n  padding-right: 0.1rem;\n}\n.bar >div:nth-of-type(2) p[data-v-4fa7064f] {\n  width: 100%;\n  text-align: right;\n  margin-right: 0.1rem;\n}\n.areas[data-v-4fa7064f] {\n  display: flex;\n  justify-content: space-between;\n}\n.areas >div[data-v-4fa7064f] {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  background: rgba(70,83,97,0.4);\n  border-radius: 0.04rem;\n  box-shadow: 0 0.01rem 0.01rem 0 rgba(255,255,255,0.2) inset;\n  box-sizing: border-box;\n  color: #ccc;\n  padding: 0.05rem 0.08rem;\n}\n.areas >div+div[data-v-4fa7064f] {\n  flex: 1;\n  margin-left: 0.05rem;\n}\n.areas >div .orange-count[data-v-4fa7064f] {\n  margin: 0 0.04rem 0.02rem 0.1rem;\n}\n.areas >div span[data-v-4fa7064f] {\n  display: flex;\n  align-items: center;\n  font-size: 0.09rem;\n  color: #aaa;\n}\n";
styleInject(css_248z);

script.__scopeId = "data-v-4fa7064f";

var componentLib = /*#__PURE__*/Object.freeze({
    __proto__: null,
    A001: script$k,
    A002: script$i,
    A003: script$g,
    A004: script$f,
    A005: script$e,
    A006: script$d,
    A007: script$c,
    A008: script$b,
    A009: script$a,
    A010: script$9,
    A011: script$8,
    A012: script$7,
    A013: script$6,
    A014: script$5,
    A015: script$4,
    A016: script$3,
    A017: script$2,
    A018: script$1,
    A019: script
});

const install = function (app) {
  Object.entries(components).forEach(([componentName, component]) => {
    app.component(componentName, component);
  });
};

const eventBus = EventBus;
const components = componentLib;

export { components, install as default, eventBus };
