import { ref } from 'vue'
import componentList, { tabs } from '@/utils/component-list'
import take2rows from '@/utils/take2rows'

export default function useComponent() {
  const showComponentModal = ref(false) // 展示组件选择框
  const curBox = ref<number | null>(null) // 当前容器下标
  const components = ref<{ [key: number]: string }>({}) // {容器下标: 组件key}
  const isTake2rows = ref<boolean>(false)

  const openComponentModal = (i: number, template: string[]) => {
    // 点击容器中的新增按钮
    curBox.value = i
    const name = `box${i + 1}`
    isTake2rows.value = take2rows(template, name)
    showComponentModal.value = true
  }
  const onSelectComponent = (key: string) => {
    // 选择组件后将key存入
    if (curBox.value === null) return
    components.value[curBox.value] = key
  }
  const onCancelComponent = (i: number) => {
    // 取消组件
    delete components.value?.[i]
  }

  return {
    components,
    componentList, // key-组件 对照表
    showComponentModal,
    openComponentModal,
    onSelectComponent,
    onCancelComponent,
    tabs,
    isTake2rows,
  }
}
