interface Config {
  layout?: { template: string[]; rows: string; boxNum: number }
  components?: { [key: number]: string }
}

export default function useConfig(config?: string) {
  if (config) {
    // 保存配置
    window.sessionStorage.setItem('__layout_components__', config)
    return
  }

  // 获取配置
  let data = window.sessionStorage.getItem('__layout_components__')
  data && (data = JSON.parse(data))
  return data as Config
}
