export interface EventListener {
  onLoad: (cb: CallBack) => void
  onZoom: (cb: CallBack) => void
  onMove: (cb: CallBack) => void
  onBlur: (cb: CallBack) => void
  onFocus: (cb: CallBack) => void
  onDrag: (cb: CallBack) => void
  onResize: (cb: CallBack) => void
  onClick: (cb: CallBack) => void
  onDblclick: (cb: CallBack) => void
  onMousewheel: (cb: CallBack) => void
}

export type EventName =
  | 'load'
  | 'zoom'
  | 'move'
  | 'blur'
  | 'focus'
  | 'drag'
  | 'resize'
  | 'click'
  | 'dblclick'
  | 'mousewheel'

export interface MapConfig {
  el: string
  type: 'SMap' | 'AMap' | 'BMap'
  options: MapOptions
  sources?: string[]
}

export interface MapOptions {
  viewMode?: '2D' | '3D'
  center?: number[]
  zooms?: number[]
  zoom?: number
  pitch?: number
  rotation?: number
  mapStyle?: string
  showBuildingBlock?: boolean
  resizeEnable?: boolean
  rotateEnable?: boolean
  pitchEnable?: boolean
  showLabel?: boolean
  buildingAnimation?: boolean // 楼块出现是否带动画
  expandZoomRange?: boolean
  showIndoorMap?: boolean
  features?: string[]
  netType?: string
}

export type CallBack = (arg: unknown, oth?: unknown) => void

// export type CallBackDic = { [key: string]: CallBack }

export interface BoundaryOption {
  name?: string
  type?: string
  weight?: number
  count?: number
  color?: string
  maskColor?: number[]
}

export interface MarkerOption {
  data: unknown[]
  key?: string
  labelKey?: string
  icon?: string
  size?: number | number[]
  color?: string
}
