import {
  CallBack,
  EventListener,
  BoundaryOption,
  MarkerOption,
  EventName,
} from './types'

export default abstract class Map implements EventListener {
  protected map
  constructor(map: any) {
    this.map = map
  }
  get instance(): any {
    return this.map
  }
  on<T extends keyof EventListener>(name: EventName, cb: CallBack): this {
    const eventName = `on${name.slice(0, 1).toUpperCase()}${name
      .slice(1)
      .toLowerCase()}` as T
    if (!this[eventName]) throw new Error(`地图不存在'${name}'事件`)
    this[eventName](cb)
    return this
  }
  abstract onLoad(cb: CallBack): void
  abstract onZoom(cb: CallBack): void
  abstract onMove(cb: CallBack): void
  abstract onBlur(cb: CallBack): void
  abstract onFocus(cb: CallBack): void
  abstract onDrag(cb: CallBack): void
  abstract onResize(cb: CallBack): void
  abstract onClick(cb: CallBack): void
  abstract onDblclick(cb: CallBack): void
  abstract onMousewheel(cb: CallBack): void
  abstract zoomIn(): void
  abstract zoomOut(): void
  abstract hideCommunity(): void
  abstract showCommunity(): void
  abstract filterCommunity(ids: unknown[], key: string): void
  abstract focus(location: number[], zoom?: number): void
  abstract addBoundary(option: BoundaryOption): unknown
  abstract addMarkers(option: MarkerOption): unknown
  abstract remove(markers: unknown): void
}
