import { MapConfig, EventListener } from './types'
import Map from './map'
import S_Map from './s-map'
import A_Map from './a-map'

export type MapType = Omit<Map, keyof EventListener>

export async function createMap(config: MapConfig): Promise<MapType> {
  await _injectSource(config)
  return _whichMap(config)
}

function _injectSource(config: MapConfig): Promise<unknown[]> {
  if (!config.sources || config.sources.length === 0) {
    return Promise.resolve([true])
  }
  const promises = config.sources.map((source: string, index: number) => {
    return new Promise((resolve) => {
      const id = `_my_map_source${index}`
      if (document.getElementById(id)) return resolve(true)

      const mapSource = document.createElement('script')
      mapSource.type = 'text/javascript'
      mapSource.src = source
      mapSource.setAttribute('id', id)
      document.body.appendChild(mapSource)
      mapSource.onload = () => resolve(true)
    })
  })
  return Promise.all(promises)
}

function _whichMap(config: MapConfig): Map {
  const { type } = config
  switch (type) {
    case 'SMap':
      return new S_Map(config)
    case 'AMap':
      return new A_Map(config)
    default:
      if (type) {
        throw new Error(`不存在${type}类型的地图！`)
      } else {
        // eslint-disable-next-line
        throw new Error('初始化地图需要配置\'type\'字段！')
      }
  }
}
