import { MapConfig, CallBack, BoundaryOption, MarkerOption } from './types'
import Map from './map'

declare const AMap: {
  Map: any
  Icon: any
  DistrictSearch: any
  LngLat: any
  Marker: any
  Polygon: any
}

export default class A_Map extends Map {
  constructor(config: MapConfig) {
    super(new AMap.Map(config.el, config.options))
  }
  onLoad(cb: CallBack): void {
    this.map.on('complete', cb)
  }
  onZoom(cb: CallBack): void {
    this.map.on('zoomend', cb)
  }
  onMove(cb: CallBack): void {
    this.map.on('mapmove', cb)
  }
  onBlur(): void {
    throw new Error('AMap没有blur事件!')
  }
  onFocus(): void {
    throw new Error('AMap没有focus事件!')
  }
  onDrag(cb: CallBack): void {
    this.map.on('dragging', cb)
  }
  onResize(cb: CallBack): void {
    this.map.on('resize', cb)
  }
  onClick(cb: CallBack): void {
    this.map.on('click', cb)
  }
  onDblclick(cb: CallBack): void {
    this.map.on('dblclick', cb)
  }
  onMousewheel(cb: CallBack): void {
    this.map.on('mousewheel', cb)
  }
  zoomIn(): void {
    this.map.zoomIn()
  }
  zoomOut(): void {
    this.map.zoomOut()
  }
  hideCommunity(): void {
    throw new Error('AMap没有hideCommunity方法！')
  }
  showCommunity(): void {
    throw new Error('AMap没有showCommunity方法！')
  }
  filterCommunity(): void {
    throw new Error('AMap没有filterCommunity方法！')
  }
  focus(location: number[], zoom = this.map.getZoom()): void {
    this.map.setView(location, zoom)
  }
  addBoundary({
    name,
    type,
    weight = 10,
    color = 'rgba(51,145,255,.6)',
    maskColor = [0, 17, 33, 0.9],
  }: BoundaryOption): unknown {
    if (!name || !type) {
      throw new Error('AMap的addBoundary方法需要name参数！')
      return
    }
    return new AMap.DistrictSearch({
      extensions: 'all',
      subdistrict: 0,
    }).search(name, (_: unknown, result: any) => {
      // 外多边形坐标数组和内多边形坐标数组
      const outer = [
        new AMap.LngLat(-360, 90, true),
        new AMap.LngLat(-360, -90, true),
        new AMap.LngLat(360, -90, true),
        new AMap.LngLat(360, 90, true),
      ]
      const holes = result.districtList[0].boundaries

      const pathArray = [outer]
      pathArray.push(holes)
      const polygon = new AMap.Polygon({
        pathL: pathArray,
        //线条颜色，使用16进制颜色代码赋值。默认值为#006600
        strokeColor: color,
        strokeWeight: weight,
        //轮廓线透明度，取值范围[0,1]，0表示完全透明，1表示不透明。默认为0.9
        strokeOpacity: 0.5,
        //多边形填充颜色，使用16进制颜色代码赋值，如：#FFAA00
        fillColor: maskColor,
        //多边形填充透明度，取值范围[0,1]，0表示完全透明，1表示不透明。默认为0.9
        fillOpacity: 1,
        //轮廓线样式，实线:solid，虚线:dashed
        strokeStyle: 'solid',
      })
      polygon.setPath(pathArray)
      this.map.add(polygon)
      return polygon
    })
  }
  private transMarkerData(option: MarkerOption): unknown[] {
    const { data = [], size, icon, key } = option
    return data.map((item: any) => {
      let sizeProp = Array.isArray(size) ? size : [size, size]
      if (item.size) {
        sizeProp = Array.isArray(item.size) ? item.size : [item.size, item.size]
      }
      const result = {
        icon: new AMap.Icon({
          size: sizeProp,
          image: item.icon || icon,
        }),
        position: [
          item.X || item.x || item.gpsx || item.lon,
          item.Y || item.y || item.gpsy || item.lat,
          item.Z || item.z || item.gpsz || 0,
        ],
        extData: { key, ...item },
      }
      return new AMap.Marker(result)
    })
  }
  addMarkers(option: MarkerOption): unknown {
    const markers = this.transMarkerData(option)
    this.map.add(markers)
    return markers
  }
  remove(markers: unknown): void {
    this.map.remove(markers)
  }
}
