import { AIMapConfig, MapConfig, SMapConfig } from './types'
import type MapType from './my-map'
import S_Map from './s-map'
import AI_Map from './ai-map'

const whichMap = {
  SMap: {
    /**
     * 使用配置初始化地图
     * @param config 地图配置
     */
    with: (config: MapConfig<SMapConfig>) => new S_Map(config),
  },
  AIMap: {
    /**
     * 使用配置初始化地图
     * @param config 地图配置
     */
    with: (config: MapConfig<AIMapConfig>) => new AI_Map(config),
  },
}

export type MyMap = MapType
export namespace MyMap {
  /**
   * 创建地图
   * @param key 地图关键字:
   *
   * 'SMap': 测绘院地图
   *
   * 'AIMap': 维智地图
   *
   */
  export function useMap<K extends keyof typeof whichMap>(key: K) {
    return whichMap[key]
  }
}

// function _injectSource(sources: any[]): Promise<unknown[]> {
//   const promises = sources.map((source: string, index: number) => {
//     return new Promise((resolve) => {
//       const id = `_my_map_source${index}`
//       if (document.getElementById(id)) return resolve(true)

//       const mapSource = document.createElement('script')
//       mapSource.type = 'text/javascript'
//       mapSource.src = source
//       mapSource.setAttribute('id', id)
//       document.body.appendChild(mapSource)
//       mapSource.onload = () => resolve(true)
//     })
//   })
//   return Promise.all(promises)
// }
