import { LayerOption, PointsData } from '../types'

/** 转化点状覆盖物 */
export function toPoints(map: unknown, options: LayerOption) {
  const {
    data,
    size = 20,
    icon,
    labelKey,
    spatialReference = 'gcj02',
    labelOptions,
  } = options
  const [horizontal, vertical] = labelOptions?.offset || []
  const result: any = { data: [], images: [] }
  const transData = (item: PointsData, i: number) => {
    const x = item.X || item.x || item.gpsx
    const y = item.Y || item.y || item.gpsy
    if ((x !== 0 && !x) || (y !== 0 && !y)) {
      console.error(`add point: 非法的坐标[${x}, ${y}] 存在于数据: ${item}`)
    }
    const z = item.Z || item.z || item.gpsz || 0
    result.data.push({
      ...item,
      id: item.id || i,
      icon: item.icon ? `icon${i}` : 'icon',
      spatialReference: spatialReference || item.spatialReference,
      coordinates: z ? [x, y, z] : [x, y],
    })
    result.images.push({
      id: item.icon ? `icon${i}` : 'icon',
      url: item.icon || icon,
    })
  }
  if (Array.isArray(data)) {
    data.forEach(transData)
  } else {
    transData(data, 0)
  }
  return {
    map,
    spatialReference: spatialReference,
    data: result.data,
    images: result.images,
    style: {
      'text-field': `{${labelKey}}`,
      'text-color': labelOptions?.color,
      // 偏移相比测绘院地图大概小了10倍，且竖直偏移相反
      'text-offset': [
        horizontal ? horizontal / 10 : 0,
        vertical ? vertical / -10 : 0,
      ],
      'icon-anchor': 'center',
      'icon-image': ['get', 'icon'],
      // size相比测绘院地图大概小了50倍
      'icon-size': Array.isArray(size) ? size[0] / 50 : size / 50,
    },
  }
}

/** 转化线状覆盖物 */
export function toLines(map: unknown, options: LayerOption) {
  const {
    data,
    lineWidth = 3,
    color = 'blue',
    labelKey,
    spatialReference = 'gcj02',
    labelOptions,
    lineJoin = 'round',
  } = options
  const [horizontal, vertical] = labelOptions?.offset || []
  return {
    map,
    spatialReference: spatialReference,
    data: {
      coordinates: Array.isArray(data)
        ? data.map(({ path }) => path?.map((e) => e))
        : data.path,
      ...data,
    },
    style: {
      'line-width': lineWidth,
      'line-color': color,
      'line-join': lineJoin,
      'text-field': `{${labelKey}}`,
      'text-color': labelOptions?.color,
      // 偏移相比测绘院地图大概小了10倍，且竖直偏移相反
      'text-offset': [
        horizontal ? horizontal / 10 : 0,
        vertical ? vertical / -10 : 0,
      ],
    },
  }
}

/** 转化面状覆盖物 */
export function toPolygons(map: unknown, options: LayerOption) {
  const {
    data,
    lineWidth = 3,
    color = 'blue',
    fillColor = 'rgba(135,206,235,0.5)',
    labelKey,
    spatialReference = 'gcj02',
    labelOptions,
    lineJoin = 'round',
  } = options
  const [horizontal, vertical] = labelOptions?.offset || []
  return {
    map,
    spatialReference: spatialReference,
    data: {
      coordinates: Array.isArray(data)
        ? data.map(({ path }) => path?.map((e) => e))
        : data.path,
      ...data,
    },
    style: {
      'line-width': lineWidth,
      'line-color': color,
      'fill-color': fillColor,
      'line-join': lineJoin,
      'text-field': `{${labelKey}}`,
      'text-color': labelOptions?.color,
      // 偏移相比测绘院地图大概小了10倍，且竖直偏移相反
      'text-offset': [
        horizontal ? horizontal / 10 : 0,
        vertical ? vertical / -10 : 0,
      ],
    },
  }
}
