import * as esriloader from 'esri-loader'

export default function useJsApi(modules: string[]) {
  const opt: esriloader.ILoadScriptOptions & { dojoConfig?: unknown } = {}

  window.dojoConfig && (opt.dojoConfig = window.dojoConfig)

  window.apiRoot && (opt.url = window.apiRoot)

  !esriloader.utils.Promise && (esriloader.utils.Promise = window.Promise)

  return esriloader.loadModules(modules, opt)
}
