import { ajax, api } from '@/ajax'

interface QueryProps {
  a?: string
  q?: string
  keys?: string
  [key: string]: unknown
}

export async function useFetchOrg(params: QueryProps) {
  const res = await ajax.get({
    url: api.ORGANIZATION,
    params,
  })
  return res && res.data && res.data.result
}

export async function useFetchMember(params: QueryProps) {
  const res = await ajax.get({
    url: api.MEMBER,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchActivity(params: QueryProps) {
  const res = await ajax.get({
    url: api.ACTIVITY,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchArea(params: QueryProps) {
  const res = await ajax.get({
    url: api.AREA,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchCommittee(params: QueryProps) {
  const res = await ajax.get({
    url: api.COMMITTEE,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchCommunity(params: QueryProps) {
  const res = await ajax.get({
    url: api.COMMUNITY,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchStreet(params: QueryProps) {
  const res = await ajax.get({
    url: api.STREET,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchBuilding(params: QueryProps) {
  const res = await ajax.get({
    url: api.BUILDING,
    params,
  })
  return res && res.data && res.data.result
}
export async function useFetchAttachment(params: QueryProps) {
  const res = await ajax.get({
    url: api.ATTACHMENT,
    params,
  })
  return res && res.data && res.data.result
}
